/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import org.bimserver.interfaces.objects.SBounds;
import org.bimserver.interfaces.objects.SVector3f;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.serializers.binarygeometry.Double3;

public class Bounds {
    public Double3 min;
    public Double3 max;

    public Bounds(Double3 min, Double3 max) {
        this.min = min;
        this.max = max;
    }

    public Bounds() {
        this.min = new Double3(3.4028234663852886E38, 3.4028234663852886E38, 3.4028234663852886E38);
        this.max = new Double3(-3.4028234663852886E38, -3.4028234663852886E38, -3.4028234663852886E38);
    }

    public Bounds(Vector3f minBounds, Vector3f maxBounds) {
        this.min = new Double3(minBounds.getX(), minBounds.getY(), minBounds.getZ());
        this.max = new Double3(maxBounds.getX(), maxBounds.getY(), maxBounds.getZ());
    }

    public Bounds(SVector3f minBounds, SVector3f maxBounds) {
        this.min = new Double3(minBounds.getX(), minBounds.getY(), minBounds.getZ());
        this.max = new Double3(maxBounds.getX(), maxBounds.getY(), maxBounds.getZ());
    }

    public Bounds(org.bimserver.models.geometry.Bounds bounds) {
        this(new Double3(bounds.getMin().getX(), bounds.getMin().getY(), bounds.getMin().getZ()), new Double3(bounds.getMax().getX(), bounds.getMax().getY(), bounds.getMax().getZ()));
    }

    public Bounds(SBounds bounds) {
        this(bounds.getMin(), bounds.getMax());
    }

    public void integrate(Bounds objectBounds) {
        this.min.min(objectBounds.min);
        this.max.max(objectBounds.max);
    }

    public void writeTo(LittleEndianDataOutputStream dataOutputStream) throws IOException {
        this.min.writeTo(dataOutputStream);
        this.max.writeTo(dataOutputStream);
    }

    public boolean in(float[] vertex) {
        return (double)vertex[0] >= this.min.x && (double)vertex[0] <= this.max.x && (double)vertex[1] >= this.min.y && (double)vertex[1] <= this.max.y && (double)vertex[2] >= this.min.z && (double)vertex[2] <= this.max.z;
    }

    public String toString() {
        return "[" + this.min.x + ", " + this.min.y + ", " + this.min.z + "] [" + this.max.x + ", " + this.max.y + ", " + this.max.z + "]";
    }
}

