/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.serializers.binarygeometry.GeometryBuffer;
import org.bimserver.shared.HashMapVirtualObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class GeometrySubBuffer {
    private final Map<HashMapVirtualObject, HashMapVirtualObject> mapping = new LinkedHashMap<HashMapVirtualObject, HashMapVirtualObject>();
    private int nrTriangles = 0;
    private int preparedByteSize = 24;
    private int nrIndices;
    private int nrLineIndices;
    private int nrVertices;
    private int nrColors;
    private int nrObjects;
    private int totalColorPackSize;
    private GeometryBuffer geometryBuffer;
    private int baseIndex;

    public GeometrySubBuffer(GeometryBuffer geometryBuffer, int baseIndex) {
        this.geometryBuffer = geometryBuffer;
        this.baseIndex = baseIndex;
    }

    public int getNrTriangles() {
        return this.nrTriangles;
    }

    public void put(HashMapVirtualObject hashMapVirtualObject, HashMapVirtualObject data) {
        this.mapping.put(hashMapVirtualObject, data);
        this.nrTriangles += (Integer)data.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_NrIndices()) / 3;
    }

    public Set<HashMapVirtualObject> keySet() {
        return this.mapping.keySet();
    }

    public HashMapVirtualObject get(HashMapVirtualObject info) {
        return this.mapping.get(info);
    }

    public int getPreparedByteSize() {
        return this.preparedByteSize;
    }

    public void setPreparedByteSize(int preparedByteSize) {
        this.preparedByteSize = preparedByteSize;
    }

    public int getNrIndices() {
        return this.nrIndices;
    }

    public int getNrLineIndices() {
        return this.nrLineIndices;
    }

    public void setNrIndices(int nrIndices) {
        this.nrIndices = nrIndices;
    }

    public int getNrVertices() {
        return this.nrVertices;
    }

    public void setNrVertices(int nrVertices) {
        this.nrVertices = nrVertices;
    }

    public int getNrColors() {
        return this.nrColors;
    }

    public void setNrColors(int nrColors) {
        this.nrColors = nrColors;
    }

    public void incNrIndices(int nrIndices) {
        this.nrIndices += nrIndices;
        this.geometryBuffer.incNrIndices(nrIndices);
    }

    public void incNrLineIndices(int nrLineIndices) {
        this.nrLineIndices += nrLineIndices;
        this.geometryBuffer.incNrLineIndices(nrLineIndices);
    }

    public void incNrVertices(int nrVertices) {
        this.nrVertices += nrVertices;
        this.geometryBuffer.incNrVertices(nrVertices);
    }

    public void incNrColors(int nrColors) {
        this.nrColors += nrColors;
        this.geometryBuffer.incNrColors(nrColors);
    }

    public void incPreparedSize(int byteSize) {
        this.preparedByteSize += byteSize;
        this.geometryBuffer.incPreparedByteSize(byteSize);
    }

    public void incNrObjects() {
        ++this.nrObjects;
        this.geometryBuffer.incNrObjects();
    }

    public int getNrObjects() {
        return this.nrObjects;
    }

    public void incTotalColorPackSize(int bytes) {
        this.totalColorPackSize += bytes;
    }

    public int getTotalColorPackSize() {
        return this.totalColorPackSize;
    }

    public void setBaseIndex(int baseIndex) {
        this.baseIndex = baseIndex;
    }

    public int getBaseIndex() {
        return this.baseIndex;
    }
}

