/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bimserver.geometry.Vector3D;
import org.bimserver.serializers.binarygeometry.IndexedVertex3D;

public class Mesh {
    private IntBuffer indices;
    private DoubleBuffer vertices;
    private FloatBuffer normals;
    private Map<Integer, Set<Integer>> referencedVertices = new HashMap<Integer, Set<Integer>>();
    private Map<Vector3D, Set<IndexedVertex3D>> verticesMap = new HashMap<Vector3D, Set<IndexedVertex3D>>();

    public Mesh(IntBuffer indices, DoubleBuffer vertices, FloatBuffer normals) {
        int i;
        this.indices = indices;
        this.vertices = vertices;
        this.normals = normals;
        for (i = 0; i < indices.capacity(); i += 3) {
            for (int j = 0; j < 3; ++j) {
                int index = indices.get(i + j);
                Set<Integer> set = this.referencedVertices.get(index);
                if (set == null) {
                    set = new HashSet<Integer>();
                    this.referencedVertices.put(index, set);
                }
                set.add(i);
            }
        }
        for (i = 0; i < vertices.capacity(); i += 3) {
            IndexedVertex3D indexedVertex3D = new IndexedVertex3D(i / 3, vertices.get(), vertices.get(), vertices.get());
            Set<IndexedVertex3D> set = this.verticesMap.get((Object)indexedVertex3D);
            if (set == null) {
                set = new HashSet<IndexedVertex3D>();
                this.verticesMap.put(indexedVertex3D, set);
            }
            set.add(indexedVertex3D);
        }
    }

    public void swapVertex(int oldPos, int newPos) {
        int i;
        for (i = 0; i < 3; ++i) {
            double tmp = this.vertices.get(oldPos * 3 + i);
            this.vertices.put(oldPos * 3 + i, this.vertices.get(newPos * 3 + i));
            this.vertices.put(newPos * 3 + i, tmp);
        }
        for (i = 0; i < 3; ++i) {
            float tmp = this.normals.get(oldPos * 3 + i);
            this.normals.put(oldPos * 3 + i, this.normals.get(newPos * 3 + i));
            this.normals.put(newPos * 3 + i, tmp);
        }
        HashSet set1 = new HashSet(this.referencedVertices.get(oldPos));
        HashSet set2 = new HashSet(this.referencedVertices.get(newPos));
        for (Integer index : set1) {
            this.indices.put((int)index, newPos);
        }
        this.referencedVertices.put(oldPos, set2);
        this.referencedVertices.put(newPos, set1);
        Set<IndexedVertex3D> set = this.verticesMap.get((Object)new IndexedVertex3D(0, this.vertices.get(newPos * 3), this.vertices.get(newPos * 3 + 1), this.vertices.get(newPos * 3 + 2)));
        for (IndexedVertex3D indexedVertex3D : set) {
            indexedVertex3D.setOriginalIndex(0);
        }
    }

    public IntBuffer getIndices() {
        return this.indices;
    }

    public DoubleBuffer getVertices() {
        return this.vertices;
    }

    public FloatBuffer getNormals() {
        return this.normals;
    }

    public Mesh copy() {
        IntBuffer newIndices = IntBuffer.allocate(this.indices.capacity());
        newIndices.put(this.indices);
        DoubleBuffer newVertices = DoubleBuffer.allocate(this.vertices.capacity());
        newVertices.put(this.vertices);
        FloatBuffer newNormals = FloatBuffer.allocate(this.normals.capacity());
        newNormals.put(this.normals);
        return new Mesh(newIndices, newVertices, newNormals);
    }
}

