/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.serializer;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import nl.tue.buildingsmart.schema.EntityDefinition;
import org.bimserver.emf.IdEObject;
import org.bimserver.ifc.IfcSerializer;
import org.bimserver.ifc.step.deserializer.IfcParserWriterUtils;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.plugins.HeaderTakingSerializer;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.serializers.EmfSerializer;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.utils.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcStepSerializer
extends IfcSerializer
implements HeaderTakingSerializer {
    private static final byte[] NEW_LINE = "\n".getBytes(Charsets.UTF_8);
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcStepSerializer.class);
    private static final EcorePackage ECORE_PACKAGE_INSTANCE = EcorePackage.eINSTANCE;
    private static final String NULL = "NULL";
    private static final String OPEN_CLOSE_PAREN = "()";
    private static final String ASTERISK = "*";
    private static final String PAREN_CLOSE_SEMICOLON = ");";
    private static final String DASH = "#";
    private static final String IFC_LOGICAL = "IfcLogical";
    private static final String IFC_BOOLEAN = "IfcBoolean";
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final String OPEN_PAREN = "(";
    private static final String CLOSE_PAREN = ")";
    private static final String BOOLEAN_UNDEFINED = ".U.";
    private static final String DOLLAR = "$";
    private static final String WRAPPED_VALUE = "wrappedValue";
    private Iterator<IdEObject> iterator;
    private String headerSchema;
    private long writeCounter;
    private OutputStream outputStream;

    public IfcStepSerializer(PluginConfiguration pluginConfiguration) {
    }

    public void setHeaderSchema(String headerSchema) {
        this.headerSchema = headerSchema;
    }

    public boolean write(OutputStream outputStream, ProgressReporter progressReporter) throws SerializerException {
        try {
            this.outputStream = outputStream;
            if (this.getMode() == EmfSerializer.Mode.HEADER) {
                this.writeHeader();
                this.setMode(EmfSerializer.Mode.BODY);
                this.iterator = this.model.getValues().iterator();
                return true;
            }
            if (this.getMode() == EmfSerializer.Mode.BODY) {
                if (this.iterator.hasNext()) {
                    IdEObject next = this.iterator.next();
                    while (next.eClass().getEPackage() != this.getPackageMetaData().getEPackage() && this.iterator.hasNext()) {
                        next = this.iterator.next();
                    }
                    this.write(next);
                    ++this.writeCounter;
                    if (progressReporter != null) {
                        progressReporter.update(this.writeCounter, this.model.size());
                    }
                } else {
                    this.iterator = null;
                    this.setMode(EmfSerializer.Mode.FOOTER);
                    return this.write(outputStream, progressReporter);
                }
                return true;
            }
            if (this.getMode() == EmfSerializer.Mode.FOOTER) {
                this.writeFooter();
                if (progressReporter != null) {
                    progressReporter.update(this.model.size(), this.model.size());
                }
                this.setMode(EmfSerializer.Mode.FINISHED);
                return true;
            }
            if (this.getMode() == EmfSerializer.Mode.FINISHED) {
                return false;
            }
            return false;
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
    }

    private void writeFooter() throws IOException {
        this.println("ENDSEC;");
        this.println("END-ISO-10303-21;");
    }

    private void writeHeader() throws IOException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.println("ISO-10303-21;");
        this.println("HEADER;");
        IfcHeader ifcHeader = this.getModel().getModelMetaData().getIfcHeader();
        if (ifcHeader == null) {
            Date date = new Date();
            this.println("FILE_DESCRIPTION ((''), '2;1');");
            this.println("FILE_NAME ('', '" + dateFormatter.format(date) + "', (''), (''), '', 'BIMserver', '');");
            this.println("FILE_SCHEMA (('" + this.headerSchema + "'));");
        } else {
            this.print("FILE_DESCRIPTION ((");
            this.print(StringUtils.concat((List)ifcHeader.getDescription(), (String)"'", (String)", "));
            this.println("), '" + ifcHeader.getImplementationLevel() + "');");
            this.println("FILE_NAME ('" + ifcHeader.getFilename().replace("\\", "\\\\") + "', '" + dateFormatter.format(ifcHeader.getTimeStamp()) + "', (" + StringUtils.concat((List)ifcHeader.getAuthor(), (String)"'", (String)", ") + "), (" + StringUtils.concat((List)ifcHeader.getOrganization(), (String)"'", (String)", ") + "), '" + ifcHeader.getPreProcessorVersion() + "', '" + ifcHeader.getOriginatingSystem() + "', '" + ifcHeader.getAuthorization() + "');");
            this.println("FILE_SCHEMA (('" + this.headerSchema + "'));");
        }
        this.println("ENDSEC;");
        this.println("DATA;");
    }

    private void println(String line) throws IOException {
        byte[] bytes = line.getBytes(Charsets.UTF_8);
        this.outputStream.write(bytes, 0, bytes.length);
        this.outputStream.write(NEW_LINE, 0, NEW_LINE.length);
    }

    private void print(String text) throws IOException {
        byte[] bytes = text.getBytes(Charsets.UTF_8);
        this.outputStream.write(bytes, 0, bytes.length);
    }

    private void write(IdEObject object) throws SerializerException, IOException {
        EClass eClass = object.eClass();
        if (eClass.getEAnnotation("hidden") != null) {
            return;
        }
        if (eClass.getEPackage() != this.getPackageMetaData().getEPackage()) {
            return;
        }
        this.print(DASH);
        long convertedKey = this.getExpressId(object);
        if (convertedKey == -1L) {
            throw new SerializerException("Going to serialize an object with id -1 (" + object.eClass().getName() + CLOSE_PAREN);
        }
        this.print(String.valueOf(convertedKey));
        this.print("= ");
        String upperCase = this.getPackageMetaData().getUpperCase(eClass);
        if (upperCase == null) {
            throw new SerializerException("Type not found: " + eClass.getName());
        }
        this.print(upperCase);
        this.print(OPEN_PAREN);
        boolean isFirst = true;
        EntityDefinition entityBN = this.getPackageMetaData().getSchemaDefinition().getEntityBN(object.eClass().getName());
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (feature.getEAnnotation("hidden") != null || entityBN == null || entityBN.isDerived(feature.getName()) && !entityBN.isDerivedOverride(feature.getName())) continue;
            EClassifier type = feature.getEType();
            if (type instanceof EEnum) {
                if (!isFirst) {
                    this.print(COMMA);
                }
                this.writeEnum((EObject)object, feature);
                isFirst = false;
                continue;
            }
            if (type instanceof EClass) {
                EReference eReference = (EReference)feature;
                if (this.getPackageMetaData().isInverse(eReference)) continue;
                if (!isFirst) {
                    this.print(COMMA);
                }
                this.writeEClass(object, feature);
                isFirst = false;
                continue;
            }
            if (!(type instanceof EDataType)) continue;
            if (!isFirst) {
                this.print(COMMA);
            }
            this.writeEDataType(object, entityBN, feature);
            isFirst = false;
        }
        this.println(PAREN_CLOSE_SEMICOLON);
    }

    private void writeEDataType(IdEObject object, EntityDefinition entityBN, EStructuralFeature feature) throws SerializerException, IOException {
        if (entityBN != null && entityBN.isDerived(feature.getName())) {
            this.print(ASTERISK);
        } else if (feature.isMany()) {
            this.writeList(object, feature);
        } else {
            this.writeObject(object, feature);
        }
    }

    private void writeEClass(IdEObject object, EStructuralFeature feature) throws SerializerException, IOException {
        Object referencedObject = object.eGet(feature);
        if (referencedObject instanceof IdEObject && ((IdEObject)referencedObject).eClass().getEAnnotation("wrapped") != null) {
            this.writeWrappedValue((EObject)object, feature, ((EObject)referencedObject).eClass());
        } else if (referencedObject instanceof EObject && this.model.contains((IdEObject)referencedObject)) {
            this.print(DASH);
            this.print(String.valueOf(this.getExpressId((IdEObject)referencedObject)));
        } else {
            EntityDefinition entityBN = this.getPackageMetaData().getSchemaDefinition().getEntityBN(object.eClass().getName());
            if (entityBN != null && entityBN.isDerived(feature.getName())) {
                this.print(ASTERISK);
            } else if (feature.isMany()) {
                this.writeList(object, feature);
            } else {
                this.writeObject(object, feature);
            }
        }
    }

    private void writeObject(IdEObject object, EStructuralFeature feature) throws SerializerException, IOException {
        Object ref = object.eGet(feature);
        if (ref == null || feature.isUnsettable() && !object.eIsSet(feature)) {
            EClassifier type = feature.getEType();
            if (type instanceof EClass) {
                EStructuralFeature structuralFeature = ((EClass)type).getEStructuralFeature(WRAPPED_VALUE);
                if (structuralFeature != null) {
                    String name = structuralFeature.getEType().getName();
                    if (name.equals(IFC_BOOLEAN) || name.equals(IFC_LOGICAL) || structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                        this.print(BOOLEAN_UNDEFINED);
                    } else {
                        this.print(DOLLAR);
                    }
                } else {
                    this.print(DOLLAR);
                }
            } else if (type == EcorePackage.eINSTANCE.getEBoolean()) {
                this.print(BOOLEAN_UNDEFINED);
            } else if (feature.isMany()) {
                this.print(OPEN_CLOSE_PAREN);
            } else {
                this.print(DOLLAR);
            }
        } else if (ref instanceof EObject) {
            this.writeEmbedded((EObject)ref);
        } else if (feature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
            this.writeDoubleValue((Double)ref, (EObject)object, feature);
        } else {
            IfcParserWriterUtils.writePrimitive(ref, this.outputStream);
        }
    }

    private void writeDoubleValue(double value, EObject object, EStructuralFeature feature) throws SerializerException, IOException {
        Object stringValue;
        if (this.model.isUseDoubleStrings() && (stringValue = object.eGet(object.eClass().getEStructuralFeature(feature.getName() + "AsString"))) != null) {
            this.print((String)stringValue);
            return;
        }
        IfcParserWriterUtils.writePrimitive((Object)value, this.outputStream);
    }

    private void writeEmbedded(EObject eObject) throws SerializerException, IOException {
        EClass class1 = eObject.eClass();
        this.print(this.getPackageMetaData().getUpperCase(class1));
        this.print(OPEN_PAREN);
        EStructuralFeature structuralFeature = class1.getEStructuralFeature(WRAPPED_VALUE);
        if (structuralFeature != null) {
            Object realVal = eObject.eGet(structuralFeature);
            if (structuralFeature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
                this.writeDoubleValue((Double)realVal, eObject, structuralFeature);
            } else {
                IfcParserWriterUtils.writePrimitive(realVal, this.outputStream);
            }
        }
        this.print(CLOSE_PAREN);
    }

    private void writeList(IdEObject object, EStructuralFeature feature) throws SerializerException, IOException {
        List list = (List)object.eGet(feature);
        List doubleStingList = null;
        if (feature.getEType() == EcorePackage.eINSTANCE.getEDouble() && this.model.isUseDoubleStrings()) {
            EStructuralFeature doubleStringFeature = feature.getEContainingClass().getEStructuralFeature(feature.getName() + "AsString");
            if (doubleStringFeature == null) {
                throw new SerializerException("Field " + feature.getName() + "AsString not found");
            }
            doubleStingList = (List)object.eGet(doubleStringFeature);
        }
        if (list.isEmpty()) {
            if (!feature.isUnsettable()) {
                this.print(OPEN_CLOSE_PAREN);
            } else {
                this.print(DOLLAR);
            }
        } else {
            this.print(OPEN_PAREN);
            boolean first = true;
            int index = 0;
            for (Object listObject : list) {
                IdEObject eObject;
                if (!first) {
                    this.print(COMMA);
                }
                if (listObject instanceof IdEObject && this.model.contains((IdEObject)listObject)) {
                    eObject = (IdEObject)listObject;
                    this.print(DASH);
                    this.print(String.valueOf(this.getExpressId(eObject)));
                } else if (listObject == null) {
                    this.print(DOLLAR);
                } else if (listObject instanceof IdEObject && feature.getEType().getEAnnotation("wrapped") != null) {
                    eObject = (IdEObject)listObject;
                    Object realVal = eObject.eGet(eObject.eClass().getEStructuralFeature(WRAPPED_VALUE));
                    if (realVal instanceof Double) {
                        if (this.model.isUseDoubleStrings()) {
                            Object stringVal = eObject.eGet(eObject.eClass().getEStructuralFeature("wrappedValueAsString"));
                            if (stringVal != null) {
                                this.print((String)stringVal);
                            } else {
                                IfcParserWriterUtils.writePrimitive(realVal, this.outputStream);
                            }
                        } else {
                            IfcParserWriterUtils.writePrimitive(realVal, this.outputStream);
                        }
                    } else {
                        IfcParserWriterUtils.writePrimitive(realVal, this.outputStream);
                    }
                } else if (listObject instanceof EObject) {
                    eObject = (IdEObject)listObject;
                    EClass class1 = eObject.eClass();
                    EStructuralFeature structuralFeature = class1.getEStructuralFeature(WRAPPED_VALUE);
                    if (structuralFeature != null) {
                        Object realVal = eObject.eGet(structuralFeature);
                        this.print(this.getPackageMetaData().getUpperCase(class1));
                        this.print(OPEN_PAREN);
                        if (realVal instanceof Double) {
                            this.writeDoubleValue((Double)realVal, (EObject)eObject, structuralFeature);
                        } else {
                            IfcParserWriterUtils.writePrimitive(realVal, this.outputStream);
                        }
                        this.print(CLOSE_PAREN);
                    } else if (feature.getEAnnotation("twodimensionalarray") != null) {
                        this.writeList(eObject, eObject.eClass().getEStructuralFeature("List"));
                    } else {
                        LOGGER.info("Unfollowable reference found from " + object + OPEN_PAREN + object.getOid() + ")." + feature.getName() + " to " + eObject + OPEN_PAREN + eObject.getOid() + CLOSE_PAREN);
                    }
                } else if (doubleStingList != null) {
                    if (index < doubleStingList.size()) {
                        String val = (String)doubleStingList.get(index);
                        if (val == null) {
                            IfcParserWriterUtils.writePrimitive(listObject, this.outputStream);
                        } else {
                            this.print(val);
                        }
                    } else {
                        IfcParserWriterUtils.writePrimitive(listObject, this.outputStream);
                    }
                } else {
                    IfcParserWriterUtils.writePrimitive(listObject, this.outputStream);
                }
                first = false;
                ++index;
            }
            this.print(CLOSE_PAREN);
        }
    }

    private void writeWrappedValue(EObject object, EStructuralFeature feature, EClass ec) throws SerializerException, IOException {
        Object get = object.eGet(feature);
        boolean isWrapped = ec.getEAnnotation("wrapped") != null;
        EStructuralFeature structuralFeature = ec.getEStructuralFeature(WRAPPED_VALUE);
        if (get instanceof EObject) {
            boolean isDefinedWrapped = feature.getEType().getEAnnotation("wrapped") != null;
            EObject betweenObject = (EObject)get;
            if (betweenObject != null) {
                if (isWrapped && isDefinedWrapped) {
                    Object val = betweenObject.eGet(structuralFeature);
                    String name = structuralFeature.getEType().getName();
                    if ((name.equals(IFC_BOOLEAN) || name.equals(IFC_LOGICAL)) && val == null) {
                        this.print(BOOLEAN_UNDEFINED);
                    } else if (structuralFeature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
                        this.writeDoubleValue((Double)val, betweenObject, feature);
                    } else {
                        IfcParserWriterUtils.writePrimitive(val, this.outputStream);
                    }
                } else {
                    this.writeEmbedded(betweenObject);
                }
            }
        } else if (get instanceof EList) {
            EList list = (EList)get;
            if (list.isEmpty()) {
                if (!feature.isUnsettable()) {
                    this.print(OPEN_CLOSE_PAREN);
                } else {
                    this.print(DOLLAR);
                }
            } else {
                this.print(OPEN_PAREN);
                boolean first = true;
                for (Object o : list) {
                    if (!first) {
                        this.print(COMMA);
                    }
                    EObject object2 = (EObject)o;
                    Object val = object2.eGet(structuralFeature);
                    if (structuralFeature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
                        this.writeDoubleValue((Double)val, object2, structuralFeature);
                    } else {
                        IfcParserWriterUtils.writePrimitive(val, this.outputStream);
                    }
                    first = false;
                }
                this.print(CLOSE_PAREN);
            }
        } else if (get == null) {
            EClassifier type = structuralFeature.getEType();
            if (type.getName().equals(IFC_BOOLEAN) || type.getName().equals(IFC_LOGICAL) || type == ECORE_PACKAGE_INSTANCE.getEBoolean()) {
                this.print(BOOLEAN_UNDEFINED);
            } else {
                EntityDefinition entityBN = this.getPackageMetaData().getSchemaDefinition().getEntityBN(object.eClass().getName());
                if (entityBN != null && entityBN.isDerived(feature.getName())) {
                    this.print(ASTERISK);
                } else {
                    this.print(DOLLAR);
                }
            }
        }
    }

    private void writeEnum(EObject object, EStructuralFeature feature) throws SerializerException, IOException {
        Object val = object.eGet(feature);
        if (feature.getEType().getName().equals("Tristate")) {
            IfcParserWriterUtils.writePrimitive(val, this.outputStream);
        } else if (val == null) {
            this.print(DOLLAR);
        } else if (((Enum)val).toString().equals(NULL)) {
            this.print(DOLLAR);
        } else {
            this.print(DOT);
            this.print(val.toString());
            this.print(DOT);
        }
    }
}

