/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.deserializer;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.ExplicitAttribute;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.MetaDataException;
import org.bimserver.emf.Schema;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.ifc.step.deserializer.IfcHeaderParser;
import org.bimserver.ifc.step.deserializer.IfcParserWriterUtils;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.deserializers.ByteProgressReporter;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.deserializers.EmfDeserializer;
import org.bimserver.shared.ListWaitingObject;
import org.bimserver.shared.SingleWaitingObject;
import org.bimserver.shared.WaitingList;
import org.bimserver.shared.WaitingObject;
import org.bimserver.utils.FakeClosingInputStream;
import org.bimserver.utils.StringUtils;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EEnumImpl;

@Deprecated
public abstract class IfcStepDeserializer
extends EmfDeserializer {
    private static final int AVERAGE_LINE_LENGTH = 58;
    private static final String WRAPPED_VALUE = "wrappedValue";
    private final WaitingList<Long> waitingList = new WaitingList();
    private Mode mode = Mode.HEADER;
    private IfcModelInterface model;
    private long lineNumber;
    private Schema schema;

    public IfcStepDeserializer(Schema schema) {
        this.schema = schema;
    }

    public IfcModelInterface read(InputStream in, String filename, long fileSize, ByteProgressReporter byteProgressReporter) throws DeserializeException {
        this.mode = Mode.HEADER;
        if (filename != null && (filename.toUpperCase().endsWith(".ZIP") || filename.toUpperCase().endsWith(".IFCZIP"))) {
            ZipInputStream zipInputStream = new ZipInputStream(in);
            try {
                ZipEntry nextEntry = zipInputStream.getNextEntry();
                if (nextEntry == null) {
                    throw new DeserializeException("Zip files must contain exactly one IFC-file, this zip-file looks empty");
                }
                if (nextEntry.getName().toUpperCase().endsWith(".IFC")) {
                    IfcModelInterface model = null;
                    FakeClosingInputStream fakeClosingInputStream = new FakeClosingInputStream((InputStream)zipInputStream);
                    model = this.read((InputStream)fakeClosingInputStream, fileSize, byteProgressReporter);
                    if (model.size() == 0L) {
                        throw new DeserializeException("Uploaded file does not seem to be a correct IFC file");
                    }
                    if (zipInputStream.getNextEntry() != null) {
                        zipInputStream.close();
                        throw new DeserializeException("Zip files may only contain one IFC-file, this zip-file contains more files");
                    }
                    zipInputStream.close();
                    return model;
                }
                throw new DeserializeException("Zip files must contain exactly one IFC-file, this zip-file seems to have one or more non-IFC files");
            }
            catch (IOException e) {
                throw new DeserializeException((Exception)e);
            }
        }
        return this.read(in, fileSize, byteProgressReporter);
    }

    private IfcModelInterface read(InputStream inputStream, long fileSize, ByteProgressReporter byteProgressReporter) throws DeserializeException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        int initialCapacity = (int)(fileSize / 58L);
        this.model = new BasicIfcModel(this.getPackageMetaData(), null, initialCapacity);
        long bytesRead = 0L;
        this.lineNumber = 0L;
        try {
            String line = reader.readLine();
            if (line == null) {
                throw new DeserializeException("Unexpected end of stream reading first line " + this.model);
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            while (line != null) {
                byte[] bytes = line.getBytes(Charsets.UTF_8);
                md.update(bytes, 0, bytes.length);
                try {
                    String readLine;
                    while (!this.processLine(line.trim()) && (readLine = reader.readLine()) != null) {
                        line = line + readLine;
                        ++this.lineNumber;
                    }
                }
                catch (Exception e) {
                    if (e instanceof DeserializeException) {
                        throw (DeserializeException)((Object)e);
                    }
                    throw new DeserializeException(this.lineNumber, " (" + e.getMessage() + ") " + line, e);
                }
                bytesRead += (long)bytes.length;
                if (byteProgressReporter != null) {
                    byteProgressReporter.progress(bytesRead);
                }
                line = reader.readLine();
                ++this.lineNumber;
            }
            this.model.getModelMetaData().setChecksum(md.digest());
            if (this.mode == Mode.HEADER) {
                throw new DeserializeException(this.lineNumber, "No valid IFC header found");
            }
        }
        catch (FileNotFoundException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
        catch (IOException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
        return this.model;
    }

    public IfcModelInterface read(File sourceFile) throws DeserializeException {
        try {
            FileInputStream in = new FileInputStream(sourceFile);
            this.read(in, sourceFile.length(), null);
            in.close();
            this.model.getModelMetaData().setDate(new Date());
            this.model.getModelMetaData().setName(sourceFile.getName());
            return this.model;
        }
        catch (FileNotFoundException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
        catch (IOException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
    }

    public IfcModelInterface getModel() {
        return this.model;
    }

    private boolean processLine(String line) throws DeserializeException, MetaDataException {
        switch (this.mode) {
            case HEADER: {
                if (line.length() > 0) {
                    if (line.endsWith(";")) {
                        this.processHeader(line);
                    } else {
                        return false;
                    }
                }
                if (!line.equals("DATA;")) break;
                this.mode = Mode.DATA;
                break;
            }
            case DATA: {
                if (line.equals("ENDSEC;")) {
                    this.mode = Mode.FOOTER;
                    break;
                }
                if (line.length() <= 0 || line.charAt(0) != '#') break;
                while (line.endsWith("*/")) {
                    line = line.substring(0, line.lastIndexOf("/*")).trim();
                }
                if (line.endsWith(";")) {
                    this.processRecord(line);
                    break;
                }
                return false;
            }
            case FOOTER: {
                if (!line.equals("ENDSEC;")) break;
                this.mode = Mode.DONE;
                break;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processHeader(String line) throws DeserializeException {
        try {
            IfcHeader ifcHeader = this.model.getModelMetaData().getIfcHeader();
            if (ifcHeader == null) {
                ifcHeader = StoreFactory.eINSTANCE.createIfcHeader();
                this.model.getModelMetaData().setIfcHeader(ifcHeader);
            }
            if (line.startsWith("FILE_DESCRIPTION")) {
                String filedescription = line.substring("FILE_DESCRIPTION".length()).trim();
                new IfcHeaderParser().parseDescription(filedescription.substring(1, filedescription.length() - 2), ifcHeader);
                return;
            }
            if (line.startsWith("FILE_NAME")) {
                String filename = line.substring("FILE_NAME".length()).trim();
                new IfcHeaderParser().parseFileName(filename.substring(1, filename.length() - 2), ifcHeader);
                return;
            }
            if (line.startsWith("FILE_SCHEMA")) {
                String fileschema = line.substring("FILE_SCHEMA".length()).trim();
                new IfcHeaderParser().parseFileSchema(fileschema.substring(1, fileschema.length() - 2), ifcHeader);
                String ifcSchemaVersion = ifcHeader.getIfcSchemaVersion();
                if (!ifcSchemaVersion.toLowerCase().equalsIgnoreCase(this.schema.getHeaderName().toLowerCase())) {
                    throw new DeserializeException(this.lineNumber, ifcSchemaVersion + " is not supported by this deserializer (" + this.schema.getHeaderName() + " is)");
                }
                ifcHeader.setIfcSchemaVersion(ifcSchemaVersion);
                return;
            }
            if (!line.startsWith("ENDSEC;")) return;
        }
        catch (ParseException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
    }

    public void processRecord(String line) throws DeserializeException, MetaDataException {
        int equalSignLocation = line.indexOf("=");
        int lastIndexOfSemiColon = line.lastIndexOf(";");
        if (lastIndexOfSemiColon == -1) {
            throw new DeserializeException(this.lineNumber, "No semicolon found in line");
        }
        int indexOfFirstParen = line.indexOf("(", equalSignLocation);
        if (indexOfFirstParen == -1) {
            throw new DeserializeException(this.lineNumber, "No left parenthesis found in line");
        }
        int indexOfLastParen = line.lastIndexOf(")", lastIndexOfSemiColon);
        if (indexOfLastParen == -1) {
            throw new DeserializeException(this.lineNumber, "No right parenthesis found in line");
        }
        long recordNumber = Long.parseLong(line.substring(1, equalSignLocation).trim());
        String name = line.substring(equalSignLocation + 1, indexOfFirstParen).trim();
        EClass eClass = (EClass)this.getPackageMetaData().getEClassifierCaseInsensitive(name);
        if (eClass != null) {
            IdEObject object = this.getPackageMetaData().create(eClass);
            try {
                this.model.add(recordNumber, object);
            }
            catch (IfcModelInterfaceException e) {
                throw new DeserializeException(this.lineNumber, (Exception)((Object)e));
            }
            ((IdEObjectImpl)object).setExpressId(recordNumber);
            String realData = line.substring(indexOfFirstParen + 1, indexOfLastParen);
            int lastIndex = 0;
            EntityDefinition entityBN = this.getPackageMetaData().getSchemaDefinition().getEntityBN(name);
            if (entityBN == null) {
                throw new DeserializeException(this.lineNumber, "Unknown entity " + name);
            }
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                if (this.getPackageMetaData().useForSerialization(eClass, eStructuralFeature)) {
                    int nextIndex;
                    if (this.getPackageMetaData().useForDatabaseStorage(eClass, eStructuralFeature)) {
                        EStructuralFeature doubleStringFeature;
                        nextIndex = StringUtils.nextString((String)realData, (int)lastIndex);
                        if (nextIndex <= lastIndex && eStructuralFeature == Ifc4Package.eINSTANCE.getIfcSurfaceStyleShading_Transparency()) continue;
                        String val = null;
                        try {
                            val = realData.substring(lastIndex, nextIndex - 1).trim();
                        }
                        catch (Exception e) {
                            int expected = 0;
                            for (Attribute attribute2 : entityBN.getAttributesCached(true)) {
                                if (!(attribute2 instanceof ExplicitAttribute)) continue;
                                ++expected;
                            }
                            throw new DeserializeException(this.lineNumber, eClass.getName() + " expects " + expected + " fields, but less found");
                        }
                        lastIndex = nextIndex;
                        char firstChar = val.charAt(0);
                        if (firstChar == '$') {
                            object.eUnset(eStructuralFeature);
                            if (eStructuralFeature.getEType() != EcorePackage.eINSTANCE.getEDouble()) continue;
                            doubleStringFeature = eClass.getEStructuralFeature(eStructuralFeature.getName() + "AsString");
                            object.eUnset(doubleStringFeature);
                            continue;
                        }
                        if (firstChar == '#') {
                            this.readReference(val, (EObject)object, eStructuralFeature);
                            continue;
                        }
                        if (firstChar == '.') {
                            this.readEnum(val, (EObject)object, eStructuralFeature);
                            continue;
                        }
                        if (firstChar == '(') {
                            this.readList(val, (EObject)object, eStructuralFeature);
                            continue;
                        }
                        if (firstChar == '*' || eStructuralFeature.isMany()) continue;
                        object.eSet(eStructuralFeature, this.convert(eStructuralFeature, eStructuralFeature.getEType(), val));
                        if (eStructuralFeature.getEType() != EcorePackage.eINSTANCE.getEDouble()) continue;
                        doubleStringFeature = eClass.getEStructuralFeature(eStructuralFeature.getName() + "AsString");
                        object.eSet(doubleStringFeature, (Object)val);
                        continue;
                    }
                    lastIndex = nextIndex = StringUtils.nextString((String)realData, (int)lastIndex);
                    continue;
                }
                if (!this.getPackageMetaData().useForDatabaseStorage(eClass, eStructuralFeature)) continue;
                if (eStructuralFeature instanceof EReference && this.getPackageMetaData().isInverse((EReference)eStructuralFeature)) {
                    object.eUnset(eStructuralFeature);
                    continue;
                }
                if (eStructuralFeature.getEAnnotation("asstring") != null) continue;
                object.eUnset(eStructuralFeature);
            }
            if (this.waitingList.containsKey((Object)recordNumber)) {
                this.waitingList.updateNode((Object)recordNumber, eClass, object);
            }
        } else {
            throw new DeserializeException(this.lineNumber, name + " is not a known entity");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readList(String val, EObject object, EStructuralFeature structuralFeature) throws DeserializeException, MetaDataException {
        int index = 0;
        if (!structuralFeature.isMany()) {
            throw new DeserializeException(this.lineNumber, "Field " + structuralFeature.getName() + " of " + structuralFeature.getEContainingClass().getName() + " is no aggregation");
        }
        AbstractEList list = (AbstractEList)object.eGet(structuralFeature);
        AbstractEList doubleStringList = null;
        if (structuralFeature.getEType() == EcorePackage.eINSTANCE.getEDouble()) {
            EStructuralFeature doubleStringFeature = structuralFeature.getEContainingClass().getEStructuralFeature(structuralFeature.getName() + "AsString");
            if (doubleStringFeature == null) {
                throw new DeserializeException(this.lineNumber, "Field not found: " + structuralFeature.getName() + "AsString");
            }
            doubleStringList = (AbstractEList)object.eGet(doubleStringFeature);
        }
        String realData = val.substring(1, val.length() - 1);
        int lastIndex = 0;
        while (lastIndex != realData.length() + 1) {
            int nextIndex = StringUtils.nextString((String)realData, (int)lastIndex);
            String stringValue = realData.substring(lastIndex, nextIndex - 1).trim();
            lastIndex = nextIndex;
            if (stringValue.length() > 0) {
                if (stringValue.charAt(0) == '#') {
                    long referenceId = Long.parseLong(stringValue.substring(1));
                    if (this.model.contains(referenceId)) {
                        IdEObject referencedObject = this.model.get(referenceId);
                        if (referencedObject != null) {
                            EClass referenceEClass = referencedObject.eClass();
                            if (!((EClass)structuralFeature.getEType()).isSuperTypeOf(referenceEClass)) throw new DeserializeException(this.lineNumber, referenceEClass.getName() + " cannot be stored in " + structuralFeature.getName());
                            while (list.size() <= index) {
                                list.addUnique((Object)referencedObject);
                            }
                            list.setUnique(index, (Object)referencedObject);
                        }
                    } else {
                        this.waitingList.add((Object)referenceId, (WaitingObject)new ListWaitingObject(this.lineNumber, object, (EReference)structuralFeature, index));
                    }
                } else if (stringValue.charAt(0) == '(') {
                    IdEObject newObject = this.getPackageMetaData().create((EClass)structuralFeature.getEType());
                    this.readList(stringValue, (EObject)newObject, newObject.eClass().getEStructuralFeature("List"));
                    list.addUnique((Object)newObject);
                } else {
                    Object convert = this.convert(structuralFeature, structuralFeature.getEType(), stringValue);
                    if (convert != null) {
                        while (list.size() <= index) {
                            if (doubleStringList != null) {
                                doubleStringList.addUnique((Object)stringValue);
                            }
                            list.addUnique(convert);
                        }
                        if (doubleStringList != null) {
                            doubleStringList.setUnique(index, (Object)stringValue);
                        }
                        list.setUnique(index, convert);
                    }
                }
            }
            ++index;
        }
    }

    private Object convert(EStructuralFeature eStructuralFeature, EClassifier classifier, String value) throws DeserializeException, MetaDataException {
        if (classifier != null) {
            if (classifier instanceof EClassImpl) {
                if (null != ((EClassImpl)classifier).getEStructuralFeature(WRAPPED_VALUE)) {
                    IdEObject newObject = this.getPackageMetaData().create((EClass)classifier);
                    Class instanceClass = newObject.eClass().getEStructuralFeature(WRAPPED_VALUE).getEType().getInstanceClass();
                    if (!value.equals("")) {
                        if (instanceClass == Integer.class || instanceClass == Integer.TYPE) {
                            try {
                                newObject.eSet(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)Integer.parseInt(value));
                            }
                            catch (NumberFormatException e) {
                                throw new DeserializeException(this.lineNumber, value + " is not a valid integer(32) value");
                            }
                        }
                        if (instanceClass == Long.class || instanceClass == Long.TYPE) {
                            try {
                                newObject.eSet(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)Long.parseLong(value));
                            }
                            catch (NumberFormatException e) {
                                throw new DeserializeException(this.lineNumber, value + " is not a valid integer(64) value");
                            }
                        }
                        if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
                            newObject.eSet(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)value.equals(".T."));
                        } else if (instanceClass == Double.class || instanceClass == Double.TYPE) {
                            try {
                                newObject.eSet(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)Double.parseDouble(value));
                            }
                            catch (NumberFormatException e) {
                                throw new DeserializeException(this.lineNumber, value + " is not a valid floating point(32) number");
                            }
                            newObject.eSet(newObject.eClass().getEStructuralFeature("wrappedValueAsString"), (Object)value);
                        } else if (instanceClass == String.class) {
                            newObject.eSet(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)IfcParserWriterUtils.readString(value, this.lineNumber));
                        } else if (instanceClass.getSimpleName().equals("Tristate")) {
                            Enumerator tristate = null;
                            if (value.equals(".T.")) {
                                tristate = this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE").getInstance();
                            } else if (value.equals(".F.")) {
                                tristate = this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE").getInstance();
                            } else if (value.equals(".U.")) {
                                tristate = this.getPackageMetaData().getEEnumLiteral("Tristate", "UNDEFINED").getInstance();
                            }
                            newObject.eSet(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)tristate);
                        } else {
                            throw new DeserializeException(this.lineNumber, instanceClass.getSimpleName() + " not implemented");
                        }
                    }
                    return newObject;
                }
                return this.processInline(eStructuralFeature, classifier, value);
            }
            if (classifier instanceof EDataType) {
                return IfcParserWriterUtils.convertSimpleValue(this.getPackageMetaData(), eStructuralFeature, classifier.getInstanceClass(), value, this.lineNumber);
            }
        }
        return null;
    }

    private Object processInline(EStructuralFeature eStructuralFeature, EClassifier classifier, String value) throws DeserializeException, MetaDataException {
        if (value.indexOf("(") != -1) {
            String typeName = value.substring(0, value.indexOf("(")).trim();
            String v = value.substring(value.indexOf("(") + 1, value.length() - 1);
            EClassifier eClassifier = this.getPackageMetaData().getEClassifierCaseInsensitive(typeName);
            if (eClassifier instanceof EClass) {
                Object convert = this.convert(eStructuralFeature, eClassifier, v);
                try {
                    this.model.add(-1L, (IdEObject)convert);
                }
                catch (IfcModelInterfaceException e) {
                    throw new DeserializeException(this.lineNumber, (Exception)((Object)e));
                }
                return convert;
            }
            throw new DeserializeException(this.lineNumber, typeName + " is not an existing IFC entity");
        }
        return IfcParserWriterUtils.convertSimpleValue(this.getPackageMetaData(), eStructuralFeature, classifier.getInstanceClass(), value, this.lineNumber);
    }

    private void readEnum(String val, EObject object, EStructuralFeature structuralFeature) throws DeserializeException, MetaDataException {
        if (val.equals(".T.")) {
            if (structuralFeature.getEType().getName().equals("Tristate")) {
                object.eSet(structuralFeature, (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE").getInstance());
            } else if (structuralFeature.getEType().getName().equals("IfcBoolean")) {
                EClass eClass = this.getPackageMetaData().getEClass("IfcBoolean");
                IdEObject createIfcBoolean = this.getPackageMetaData().create(eClass);
                createIfcBoolean.eSet(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE").getInstance());
                object.eSet(structuralFeature, (Object)createIfcBoolean);
            } else if (structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                object.eSet(structuralFeature, (Object)true);
            } else {
                EClass eClass = this.getPackageMetaData().getEClass("IfcLogical");
                IdEObject createIfcBoolean = this.getPackageMetaData().create(eClass);
                createIfcBoolean.eSet(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE").getInstance());
                object.eSet(structuralFeature, (Object)createIfcBoolean);
            }
        } else if (val.equals(".F.")) {
            if (structuralFeature.getEType().getName().equals("Tristate")) {
                object.eSet(structuralFeature, (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE").getInstance());
            } else if (structuralFeature.getEType().getName().equals("IfcBoolean")) {
                EClass eClass = this.getPackageMetaData().getEClass("IfcBoolean");
                IdEObject createIfcBoolean = this.getPackageMetaData().create(eClass);
                createIfcBoolean.eSet(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE").getInstance());
                object.eSet(structuralFeature, (Object)createIfcBoolean);
            } else if (structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                object.eSet(structuralFeature, (Object)false);
            } else {
                EClass eClass = this.getPackageMetaData().getEClass("IfcLogical");
                IdEObject createIfcBoolean = this.getPackageMetaData().create(eClass);
                createIfcBoolean.eSet(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE").getInstance());
                object.eSet(structuralFeature, (Object)createIfcBoolean);
            }
        } else if (val.equals(".U.")) {
            if (structuralFeature.getEType().getName().equals("Tristate")) {
                object.eSet(structuralFeature, (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "UNDEFINED").getInstance());
            } else if (structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                object.eUnset(structuralFeature);
            } else {
                EClass eClass = this.getPackageMetaData().getEClass("IfcLogical");
                IdEObject createIfcBoolean = this.getPackageMetaData().create(eClass);
                createIfcBoolean.eSet(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "UNDEFINED").getInstance());
                object.eSet(structuralFeature, (Object)createIfcBoolean);
            }
        } else if (structuralFeature.getEType() instanceof EEnumImpl) {
            String realEnumValue = val.substring(1, val.length() - 1);
            EEnumLiteral enumValue = ((EEnumImpl)structuralFeature.getEType()).getEEnumLiteral(realEnumValue);
            if (enumValue == null && structuralFeature.getEType() == Ifc4Package.eINSTANCE.getIfcExternalSpatialElementTypeEnum() && realEnumValue.equals("NOTDEFIEND")) {
                realEnumValue = "NOTDEFINED";
                enumValue = ((EEnumImpl)structuralFeature.getEType()).getEEnumLiteral(realEnumValue);
            }
            if (enumValue == null) {
                throw new DeserializeException(this.lineNumber, "Enum type " + structuralFeature.getEType().getName() + " has no literal value '" + realEnumValue + "'");
            }
            object.eSet(structuralFeature, (Object)enumValue.getInstance());
        } else {
            throw new DeserializeException(this.lineNumber, "Value " + val + " indicates enum type but " + structuralFeature.getEType().getName() + " expected");
        }
    }

    private void readReference(String val, EObject object, EStructuralFeature structuralFeature) throws DeserializeException {
        long referenceId;
        if (structuralFeature == Ifc4Package.eINSTANCE.getIfcIndexedColourMap_Opacity()) {
            object.eSet(structuralFeature, (Object)0.0);
            object.eSet(structuralFeature.getEContainingClass().getEStructuralFeature(structuralFeature.getName() + "AsString"), (Object)"0");
            return;
        }
        try {
            referenceId = Long.parseLong(val.substring(1));
        }
        catch (NumberFormatException e) {
            throw new DeserializeException(this.lineNumber, "'" + val + "' is not a valid reference");
        }
        if (this.model.contains(referenceId)) {
            object.eSet(structuralFeature, (Object)this.model.get(referenceId));
        } else {
            this.waitingList.add((Object)referenceId, (WaitingObject)new SingleWaitingObject(this.lineNumber, object, (EReference)structuralFeature));
        }
    }

    public static enum Mode {
        HEADER,
        DATA,
        FOOTER,
        DONE;

    }
}

