/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.deserializer;

import org.bimserver.ifc.step.deserializer.IfcParserWriterUtils;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.utils.StringUtils;

public class StepParser {
    private String line;
    private int lastIndex = 0;

    public StepParser(String line) {
        this.line = line;
        if (line.startsWith("(") && line.endsWith(")")) {
            this.line = line.substring(1, line.length() - 1);
        }
        this.lastIndex = StringUtils.nextField((String)this.line, (int)0);
    }

    public String readNextString() throws DeserializeException {
        int nextIndex = StringUtils.nextString((String)this.line, (int)this.lastIndex);
        String val = null;
        try {
            val = this.line.substring(this.lastIndex, nextIndex - 1).trim();
        }
        catch (Exception e) {
            throw new DeserializeException(0L, "Expected string");
        }
        this.lastIndex = StringUtils.nextField((String)this.line, (int)nextIndex);
        if (val.equals("$")) {
            return null;
        }
        return IfcParserWriterUtils.readString(val, 0L);
    }

    private void skipSpaces() {
        while (this.lastIndex < this.line.length() - 1 && this.line.charAt(this.lastIndex) == ' ') {
            ++this.lastIndex;
        }
    }

    public StepParser startList() throws DeserializeException {
        this.skipSpaces();
        int nextIndex = StringUtils.nextString((String)this.line, (int)this.lastIndex);
        String val = this.line.substring(this.lastIndex, nextIndex - 1).trim();
        this.lastIndex = StringUtils.nextField((String)this.line, (int)nextIndex);
        return new StepParser(val);
    }

    public boolean hasMoreListItems() {
        this.skipSpaces();
        if (this.lastIndex >= this.line.length()) {
            return false;
        }
        String character = this.line.substring(this.lastIndex, this.lastIndex + 1);
        return !character.equals(")");
    }

    public void endList() throws DeserializeException {
        String character = this.line.substring(this.lastIndex, this.lastIndex + 1);
        if (character.equals(")")) {
            ++this.lastIndex;
        } else {
            throw new DeserializeException("Expected ), got " + character);
        }
    }
}

