/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.serializer;

import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.SchemaDefinition;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifc.step.deserializer.IfcParserWriterUtils;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.OidConvertingSerializer;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.plugins.serializers.SerializerInputstream;
import org.bimserver.plugins.serializers.StreamingReader;
import org.bimserver.plugins.serializers.StreamingSerializer;
import org.bimserver.shared.AbstractHashMapVirtualObject;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.MinimalVirtualObject;
import org.bimserver.utils.StringUtils;
import org.bimserver.utils.UTF8PrintWriter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public abstract class IfcStepStreamingSerializer
implements StreamingSerializer,
StreamingReader,
OidConvertingSerializer {
    private static final EcorePackage ECORE_PACKAGE_INSTANCE = EcorePackage.eINSTANCE;
    private static final String NULL = "NULL";
    private static final String OPEN_CLOSE_PAREN = "()";
    private static final String ASTERISK = "*";
    private static final String PAREN_CLOSE_SEMICOLON = ");";
    private static final String DASH = "#";
    private static final String IFC_LOGICAL = "IfcLogical";
    private static final String IFC_BOOLEAN = "IfcBoolean";
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final String OPEN_PAREN = "(";
    private static final String CLOSE_PAREN = ")";
    private static final String BOOLEAN_UNDEFINED = ".U.";
    private static final String DOLLAR = "$";
    private static final String WRAPPED_VALUE = "wrappedValue";
    private String headerSchema;
    private ObjectProvider objectProvider;
    private final Map<Long, Long> oidToEid = new Long2LongOpenHashMap();
    private long oidCounter = 1L;
    private Mode mode = Mode.HEADER;
    private IfcHeader ifcHeader;
    private PackageMetaData packageMetaData;
    private PrintWriter printWriter;

    public boolean write(OutputStream outputStream) throws SerializerException, BimserverDatabaseException {
        if (this.printWriter == null) {
            this.printWriter = new UTF8PrintWriter(outputStream);
        }
        boolean result = false;
        try {
            result = this.processMode();
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
        return result;
    }

    public Map<Long, Long> getOidToEid() {
        return this.oidToEid;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public InputStream getInputStream() {
        return new SerializerInputstream((StreamingReader)this);
    }

    public IfcStepStreamingSerializer(PluginConfiguration pluginConfiguration) {
    }

    protected void setHeaderSchema(String headerSchema) {
        this.headerSchema = headerSchema;
    }

    public void init(ObjectProvider objectProvider, ProjectInfo projectInfo, IfcHeader ifcHeader, PluginManagerInterface pluginManager, PackageMetaData packageMetaData) throws SerializerException {
        this.objectProvider = objectProvider;
        this.ifcHeader = ifcHeader;
        this.packageMetaData = packageMetaData;
    }

    public void writeToOutputStream(OutputStream outputStream) throws SerializerException, BimserverDatabaseException {
        this.printWriter = new UTF8PrintWriter(outputStream);
        try {
            while (this.mode != Mode.FINISHED) {
                this.processMode();
            }
        }
        catch (Exception e) {
            throw new SerializerException((Throwable)e);
        }
    }

    private boolean processMode() throws IOException, BimserverDatabaseException, SerializerException {
        if (this.getMode() == Mode.HEADER) {
            this.writeHeader();
            this.setMode(Mode.BODY);
        } else if (this.getMode() == Mode.BODY) {
            HashMapVirtualObject next = this.objectProvider.next();
            if (next != null) {
                this.write(next);
            } else {
                this.setMode(Mode.FOOTER);
            }
        } else if (this.getMode() == Mode.FOOTER) {
            this.writeFooter();
            this.setMode(Mode.FINISHED);
            if (this.printWriter != null) {
                this.printWriter.flush();
            }
        } else if (this.getMode() == Mode.FINISHED) {
            return false;
        }
        return true;
    }

    private void writeFooter() throws IOException {
        this.println("ENDSEC;");
        this.println("END-ISO-10303-21;");
    }

    private void writeHeader() throws IOException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.println("ISO-10303-21;");
        this.println("HEADER;");
        if (this.ifcHeader == null) {
            Date date = new Date();
            this.println("FILE_DESCRIPTION ((''), '2;1');");
            this.println("FILE_NAME ('', '" + dateFormatter.format(date) + "', (''), (''), '', 'BIMserver', '');");
            this.println("FILE_SCHEMA (('" + this.headerSchema + "'));");
        } else {
            this.print("FILE_DESCRIPTION ((");
            this.print(StringUtils.concat((List)this.ifcHeader.getDescription(), (String)"'", (String)", "));
            this.println("), '" + this.ifcHeader.getImplementationLevel() + "');");
            this.println("FILE_NAME ('" + this.ifcHeader.getFilename().replace("\\", "\\\\") + "', '" + dateFormatter.format(this.ifcHeader.getTimeStamp()) + "', (" + StringUtils.concat((List)this.ifcHeader.getAuthor(), (String)"'", (String)", ") + "), (" + StringUtils.concat((List)this.ifcHeader.getOrganization(), (String)"'", (String)", ") + "), '" + this.ifcHeader.getPreProcessorVersion() + "', '" + this.ifcHeader.getOriginatingSystem() + "', '" + this.ifcHeader.getAuthorization() + "');");
            this.println("FILE_SCHEMA (('" + this.headerSchema + "'));");
        }
        this.println("ENDSEC;");
        this.println("DATA;");
    }

    private void println(String line) throws IOException {
        this.printWriter.println(line);
    }

    private void print(String text) throws IOException {
        this.printWriter.write(text);
    }

    private void write(HashMapVirtualObject object) throws SerializerException, IOException {
        EClass eClass = object.eClass();
        if (eClass.getEPackage() == GeometryPackage.eINSTANCE) {
            return;
        }
        if (eClass.getEAnnotation("hidden") != null) {
            return;
        }
        this.print(DASH);
        long convertedKey = this.getExpressId(object);
        if (convertedKey == -1L) {
            throw new SerializerException("Going to serialize an object with id -1 (" + object.eClass().getName() + CLOSE_PAREN);
        }
        this.print(String.valueOf(convertedKey));
        this.print("= ");
        String upperCase = this.packageMetaData.getUpperCase(eClass);
        if (upperCase == null) {
            throw new SerializerException("Type not found: " + eClass.getName());
        }
        this.print(upperCase);
        this.print(OPEN_PAREN);
        boolean isFirst = true;
        EntityDefinition entityBN = this.getSchemaDefinition().getEntityBN(object.eClass().getName());
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (feature.getEAnnotation("hidden") != null || entityBN == null || entityBN.isDerived(feature.getName()) && !entityBN.isDerivedOverride(feature.getName())) continue;
            EClassifier type = feature.getEType();
            if (type instanceof EEnum) {
                if (!isFirst) {
                    this.print(COMMA);
                }
                this.writeEnum(object, feature);
                isFirst = false;
                continue;
            }
            if (type instanceof EClass) {
                EReference eReference = (EReference)feature;
                if (this.packageMetaData.isInverse(eReference)) continue;
                if (!isFirst) {
                    this.print(COMMA);
                }
                this.writeEClass(object, feature);
                isFirst = false;
                continue;
            }
            if (!(type instanceof EDataType)) continue;
            if (!isFirst) {
                this.print(COMMA);
            }
            this.writeEDataType(object, entityBN, feature);
            isFirst = false;
        }
        this.println(PAREN_CLOSE_SEMICOLON);
    }

    private long getExpressId(HashMapVirtualObject object) {
        return this.getExpressId(object.getOid());
    }

    private long getExpressId(long oid) {
        if (this.oidToEid.containsKey(oid)) {
            return this.oidToEid.get(oid);
        }
        long eid = this.oidCounter++;
        this.oidToEid.put(oid, eid);
        return eid;
    }

    private void writeEDataType(HashMapVirtualObject object, EntityDefinition entityBN, EStructuralFeature feature) throws SerializerException, IOException {
        if (entityBN != null && entityBN.isDerived(feature.getName())) {
            this.print(ASTERISK);
        } else if (feature.isMany()) {
            this.writeList((MinimalVirtualObject)object, feature);
        } else {
            this.writeObject(object, feature);
        }
    }

    private void writeEClass(HashMapVirtualObject object, EStructuralFeature feature) throws SerializerException, IOException {
        Object referencedObject = object.eGet(feature);
        if (referencedObject instanceof AbstractHashMapVirtualObject && ((AbstractHashMapVirtualObject)referencedObject).eClass().getEAnnotation("wrapped") != null) {
            this.writeWrappedValue(object, feature, ((AbstractHashMapVirtualObject)referencedObject).eClass());
        } else if (referencedObject instanceof Long) {
            if (object.useFeatureForSerialization(feature)) {
                this.print(DASH);
                this.print(String.valueOf(this.getExpressId((Long)referencedObject)));
            } else {
                this.print(DOLLAR);
            }
        } else {
            EntityDefinition entityBN = this.getSchemaDefinition().getEntityBN(object.eClass().getName());
            if (entityBN != null && entityBN.isDerived(feature.getName())) {
                this.print(ASTERISK);
            } else if (feature.isMany()) {
                this.writeList((MinimalVirtualObject)object, feature);
            } else {
                this.writeObject(object, feature);
            }
        }
    }

    private void writeObject(HashMapVirtualObject object, EStructuralFeature feature) throws SerializerException, IOException {
        Object ref = object.eGet(feature);
        if (ref == null || feature.isUnsettable() && !object.eIsSet(feature)) {
            EClassifier type = feature.getEType();
            if (type instanceof EClass) {
                EStructuralFeature structuralFeature = ((EClass)type).getEStructuralFeature(WRAPPED_VALUE);
                if (structuralFeature != null) {
                    String name = structuralFeature.getEType().getName();
                    if (name.equals(IFC_BOOLEAN) || name.equals(IFC_LOGICAL) || structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                        this.print(BOOLEAN_UNDEFINED);
                    } else {
                        this.print(DOLLAR);
                    }
                } else {
                    this.print(DOLLAR);
                }
            } else if (type == EcorePackage.eINSTANCE.getEBoolean()) {
                this.print(BOOLEAN_UNDEFINED);
            } else if (feature.isMany()) {
                this.print(OPEN_CLOSE_PAREN);
            } else {
                this.print(DOLLAR);
            }
        } else if (ref instanceof HashMapWrappedVirtualObject) {
            this.writeEmbedded((HashMapWrappedVirtualObject)ref);
        } else if (feature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
            EStructuralFeature asStringFeature = object.eClass().getEStructuralFeature(feature.getName() + "AsString");
            String asString = (String)object.eGet(asStringFeature);
            this.writeDoubleValue((Double)ref, asString, feature);
        } else {
            IfcParserWriterUtils.writePrimitive(ref, this.printWriter);
        }
    }

    private void writeDoubleValue(double value, String asString, EStructuralFeature feature) throws SerializerException, IOException {
        if (asString != null) {
            this.print(asString);
            return;
        }
        IfcParserWriterUtils.writePrimitive((Object)value, this.printWriter);
    }

    private void writeEmbedded(HashMapWrappedVirtualObject eObject) throws SerializerException, IOException {
        EClass class1 = eObject.eClass();
        this.print(this.packageMetaData.getUpperCase(class1));
        this.print(OPEN_PAREN);
        EStructuralFeature structuralFeature = class1.getEStructuralFeature(WRAPPED_VALUE);
        if (structuralFeature != null) {
            Object realVal = eObject.eGet(structuralFeature);
            if (structuralFeature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
                EStructuralFeature asStringFeature = eObject.eClass().getEStructuralFeature(structuralFeature.getName() + "AsString");
                String asString = (String)eObject.eGet(asStringFeature);
                this.writeDoubleValue((Double)realVal, asString, structuralFeature);
            } else {
                IfcParserWriterUtils.writePrimitive(realVal, this.printWriter);
            }
        }
        this.print(CLOSE_PAREN);
    }

    private void writeList(MinimalVirtualObject object, EStructuralFeature feature) throws SerializerException, IOException {
        List list = (List)object.eGet(feature);
        if (list == null) {
            if (feature.isUnsettable()) {
                this.print(DOLLAR);
            } else {
                this.print(OPEN_CLOSE_PAREN);
            }
            return;
        }
        List doubleStingList = null;
        if (feature.getEType() == EcorePackage.eINSTANCE.getEDouble()) {
            EStructuralFeature doubleStringFeature = feature.getEContainingClass().getEStructuralFeature(feature.getName() + "AsString");
            if (doubleStringFeature == null) {
                throw new SerializerException("Field " + feature.getName() + "AsString not found");
            }
            doubleStingList = (List)object.eGet(doubleStringFeature);
        }
        if (list.isEmpty() || !object.useFeatureForSerialization(feature) && feature.getEAnnotation("twodimensionalarray") == null) {
            if (!feature.isUnsettable()) {
                this.print(OPEN_CLOSE_PAREN);
            } else {
                this.print(DOLLAR);
            }
        } else {
            this.print(OPEN_PAREN);
            boolean first = true;
            int index = 0;
            for (Object listObject : list) {
                if (object.useFeatureForSerialization(feature, index) || feature.getEAnnotation("twodimensionalarray") != null) {
                    HashMapVirtualObject td;
                    HashMapWrappedVirtualObject eObject;
                    if (!first) {
                        this.print(COMMA);
                    }
                    if (feature instanceof EReference && listObject instanceof Long) {
                        this.print(DASH);
                        this.print(String.valueOf(this.getExpressId((Long)listObject)));
                    } else if (listObject == null) {
                        this.print(DOLLAR);
                    } else if (listObject instanceof HashMapWrappedVirtualObject && feature.getEType().getEAnnotation("wrapped") != null) {
                        eObject = (HashMapWrappedVirtualObject)listObject;
                        Object realVal = eObject.eGet(eObject.eClass().getEStructuralFeature(WRAPPED_VALUE));
                        if (realVal instanceof Double) {
                            Object stringVal = eObject.eGet(eObject.eClass().getEStructuralFeature("wrappedValueAsString"));
                            if (stringVal != null) {
                                this.print((String)stringVal);
                            } else {
                                IfcParserWriterUtils.writePrimitive(realVal, this.printWriter);
                            }
                        } else {
                            IfcParserWriterUtils.writePrimitive(realVal, this.printWriter);
                        }
                    } else if (listObject instanceof HashMapVirtualObject && feature.getEAnnotation("twodimensionalarray") != null) {
                        td = (HashMapVirtualObject)listObject;
                        this.writeList((MinimalVirtualObject)td, td.eClass().getEStructuralFeature("List"));
                    } else if (listObject instanceof HashMapVirtualObject) {
                        td = (HashMapVirtualObject)listObject;
                        this.print(this.packageMetaData.getUpperCase(td.eClass()));
                        this.print(OPEN_PAREN);
                        this.writeList((MinimalVirtualObject)td, td.eClass().getEStructuralFeature(WRAPPED_VALUE));
                        this.print(CLOSE_PAREN);
                    } else if (listObject instanceof HashMapWrappedVirtualObject) {
                        eObject = (HashMapWrappedVirtualObject)listObject;
                        EClass class1 = eObject.eClass();
                        EStructuralFeature structuralFeature = class1.getEStructuralFeature(WRAPPED_VALUE);
                        if (structuralFeature != null) {
                            Object realVal = eObject.eGet(structuralFeature);
                            this.print(this.packageMetaData.getUpperCase(class1));
                            this.print(OPEN_PAREN);
                            if (realVal instanceof Double) {
                                EStructuralFeature asStringFeature = eObject.eClass().getEStructuralFeature(structuralFeature.getName() + "AsString");
                                String asString = (String)eObject.eGet(asStringFeature);
                                this.writeDoubleValue((Double)realVal, asString, structuralFeature);
                            } else {
                                IfcParserWriterUtils.writePrimitive(realVal, this.printWriter);
                            }
                            this.print(CLOSE_PAREN);
                        } else if (feature.getEAnnotation("twodimensionalarray") != null) {
                            this.writeList((MinimalVirtualObject)eObject, eObject.eClass().getEStructuralFeature("List"));
                        }
                    } else if (doubleStingList != null) {
                        if (index < doubleStingList.size()) {
                            String val = (String)doubleStingList.get(index);
                            if (val == null) {
                                IfcParserWriterUtils.writePrimitive(listObject, this.printWriter);
                            } else {
                                this.print(val);
                            }
                        } else {
                            IfcParserWriterUtils.writePrimitive(listObject, this.printWriter);
                        }
                    } else {
                        IfcParserWriterUtils.writePrimitive(listObject, this.printWriter);
                    }
                    first = false;
                }
                ++index;
            }
            this.print(CLOSE_PAREN);
        }
    }

    private void writeWrappedValue(HashMapVirtualObject object, EStructuralFeature feature, EClass ec) throws SerializerException, IOException {
        Object get = object.eGet(feature);
        boolean isWrapped = ec.getEAnnotation("wrapped") != null;
        EStructuralFeature structuralFeature = ec.getEStructuralFeature(WRAPPED_VALUE);
        if (get instanceof HashMapWrappedVirtualObject) {
            boolean isDefinedWrapped = feature.getEType().getEAnnotation("wrapped") != null;
            HashMapWrappedVirtualObject betweenObject = (HashMapWrappedVirtualObject)get;
            if (betweenObject != null) {
                if (isWrapped && isDefinedWrapped) {
                    Object val = betweenObject.eGet(structuralFeature);
                    String name = structuralFeature.getEType().getName();
                    if ((name.equals(IFC_BOOLEAN) || name.equals(IFC_LOGICAL)) && val == null) {
                        this.print(BOOLEAN_UNDEFINED);
                    } else if (structuralFeature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
                        EStructuralFeature asStringFeature = betweenObject.eClass().getEStructuralFeature(feature.getName() + "AsString");
                        String asString = (String)betweenObject.eGet(asStringFeature);
                        this.writeDoubleValue((Double)val, asString, feature);
                    } else {
                        IfcParserWriterUtils.writePrimitive(val, this.printWriter);
                    }
                } else {
                    this.writeEmbedded(betweenObject);
                }
            }
        } else if (get instanceof EList) {
            EList list = (EList)get;
            if (list.isEmpty()) {
                if (!feature.isUnsettable()) {
                    this.print(OPEN_CLOSE_PAREN);
                } else {
                    this.print(DOLLAR);
                }
            } else {
                this.print(OPEN_PAREN);
                boolean first = true;
                for (Object o : list) {
                    if (!first) {
                        this.print(COMMA);
                    }
                    HashMapVirtualObject object2 = (HashMapVirtualObject)o;
                    Object val = object2.eGet(structuralFeature);
                    if (structuralFeature.getEType() == ECORE_PACKAGE_INSTANCE.getEDouble()) {
                        EStructuralFeature asStringFeature = object2.eClass().getEStructuralFeature(feature.getName() + "AsString");
                        String asString = (String)object2.eGet(asStringFeature);
                        this.writeDoubleValue((Double)val, asString, structuralFeature);
                    } else {
                        IfcParserWriterUtils.writePrimitive(val, this.printWriter);
                    }
                    first = false;
                }
                this.print(CLOSE_PAREN);
            }
        } else if (get == null) {
            EClassifier type = structuralFeature.getEType();
            if (type.getName().equals(IFC_BOOLEAN) || type.getName().equals(IFC_LOGICAL) || type == ECORE_PACKAGE_INSTANCE.getEBoolean()) {
                this.print(BOOLEAN_UNDEFINED);
            } else {
                EntityDefinition entityBN = this.getSchemaDefinition().getEntityBN(object.eClass().getName());
                if (entityBN != null && entityBN.isDerived(feature.getName())) {
                    this.print(ASTERISK);
                } else {
                    this.print(DOLLAR);
                }
            }
        } else {
            System.out.println("Unimplemented?");
        }
    }

    private SchemaDefinition getSchemaDefinition() {
        return this.packageMetaData.getSchemaDefinition();
    }

    private void writeEnum(HashMapVirtualObject object, EStructuralFeature feature) throws SerializerException, IOException {
        Object val = object.eGet(feature);
        if (feature.getEType().getName().equals("Tristate")) {
            if (val == null) {
                this.print(DOLLAR);
            } else {
                IfcParserWriterUtils.writePrimitive(val, this.printWriter);
            }
        } else if (val == null) {
            this.print(DOLLAR);
        } else if (((Enum)val).toString().equals(NULL)) {
            this.print(DOLLAR);
        } else {
            this.print(DOT);
            this.print(val.toString());
            this.print(DOT);
        }
    }

    protected static enum Mode {
        HEADER,
        BODY,
        FOOTER,
        FINISHED;

    }
}

