/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.geometry.Matrix;
import org.bimserver.geometry.Matrix3;
import org.bimserver.geometry.Vector;
import org.bimserver.geometry.Vector3D;
import org.bimserver.interfaces.objects.SVector3f;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.plugins.LittleEndianSerializerDataOutputStream;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.SerializerDataOutputStream;
import org.bimserver.plugins.serializers.MessagingStreamingSerializer;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.serializers.binarygeometry.GeometryBuffer;
import org.bimserver.serializers.binarygeometry.GeometryMainBuffer;
import org.bimserver.serializers.binarygeometry.GeometrySubBuffer;
import org.bimserver.serializers.binarygeometry.LineSegment;
import org.bimserver.serializers.binarygeometry.Mesh;
import org.bimserver.serializers.binarygeometry.MeshChanger;
import org.bimserver.serializers.binarygeometry.clipping.Point;
import org.bimserver.shared.AbstractHashMapVirtualObject;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryGeometryMessagingStreamingSerializer
implements MessagingStreamingSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryGeometryMessagingStreamingSerializer.class);
    private static final byte FORMAT_VERSION = 19;
    private boolean splitGeometry = true;
    private boolean useSingleColors = false;
    private boolean quantizeNormals = false;
    private boolean quantizeVertices = false;
    private boolean quantizeColors = false;
    private boolean prepareBuffers = false;
    private boolean normalizeUnitsToMM = false;
    private boolean useSmallInts = true;
    private boolean reportProgress = true;
    private boolean useUuidAndRid = false;
    private Map<Long, float[]> vertexQuantizationMatrices;
    private GeometryMainBuffer transparentGeometryBuffer;
    private GeometryMainBuffer opaqueGeometryBuffer;
    private final Map<Long, HashMapVirtualObject> oidToGeometryData = new HashMap<Long, HashMapVirtualObject>();
    private final Map<Long, HashMapVirtualObject> dataToGeometryInfo = new HashMap<Long, HashMapVirtualObject>();
    private double[] vertexQuantizationMatrix;
    private Mode mode = Mode.LOAD;
    private long splitCounter = 0L;
    private ObjectProvider objectProvider;
    private ProjectInfo projectInfo;
    private SerializerDataOutputStream serializerDataOutputStream;
    private HashMapVirtualObject next;
    private ProgressReporter progressReporter;
    private int nrObjectsWritten;
    private int size;
    private ByteBuffer lastTransformation;
    private Set<Long> reusedDataOids;
    private double[] globalTranslationVector;
    private boolean generateLineRenders;

    public void init(ObjectProvider objectProvider, ProjectInfo projectInfo, PluginManagerInterface pluginManager, PackageMetaData packageMetaData) throws SerializerException {
        ObjectNode tilesNode;
        this.objectProvider = objectProvider;
        this.projectInfo = projectInfo;
        ObjectNode queryNode = objectProvider.getQueryNode();
        if (queryNode.has("tiles") && (tilesNode = (ObjectNode)queryNode.get("tiles")).has("geometryDataToReuse") && !tilesNode.get("geometryDataToReuse").isNull()) {
            ArrayNode reuseNodes = (ArrayNode)tilesNode.get("geometryDataToReuse");
            this.reusedDataOids = new HashSet<Long>();
            for (Object jsonNode : reuseNodes) {
                this.reusedDataOids.add(jsonNode.asLong());
            }
        }
        if (queryNode.has("loaderSettings")) {
            ObjectNode geometrySettings = (ObjectNode)queryNode.get("loaderSettings");
            this.useUuidAndRid = geometrySettings.has("useUuidAndRid") && geometrySettings.get("useUuidAndRid").asBoolean();
            this.useSingleColors = geometrySettings.has("useObjectColors") && geometrySettings.get("useObjectColors").asBoolean();
            this.splitGeometry = geometrySettings.has("splitGeometry") && geometrySettings.get("splitGeometry").asBoolean();
            this.quantizeNormals = geometrySettings.has("quantizeNormals") && geometrySettings.get("quantizeNormals").asBoolean();
            this.quantizeVertices = geometrySettings.has("quantizeVertices") && geometrySettings.get("quantizeVertices").asBoolean();
            this.quantizeColors = geometrySettings.has("quantizeColors") && geometrySettings.get("quantizeColors").asBoolean();
            this.normalizeUnitsToMM = geometrySettings.has("normalizeUnitsToMM") && geometrySettings.get("normalizeUnitsToMM").asBoolean();
            this.reportProgress = !geometrySettings.has("reportProgress") || geometrySettings.get("reportProgress").asBoolean();
            this.useSmallInts = !geometrySettings.has("useSmallInts") || geometrySettings.get("useSmallInts").asBoolean();
            this.prepareBuffers = geometrySettings.has("prepareBuffers") && geometrySettings.get("prepareBuffers").asBoolean();
            boolean bl = this.generateLineRenders = geometrySettings.has("generateLineRenders") && geometrySettings.get("generateLineRenders").asBoolean();
            if (geometrySettings.has("globalTranslationVector")) {
                this.globalTranslationVector = new double[3];
                ArrayNode matrixNode = (ArrayNode)geometrySettings.get("globalTranslationVector");
                int i = 0;
                for (JsonNode v : matrixNode) {
                    this.globalTranslationVector[i++] = v.asDouble();
                }
            }
            if (this.prepareBuffers) {
                this.transparentGeometryBuffer = new GeometryMainBuffer();
                this.opaqueGeometryBuffer = new GeometryMainBuffer();
            }
            if (this.quantizeVertices) {
                ArrayNode vqmNode;
                if (queryNode.has("loaderSettings") && (vqmNode = (ArrayNode)geometrySettings.get("vertexQuantizationMatrix")) != null) {
                    this.vertexQuantizationMatrix = new double[16];
                    int i = 0;
                    for (JsonNode v : vqmNode) {
                        this.vertexQuantizationMatrix[i++] = v.doubleValue();
                    }
                }
                if ((vqmNode = (ObjectNode)geometrySettings.get("vertexQuantizationMatrices")) != null) {
                    Iterator fieldNames = vqmNode.fieldNames();
                    this.vertexQuantizationMatrices = new HashMap<Long, float[]>();
                    while (fieldNames.hasNext()) {
                        String key = (String)fieldNames.next();
                        long croid = Long.parseLong(key);
                        float[] vertexQuantizationMatrix = new float[16];
                        ArrayNode mNode = (ArrayNode)vqmNode.get(key);
                        this.vertexQuantizationMatrices.put(croid, vertexQuantizationMatrix);
                        int i = 0;
                        for (JsonNode v : mNode) {
                            vertexQuantizationMatrix[i++] = v.floatValue();
                        }
                    }
                }
            }
        }
    }

    public boolean writeMessage(OutputStream outputStream, ProgressReporter progressReporter) throws IOException, SerializerException {
        this.progressReporter = progressReporter;
        this.serializerDataOutputStream = null;
        this.serializerDataOutputStream = outputStream instanceof SerializerDataOutputStream ? (SerializerDataOutputStream)outputStream : new LittleEndianSerializerDataOutputStream(outputStream);
        switch (this.mode) {
            case LOAD: {
                this.load();
                this.mode = Mode.START;
            }
            case START: {
                this.writeStart();
                this.serializerDataOutputStream.align8();
                if (this.next == null) {
                    this.mode = Mode.END;
                    break;
                }
                this.mode = Mode.DATA;
                break;
            }
            case DATA: {
                if (!this.writeData()) {
                    this.serializerDataOutputStream.align8();
                    this.mode = this.prepareBuffers ? Mode.PREPARED_BUFFER_OPAQUE : Mode.END;
                    return true;
                }
                this.serializerDataOutputStream.align8();
                break;
            }
            case PREPARED_BUFFER_OPAQUE: {
                if (this.writePreparedBuffer(this.mode)) break;
                this.mode = Mode.PREPARED_BUFFER_TRANSPARENT;
                break;
            }
            case PREPARED_BUFFER_TRANSPARENT: {
                if (this.writePreparedBuffer(this.mode)) break;
                this.mode = Mode.END;
                break;
            }
            case END: {
                this.writeEnd();
                this.serializerDataOutputStream.align8();
                return false;
            }
        }
        return true;
    }

    private boolean writePreparedBuffer(Mode mode) throws IOException, SerializerException {
        GeometryMainBuffer geometryMainBuffer = this.getCurrentMainBuffer();
        if (geometryMainBuffer == null) {
            return false;
        }
        GeometryBuffer geometryBuffer = geometryMainBuffer.getCurrentReadBuffer();
        while (geometryBuffer == null || geometryBuffer.isEmpty() || !geometryBuffer.hasNextGeometryMapping()) {
            if (geometryMainBuffer.hasNextReadBuffer()) {
                geometryBuffer = geometryMainBuffer.getNextReadBuffer();
                continue;
            }
            return false;
        }
        if (!geometryBuffer.initSent()) {
            ByteBuffer buffer = ByteBuffer.allocate(25).order(ByteOrder.LITTLE_ENDIAN);
            buffer.put(mode == Mode.PREPARED_BUFFER_OPAQUE ? MessageType.PREPARED_BUFFER_OPAQUE_INIT.getId() : MessageType.PREPARED_BUFFER_TRANSPARENT_INIT.getId());
            buffer.putInt(geometryBuffer.getNrObjects());
            buffer.putInt(geometryBuffer.getNrIndices());
            buffer.putInt(this.generateLineRenders ? geometryBuffer.getNrLineIndices() : 0);
            buffer.putInt(geometryBuffer.getNrVertices());
            buffer.putInt(geometryBuffer.getNrVertices());
            buffer.putInt(geometryBuffer.getNrColors());
            this.serializerDataOutputStream.write(buffer.array());
            this.serializerDataOutputStream.align8();
            geometryBuffer.setInitSent();
            return true;
        }
        int vertexPosition = 0;
        this.serializerDataOutputStream.writeByte(mode == Mode.PREPARED_BUFFER_TRANSPARENT ? 7 : 8);
        GeometrySubBuffer geometryMapping = geometryBuffer.getNextGeometryMapping();
        ByteBuffer buffer = ByteBuffer.allocate(geometryMapping.getPreparedByteSize()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(geometryMapping.getNrObjects());
        buffer.putInt(geometryMapping.getNrIndices());
        buffer.putInt(this.generateLineRenders ? geometryMapping.getNrLineIndices() : 0);
        buffer.putInt(geometryMapping.getNrVertices());
        buffer.putInt(geometryMapping.getNrVertices());
        buffer.putInt(geometryMapping.getNrColors());
        int indicesStartByte = 24;
        int lineIndicesStartByte = indicesStartByte + geometryMapping.getNrIndices() * 4;
        int indicesMappingStartByte = this.generateLineRenders ? lineIndicesStartByte + geometryMapping.getNrLineIndices() * 4 : lineIndicesStartByte;
        int verticesStartByte = indicesMappingStartByte + geometryMapping.getNrObjects() * (44 + (this.useUuidAndRid ? 20 : 0)) + geometryMapping.getTotalColorPackSize();
        int normalsStartByte = verticesStartByte + geometryMapping.getNrVertices() * (this.quantizeVertices ? 2 : 4);
        int baseIndex = geometryMapping.getBaseIndex();
        for (HashMapVirtualObject info : geometryMapping.keySet()) {
            byte[] colorPackData;
            HashMapVirtualObject data = geometryMapping.get(info);
            DoubleBuffer transformation = ByteBuffer.wrap((byte[])info.eGet(info.eClass().getEStructuralFeature("transformation"))).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
            double[] ms = new double[16];
            for (int i = 0; i < 16; ++i) {
                ms[i] = transformation.get();
            }
            AbstractHashMapVirtualObject indicesBuffer = data.getDirectFeature((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Indices());
            byte[] normals = null;
            byte[] vertices = null;
            AbstractHashMapVirtualObject normalsBuffer = data.getDirectFeature((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Normals());
            normals = (byte[])normalsBuffer.get("data");
            AbstractHashMapVirtualObject verticesBuffer = data.getDirectFeature((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Vertices());
            vertices = (byte[])verticesBuffer.get("data");
            IntBuffer indices = ByteBuffer.wrap((byte[])indicesBuffer.get("data")).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            ByteBuffer vertexByteBuffer = ByteBuffer.wrap(vertices).order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer normalsByteBuffer = ByteBuffer.wrap(normals).order(ByteOrder.LITTLE_ENDIAN);
            AbstractHashMapVirtualObject lineIndicesBuffer = data.getDirectFeature((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_LineIndices());
            byte[] lineIndicesBytes = null;
            if (lineIndicesBuffer != null) {
                lineIndicesBytes = (byte[])lineIndicesBuffer.get("data");
            }
            Long oid = (Long)info.get("ifcProductOid");
            buffer.putLong(indicesMappingStartByte, oid);
            indicesMappingStartByte += 8;
            if (this.useUuidAndRid) {
                buffer.position(indicesMappingStartByte);
                byte[] bytes = (byte[])info.get("ifcProductUuid");
                buffer.put(bytes);
                buffer.putInt(indicesMappingStartByte += 16, (Integer)info.get("ifcProductRid"));
                indicesMappingStartByte += 4;
            }
            int indicesStart = (indicesStartByte - 24) / 4;
            buffer.putInt(indicesMappingStartByte, indicesStart);
            buffer.putInt(indicesMappingStartByte += 4, (lineIndicesStartByte - indicesStart) / 4);
            buffer.putInt(indicesMappingStartByte += 4, indices.capacity());
            buffer.putInt(indicesMappingStartByte += 4, lineIndicesBytes == null ? 0 : lineIndicesBytes.length / 4);
            buffer.putInt(indicesMappingStartByte += 4, vertices.length / 8);
            indicesMappingStartByte += 4;
            int minIndex = -1;
            int maxIndex = -1;
            for (int i = 0; i < indices.capacity(); ++i) {
                int index = indices.get();
                int modifiedIndex = baseIndex + index + vertexPosition / 3;
                if (minIndex == -1 || modifiedIndex < minIndex) {
                    minIndex = modifiedIndex;
                }
                if (maxIndex == -1 || modifiedIndex > maxIndex) {
                    maxIndex = modifiedIndex;
                }
                buffer.putInt(indicesStartByte, baseIndex + index + vertexPosition / 3);
                indicesStartByte += 4;
            }
            if (this.generateLineRenders) {
                buffer.position(lineIndicesStartByte);
                buffer.put(lineIndicesBytes);
                lineIndicesStartByte += lineIndicesBytes.length;
            }
            buffer.putInt(indicesMappingStartByte, minIndex);
            buffer.putInt(indicesMappingStartByte += 4, maxIndex);
            float density = ((Float)info.get("density")).floatValue();
            buffer.putFloat(indicesMappingStartByte += 4, density);
            indicesMappingStartByte += 4;
            HashMapVirtualObject colorPack = (HashMapVirtualObject)data.getDirectFeature((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_ColorPack());
            byte[] byArray = colorPackData = colorPack == null ? null : (byte[])colorPack.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getColorPack_Data());
            if (colorPackData == null || colorPackData.length == 0) {
                buffer.putInt(indicesMappingStartByte, 0);
                indicesMappingStartByte += 4;
            } else {
                int colorPackSize = colorPackData.length / 8;
                buffer.putInt(indicesMappingStartByte, colorPackSize);
                buffer.position(indicesMappingStartByte += 4);
                buffer.put(colorPackData);
                indicesMappingStartByte += colorPackData.length;
            }
            double[] in = new double[4];
            double[] vertex = new double[4];
            double[] result = new double[4];
            in[3] = 1.0;
            vertex[3] = 1.0;
            int nrPos = vertexByteBuffer.capacity() / 8;
            for (int i = 0; i < nrPos; i += 3) {
                in[0] = vertexByteBuffer.getDouble();
                in[1] = vertexByteBuffer.getDouble();
                in[2] = vertexByteBuffer.getDouble();
                Matrix.multiplyMV((double[])vertex, (int)0, (double[])ms, (int)0, (double[])in, (int)0);
                if (this.projectInfo.getMultiplierToMm() != 1.0f) {
                    vertex[0] = vertex[0] * (double)this.projectInfo.getMultiplierToMm();
                    vertex[1] = vertex[1] * (double)this.projectInfo.getMultiplierToMm();
                    vertex[2] = vertex[2] * (double)this.projectInfo.getMultiplierToMm();
                }
                if (this.globalTranslationVector != null) {
                    Vector.addition((double[])vertex, (double[])this.globalTranslationVector, (double[])vertex);
                }
                if (this.quantizeVertices) {
                    Matrix.multiplyMV((double[])result, (int)0, (double[])this.vertexQuantizationMatrix, (int)0, (double[])vertex, (int)0);
                    buffer.putShort(verticesStartByte, (short)result[0]);
                    buffer.putShort(verticesStartByte + 2, (short)result[1]);
                    buffer.putShort(verticesStartByte + 4, (short)result[2]);
                    verticesStartByte += 6;
                    continue;
                }
                buffer.putFloat(verticesStartByte, (float)vertex[0]);
                buffer.putFloat(verticesStartByte + 4, (float)vertex[1]);
                buffer.putFloat(verticesStartByte + 8, (float)vertex[2]);
                verticesStartByte += 12;
            }
            vertexPosition += nrPos;
            double[] inverted = new double[9];
            double[] transposed = new double[9];
            double[] mat3 = new double[9];
            Matrix3.fromMat4((double[])mat3, (double[])ms);
            Matrix3.invert((double[])inverted, (double[])mat3);
            Matrix3.transpose((double[])transposed, (double[])inverted);
            float[] normalIn = new float[3];
            float[] normal = new float[3];
            for (int i = 0; i < nrPos; i += 3) {
                normalIn[0] = normalsByteBuffer.getFloat();
                normalIn[1] = normalsByteBuffer.getFloat();
                normalIn[2] = normalsByteBuffer.getFloat();
                Matrix3.multiplyMV((float[])normal, (float[])normalIn, (double[])transposed);
                Vector3D.normalize((float[])normal, (float[])normal);
                this.writeNormalToOct(buffer, normalsStartByte, normal);
                normalsStartByte += 2;
            }
        }
        this.serializerDataOutputStream.write(buffer.array());
        this.serializerDataOutputStream.align8();
        return geometryMainBuffer.hasNextReadBuffer() || geometryBuffer.hasNextGeometryMapping();
    }

    private void reorderForLineRendering(IntBuffer indices, DoubleBuffer vertices, FloatBuffer normals) {
        Mesh mesh = new Mesh(indices, vertices, normals);
        Mesh newMesh = mesh.copy();
        MeshChanger meshChanger = new MeshChanger(mesh, newMesh);
        HashMap<LineSegment, LineSegment> lineSegments = new HashMap<LineSegment, LineSegment>();
        for (int i = 0; i < indices.capacity(); i += 3) {
            int[] triangle = new int[]{indices.get(), indices.get(), indices.get()};
            for (int j = 0; j < 3; ++j) {
                LineSegment lineSegment = new LineSegment(i / 3, triangle[j], triangle[(j + 1) % 3]);
                if (lineSegments.containsKey(lineSegment)) {
                    lineSegments.remove(lineSegment);
                    continue;
                }
                lineSegments.put(lineSegment, lineSegment);
            }
        }
        for (LineSegment lineSegment : lineSegments.keySet()) {
            lineSegment.getIndex1();
        }
    }

    private float signNotZero(float in) {
        return in >= 0.0f ? 1.0f : -1.0f;
    }

    private void writeNormalToOct(ByteBuffer buffer, int normalsStartByte, float[] normal) {
        float x = Math.abs(normal[0]) + Math.abs(normal[1]) + Math.abs(normal[2]);
        float[] p = new float[]{normal[0] / x, normal[1] / x};
        if (normal[2] <= 0.0f) {
            float a = (1.0f - Math.abs(p[0])) * this.signNotZero(p[0]);
            float b = (1.0f - Math.abs(p[1])) * this.signNotZero(p[1]);
            p = new float[]{a, b};
        }
        byte a = (byte)(p[0] * 127.0f);
        buffer.put(normalsStartByte, a);
        byte b = (byte)(p[1] * 127.0f);
        buffer.put(normalsStartByte + 1, b);
    }

    private void load() throws SerializerException {
        if (this.reportProgress) {
            this.size = 0;
            HashMapVirtualObject next = null;
            try {
                next = this.objectProvider.next();
                while (next != null) {
                    if (next.eClass() == GeometryPackage.eINSTANCE.getGeometryInfo()) {
                        ++this.size;
                    }
                    next = this.objectProvider.next();
                }
            }
            catch (BimserverDatabaseException e) {
                throw new SerializerException((Throwable)e);
            }
            try {
                this.objectProvider = this.objectProvider.copy();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
        }
        try {
            this.next = this.objectProvider.next();
        }
        catch (BimserverDatabaseException e) {
            e.printStackTrace();
        }
    }

    private boolean writeEnd() throws IOException {
        this.serializerDataOutputStream.write((int)MessageType.END.getId());
        return true;
    }

    private void writeStart() throws IOException {
        this.serializerDataOutputStream.writeByte(MessageType.INIT.getId());
        this.serializerDataOutputStream.writeUTF("BGS");
        this.serializerDataOutputStream.writeByte((byte)19);
        this.serializerDataOutputStream.writeFloat(this.projectInfo.getMultiplierToMm());
        this.serializerDataOutputStream.align8();
        SVector3f minBounds = this.projectInfo.getMinBounds();
        SVector3f maxBounds = this.projectInfo.getMaxBounds();
        if (this.normalizeUnitsToMM && this.projectInfo.getMultiplierToMm() != 1.0f) {
            this.serializerDataOutputStream.writeDouble(minBounds.getX() * (double)this.projectInfo.getMultiplierToMm());
            this.serializerDataOutputStream.writeDouble(minBounds.getY() * (double)this.projectInfo.getMultiplierToMm());
            this.serializerDataOutputStream.writeDouble(minBounds.getZ() * (double)this.projectInfo.getMultiplierToMm());
            this.serializerDataOutputStream.writeDouble(maxBounds.getX() * (double)this.projectInfo.getMultiplierToMm());
            this.serializerDataOutputStream.writeDouble(maxBounds.getY() * (double)this.projectInfo.getMultiplierToMm());
            this.serializerDataOutputStream.writeDouble(maxBounds.getZ() * (double)this.projectInfo.getMultiplierToMm());
        } else {
            this.serializerDataOutputStream.writeDouble(minBounds.getX());
            this.serializerDataOutputStream.writeDouble(minBounds.getY());
            this.serializerDataOutputStream.writeDouble(minBounds.getZ());
            this.serializerDataOutputStream.writeDouble(maxBounds.getX());
            this.serializerDataOutputStream.writeDouble(maxBounds.getY());
            this.serializerDataOutputStream.writeDouble(maxBounds.getZ());
        }
    }

    private boolean writeData() throws IOException, SerializerException {
        if (this.next == null) {
            return false;
        }
        boolean wroteSomething = false;
        while (!wroteSomething && this.next != null) {
            if (GeometryPackage.eINSTANCE.getGeometryInfo() == this.next.eClass()) {
                this.writeGeometryInfo(this.next);
                wroteSomething = true;
            } else if (GeometryPackage.eINSTANCE.getGeometryData() == this.next.eClass()) {
                wroteSomething = this.writeGeometryData(this.next, this.next.getOid());
            }
            try {
                this.next = this.objectProvider.next();
            }
            catch (BimserverDatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return this.next != null;
    }

    private void writeGeometryInfo(HashMapVirtualObject info) throws IOException, SerializerException {
        boolean hasTransparancy = (Boolean)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_HasTransparency());
        long geometryDataId = (Long)info.eGet(info.eClass().getEStructuralFeature("data"));
        boolean inPreparedBuffer = false;
        long oid = (Long)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_IfcProductOid());
        if (this.prepareBuffers && (this.reusedDataOids == null || !this.reusedDataOids.contains(geometryDataId))) {
            inPreparedBuffer = true;
            if (this.oidToGeometryData.containsKey(geometryDataId)) {
                GeometryMainBuffer geometryMainBuffer = this.getCurrentMainBuffer(hasTransparancy);
                GeometryBuffer currentBuffer = geometryMainBuffer.getCurrentWriteBuffer();
                GeometrySubBuffer geometryMapping = currentBuffer.getCurrentGeometryMapping(true);
                HashMapVirtualObject gd = this.oidToGeometryData.get(geometryDataId);
                geometryMapping.put(info, gd);
                this.updateSize(gd, currentBuffer);
            } else {
                this.dataToGeometryInfo.put(geometryDataId, info);
            }
            this.writeMinimalGeometryInfo(info);
            return;
        }
        byte[] transformation = (byte[])info.eGet(info.eClass().getEStructuralFeature("transformation"));
        long dataOid = geometryDataId;
        this.serializerDataOutputStream.writeByte(MessageType.GEOMETRY_INFO.getId());
        this.serializerDataOutputStream.writeByte(inPreparedBuffer ? (byte)1 : 0);
        this.serializerDataOutputStream.writeLong(oid);
        if (this.useUuidAndRid) {
            this.serializerDataOutputStream.write((byte[])info.get("ifcProductUuid"));
            this.serializerDataOutputStream.writeInt(((Integer)info.get("ifcProductRid")).intValue());
        }
        String type = this.objectProvider.getEClassForOid(oid).getName();
        this.serializerDataOutputStream.writeUTF(type);
        int nrColors = (Integer)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_NrColors());
        if (nrColors == 0) {
            int nrVertices = (Integer)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_NrVertices());
            nrColors = nrVertices / 3 * 4;
        }
        this.serializerDataOutputStream.writeInt(nrColors);
        this.serializerDataOutputStream.align8();
        this.serializerDataOutputStream.ensureExtraCapacity(24);
        this.serializerDataOutputStream.writeLongUnchecked(info.getRoid());
        this.serializerDataOutputStream.writeLongUnchecked(info.getOid());
        this.serializerDataOutputStream.writeLongUnchecked(hasTransparancy ? 1L : 0L);
        this.writeBounds(info);
        this.lastTransformation = ByteBuffer.wrap(transformation);
        this.lastTransformation.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newTransformation = this.lastTransformation;
        if (this.globalTranslationVector != null) {
            DoubleBuffer asDoubleBuffer = this.lastTransformation.asDoubleBuffer();
            double[] ms = new double[16];
            for (int i = 0; i < 16; ++i) {
                ms[i] = asDoubleBuffer.get();
            }
            double[] tmp = new double[16];
            double[] translationMatrix = new double[16];
            Matrix.setIdentityM((double[])translationMatrix, (int)0);
            Matrix.translateM((double[])translationMatrix, (int)0, (double[])translationMatrix, (int)0, (double)(this.globalTranslationVector[0] / (double)this.projectInfo.getMultiplierToMm()), (double)(this.globalTranslationVector[1] / (double)this.projectInfo.getMultiplierToMm()), (double)(this.globalTranslationVector[2] / (double)this.projectInfo.getMultiplierToMm()));
            Matrix.multiplyMM((double[])tmp, (int)0, (double[])translationMatrix, (int)0, (double[])ms, (int)0);
            ms = tmp;
            newTransformation = ByteBuffer.wrap(new byte[128]).order(ByteOrder.LITTLE_ENDIAN);
            for (double d : ms) {
                newTransformation.putDouble(d);
            }
        }
        this.serializerDataOutputStream.ensureExtraCapacity(transformation.length + 8);
        this.serializerDataOutputStream.write(newTransformation.array());
        this.serializerDataOutputStream.writeLong(dataOid);
        ++this.nrObjectsWritten;
        if (this.reportProgress && this.progressReporter != null) {
            this.progressReporter.update((long)this.nrObjectsWritten, (long)this.size);
        }
    }

    private void writeBounds(HashMapVirtualObject info) throws IOException {
        HashMapWrappedVirtualObject bounds = (HashMapWrappedVirtualObject)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Bounds());
        HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)bounds.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getBounds_Min());
        HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)bounds.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getBounds_Max());
        Double minX = (Double)minBounds.eGet("x");
        Double minY = (Double)minBounds.eGet("y");
        Double minZ = (Double)minBounds.eGet("z");
        Double maxX = (Double)maxBounds.eGet("x");
        Double maxY = (Double)maxBounds.eGet("y");
        Double maxZ = (Double)maxBounds.eGet("z");
        if (this.normalizeUnitsToMM && this.projectInfo.getMultiplierToMm() != 1.0f) {
            minX = minX * (double)this.projectInfo.getMultiplierToMm();
            minY = minY * (double)this.projectInfo.getMultiplierToMm();
            minZ = minZ * (double)this.projectInfo.getMultiplierToMm();
            maxX = maxX * (double)this.projectInfo.getMultiplierToMm();
            maxY = maxY * (double)this.projectInfo.getMultiplierToMm();
            maxZ = maxZ * (double)this.projectInfo.getMultiplierToMm();
        }
        this.serializerDataOutputStream.ensureExtraCapacity(48);
        this.serializerDataOutputStream.writeDoubleUnchecked(minX.doubleValue());
        this.serializerDataOutputStream.writeDoubleUnchecked(minY.doubleValue());
        this.serializerDataOutputStream.writeDoubleUnchecked(minZ.doubleValue());
        this.serializerDataOutputStream.writeDoubleUnchecked(maxX.doubleValue());
        this.serializerDataOutputStream.writeDoubleUnchecked(maxY.doubleValue());
        this.serializerDataOutputStream.writeDoubleUnchecked(maxZ.doubleValue());
    }

    private void writeMinimalGeometryInfo(HashMapVirtualObject info) throws IOException {
        boolean hasTransparancy = (Boolean)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_HasTransparency());
        long geometryDataId = (Long)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Data());
        long oid = (Long)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_IfcProductOid());
        this.serializerDataOutputStream.writeByte(MessageType.MINIMAL_GEOMETRY_INFO.getId());
        this.serializerDataOutputStream.writeLong(oid);
        if (this.useUuidAndRid) {
            byte[] b = (byte[])info.get("ifcProductUuid");
            if (b.length != 16) {
                throw new RuntimeException("Must be 16 bytes");
            }
            this.serializerDataOutputStream.write(b);
            this.serializerDataOutputStream.writeInt(((Integer)info.get("ifcProductRid")).intValue());
        }
        String type = this.objectProvider.getEClassForOid(oid).getName();
        this.serializerDataOutputStream.writeUTF(type);
        int nrColors = (Integer)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_NrColors());
        if (nrColors == 0) {
            int nrVertices = (Integer)info.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_NrVertices());
            nrColors = nrVertices / 3 * 4;
        }
        this.serializerDataOutputStream.writeInt(nrColors);
        this.serializerDataOutputStream.ensureExtraCapacity(32);
        this.serializerDataOutputStream.writeLongUnchecked(info.getRoid());
        this.serializerDataOutputStream.writeLongUnchecked(info.getOid());
        this.serializerDataOutputStream.writeLongUnchecked(hasTransparancy ? 1L : 0L);
        this.serializerDataOutputStream.align8();
        this.writeBounds(info);
        this.serializerDataOutputStream.writeLong(geometryDataId);
        ++this.nrObjectsWritten;
        if (this.reportProgress && this.progressReporter != null) {
            this.progressReporter.update((long)this.nrObjectsWritten, (long)this.size);
        }
    }

    private boolean writeGeometryData(HashMapVirtualObject data, long oid) throws IOException, SerializerException {
        EStructuralFeature hasTransparencyFeature = data.eClass().getEStructuralFeature("hasTransparency");
        boolean hasTransparancy = (Boolean)data.eGet(hasTransparencyFeature);
        if (this.prepareBuffers && (this.reusedDataOids == null || !this.reusedDataOids.contains(oid))) {
            this.oidToGeometryData.put(oid, data);
            if (this.dataToGeometryInfo.containsKey(oid)) {
                GeometryMainBuffer geometryMainBuffer = this.getCurrentMainBuffer(hasTransparancy);
                GeometryBuffer currentBuffer = geometryMainBuffer.getCurrentWriteBuffer();
                GeometrySubBuffer geometryMapping = currentBuffer.getCurrentGeometryMapping(true);
                geometryMapping.put(this.dataToGeometryInfo.get(oid), data);
                this.updateSize(data, currentBuffer);
            }
            return false;
        }
        EStructuralFeature indicesFeature = data.eClass().getEStructuralFeature("indices");
        EStructuralFeature verticesFeature = data.eClass().getEStructuralFeature("vertices");
        EStructuralFeature verticesQuantizedFeature = data.eClass().getEStructuralFeature("verticesQuantized");
        EStructuralFeature normalsFeature = data.eClass().getEStructuralFeature("normals");
        EStructuralFeature normalsQuantizedFeature = data.eClass().getEStructuralFeature("normalsQuantized");
        EStructuralFeature colorsFeature = data.eClass().getEStructuralFeature("colorsQuantized");
        EStructuralFeature colorFeature = data.eClass().getEStructuralFeature("color");
        EStructuralFeature mostUsedColorFeature = data.eClass().getEStructuralFeature("mostUsedColor");
        AbstractHashMapVirtualObject indicesBuffer = data.getDirectFeature(indicesFeature);
        byte[] normals = null;
        byte[] normalsQuantized = null;
        byte[] vertices = null;
        byte[] verticesQuantized = null;
        AbstractHashMapVirtualObject quantizedNormalsBuffer = data.getDirectFeature(normalsQuantizedFeature);
        if (this.quantizeNormals && quantizedNormalsBuffer != null) {
            normalsQuantized = (byte[])quantizedNormalsBuffer.get("data");
        } else {
            AbstractHashMapVirtualObject normalsBuffer = data.getDirectFeature(normalsFeature);
            normals = (byte[])normalsBuffer.get("data");
        }
        AbstractHashMapVirtualObject quantizedVerticesBuffer = data.getDirectFeature(verticesQuantizedFeature);
        if (this.quantizeVertices && quantizedVerticesBuffer != null) {
            verticesQuantized = (byte[])quantizedVerticesBuffer.get("data");
        } else {
            AbstractHashMapVirtualObject verticesBuffer = data.getDirectFeature(verticesFeature);
            vertices = (byte[])verticesBuffer.get("data");
        }
        AbstractHashMapVirtualObject colorsBuffer = data.getDirectFeature(colorsFeature);
        HashMapWrappedVirtualObject color = (HashMapWrappedVirtualObject)data.eGet(colorFeature);
        HashMapWrappedVirtualObject mostUsedColor = (HashMapWrappedVirtualObject)data.eGet(mostUsedColorFeature);
        byte[] indices = (byte[])indicesBuffer.get("data");
        byte[] colors = null;
        if (colorsBuffer != null) {
            colors = (byte[])colorsBuffer.get("data");
        }
        int totalNrIndices = indices.length / 4;
        int maxIndexValues = 16389;
        if (this.splitGeometry && totalNrIndices > maxIndexValues) {
            this.serializerDataOutputStream.writeByte(MessageType.GEOMETRY_TRIANGLES_PARTED.getId());
            this.serializerDataOutputStream.writeInt(((Integer)data.get("reused")).intValue());
            short cid = (Short)data.get("type");
            String type = this.objectProvider.getEClassForCid(cid).getName();
            this.serializerDataOutputStream.writeUTF(type);
            this.serializerDataOutputStream.align8();
            this.serializerDataOutputStream.writeLong(hasTransparancy ? 1L : 0L);
            this.serializerDataOutputStream.writeLong(data.getOid());
            int nrParts = (totalNrIndices + maxIndexValues - 1) / maxIndexValues;
            this.serializerDataOutputStream.writeInt(nrParts);
            ByteBuffer indicesByteBuffer = ByteBuffer.wrap(indices);
            indicesByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer indicesIntBuffer = indicesByteBuffer.asIntBuffer();
            ByteBuffer vertexBuffer = ByteBuffer.wrap(vertices);
            vertexBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer verticesDoubleBuffer = vertexBuffer.asDoubleBuffer();
            ByteBuffer normalsBuffer = ByteBuffer.wrap(normals);
            normalsBuffer.order(ByteOrder.LITTLE_ENDIAN);
            FloatBuffer normalsFloatBuffer = normalsBuffer.asFloatBuffer();
            for (int part = 0; part < nrParts; ++part) {
                int oldIndex3;
                int oldIndex2;
                int oldIndex1;
                int i;
                long splitId;
                ++this.splitCounter;
                this.serializerDataOutputStream.writeLong(splitId);
                short indexCounter = 0;
                int upto = Math.min((part + 1) * maxIndexValues, totalNrIndices);
                this.serializerDataOutputStream.writeInt(upto - part * maxIndexValues);
                this.serializerDataOutputStream.ensureExtraCapacity(2 * (upto - part * maxIndexValues));
                for (int i2 = part * maxIndexValues; i2 < upto; ++i2) {
                    short s = indexCounter;
                    indexCounter = (short)(indexCounter + 1);
                    this.serializerDataOutputStream.writeShortUnchecked(s);
                }
                this.serializerDataOutputStream.align4();
                if (color != null) {
                    this.serializerDataOutputStream.writeInt(1);
                    this.serializerDataOutputStream.writeFloat(((Float)color.eGet("x")).floatValue());
                    this.serializerDataOutputStream.writeFloat(((Float)color.eGet("y")).floatValue());
                    this.serializerDataOutputStream.writeFloat(((Float)color.eGet("z")).floatValue());
                    this.serializerDataOutputStream.writeFloat(((Float)color.eGet("w")).floatValue());
                } else {
                    this.serializerDataOutputStream.writeInt(0);
                }
                this.serializerDataOutputStream.align4();
                int nrVertices = (upto - part * maxIndexValues) * 3;
                this.serializerDataOutputStream.writeInt(nrVertices);
                this.serializerDataOutputStream.ensureExtraCapacity(12 * (upto - part * maxIndexValues));
                for (i = part * maxIndexValues; i < upto; i += 3) {
                    oldIndex1 = indicesIntBuffer.get(i);
                    oldIndex2 = indicesIntBuffer.get(i + 1);
                    oldIndex3 = indicesIntBuffer.get(i + 2);
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex1 * 3));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex1 * 3 + 1));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex1 * 3 + 2));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex2 * 3));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex2 * 3 + 1));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex2 * 3 + 2));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex3 * 3));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex3 * 3 + 1));
                    this.serializerDataOutputStream.writeFloatUnchecked((float)verticesDoubleBuffer.get(oldIndex3 * 3 + 2));
                }
                this.serializerDataOutputStream.writeInt(nrVertices);
                this.serializerDataOutputStream.ensureExtraCapacity(12 * (upto - part * maxIndexValues));
                for (i = part * maxIndexValues; i < upto; i += 3) {
                    oldIndex1 = indicesIntBuffer.get(i);
                    oldIndex2 = indicesIntBuffer.get(i + 1);
                    oldIndex3 = indicesIntBuffer.get(i + 2);
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex1 * 3));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex1 * 3 + 1));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex1 * 3 + 2));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex2 * 3));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex2 * 3 + 1));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex2 * 3 + 2));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex3 * 3));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex3 * 3 + 1));
                    this.serializerDataOutputStream.writeFloatUnchecked(normalsFloatBuffer.get(oldIndex3 * 3 + 2));
                }
                if (colors != null && color == null) {
                    ByteBuffer materialsByteBuffer = ByteBuffer.wrap(colors);
                    this.serializerDataOutputStream.writeInt(nrVertices * 4 / 3);
                    this.serializerDataOutputStream.ensureExtraCapacity(16 * (upto - part * maxIndexValues));
                    for (int i3 = part * maxIndexValues; i3 < upto; i3 += 3) {
                        int oldIndex12 = indicesIntBuffer.get(i3);
                        int oldIndex22 = indicesIntBuffer.get(i3 + 1);
                        int oldIndex32 = indicesIntBuffer.get(i3 + 2);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex12 * 4)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex12 * 4 + 1)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex12 * 4 + 2)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex12 * 4 + 3)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex22 * 4)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex22 * 4 + 1)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex22 * 4 + 2)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex22 * 4 + 3)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex32 * 4)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex32 * 4 + 1)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex32 * 4 + 2)) / 255.0f);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)UnsignedBytes.toInt((byte)materialsByteBuffer.get(oldIndex32 * 4 + 3)) / 255.0f);
                    }
                    continue;
                }
                this.serializerDataOutputStream.writeInt(0);
            }
        } else {
            double[] vertex;
            int nrPos;
            ByteBuffer vertexByteBuffer;
            this.serializerDataOutputStream.writeByte(MessageType.GEOMETRY_TRIANGLES.getId());
            int reused = (Integer)data.get("reused");
            this.serializerDataOutputStream.writeInt(reused);
            short cid = (Short)data.get("type");
            String type = this.objectProvider.getEClassForCid(cid).getName();
            this.serializerDataOutputStream.writeUTF(type);
            this.serializerDataOutputStream.align8();
            long roid = data.getRoid();
            long croid = data.getCroid();
            this.serializerDataOutputStream.writeLong(roid);
            this.serializerDataOutputStream.writeLong(croid);
            this.serializerDataOutputStream.writeLong(hasTransparancy ? 1L : 0L);
            this.serializerDataOutputStream.writeLong(oid);
            ByteBuffer indicesByteBuffer = ByteBuffer.wrap(indices);
            indicesByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.serializerDataOutputStream.writeInt(indicesByteBuffer.capacity() / 4);
            if (this.useSmallInts) {
                IntBuffer intBuffer = indicesByteBuffer.asIntBuffer();
                this.serializerDataOutputStream.ensureExtraCapacity(intBuffer.capacity() * 2);
                for (int i = 0; i < intBuffer.capacity(); ++i) {
                    this.serializerDataOutputStream.writeShortUnchecked((short)intBuffer.get());
                }
                this.serializerDataOutputStream.align4();
            } else {
                this.serializerDataOutputStream.write(indicesByteBuffer.array());
            }
            if (color != null) {
                this.serializerDataOutputStream.writeInt(1);
                this.serializerDataOutputStream.writeFloat(((Float)color.eGet("x")).floatValue());
                this.serializerDataOutputStream.writeFloat(((Float)color.eGet("y")).floatValue());
                this.serializerDataOutputStream.writeFloat(((Float)color.eGet("z")).floatValue());
                this.serializerDataOutputStream.writeFloat(((Float)color.eGet("w")).floatValue());
            } else if (this.useSingleColors && mostUsedColor != null) {
                this.serializerDataOutputStream.writeInt(1);
                this.serializerDataOutputStream.writeFloat(((Float)mostUsedColor.eGet("x")).floatValue());
                this.serializerDataOutputStream.writeFloat(((Float)mostUsedColor.eGet("y")).floatValue());
                this.serializerDataOutputStream.writeFloat(((Float)mostUsedColor.eGet("z")).floatValue());
                this.serializerDataOutputStream.writeFloat(((Float)mostUsedColor.eGet("w")).floatValue());
            } else {
                this.serializerDataOutputStream.writeInt(0);
            }
            if (this.quantizeVertices) {
                if (verticesQuantized != null && this.normalizeUnitsToMM) {
                    this.serializerDataOutputStream.writeInt(verticesQuantized.length / 2);
                    this.serializerDataOutputStream.write(verticesQuantized);
                    this.serializerDataOutputStream.align8();
                } else {
                    vertexByteBuffer = ByteBuffer.wrap(vertices);
                    nrPos = vertexByteBuffer.capacity() / 8;
                    this.serializerDataOutputStream.writeInt(nrPos);
                    vertexByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.serializerDataOutputStream.ensureExtraCapacity(vertexByteBuffer.capacity() * 6 / 8);
                    vertex = new double[4];
                    double[] result = new double[4];
                    vertex[3] = 1.0;
                    for (int i = 0; i < nrPos; i += 3) {
                        double[] matrix;
                        vertex[0] = vertexByteBuffer.getDouble();
                        vertex[1] = vertexByteBuffer.getDouble();
                        vertex[2] = vertexByteBuffer.getDouble();
                        if (this.normalizeUnitsToMM && this.projectInfo.getMultiplierToMm() != 1.0f) {
                            vertex[0] = vertex[0] * (double)this.projectInfo.getMultiplierToMm();
                            vertex[1] = vertex[1] * (double)this.projectInfo.getMultiplierToMm();
                            vertex[2] = vertex[2] * (double)this.projectInfo.getMultiplierToMm();
                        }
                        if ((matrix = this.vertexQuantizationMatrix) == null) {
                            LOGGER.error("Missing quant matrix for " + croid);
                            return false;
                        }
                        Matrix.multiplyMV((double[])result, (int)0, (double[])matrix, (int)0, (double[])vertex, (int)0);
                        this.serializerDataOutputStream.writeShortUnchecked((short)result[0]);
                        this.serializerDataOutputStream.writeShortUnchecked((short)result[1]);
                        this.serializerDataOutputStream.writeShortUnchecked((short)result[2]);
                    }
                    this.serializerDataOutputStream.align8();
                }
            } else {
                vertexByteBuffer = ByteBuffer.wrap(vertices).order(ByteOrder.LITTLE_ENDIAN);
                nrPos = vertexByteBuffer.capacity() / 8;
                this.serializerDataOutputStream.writeInt(nrPos);
                if (this.normalizeUnitsToMM && this.projectInfo.getMultiplierToMm() != 1.0f) {
                    vertexByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.serializerDataOutputStream.ensureExtraCapacity(vertexByteBuffer.capacity() * 6 / 8);
                    vertex = new double[3];
                    for (int i = 0; i < nrPos; i += 3) {
                        vertex[0] = vertexByteBuffer.getDouble();
                        vertex[1] = vertexByteBuffer.getDouble();
                        vertex[2] = vertexByteBuffer.getDouble();
                        vertex[0] = vertex[0] * (double)this.projectInfo.getMultiplierToMm();
                        vertex[1] = vertex[1] * (double)this.projectInfo.getMultiplierToMm();
                        vertex[2] = vertex[2] * (double)this.projectInfo.getMultiplierToMm();
                        this.serializerDataOutputStream.writeFloatUnchecked((float)vertex[0]);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)vertex[1]);
                        this.serializerDataOutputStream.writeFloatUnchecked((float)vertex[2]);
                    }
                } else {
                    DoubleBuffer vertexDoubleBuffer = vertexByteBuffer.asDoubleBuffer();
                    for (int i = 0; i < vertexDoubleBuffer.capacity(); ++i) {
                        this.serializerDataOutputStream.writeFloat((float)vertexDoubleBuffer.get(i));
                    }
                }
            }
            if (this.quantizeNormals && normalsQuantized != null) {
                float[] floatNormal = new float[3];
                byte[] oct = new byte[2];
                this.serializerDataOutputStream.writeInt(normalsQuantized.length / 3 * 2);
                for (int i = 0; i < normalsQuantized.length; i += 3) {
                    floatNormal[0] = normalsQuantized[i] / 127;
                    floatNormal[1] = normalsQuantized[i + 1] / 127;
                    floatNormal[2] = normalsQuantized[i + 2] / 127;
                    this.octEncodeFloat(floatNormal, oct);
                    this.serializerDataOutputStream.write((int)oct[0]);
                    this.serializerDataOutputStream.write((int)oct[1]);
                }
                this.serializerDataOutputStream.align8();
            } else {
                this.serializerDataOutputStream.writeInt(normals.length / 4);
                this.serializerDataOutputStream.write(normals);
            }
            if (this.useSingleColors) {
                this.serializerDataOutputStream.writeInt(0);
            } else {
                if (colors == null) {
                    if (color == null) {
                        this.serializerDataOutputStream.writeInt(0);
                        return true;
                    }
                    this.serializerDataOutputStream.writeInt(0);
                    return true;
                }
                ByteBuffer materialsByteBuffer = ByteBuffer.wrap(colors);
                this.serializerDataOutputStream.writeInt(materialsByteBuffer.capacity());
                if (this.quantizeColors) {
                    this.serializerDataOutputStream.write(materialsByteBuffer.array());
                } else {
                    this.serializerDataOutputStream.ensureExtraCapacity(materialsByteBuffer.capacity() * 4);
                    for (int i = 0; i < materialsByteBuffer.capacity(); ++i) {
                        byte b = materialsByteBuffer.get(i);
                        float f = (float)UnsignedBytes.toInt((byte)b) / 255.0f;
                        this.serializerDataOutputStream.writeFloatUnchecked(f);
                    }
                }
            }
        }
        return true;
    }

    private void octEncodeFloat(float[] in, byte[] out) {
        float x = Math.abs(in[0]) + Math.abs(in[1]) + Math.abs(in[2]);
        float[] p = new float[]{in[0] / x, in[1] / x};
        if (in[2] <= 0.0f) {
            float a = (1.0f - Math.abs(p[0])) * this.signNotZero(p[0]);
            float b = (1.0f - Math.abs(p[1])) * this.signNotZero(p[1]);
            p = new float[]{a, b};
        }
        out[0] = (byte)(p[0] * 127.0f);
        out[1] = (byte)(p[1] * 127.0f);
    }

    private void updateSize(HashMapVirtualObject data, GeometryBuffer geometryBuffer) {
        int nrIndices = (Integer)data.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_NrIndices());
        int nrLineIndices = (Integer)data.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_NrLineIndices());
        int nrVertices = (Integer)data.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_NrVertices());
        HashMapVirtualObject colorPack = (HashMapVirtualObject)data.getDirectFeature((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_ColorPack());
        byte[] colorPackData = colorPack == null ? null : (byte[])colorPack.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getColorPack_Data());
        GeometrySubBuffer currentGeometryMapping = geometryBuffer.getCurrentGeometryMapping(false);
        currentGeometryMapping.incNrIndices(nrIndices);
        if (this.generateLineRenders) {
            currentGeometryMapping.incNrLineIndices(nrLineIndices);
        }
        currentGeometryMapping.incNrVertices(nrVertices);
        currentGeometryMapping.incNrColors(colorPackData == null ? 0 : colorPackData.length);
        currentGeometryMapping.incTotalColorPackSize(colorPackData == null ? 0 : colorPackData.length);
        currentGeometryMapping.incNrObjects();
        currentGeometryMapping.incPreparedSize(nrIndices * 4 + (this.generateLineRenders ? nrLineIndices * 4 : 0) + nrVertices * (this.quantizeVertices ? 2 : 4) + nrVertices / 3 * 2 + 4 + (colorPackData == null ? 0 : colorPackData.length) + 40 + (this.useUuidAndRid ? 20 : 0));
    }

    private GeometryMainBuffer getCurrentMainBuffer() {
        if (this.mode == Mode.PREPARED_BUFFER_TRANSPARENT) {
            return this.transparentGeometryBuffer;
        }
        if (this.mode == Mode.PREPARED_BUFFER_OPAQUE) {
            return this.opaqueGeometryBuffer;
        }
        return null;
    }

    private GeometryMainBuffer getCurrentMainBuffer(boolean hasTransparency) {
        if (hasTransparency) {
            return this.transparentGeometryBuffer;
        }
        return this.opaqueGeometryBuffer;
    }

    private boolean inside(Point a, double[] bounds) {
        return !(a.getX() < bounds[0] || a.getY() < bounds[1] || a.getZ() < bounds[2] || a.getX() > bounds[3] || a.getY() > bounds[4]) && !(a.getZ() > bounds[5]);
    }

    public void close() {
    }

    private static enum MessageType {
        INIT(0),
        GEOMETRY_TRIANGLES_PARTED(3),
        GEOMETRY_TRIANGLES(1),
        GEOMETRY_INFO(5),
        MINIMAL_GEOMETRY_INFO(9),
        PREPARED_BUFFER_TRANSPARENT(7),
        PREPARED_BUFFER_OPAQUE(8),
        PREPARED_BUFFER_TRANSPARENT_INIT(10),
        PREPARED_BUFFER_OPAQUE_INIT(11),
        END(6);

        private byte id;

        private MessageType(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }
    }

    private static enum Mode {
        LOAD,
        START,
        DATA,
        PREPARED_BUFFER_INIT,
        PREPARED_BUFFER_TRANSPARENT,
        PREPARED_BUFFER_OPAQUE,
        END;

    }
}

