/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.deserializer;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifc.step.deserializer.ParserPlan;
import org.bimserver.ifc.step.deserializer.SPass;
import org.bimserver.ifc.step.deserializer.X2Pass;
import org.bimserver.ifc.step.deserializer.X4Pass;
import org.bimserver.ifc.step.deserializer.XPass;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.serializers.SerializerException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcParserWriterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcParserWriterUtils.class);
    private static final boolean USE_ISO_8859_1 = false;
    private static final ParserPlan[] plans = new ParserPlan[]{new ParserPlan(new XPass(), new X2Pass(), new X4Pass(), new SPass()), new ParserPlan(new SPass(), new XPass(), new X2Pass(), new X4Pass())};

    public static Object convertSimpleValue(PackageMetaData packageMetaData, EStructuralFeature eStructuralFeature, Class<?> instanceClass, String value, long lineNumber) throws DeserializeException {
        if (!value.equals("")) {
            if (instanceClass == Integer.class || instanceClass == Integer.TYPE) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    try {
                        new BigInteger(value);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                    throw new NumberFormatException("Input is outside of Integer range (" + value + ")");
                }
            }
            if (instanceClass == Long.class || instanceClass == Long.TYPE) {
                if (eStructuralFeature == Ifc4Package.eINSTANCE.getIfcRelConnectsPathElements_RelatingPriorities() || eStructuralFeature == Ifc4Package.eINSTANCE.getIfcRelConnectsPathElements_RelatedPriorities() || eStructuralFeature == Ifc4Package.eINSTANCE.getIfcMaterialProfile_Priority()) {
                    if (value.contains(".")) {
                        return (long)(100.0 * Double.parseDouble(value));
                    }
                    return Long.parseLong(value);
                }
                return Long.parseLong(value);
            }
            if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
                return Boolean.parseBoolean(value);
            }
            if (instanceClass.getSimpleName().equals("Tristate")) {
                EEnum eEnum = packageMetaData.getEEnum("Tristate");
                if (value.toString().equals("TRUE")) {
                    return eEnum.getEEnumLiteral("TRUE");
                }
                if (value.toString().equals("FALSE")) {
                    return eEnum.getEEnumLiteral("FALSE");
                }
                if (value.toString().equals("UNDEFINED")) {
                    return eEnum.getEEnumLiteral("UNDEFINED");
                }
                throw new DeserializeException(lineNumber, "Unknown value: " + value);
            }
            if (instanceClass == Double.class || instanceClass == Double.TYPE) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    throw new DeserializeException(lineNumber, "Incorrect double floating point value: " + value, (Exception)e);
                }
            }
            if (instanceClass == String.class) {
                if (value.startsWith("'") && value.endsWith("'")) {
                    return IfcParserWriterUtils.readString(value, lineNumber);
                }
                return value;
            }
            if (instanceClass == byte[].class) {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    try {
                        String substring = value.substring(2, value.length() - 1);
                        byte[] decoded = Hex.decodeHex((char[])substring.toCharArray());
                        return decoded;
                    }
                    catch (DecoderException e) {
                        throw new DeserializeException((Exception)((Object)e));
                    }
                }
                throw new DeserializeException(lineNumber, "Byte[] not starting/ending with \"");
            }
            if (IdEObject.class.isAssignableFrom(instanceClass)) {
                throw new DeserializeException(lineNumber, instanceClass.getSimpleName() + " expected, but got \"" + value + "\"");
            }
            throw new DeserializeException(lineNumber, "Unimplemented " + instanceClass);
        }
        return null;
    }

    public static String readString(String value, long lineNumber) throws DeserializeException {
        String result = value.substring(1, value.length() - 1);
        while (result.contains("''")) {
            int index = result.indexOf("''");
            result = result.substring(0, index) + "'" + result.substring(index + 2);
        }
        for (ParserPlan parserPlan : plans) {
            try {
                result = parserPlan.process(lineNumber, result);
                break;
            }
            catch (NumberFormatException e) {
                if (parserPlan != plans[plans.length - 1]) continue;
                throw e;
            }
        }
        while (result.contains("\\\\")) {
            int index = result.indexOf("\\\\");
            result = result.substring(0, index) + "\\" + result.substring(index + 2);
        }
        return result;
    }

    public static void writePrimitive(Object val, OutputStream outputStream) throws SerializerException, IOException {
        if (val.getClass().getSimpleName().equals("Tristate")) {
            if (val.toString().equals("TRUE")) {
                outputStream.write(".T.".getBytes(Charsets.UTF_8));
            } else if (val.toString().equals("FALSE")) {
                outputStream.write(".F.".getBytes(Charsets.UTF_8));
            } else if (val.toString().equals("UNDEFINED")) {
                outputStream.write(".U.".getBytes(Charsets.UTF_8));
            }
        } else if (val instanceof Double) {
            if (((Double)val).isInfinite() || ((Double)val).isNaN()) {
                LOGGER.info("Serializing infinite or NaN double as 0.0");
                outputStream.write("0.0".getBytes(Charsets.UTF_8));
            } else {
                String string = val.toString();
                if (string.endsWith(".0")) {
                    outputStream.write(string.substring(0, string.length() - 1).getBytes(Charsets.UTF_8));
                } else {
                    outputStream.write(string.getBytes(Charsets.UTF_8));
                }
            }
        } else if (val instanceof Boolean) {
            Boolean bool = (Boolean)val;
            if (bool.booleanValue()) {
                outputStream.write(".T.".getBytes(Charsets.UTF_8));
            } else {
                outputStream.write(".F.".getBytes(Charsets.UTF_8));
            }
        } else if (val instanceof String) {
            outputStream.write("'".getBytes(Charsets.UTF_8));
            String stringVal = (String)val;
            for (int i = 0; i < stringVal.length(); ++i) {
                char c = stringVal.charAt(i);
                if (c == '\'') {
                    outputStream.write("''".getBytes(Charsets.UTF_8));
                    continue;
                }
                if (c == '\\') {
                    outputStream.write("\\\\".getBytes(Charsets.UTF_8));
                    continue;
                }
                if (c >= ' ' && c <= '~') {
                    outputStream.write(("" + c).getBytes(Charsets.UTF_8));
                    continue;
                }
                if (c < '\u00ff') {
                    outputStream.write(("\\X\\" + new String(Hex.encodeHex((byte[])Charsets.ISO_8859_1.encode(CharBuffer.wrap(new char[]{c})).array())).toUpperCase()).getBytes(Charsets.UTF_8));
                    continue;
                }
                if (Character.isLowSurrogate(c)) {
                    throw new SerializerException("Unexpected low surrogate range char");
                }
                if (Character.isHighSurrogate(c)) {
                    if (i + 1 < stringVal.length()) {
                        char low = stringVal.charAt(i + 1);
                        if (!Character.isLowSurrogate(low)) {
                            throw new SerializerException("High surrogate char should be followed by char in low surrogate range");
                        }
                        try {
                            outputStream.write(("\\X4\\" + new String(Hex.encodeHex((byte[])Charset.forName("UTF-32").encode(new String(new char[]{c, low})).array())).toUpperCase() + "\\X0\\").getBytes(Charsets.UTF_8));
                        }
                        catch (UnsupportedCharsetException e) {
                            throw new SerializerException((Throwable)e);
                        }
                        ++i;
                        continue;
                    }
                    throw new SerializerException("High surrogate char should be followed by char in low surrogate range, but end of string reached");
                }
                outputStream.write(("\\X2\\" + new String(Hex.encodeHex((byte[])Charsets.UTF_16BE.encode(CharBuffer.wrap(new char[]{c})).array())).toUpperCase() + "\\X0\\").getBytes(Charsets.UTF_8));
            }
            outputStream.write("'".getBytes(Charsets.UTF_8));
        } else if (val instanceof Enumerator) {
            outputStream.write(("." + val + ".").getBytes(Charsets.UTF_8));
        } else if (val instanceof byte[]) {
            outputStream.write(("\"0" + Hex.encodeHexString((byte[])((byte[])val)) + "\"").getBytes(Charsets.UTF_8));
        } else {
            outputStream.write((val == null ? "$" : val.toString()).getBytes(Charsets.UTF_8));
        }
    }

    public static void writePrimitive(Object val, PrintWriter printWriter) throws SerializerException, IOException {
        if (val.getClass().getSimpleName().equals("Tristate")) {
            if (val.toString().equals("TRUE")) {
                printWriter.write(".T.");
            } else if (val.toString().equals("FALSE")) {
                printWriter.write(".F.");
            } else if (val.toString().equals("UNDEFINED")) {
                printWriter.write(".U.");
            }
        } else if (val instanceof Double) {
            if (((Double)val).isInfinite() || ((Double)val).isNaN()) {
                LOGGER.info("Serializing infinite or NaN double as 0.0");
                printWriter.write("0.0");
            } else {
                String string = val.toString();
                if (string.endsWith(".0")) {
                    printWriter.write(string.substring(0, string.length() - 1));
                } else {
                    printWriter.write(string);
                }
            }
        } else if (val instanceof Boolean) {
            Boolean bool = (Boolean)val;
            if (bool.booleanValue()) {
                printWriter.write(".T.");
            } else {
                printWriter.write(".F.");
            }
        } else if (val instanceof String) {
            printWriter.write(39);
            String stringVal = (String)val;
            for (int i = 0; i < stringVal.length(); ++i) {
                char c = stringVal.charAt(i);
                if (c == '\'') {
                    printWriter.write(new char[]{'\'', '\''});
                    continue;
                }
                if (c == '\\') {
                    printWriter.write(new char[]{'\\', '\\'});
                    continue;
                }
                if (c >= ' ' && c <= '~') {
                    printWriter.write(new char[]{c});
                    continue;
                }
                if (c < '\u00ff') {
                    printWriter.write("\\X\\");
                    printWriter.write(Hex.encodeHex((byte[])Charsets.ISO_8859_1.encode(CharBuffer.wrap(new char[]{c})).array(), (boolean)false));
                    continue;
                }
                if (Character.isLowSurrogate(c)) {
                    throw new SerializerException("Unexpected low surrogate range char");
                }
                if (Character.isHighSurrogate(c)) {
                    if (i + 1 < stringVal.length()) {
                        char low = stringVal.charAt(i + 1);
                        if (!Character.isLowSurrogate(low)) {
                            throw new SerializerException("High surrogate char should be followed by char in low surrogate range");
                        }
                        try {
                            printWriter.write("\\X4\\");
                            printWriter.write(Hex.encodeHex((byte[])Charset.forName("UTF-32").encode(new String(new char[]{c, low})).array(), (boolean)false));
                            printWriter.write("\\X0\\");
                        }
                        catch (UnsupportedCharsetException e) {
                            throw new SerializerException((Throwable)e);
                        }
                        ++i;
                        continue;
                    }
                    throw new SerializerException("High surrogate char should be followed by char in low surrogate range, but end of string reached");
                }
                printWriter.write("\\X2\\");
                printWriter.write(Hex.encodeHex((byte[])Charsets.UTF_16BE.encode(CharBuffer.wrap(new char[]{c})).array(), (boolean)false));
                printWriter.write("\\X0\\");
            }
            printWriter.write(39);
        } else if (val instanceof Enumerator) {
            printWriter.write(".");
            printWriter.write(val.toString());
            printWriter.write(".");
        } else if (val instanceof byte[]) {
            printWriter.write("\"0");
            printWriter.write(Hex.encodeHexString((byte[])((byte[])val)));
            printWriter.write("\"");
        } else {
            printWriter.write(val == null ? "$" : val.toString());
        }
    }
}

