/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.serializer;

import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.serializers.AbstractSerializerPlugin;
import org.bimserver.shared.exceptions.PluginException;

public abstract class IfcStepSerializerPlugin
extends AbstractSerializerPlugin {
    public void init(PluginContext pluginContext, PluginConfiguration systemSettings) throws PluginException {
    }

    public String getDefaultContentType() {
        return "application/ifc";
    }

    public String getDefaultExtension() {
        return "ifc";
    }

    public ObjectDefinition getUserSettingsDefinition() {
        ObjectDefinition objectDefinition = super.getUserSettingsDefinition();
        PrimitiveDefinition stringDefinition = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringDefinition.setType(PrimitiveEnum.STRING);
        ParameterDefinition organizationParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        organizationParameter.setIdentifier("organization");
        organizationParameter.setName("Organization");
        organizationParameter.setDescription("Organization name to put in the header");
        StringType defaultValue = StoreFactory.eINSTANCE.createStringType();
        defaultValue.setValue("BIMserver.org");
        organizationParameter.setDefaultValue((Type)defaultValue);
        organizationParameter.setType((TypeDefinition)stringDefinition);
        objectDefinition.getParameters().add((Object)organizationParameter);
        ParameterDefinition zipExtension = StoreFactory.eINSTANCE.createParameterDefinition();
        zipExtension.setIdentifier("ZipExtension");
        zipExtension.setName("ZipExtension");
        zipExtension.setDescription("Extension of the downloaded file when using zip compression");
        zipExtension.setType((TypeDefinition)stringDefinition);
        StringType defaultZipExtensionValue = StoreFactory.eINSTANCE.createStringType();
        defaultZipExtensionValue.setValue("ifczip");
        zipExtension.setDefaultValue((Type)defaultZipExtensionValue);
        objectDefinition.getParameters().add((Object)zipExtension);
        return objectDefinition;
    }
}

