/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.gltf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.geometry.IfcColors;
import org.bimserver.geometry.Matrix;
import org.bimserver.gltf.BinaryGltfBaseSerializer;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;

public class BinaryGltfSerializer
extends BinaryGltfBaseSerializer {
    private static final String VERTEX_COLOR_MATERIAL = "VertexColorMaterial";
    private static final int FLOAT_VEC_4 = 35666;
    private static final int ARRAY_BUFFER = 34962;
    private static final int ELEMENT_ARRAY_BUFFER = 34963;
    private static final String MAGIC = "glTF";
    private static final int UNSIGNED_SHORT = 5123;
    private static final int TRIANGLES = 4;
    private static final int FLOAT = 5126;
    private int JSON_SCENE_FORMAT = 0;
    private int FORMAT_VERSION_1 = 1;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ObjectNode buffers;
    private ByteBuffer body;
    private ObjectNode meshes;
    private ObjectNode accessors;
    private int accessorCounter = 0;
    private int bufferViewCounter;
    private ObjectNode buffersViews;
    private ArrayNode defaultSceneNodes;
    private ObjectNode scenesNode;
    private ObjectNode gltfNode;
    private ObjectNode nodes;
    private byte[] vertexColorFragmentShaderBytes;
    private byte[] vertexColorVertexShaderBytes;
    private byte[] materialColorFragmentShaderBytes;
    private byte[] materialColorVertexShaderBytes;
    float[] min = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
    float[] max = new float[]{-3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
    private ArrayNode modelTranslation;
    private ObjectNode materials;
    private ObjectNode shaders;
    private final Set<String> createdMaterials = new HashSet<String>();
    private ArrayNode translationChildrenNode;

    public BinaryGltfSerializer(byte[] vertexColorFragmentShaderBytes, byte[] vertexColorVertexShaderBytes, byte[] materialColorFragmentShaderBytes, byte[] materialColorVertexShaderBytes) {
        this.vertexColorFragmentShaderBytes = vertexColorFragmentShaderBytes;
        this.vertexColorVertexShaderBytes = vertexColorVertexShaderBytes;
        this.materialColorFragmentShaderBytes = materialColorFragmentShaderBytes;
        this.materialColorVertexShaderBytes = materialColorVertexShaderBytes;
    }

    protected boolean write(OutputStream outputStream, ProgressReporter progressReporter) throws SerializerException {
        this.gltfNode = OBJECT_MAPPER.createObjectNode();
        this.buffers = OBJECT_MAPPER.createObjectNode();
        this.meshes = OBJECT_MAPPER.createObjectNode();
        this.buffersViews = OBJECT_MAPPER.createObjectNode();
        this.scenesNode = OBJECT_MAPPER.createObjectNode();
        this.accessors = OBJECT_MAPPER.createObjectNode();
        this.nodes = OBJECT_MAPPER.createObjectNode();
        this.materials = OBJECT_MAPPER.createObjectNode();
        this.shaders = OBJECT_MAPPER.createObjectNode();
        this.gltfNode.set("meshes", (JsonNode)this.meshes);
        this.gltfNode.set("bufferViews", (JsonNode)this.buffersViews);
        this.gltfNode.set("scenes", (JsonNode)this.scenesNode);
        this.gltfNode.set("accessors", (JsonNode)this.accessors);
        this.gltfNode.set("nodes", (JsonNode)this.nodes);
        this.gltfNode.set("buffers", (JsonNode)this.buffers);
        this.gltfNode.set("materials", (JsonNode)this.materials);
        this.gltfNode.set("shaders", (JsonNode)this.shaders);
        this.createVertexColorMaterial();
        try {
            LittleEndianDataOutputStream dataOutputStream = new LittleEndianDataOutputStream(outputStream);
            this.generateSceneAndBody();
            byte[] sceneBytes = this.gltfNode.toString().getBytes(Charsets.UTF_8);
            this.writeHeader(dataOutputStream, 20, sceneBytes.length, this.body.capacity());
            this.writeScene(dataOutputStream, sceneBytes);
            this.writeBody(dataOutputStream, this.body.array());
        }
        catch (Exception e) {
            throw new SerializerException((Throwable)e);
        }
        return false;
    }

    private void createModelNode() {
        ObjectNode translationNode = OBJECT_MAPPER.createObjectNode();
        this.modelTranslation = OBJECT_MAPPER.createArrayNode();
        this.translationChildrenNode = OBJECT_MAPPER.createArrayNode();
        translationNode.set("children", (JsonNode)this.translationChildrenNode);
        translationNode.set("translation", (JsonNode)this.modelTranslation);
        ObjectNode rotationNode = OBJECT_MAPPER.createObjectNode();
        ArrayNode rotation = OBJECT_MAPPER.createArrayNode();
        ArrayNode rotationChildrenNode = OBJECT_MAPPER.createArrayNode();
        rotationChildrenNode.add("translationNode");
        rotationNode.set("children", (JsonNode)rotationChildrenNode);
        rotationNode.set("rotation", (JsonNode)rotation);
        rotation.add(1.0f);
        rotation.add(0.0f);
        rotation.add(0.0f);
        rotation.add(-1.0f);
        this.nodes.set("rotationNode", (JsonNode)rotationNode);
        this.nodes.set("translationNode", (JsonNode)translationNode);
        this.defaultSceneNodes.add("rotationNode");
    }

    private void generateSceneAndBody() throws SerializerException {
        int totalBodyByteLength = 0;
        int totalIndicesByteLength = 0;
        int totalVerticesByteLength = 0;
        int totalNormalsByteLength = 0;
        int totalColorsByteLength = 0;
        int maxIndexValues = 16389;
        for (IfcProduct ifcProduct : this.model.getAllWithSubTypes(IfcProduct.class)) {
            if (!this.checkGeometry(ifcProduct, true)) continue;
            GeometryInfo geometryInfo = ifcProduct.getGeometry();
            GeometryData data = geometryInfo.getData();
            int nrIndicesBytes = data.getIndices().getData().length;
            totalIndicesByteLength += nrIndicesBytes / 2;
            if (nrIndicesBytes > 4 * maxIndexValues) {
                int nrIndices = nrIndicesBytes / 4;
                totalVerticesByteLength += nrIndices * 3 * 4;
                totalNormalsByteLength += nrIndices * 3 * 4;
                if (data.getColorsQuantized() == null) continue;
                totalColorsByteLength += nrIndices * 4 * 4;
                continue;
            }
            totalVerticesByteLength += data.getVertices().getData().length;
            totalNormalsByteLength += data.getNormals().getData().length;
            if (data.getColorsQuantized() == null) continue;
            totalColorsByteLength += data.getColorsQuantized().getData().length;
        }
        totalBodyByteLength = totalIndicesByteLength + totalVerticesByteLength + totalNormalsByteLength + totalColorsByteLength;
        this.body = ByteBuffer.allocate(totalBodyByteLength + this.materialColorFragmentShaderBytes.length + this.materialColorVertexShaderBytes.length + this.vertexColorFragmentShaderBytes.length + this.vertexColorVertexShaderBytes.length);
        this.body.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newIndicesBuffer = ByteBuffer.allocate(totalIndicesByteLength);
        newIndicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newVerticesBuffer = ByteBuffer.allocate(totalVerticesByteLength);
        newVerticesBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newNormalsBuffer = ByteBuffer.allocate(totalNormalsByteLength);
        newNormalsBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newColorsBuffer = ByteBuffer.allocate(totalColorsByteLength);
        newColorsBuffer.order(ByteOrder.LITTLE_ENDIAN);
        String indicesBufferView = this.createBufferView(totalIndicesByteLength, 0, 34963);
        String verticesBufferView = this.createBufferView(totalVerticesByteLength, totalIndicesByteLength, 34962);
        String normalsBufferView = this.createBufferView(totalNormalsByteLength, totalIndicesByteLength + totalVerticesByteLength, 34962);
        String colorsBufferView = null;
        this.scenesNode.set("defaultScene", (JsonNode)this.createDefaultScene());
        this.createModelNode();
        for (Object ifcProduct : this.model.getAllWithSubTypes(IfcProduct.class)) {
            if (!this.checkGeometry((IfcProduct)ifcProduct, false)) continue;
            GeometryInfo geometryInfo = ifcProduct.getGeometry();
            ByteBuffer matrixByteBuffer = ByteBuffer.wrap(ifcProduct.getGeometry().getTransformation());
            matrixByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer = matrixByteBuffer.asDoubleBuffer();
            float[] matrix = new float[16];
            for (int i = 0; i < doubleBuffer.capacity(); ++i) {
                matrix[i] = (float)doubleBuffer.get();
            }
            this.updateExtends(geometryInfo, matrix);
        }
        float[] offsets = this.getOffsets();
        this.modelTranslation.add(-offsets[0]);
        this.modelTranslation.add(-offsets[1]);
        this.modelTranslation.add(-offsets[2]);
        for (IfcProduct ifcProduct : this.model.getAllWithSubTypes(IfcProduct.class)) {
            int totalNrIndices;
            if (!this.checkGeometry(ifcProduct, false)) continue;
            GeometryInfo geometryInfo = ifcProduct.getGeometry();
            int startPositionIndices = newIndicesBuffer.position();
            int startPositionVertices = newVerticesBuffer.position();
            int startPositionNormals = newNormalsBuffer.position();
            int startPositionColors = newColorsBuffer.position();
            GeometryData data = geometryInfo.getData();
            ByteBuffer indicesBuffer = ByteBuffer.wrap(data.getIndices().getData());
            indicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer indicesIntBuffer = indicesBuffer.asIntBuffer();
            ByteBuffer verticesBuffer = ByteBuffer.wrap(data.getVertices().getData());
            verticesBuffer.order(ByteOrder.LITTLE_ENDIAN);
            FloatBuffer verticesFloatBuffer = verticesBuffer.asFloatBuffer();
            ByteBuffer normalsBuffer = ByteBuffer.wrap(data.getNormals().getData());
            normalsBuffer.order(ByteOrder.LITTLE_ENDIAN);
            FloatBuffer normalsFloatBuffer = normalsBuffer.asFloatBuffer();
            FloatBuffer materialsFloatBuffer = null;
            if (data.getColorsQuantized() != null) {
                ByteBuffer materialsBuffer = ByteBuffer.wrap(data.getColorsQuantized().getData());
                materialsBuffer.order(ByteOrder.LITTLE_ENDIAN);
                materialsFloatBuffer = materialsBuffer.asFloatBuffer();
            }
            if (data.getNrIndices() > maxIndexValues) {
                totalNrIndices = indicesIntBuffer.capacity();
                int nrParts = (totalNrIndices + maxIndexValues - 1) / maxIndexValues;
                ArrayNode primitivesNode = OBJECT_MAPPER.createArrayNode();
                for (int part = 0; part < nrParts; ++part) {
                    int oldIndex3;
                    int oldIndex2;
                    int oldIndex1;
                    int i;
                    startPositionIndices = newIndicesBuffer.position();
                    startPositionVertices = newVerticesBuffer.position();
                    startPositionNormals = newNormalsBuffer.position();
                    startPositionColors = newColorsBuffer.position();
                    short indexCounter = 0;
                    int upto = Math.min((part + 1) * maxIndexValues, totalNrIndices);
                    for (int i2 = part * maxIndexValues; i2 < upto; ++i2) {
                        short s = indexCounter;
                        indexCounter = (short)(indexCounter + 1);
                        newIndicesBuffer.putShort(s);
                    }
                    int nrVertices = upto - part * maxIndexValues;
                    for (i = part * maxIndexValues; i < upto; i += 3) {
                        oldIndex1 = indicesIntBuffer.get(i);
                        oldIndex2 = indicesIntBuffer.get(i + 1);
                        oldIndex3 = indicesIntBuffer.get(i + 2);
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex1 * 3));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex1 * 3 + 1));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex1 * 3 + 2));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex2 * 3));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex2 * 3 + 1));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex2 * 3 + 2));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex3 * 3));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex3 * 3 + 1));
                        newVerticesBuffer.putFloat(verticesFloatBuffer.get(oldIndex3 * 3 + 2));
                    }
                    for (i = part * maxIndexValues; i < upto; i += 3) {
                        oldIndex1 = indicesIntBuffer.get(i);
                        oldIndex2 = indicesIntBuffer.get(i + 1);
                        oldIndex3 = indicesIntBuffer.get(i + 2);
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex1 * 3));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex1 * 3 + 1));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex1 * 3 + 2));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex2 * 3));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex2 * 3 + 1));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex2 * 3 + 2));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex3 * 3));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex3 * 3 + 1));
                        newNormalsBuffer.putFloat(normalsFloatBuffer.get(oldIndex3 * 3 + 2));
                    }
                    if (materialsFloatBuffer != null) {
                        for (i = part * maxIndexValues; i < upto; i += 3) {
                            oldIndex1 = indicesIntBuffer.get(i);
                            oldIndex2 = indicesIntBuffer.get(i + 1);
                            oldIndex3 = indicesIntBuffer.get(i + 2);
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex1 * 4));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex1 * 4 + 1));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex1 * 4 + 2));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex1 * 4 + 3));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex2 * 4));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex2 * 4 + 1));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex2 * 4 + 2));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex2 * 4 + 3));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex3 * 4));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex3 * 4 + 1));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex3 * 4 + 2));
                            newColorsBuffer.putFloat(materialsFloatBuffer.get(oldIndex3 * 4 + 3));
                        }
                    }
                    ObjectNode primitiveNode = OBJECT_MAPPER.createObjectNode();
                    String indicesAccessor = this.addIndicesAccessor(ifcProduct, indicesBufferView, startPositionIndices, nrVertices / 3);
                    String verticesAccessor = this.addVerticesAccessor(ifcProduct, verticesBufferView, startPositionVertices, nrVertices);
                    String normalsAccessor = this.addNormalsAccessor(ifcProduct, normalsBufferView, startPositionNormals, nrVertices);
                    String colorAccessor = null;
                    if (data.getColor() != null) {
                        if (colorsBufferView == null) {
                            colorsBufferView = this.createBufferView(totalColorsByteLength, totalIndicesByteLength + totalVerticesByteLength + totalNormalsByteLength, 34962);
                        }
                        colorAccessor = this.addColorsAccessor(ifcProduct, colorsBufferView, startPositionColors, nrVertices * 4 / 3);
                    }
                    primitivesNode.add((JsonNode)primitiveNode);
                    primitiveNode.put("indices", indicesAccessor);
                    primitiveNode.put("mode", 4);
                    ObjectNode attributesNode = OBJECT_MAPPER.createObjectNode();
                    primitiveNode.set("attributes", (JsonNode)attributesNode);
                    attributesNode.put("NORMAL", normalsAccessor);
                    attributesNode.put("POSITION", verticesAccessor);
                    if (colorAccessor != null) {
                        attributesNode.put("COLOR", colorAccessor);
                        primitiveNode.put("material", VERTEX_COLOR_MATERIAL);
                        continue;
                    }
                    primitiveNode.put("material", this.createOrGetMaterial(ifcProduct.eClass().getName(), IfcColors.getDefaultColor((String)ifcProduct.eClass().getName())));
                }
                String meshName = this.addMesh(ifcProduct, primitivesNode);
                String nodeName = this.addNode(meshName, ifcProduct);
                this.translationChildrenNode.add(nodeName);
                continue;
            }
            for (int i = 0; i < indicesIntBuffer.capacity(); ++i) {
                int index = indicesIntBuffer.get(i);
                if (index > Short.MAX_VALUE) {
                    throw new SerializerException("Index too large to store as short " + index);
                }
                newIndicesBuffer.putShort((short)index);
            }
            newVerticesBuffer.put(data.getVertices().getData());
            newNormalsBuffer.put(data.getNormals().getData());
            if (data.getColorsQuantized() != null) {
                newColorsBuffer.put(data.getColorsQuantized().getData());
            }
            totalNrIndices = indicesIntBuffer.capacity();
            ArrayNode primitivesNode = OBJECT_MAPPER.createArrayNode();
            ObjectNode primitiveNode = OBJECT_MAPPER.createObjectNode();
            String indicesAccessor = this.addIndicesAccessor(ifcProduct, indicesBufferView, startPositionIndices, totalNrIndices);
            String verticesAccessor = this.addVerticesAccessor(ifcProduct, verticesBufferView, startPositionVertices, data.getNrVertices());
            String normalsAccessor = this.addNormalsAccessor(ifcProduct, normalsBufferView, startPositionNormals, data.getNrNormals());
            String colorAccessor = null;
            if (data.getColor() != null) {
                if (colorsBufferView == null) {
                    colorsBufferView = this.createBufferView(totalColorsByteLength, totalIndicesByteLength + totalVerticesByteLength + totalNormalsByteLength, 34962);
                }
                colorAccessor = this.addColorsAccessor(ifcProduct, colorsBufferView, startPositionColors, data.getNrVertices());
            }
            primitivesNode.add((JsonNode)primitiveNode);
            primitiveNode.put("indices", indicesAccessor);
            primitiveNode.put("mode", 4);
            ObjectNode attributesNode = OBJECT_MAPPER.createObjectNode();
            primitiveNode.set("attributes", (JsonNode)attributesNode);
            attributesNode.put("NORMAL", normalsAccessor);
            attributesNode.put("POSITION", verticesAccessor);
            if (colorAccessor != null) {
                attributesNode.put("COLOR", colorAccessor);
                primitiveNode.put("material", VERTEX_COLOR_MATERIAL);
            } else {
                primitiveNode.put("material", this.createOrGetMaterial(ifcProduct.eClass().getName(), IfcColors.getDefaultColor((String)ifcProduct.eClass().getName())));
            }
            String meshName = this.addMesh(ifcProduct, primitivesNode);
            String nodeName = this.addNode(meshName, ifcProduct);
            this.translationChildrenNode.add(nodeName);
        }
        if (newIndicesBuffer.position() != newIndicesBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        if (newVerticesBuffer.position() != newVerticesBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        if (newNormalsBuffer.position() != newNormalsBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        if (newColorsBuffer.position() != newColorsBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        newIndicesBuffer.position(0);
        newVerticesBuffer.position(0);
        newNormalsBuffer.position(0);
        newColorsBuffer.position(0);
        this.body.put(newIndicesBuffer);
        this.body.put(newVerticesBuffer);
        this.body.put(newNormalsBuffer);
        this.body.put(newColorsBuffer);
        String vertexColorFragmentShaderBufferViewName = this.createBufferView(this.vertexColorFragmentShaderBytes.length, this.body.position());
        this.body.put(this.vertexColorFragmentShaderBytes);
        String vertexColorVertexShaderBufferViewName = this.createBufferView(this.vertexColorVertexShaderBytes.length, this.body.position());
        this.body.put(this.vertexColorVertexShaderBytes);
        String materialColorFragmentShaderBufferViewName = this.createBufferView(this.materialColorFragmentShaderBytes.length, this.body.position());
        this.body.put(this.materialColorFragmentShaderBytes);
        String materialColorVertexShaderBufferViewName = this.createBufferView(this.materialColorVertexShaderBytes.length, this.body.position());
        this.body.put(this.materialColorVertexShaderBytes);
        this.gltfNode.set("animations", this.createAnimations());
        this.gltfNode.set("asset", this.createAsset());
        this.gltfNode.set("programs", (JsonNode)this.createPrograms());
        this.gltfNode.put("scene", "defaultScene");
        this.gltfNode.set("skins", this.createSkins());
        this.gltfNode.set("techniques", this.createTechniques());
        this.createVertexColorShaders(vertexColorFragmentShaderBufferViewName, vertexColorVertexShaderBufferViewName);
        this.createMaterialColorShaders(materialColorFragmentShaderBufferViewName, materialColorVertexShaderBufferViewName);
        this.addBuffer("binary_glTF", "arraybuffer", this.body.capacity());
        ArrayNode extensions = OBJECT_MAPPER.createArrayNode();
        extensions.add("KHR_binary_glTF");
        this.gltfNode.set("extensionsUsed", (JsonNode)extensions);
    }

    private float[] getOffsets() {
        float[] changes = new float[3];
        for (int i = 0; i < 3; ++i) {
            changes[i] = (this.max[i] - this.min[i]) / 2.0f + this.min[i];
        }
        return changes;
    }

    private void updateExtends(GeometryInfo geometryInfo, float[] matrix) {
        ByteBuffer verticesByteBufferBuffer = ByteBuffer.wrap(geometryInfo.getData().getVertices().getData());
        verticesByteBufferBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = verticesByteBufferBuffer.asFloatBuffer();
        for (int i = 0; i < floatBuffer.capacity(); i += 3) {
            float[] input = new float[]{floatBuffer.get(i), floatBuffer.get(i + 1), floatBuffer.get(i + 2), 1.0f};
            float[] output = new float[4];
            Matrix.multiplyMV((float[])output, (int)0, (float[])matrix, (int)0, (float[])input, (int)0);
            for (int j = 0; j < 3; ++j) {
                float value = output[j];
                if (value > this.max[j]) {
                    this.max[j] = value;
                }
                if (!(value < this.min[j])) continue;
                this.min[j] = value;
            }
        }
    }

    private String addNode(String meshName, IfcProduct ifcProduct) {
        String nodeName = "node_" + ifcProduct.getOid();
        ObjectNode nodeNode = OBJECT_MAPPER.createObjectNode();
        ArrayNode matrixArray = OBJECT_MAPPER.createArrayNode();
        ByteBuffer matrixByteBuffer = ByteBuffer.wrap(ifcProduct.getGeometry().getTransformation());
        matrixByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = matrixByteBuffer.asDoubleBuffer();
        for (int i = 0; i < 16; ++i) {
            matrixArray.add(doubleBuffer.get(i));
        }
        ArrayNode meshes = OBJECT_MAPPER.createArrayNode();
        meshes.add(meshName);
        nodeNode.set("meshes", (JsonNode)meshes);
        nodeNode.set("matrix", (JsonNode)matrixArray);
        this.nodes.set(nodeName, (JsonNode)nodeNode);
        return nodeName;
    }

    private ObjectNode createDefaultScene() {
        ObjectNode sceneNode = OBJECT_MAPPER.createObjectNode();
        this.defaultSceneNodes = OBJECT_MAPPER.createArrayNode();
        sceneNode.set("nodes", (JsonNode)this.defaultSceneNodes);
        return sceneNode;
    }

    private String createBufferView(int byteLength, int byteOffset) {
        return this.createBufferView(byteLength, byteOffset, -1);
    }

    private String createBufferView(int byteLength, int byteOffset, int target) {
        String name = "bufferView_" + this.bufferViewCounter++;
        ObjectNode bufferViewNode = OBJECT_MAPPER.createObjectNode();
        bufferViewNode.put("buffer", "binary_glTF");
        bufferViewNode.put("byteLength", byteLength);
        bufferViewNode.put("byteOffset", byteOffset);
        if (target != -1) {
            bufferViewNode.put("target", target);
        }
        this.buffersViews.set(name, (JsonNode)bufferViewNode);
        return name;
    }

    private String addNormalsAccessor(IfcProduct ifcProduct, String bufferViewName, int byteOffset, int count) throws SerializerException {
        if (count <= 0) {
            throw new SerializerException("Count <= 0");
        }
        String accessorName = "accessor_normal_" + this.accessorCounter++;
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewName);
        accessor.put("byteOffset", byteOffset);
        accessor.put("byteStride", 12);
        accessor.put("componentType", 5126);
        accessor.put("count", count);
        accessor.put("type", "VEC3");
        ArrayNode min = OBJECT_MAPPER.createArrayNode();
        min.add(-1.0);
        min.add(-1.0);
        min.add(-1.0);
        ArrayNode max = OBJECT_MAPPER.createArrayNode();
        max.add(1);
        max.add(1);
        max.add(1);
        accessor.set("min", (JsonNode)min);
        accessor.set("max", (JsonNode)max);
        this.accessors.set(accessorName, (JsonNode)accessor);
        return accessorName;
    }

    private String addColorsAccessor(IfcProduct ifcProduct, String bufferViewName, int byteOffset, int count) {
        String accessorName = "accessor_color_" + this.accessorCounter++;
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewName);
        accessor.put("byteOffset", byteOffset);
        accessor.put("byteStride", 16);
        accessor.put("componentType", 5126);
        accessor.put("count", count);
        accessor.put("type", "VEC4");
        this.accessors.set(accessorName, (JsonNode)accessor);
        return accessorName;
    }

    private String addVerticesAccessor(IfcProduct ifcProduct, String bufferViewName, int startPosition, int count) throws SerializerException {
        if (count <= 0) {
            throw new SerializerException("Count <= 0");
        }
        String accessorName = "accessor_vertex_" + this.accessorCounter++;
        GeometryData data = ifcProduct.getGeometry().getData();
        ByteBuffer verticesBuffer = ByteBuffer.wrap(data.getVertices().getData());
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewName);
        accessor.put("byteOffset", startPosition);
        accessor.put("byteStride", 12);
        accessor.put("componentType", 5126);
        accessor.put("count", count);
        accessor.put("type", "VEC3");
        verticesBuffer.order(ByteOrder.LITTLE_ENDIAN);
        double[] min = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        double[] max = new double[]{-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308};
        for (int i = 0; i < verticesBuffer.capacity(); i += 3) {
            for (int j = 0; j < 3; ++j) {
                double val = verticesBuffer.get(i + j);
                if (val > max[j]) {
                    max[j] = val;
                }
                if (!(val < min[j])) continue;
                min[j] = val;
            }
        }
        ArrayNode minNode = OBJECT_MAPPER.createArrayNode();
        minNode.add(min[0]);
        minNode.add(min[1]);
        minNode.add(min[2]);
        ArrayNode maxNode = OBJECT_MAPPER.createArrayNode();
        maxNode.add(max[0]);
        maxNode.add(max[1]);
        maxNode.add(max[2]);
        accessor.set("min", (JsonNode)minNode);
        accessor.set("max", (JsonNode)maxNode);
        this.accessors.set(accessorName, (JsonNode)accessor);
        return accessorName;
    }

    private String addIndicesAccessor(IfcProduct ifcProduct, String bufferViewName, int offsetBytes, int count) throws SerializerException {
        if (count <= 0) {
            throw new SerializerException(count + " <= 0");
        }
        String accessorName = "accessor_index_" + this.accessorCounter++;
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewName);
        accessor.put("byteOffset", offsetBytes);
        accessor.put("byteStride", 0);
        accessor.put("componentType", 5123);
        accessor.put("count", count);
        accessor.put("type", "SCALAR");
        this.accessors.set(accessorName, (JsonNode)accessor);
        return accessorName;
    }

    private String addMesh(IfcProduct ifcProduct, ArrayNode primitivesNode) {
        ObjectNode meshNode = OBJECT_MAPPER.createObjectNode();
        String meshName = "mesh_" + ifcProduct.getOid();
        meshNode.put("name", meshName);
        meshNode.set("primitives", (JsonNode)primitivesNode);
        this.meshes.set(meshName, (JsonNode)meshNode);
        return meshName;
    }

    private void addBuffer(String name, String type, int byteLength) {
        ObjectNode bufferNode = OBJECT_MAPPER.createObjectNode();
        bufferNode.put("byteLength", byteLength);
        bufferNode.put("type", type);
        bufferNode.put("uri", "data:,");
        this.buffers.set(name, (JsonNode)bufferNode);
    }

    private JsonNode createAnimations() {
        return OBJECT_MAPPER.createObjectNode();
    }

    private JsonNode createTechniques() {
        ObjectNode techniques = OBJECT_MAPPER.createObjectNode();
        techniques.set("vertexColorTechnique", (JsonNode)this.createVertexColorTechnique());
        techniques.set("materialColorTechnique", (JsonNode)this.createMaterialColorTechnique());
        return techniques;
    }

    private ObjectNode createMaterialColorTechnique() {
        ObjectNode technique = OBJECT_MAPPER.createObjectNode();
        ObjectNode attributes = OBJECT_MAPPER.createObjectNode();
        ObjectNode parameters = OBJECT_MAPPER.createObjectNode();
        ObjectNode states = OBJECT_MAPPER.createObjectNode();
        ObjectNode uniforms = OBJECT_MAPPER.createObjectNode();
        attributes.put("a_normal", "normal");
        attributes.put("a_position", "position");
        ObjectNode diffuse = OBJECT_MAPPER.createObjectNode();
        diffuse.put("type", 35666);
        parameters.set("diffuse", (JsonNode)diffuse);
        ObjectNode modelViewMatrix = OBJECT_MAPPER.createObjectNode();
        modelViewMatrix.put("semantic", "MODELVIEW");
        modelViewMatrix.put("type", 35676);
        parameters.set("modelViewMatrix", (JsonNode)modelViewMatrix);
        ObjectNode normal = OBJECT_MAPPER.createObjectNode();
        normal.put("semantic", "NORMAL");
        normal.put("type", 35665);
        parameters.set("normal", (JsonNode)normal);
        ObjectNode normalMatrix = OBJECT_MAPPER.createObjectNode();
        normalMatrix.put("semantic", "MODELVIEWINVERSETRANSPOSE");
        normalMatrix.put("type", 35675);
        parameters.set("normalMatrix", (JsonNode)normalMatrix);
        ObjectNode position = OBJECT_MAPPER.createObjectNode();
        position.put("semantic", "POSITION");
        position.put("type", 35665);
        parameters.set("position", (JsonNode)position);
        ObjectNode projectionMatrix = OBJECT_MAPPER.createObjectNode();
        projectionMatrix.put("semantic", "PROJECTION");
        projectionMatrix.put("type", 35676);
        parameters.set("projectionMatrix", (JsonNode)projectionMatrix);
        ObjectNode shininess = OBJECT_MAPPER.createObjectNode();
        shininess.put("type", 5126);
        parameters.set("shininess", (JsonNode)shininess);
        ObjectNode specular = OBJECT_MAPPER.createObjectNode();
        specular.put("type", 35666);
        parameters.set("specular", (JsonNode)specular);
        technique.put("program", "materialColorProgram");
        ArrayNode statesEnable = OBJECT_MAPPER.createArrayNode();
        statesEnable.add(2929);
        statesEnable.add(2884);
        states.set("enable", (JsonNode)statesEnable);
        uniforms.put("u_diffuse", "diffuse");
        uniforms.put("u_modelViewMatrix", "modelViewMatrix");
        uniforms.put("u_normalMatrix", "normalMatrix");
        uniforms.put("u_projectionMatrix", "projectionMatrix");
        uniforms.put("u_shininess", "shininess");
        uniforms.put("u_specular", "specular");
        technique.set("attributes", (JsonNode)attributes);
        technique.set("parameters", (JsonNode)parameters);
        technique.set("states", (JsonNode)states);
        technique.set("uniforms", (JsonNode)uniforms);
        return technique;
    }

    private ObjectNode createVertexColorTechnique() {
        ObjectNode technique = OBJECT_MAPPER.createObjectNode();
        ObjectNode attributes = OBJECT_MAPPER.createObjectNode();
        ObjectNode parameters = OBJECT_MAPPER.createObjectNode();
        ObjectNode states = OBJECT_MAPPER.createObjectNode();
        ObjectNode uniforms = OBJECT_MAPPER.createObjectNode();
        attributes.put("a_normal", "normal");
        attributes.put("a_position", "position");
        attributes.put("a_color", "color");
        ObjectNode modelViewMatrix = OBJECT_MAPPER.createObjectNode();
        modelViewMatrix.put("semantic", "MODELVIEW");
        modelViewMatrix.put("type", 35676);
        parameters.set("modelViewMatrix", (JsonNode)modelViewMatrix);
        ObjectNode normal = OBJECT_MAPPER.createObjectNode();
        normal.put("semantic", "NORMAL");
        normal.put("type", 35665);
        parameters.set("normal", (JsonNode)normal);
        ObjectNode normalMatrix = OBJECT_MAPPER.createObjectNode();
        normalMatrix.put("semantic", "MODELVIEWINVERSETRANSPOSE");
        normalMatrix.put("type", 35675);
        parameters.set("normalMatrix", (JsonNode)normalMatrix);
        ObjectNode position = OBJECT_MAPPER.createObjectNode();
        position.put("semantic", "POSITION");
        position.put("type", 35665);
        parameters.set("position", (JsonNode)position);
        ObjectNode color = OBJECT_MAPPER.createObjectNode();
        color.put("semantic", "COLOR");
        color.put("type", 35666);
        parameters.set("color", (JsonNode)color);
        ObjectNode projectionMatrix = OBJECT_MAPPER.createObjectNode();
        projectionMatrix.put("semantic", "PROJECTION");
        projectionMatrix.put("type", 35676);
        parameters.set("projectionMatrix", (JsonNode)projectionMatrix);
        technique.put("program", "vertexColorProgram");
        ArrayNode statesEnable = OBJECT_MAPPER.createArrayNode();
        statesEnable.add(2929);
        statesEnable.add(2884);
        states.set("enable", (JsonNode)statesEnable);
        uniforms.put("u_modelViewMatrix", "modelViewMatrix");
        uniforms.put("u_normalMatrix", "normalMatrix");
        uniforms.put("u_projectionMatrix", "projectionMatrix");
        technique.set("attributes", (JsonNode)attributes);
        technique.set("parameters", (JsonNode)parameters);
        technique.set("states", (JsonNode)states);
        technique.set("uniforms", (JsonNode)uniforms);
        return technique;
    }

    private JsonNode createSkins() {
        return OBJECT_MAPPER.createObjectNode();
    }

    private void createVertexColorShaders(String fragmentShaderBufferViewName, String vertexShaderBufferViewName) {
        ObjectNode fragmentShaderExtensions = OBJECT_MAPPER.createObjectNode();
        ObjectNode fragmentShaderBinary = OBJECT_MAPPER.createObjectNode();
        fragmentShaderExtensions.set("KHR_binary_glTF", (JsonNode)fragmentShaderBinary);
        fragmentShaderBinary.put("bufferView", fragmentShaderBufferViewName);
        ObjectNode fragmentShader = OBJECT_MAPPER.createObjectNode();
        fragmentShader.put("type", 35632);
        fragmentShader.put("uri", "data:,");
        fragmentShader.set("extensions", (JsonNode)fragmentShaderExtensions);
        ObjectNode vertexShaderExtensions = OBJECT_MAPPER.createObjectNode();
        ObjectNode vertexShaderBinary = OBJECT_MAPPER.createObjectNode();
        vertexShaderExtensions.set("KHR_binary_glTF", (JsonNode)vertexShaderBinary);
        vertexShaderBinary.put("bufferView", vertexShaderBufferViewName);
        ObjectNode vertexShader = OBJECT_MAPPER.createObjectNode();
        vertexShader.put("type", 35633);
        vertexShader.put("uri", "data:,");
        vertexShader.set("extensions", (JsonNode)vertexShaderExtensions);
        this.shaders.set("vertexColorFragmentShader", (JsonNode)fragmentShader);
        this.shaders.set("vertexColorVertexShader", (JsonNode)vertexShader);
    }

    private void createMaterialColorShaders(String fragmentShaderBufferViewName, String vertexShaderBufferViewName) {
        ObjectNode fragmentShaderExtensions = OBJECT_MAPPER.createObjectNode();
        ObjectNode fragmentShaderBinary = OBJECT_MAPPER.createObjectNode();
        fragmentShaderExtensions.set("KHR_binary_glTF", (JsonNode)fragmentShaderBinary);
        fragmentShaderBinary.put("bufferView", fragmentShaderBufferViewName);
        ObjectNode fragmentShader = OBJECT_MAPPER.createObjectNode();
        fragmentShader.put("type", 35632);
        fragmentShader.put("uri", "data:,");
        fragmentShader.set("extensions", (JsonNode)fragmentShaderExtensions);
        ObjectNode vertexShaderExtensions = OBJECT_MAPPER.createObjectNode();
        ObjectNode vertexShaderBinary = OBJECT_MAPPER.createObjectNode();
        vertexShaderExtensions.set("KHR_binary_glTF", (JsonNode)vertexShaderBinary);
        vertexShaderBinary.put("bufferView", vertexShaderBufferViewName);
        ObjectNode vertexShader = OBJECT_MAPPER.createObjectNode();
        vertexShader.put("type", 35633);
        vertexShader.put("uri", "data:,");
        vertexShader.set("extensions", (JsonNode)vertexShaderExtensions);
        this.shaders.set("materialColorFragmentShader", (JsonNode)fragmentShader);
        this.shaders.set("materialColorVertexShader", (JsonNode)vertexShader);
    }

    private ObjectNode createPrograms() {
        ObjectNode programs = OBJECT_MAPPER.createObjectNode();
        programs.set("vertexColorProgram", this.createVertexColorsPrograms());
        programs.set("materialColorProgram", this.createMaterialColorsPrograms());
        return programs;
    }

    private JsonNode createVertexColorsPrograms() {
        ObjectNode program = OBJECT_MAPPER.createObjectNode();
        ArrayNode attributes = OBJECT_MAPPER.createArrayNode();
        program.set("attributes", (JsonNode)attributes);
        attributes.add("a_normal");
        attributes.add("a_position");
        attributes.add("a_color");
        program.put("fragmentShader", "vertexColorFragmentShader");
        program.put("vertexShader", "vertexColorVertexShader");
        return program;
    }

    private JsonNode createMaterialColorsPrograms() {
        ObjectNode program = OBJECT_MAPPER.createObjectNode();
        ArrayNode attributes = OBJECT_MAPPER.createArrayNode();
        program.set("attributes", (JsonNode)attributes);
        attributes.add("a_normal");
        attributes.add("a_position");
        program.put("fragmentShader", "materialColorFragmentShader");
        program.put("vertexShader", "materialColorVertexShader");
        return program;
    }

    private String createOrGetMaterial(String name, float[] colors) {
        if (this.createdMaterials.contains(name)) {
            return name;
        }
        ObjectNode material = OBJECT_MAPPER.createObjectNode();
        material.put("name", name + "Material");
        material.put("technique", "materialColorTechnique");
        ObjectNode values = OBJECT_MAPPER.createObjectNode();
        ArrayNode diffuse = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < 4; ++i) {
            diffuse.add(colors[i]);
        }
        ArrayNode specular = OBJECT_MAPPER.createArrayNode();
        specular.add(0.20000000298023218);
        specular.add(0.20000000298023218);
        specular.add(0.20000000298023218);
        values.set("diffuse", (JsonNode)diffuse);
        values.set("specular", (JsonNode)specular);
        values.put("shininess", 256);
        material.set("values", (JsonNode)values);
        this.materials.set(name, (JsonNode)material);
        this.createdMaterials.add(name);
        return name;
    }

    private void createVertexColorMaterial() {
        ObjectNode defaultMaterial = OBJECT_MAPPER.createObjectNode();
        defaultMaterial.put("name", VERTEX_COLOR_MATERIAL);
        defaultMaterial.put("technique", "vertexColorTechnique");
        ObjectNode values = OBJECT_MAPPER.createObjectNode();
        defaultMaterial.set("values", (JsonNode)values);
        this.materials.set(VERTEX_COLOR_MATERIAL, (JsonNode)defaultMaterial);
    }

    private JsonNode createAsset() {
        return OBJECT_MAPPER.createObjectNode();
    }

    private void writeHeader(LittleEndianDataOutputStream dataOutputStream, int headerLength, int sceneLength, int bodyLength) throws IOException {
        dataOutputStream.write(MAGIC.getBytes(Charsets.US_ASCII));
        dataOutputStream.writeInt(this.FORMAT_VERSION_1);
        dataOutputStream.writeInt(headerLength + sceneLength + bodyLength);
        dataOutputStream.writeInt(sceneLength);
        dataOutputStream.writeInt(this.JSON_SCENE_FORMAT);
    }

    private void writeBody(LittleEndianDataOutputStream dataOutputStream, byte[] body) throws IOException {
        dataOutputStream.write(body);
    }

    private void writeScene(LittleEndianDataOutputStream dataOutputStream, byte[] scene) throws IOException {
        dataOutputStream.write(scene);
    }
}

