/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.gltf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import org.bimserver.geometry.IfcColors;
import org.bimserver.geometry.Matrix;
import org.bimserver.gltf.BinaryGltfBaseSerializer;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.geometry.Vector4f;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryGltfSerializer2
extends BinaryGltfBaseSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryGltfSerializer2.class);
    private static final int ARRAY_BUFFER = 34962;
    private static final int ELEMENT_ARRAY_BUFFER = 34963;
    private static final int MAGIC = 1179937895;
    private static final int UNSIGNED_INT = 5125;
    private static final int TRIANGLES = 4;
    private static final int FLOAT = 5126;
    private static final int UNSIGNED_BYTE = 5121;
    private static final int JSON_CHUNK = 1313821514;
    private static final int BINARY_CHUNK = 5130562;
    private static final int FORMAT_VERSION = 2;
    private static final String GLTF_VERSION = "2.0";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ArrayNode buffers;
    private ByteBuffer body;
    private ArrayNode meshes;
    private ArrayNode accessors;
    private ArrayNode buffersViews;
    private ArrayNode defaultSceneNodes;
    private ArrayNode scenesNode;
    private ObjectNode gltfNode;
    private ArrayNode nodes;
    double[] min = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
    double[] max = new double[]{-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308};
    private ArrayNode modelTranslation;
    private ArrayNode materials;
    private final Map<String, Integer> createdMaterials = new HashMap<String, Integer>();
    private ArrayNode translationChildrenNode;
    private int vertexColorIndex;

    protected boolean write(OutputStream outputStream, ProgressReporter progressReporter) throws SerializerException {
        LOGGER.info("Starting serialization");
        this.gltfNode = OBJECT_MAPPER.createObjectNode();
        this.buffers = OBJECT_MAPPER.createArrayNode();
        this.meshes = OBJECT_MAPPER.createArrayNode();
        this.buffersViews = OBJECT_MAPPER.createArrayNode();
        this.scenesNode = OBJECT_MAPPER.createArrayNode();
        this.accessors = OBJECT_MAPPER.createArrayNode();
        this.nodes = OBJECT_MAPPER.createArrayNode();
        this.materials = OBJECT_MAPPER.createArrayNode();
        this.gltfNode.set("meshes", (JsonNode)this.meshes);
        this.gltfNode.set("bufferViews", (JsonNode)this.buffersViews);
        this.gltfNode.set("scenes", (JsonNode)this.scenesNode);
        this.gltfNode.set("accessors", (JsonNode)this.accessors);
        this.gltfNode.set("nodes", (JsonNode)this.nodes);
        this.gltfNode.set("buffers", (JsonNode)this.buffers);
        this.gltfNode.set("materials", (JsonNode)this.materials);
        this.createVertexColorMaterial();
        try {
            LittleEndianDataOutputStream dataOutputStream = new LittleEndianDataOutputStream(outputStream);
            this.generateSceneAndBody();
            byte[] sceneBytes = this.gltfNode.toString().getBytes(Charsets.UTF_8);
            int sceneLength = sceneBytes.length + (sceneBytes.length % 4 == 0 ? 0 : 4 - sceneBytes.length % 4);
            int bodyLength = this.body.capacity() + (this.body.capacity() % 4 == 0 ? 0 : 4 - this.body.capacity() % 4);
            this.writeHeader(dataOutputStream, 12, 8 + sceneLength, 8 + bodyLength);
            this.writeScene(dataOutputStream, sceneBytes);
            this.writeBody(dataOutputStream, this.body.array());
            dataOutputStream.flush();
        }
        catch (Exception e) {
            throw new SerializerException((Throwable)e);
        }
        return false;
    }

    private void createModelNode() {
        ObjectNode translationNode = OBJECT_MAPPER.createObjectNode();
        this.modelTranslation = OBJECT_MAPPER.createArrayNode();
        this.translationChildrenNode = OBJECT_MAPPER.createArrayNode();
        translationNode.set("children", (JsonNode)this.translationChildrenNode);
        translationNode.set("translation", (JsonNode)this.modelTranslation);
        ObjectNode rotationNode = OBJECT_MAPPER.createObjectNode();
        ArrayNode rotation = OBJECT_MAPPER.createArrayNode();
        ArrayNode rotationChildrenNode = OBJECT_MAPPER.createArrayNode();
        this.nodes.add((JsonNode)translationNode);
        rotationChildrenNode.add(this.nodes.size() - 1);
        rotationNode.set("children", (JsonNode)rotationChildrenNode);
        rotationNode.set("rotation", (JsonNode)rotation);
        float[] quat = this.normalizeQuaternion(new float[]{1.0f, 0.0f, 0.0f, -1.0f});
        rotation.add(quat[0]);
        rotation.add(quat[1]);
        rotation.add(quat[2]);
        rotation.add(quat[3]);
        this.nodes.add((JsonNode)rotationNode);
        this.defaultSceneNodes.add(this.nodes.size() - 1);
    }

    public float len2(float[] input) {
        return input[0] * input[0] + input[1] * input[1] + input[2] * input[2] + input[3] * input[3];
    }

    private float[] normalizeQuaternion(float[] input) {
        float len = this.len2(input);
        if (len != 0.0f && len != 1.0f) {
            len = (float)Math.sqrt(len);
            input[0] = input[0] / len;
            input[1] = input[1] / len;
            input[2] = input[2] / len;
            input[3] = input[3] / len;
        }
        return input;
    }

    private void generateSceneAndBody() throws SerializerException {
        int totalBodyByteLength = 0;
        int totalIndicesByteLength = 0;
        int totalVerticesByteLength = 0;
        int totalNormalsByteLength = 0;
        int totalColorsByteLength = 0;
        for (IfcProduct ifcProduct : this.model.getAllWithSubTypes(IfcProduct.class)) {
            if (!this.checkGeometry(ifcProduct, false)) continue;
            GeometryInfo geometryInfo = ifcProduct.getGeometry();
            GeometryData data = geometryInfo.getData();
            totalIndicesByteLength += data.getNrIndices() * 4;
            totalVerticesByteLength += data.getNrVertices() * 4;
            totalNormalsByteLength += data.getNrNormals() * 4;
            if (data.getColorsQuantized() != null) {
                totalColorsByteLength += data.getColorsQuantized().getData().length;
                continue;
            }
            totalColorsByteLength += data.getNrVertices() / 3 * 4;
        }
        if (totalIndicesByteLength == 0) {
            throw new SerializerException("No geometry");
        }
        totalBodyByteLength = totalIndicesByteLength + totalVerticesByteLength + totalNormalsByteLength + totalColorsByteLength;
        this.body = ByteBuffer.allocate(totalBodyByteLength);
        this.body.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newIndicesBuffer = ByteBuffer.allocate(totalIndicesByteLength);
        newIndicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newVerticesBuffer = ByteBuffer.allocate(totalVerticesByteLength);
        newVerticesBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newNormalsBuffer = ByteBuffer.allocate(totalNormalsByteLength);
        newNormalsBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer newColorsBuffer = ByteBuffer.allocate(totalColorsByteLength);
        newColorsBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int indicesBufferView = this.createBufferView(totalIndicesByteLength, 0, 34963, -1);
        int verticesBufferView = this.createBufferView(totalVerticesByteLength, totalIndicesByteLength, 34962, 12);
        int normalsBufferView = this.createBufferView(totalNormalsByteLength, totalIndicesByteLength + totalVerticesByteLength, 34962, 12);
        int colorsBufferView = -1;
        this.scenesNode.add((JsonNode)this.createDefaultScene());
        this.gltfNode.put("scene", 0);
        this.createModelNode();
        for (IfcProduct ifcProduct : this.model.getAllWithSubTypes(IfcProduct.class)) {
            if (!this.checkGeometry(ifcProduct, false)) continue;
            GeometryInfo geometryInfo = ifcProduct.getGeometry();
            ByteBuffer matrixByteBuffer = ByteBuffer.wrap(ifcProduct.getGeometry().getTransformation());
            matrixByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer = matrixByteBuffer.asDoubleBuffer();
            double[] matrix = new double[16];
            for (int i = 0; i < doubleBuffer.capacity(); ++i) {
                matrix[i] = doubleBuffer.get();
            }
            this.updateExtends(geometryInfo, matrix);
        }
        double[] offsets = this.getOffsets();
        this.modelTranslation.add(-offsets[0]);
        this.modelTranslation.add(-offsets[1]);
        this.modelTranslation.add(-offsets[2]);
        for (IfcProduct ifcProduct : this.model.getAllWithSubTypes(IfcProduct.class)) {
            GeometryInfo geometryInfo = ifcProduct.getGeometry();
            if (!this.checkGeometry(ifcProduct, true)) continue;
            int startPositionIndices = newIndicesBuffer.position();
            int startPositionVertices = newVerticesBuffer.position();
            int startPositionNormals = newNormalsBuffer.position();
            int startPositionColors = newColorsBuffer.position();
            GeometryData data = geometryInfo.getData();
            ByteBuffer indicesBuffer = ByteBuffer.wrap(data.getIndices().getData());
            indicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer indicesIntBuffer = indicesBuffer.asIntBuffer();
            ByteBuffer verticesBuffer = ByteBuffer.wrap(data.getVertices().getData());
            verticesBuffer.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer normalsBuffer = ByteBuffer.wrap(data.getNormals().getData());
            normalsBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int maxVal = 0;
            for (int i = 0; i < indicesIntBuffer.capacity(); ++i) {
                int index = indicesIntBuffer.get(i);
                newIndicesBuffer.putInt(index);
                if (index <= maxVal) continue;
                maxVal = index;
            }
            int[] min = new int[]{0};
            int[] max = new int[]{maxVal};
            for (int i = 0; i < data.getNrVertices(); ++i) {
                newVerticesBuffer.putFloat((float)verticesBuffer.getDouble());
            }
            newNormalsBuffer.put(data.getNormals().getData());
            if (data.getColorsQuantized() != null) {
                newColorsBuffer.put(data.getColorsQuantized().getData());
            } else {
                Vector4f color = data.getColor();
                if (color == null) {
                    color = data.getMostUsedColor();
                }
                if (color != null) {
                    for (int i = 0; i < data.getNrVertices() / 3; ++i) {
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)((int)(color.getX() * 255.0f))));
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)((int)(color.getY() * 255.0f))));
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)((int)(color.getZ() * 255.0f))));
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)((int)(color.getW() * 255.0f))));
                    }
                } else {
                    for (int i = 0; i < data.getNrVertices() / 3; ++i) {
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)50L));
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)50L));
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)50L));
                        newColorsBuffer.put(UnsignedBytes.checkedCast((long)255L));
                    }
                }
            }
            int totalNrIndices = indicesIntBuffer.capacity();
            ArrayNode primitivesNode = OBJECT_MAPPER.createArrayNode();
            ObjectNode primitiveNode = OBJECT_MAPPER.createObjectNode();
            int indicesAccessor = this.addIndicesAccessor(ifcProduct, indicesBufferView, startPositionIndices, totalNrIndices, min, max);
            int verticesAccessor = this.addVerticesAccessor(ifcProduct, verticesBufferView, startPositionVertices, data.getNrVertices() / 3);
            int normalsAccessor = this.addNormalsAccessor(ifcProduct, normalsBufferView, startPositionNormals, data.getNrNormals() / 3);
            int colorAccessor = -1;
            if (colorsBufferView == -1) {
                colorsBufferView = this.createBufferView(totalColorsByteLength, totalIndicesByteLength + totalVerticesByteLength + totalNormalsByteLength, 34962, 4);
            }
            colorAccessor = this.addColorsAccessor(ifcProduct, colorsBufferView, startPositionColors, data.getNrVertices() / 3);
            primitivesNode.add((JsonNode)primitiveNode);
            primitiveNode.put("indices", indicesAccessor);
            primitiveNode.put("mode", 4);
            ObjectNode attributesNode = OBJECT_MAPPER.createObjectNode();
            primitiveNode.set("attributes", (JsonNode)attributesNode);
            attributesNode.put("NORMAL", normalsAccessor);
            attributesNode.put("POSITION", verticesAccessor);
            if (colorAccessor != -1) {
                attributesNode.put("COLOR_0", colorAccessor);
                primitiveNode.put("material", this.vertexColorIndex);
            } else {
                primitiveNode.put("material", this.createOrGetMaterial(ifcProduct.eClass().getName(), IfcColors.getDefaultColor((String)ifcProduct.eClass().getName())));
            }
            int meshId = this.addMesh(ifcProduct, primitivesNode);
            int nodeId = this.addNode(meshId, ifcProduct);
            this.translationChildrenNode.add(nodeId);
        }
        if (newIndicesBuffer.position() != newIndicesBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        if (newVerticesBuffer.position() != newVerticesBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        if (newNormalsBuffer.position() != newNormalsBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        if (newColorsBuffer.position() != newColorsBuffer.capacity()) {
            throw new SerializerException("Not all space used");
        }
        newIndicesBuffer.position(0);
        newVerticesBuffer.position(0);
        newNormalsBuffer.position(0);
        newColorsBuffer.position(0);
        this.body.put(newIndicesBuffer);
        this.body.put(newVerticesBuffer);
        this.body.put(newNormalsBuffer);
        this.body.put(newColorsBuffer);
        this.gltfNode.set("asset", this.createAsset());
        this.gltfNode.put("scene", 0);
        this.addBuffer(this.body.capacity());
    }

    private double[] getOffsets() {
        double[] changes = new double[3];
        for (int i = 0; i < 3; ++i) {
            changes[i] = (this.max[i] - this.min[i]) / 2.0 + this.min[i];
        }
        return changes;
    }

    private void updateExtends(GeometryInfo geometryInfo, double[] matrix) {
        if (geometryInfo.getData() == null || geometryInfo.getData().getVertices() == null) {
            return;
        }
        ByteBuffer verticesByteBufferBuffer = ByteBuffer.wrap(geometryInfo.getData().getVertices().getData());
        verticesByteBufferBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = verticesByteBufferBuffer.asDoubleBuffer();
        for (int i = 0; i < doubleBuffer.capacity(); i += 3) {
            double[] input = new double[]{doubleBuffer.get(i), doubleBuffer.get(i + 1), doubleBuffer.get(i + 2), 1.0};
            double[] output = new double[4];
            Matrix.multiplyMV((double[])output, (int)0, (double[])matrix, (int)0, (double[])input, (int)0);
            for (int j = 0; j < 3; ++j) {
                double value = output[j];
                if (value > this.max[j]) {
                    this.max[j] = value;
                }
                if (!(value < this.min[j])) continue;
                this.min[j] = value;
            }
        }
    }

    private int addNode(int meshId, IfcProduct ifcProduct) {
        ObjectNode nodeNode = OBJECT_MAPPER.createObjectNode();
        ArrayNode matrixArray = OBJECT_MAPPER.createArrayNode();
        ByteBuffer matrixByteBuffer = ByteBuffer.wrap(ifcProduct.getGeometry().getTransformation());
        matrixByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = matrixByteBuffer.asDoubleBuffer();
        double[] buffer = new double[16];
        for (int i = 0; i < 16; ++i) {
            double d = doubleBuffer.get(i);
            matrixArray.add(d);
            buffer[i] = d;
        }
        String GUID = ifcProduct.getGlobalId();
        ObjectNode extrasNode = OBJECT_MAPPER.createObjectNode();
        nodeNode.set("extras", (JsonNode)extrasNode);
        extrasNode.put("ifcID", GUID);
        nodeNode.put("mesh", meshId);
        if (!Matrix.isIdentity((double[])buffer)) {
            if (!Matrix.invertM((double[])new double[16], (int)0, (double[])buffer, (int)0)) {
                LOGGER.info("Could not invert matrix, omitting");
            } else {
                nodeNode.set("matrix", (JsonNode)matrixArray);
            }
        }
        this.nodes.add((JsonNode)nodeNode);
        return this.nodes.size() - 1;
    }

    private ObjectNode createDefaultScene() {
        ObjectNode sceneNode = OBJECT_MAPPER.createObjectNode();
        this.defaultSceneNodes = OBJECT_MAPPER.createArrayNode();
        sceneNode.set("nodes", (JsonNode)this.defaultSceneNodes);
        return sceneNode;
    }

    private int createBufferView(int byteLength, int byteOffset, int target, int byteStride) {
        ObjectNode bufferViewNode = OBJECT_MAPPER.createObjectNode();
        bufferViewNode.put("buffer", 0);
        bufferViewNode.put("byteLength", byteLength);
        bufferViewNode.put("byteOffset", byteOffset);
        if (byteStride != -1) {
            bufferViewNode.put("byteStride", byteStride);
        }
        if (target != -1) {
            bufferViewNode.put("target", target);
        }
        this.buffersViews.add((JsonNode)bufferViewNode);
        return this.buffersViews.size() - 1;
    }

    private int addNormalsAccessor(IfcProduct ifcProduct, int bufferViewIndex, int byteOffset, int count) throws SerializerException {
        if (count <= 0) {
            throw new SerializerException("Count <= 0");
        }
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewIndex);
        accessor.put("byteOffset", byteOffset);
        accessor.put("componentType", 5126);
        accessor.put("count", count);
        accessor.put("type", "VEC3");
        ArrayNode min = OBJECT_MAPPER.createArrayNode();
        min.add(-1.0);
        min.add(-1.0);
        min.add(-1.0);
        ArrayNode max = OBJECT_MAPPER.createArrayNode();
        max.add(1);
        max.add(1);
        max.add(1);
        this.accessors.add((JsonNode)accessor);
        return this.accessors.size() - 1;
    }

    private int addColorsAccessor(IfcProduct ifcProduct, int bufferViewIndex, int byteOffset, int count) {
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewIndex);
        accessor.put("byteOffset", byteOffset);
        accessor.put("componentType", 5121);
        accessor.put("normalized", true);
        accessor.put("count", count);
        accessor.put("type", "VEC4");
        this.accessors.add((JsonNode)accessor);
        return this.accessors.size() - 1;
    }

    private int addVerticesAccessor(IfcProduct ifcProduct, int bufferViewIndex, int startPosition, int count) throws SerializerException {
        if (count <= 0) {
            throw new SerializerException("Count <= 0");
        }
        GeometryData data = ifcProduct.getGeometry().getData();
        ByteBuffer verticesBuffer = ByteBuffer.wrap(data.getVertices().getData());
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewIndex);
        accessor.put("byteOffset", startPosition);
        accessor.put("componentType", 5126);
        accessor.put("count", count);
        accessor.put("type", "VEC3");
        verticesBuffer.order(ByteOrder.LITTLE_ENDIAN);
        double[] min = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        double[] max = new double[]{-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308};
        for (int i = 0; i < verticesBuffer.capacity(); i += 24) {
            for (int j = 0; j < 3; ++j) {
                double val = verticesBuffer.getDouble(i + j * 8);
                if (val > max[j]) {
                    max[j] = val;
                }
                if (!(val < min[j])) continue;
                min[j] = val;
            }
        }
        ArrayNode minNode = OBJECT_MAPPER.createArrayNode();
        minNode.add(min[0]);
        minNode.add(min[1]);
        minNode.add(min[2]);
        ArrayNode maxNode = OBJECT_MAPPER.createArrayNode();
        maxNode.add(max[0]);
        maxNode.add(max[1]);
        maxNode.add(max[2]);
        accessor.set("min", (JsonNode)minNode);
        accessor.set("max", (JsonNode)maxNode);
        this.accessors.add((JsonNode)accessor);
        return this.accessors.size() - 1;
    }

    private int addIndicesAccessor(IfcProduct ifcProduct, int bufferViewIndex, int offsetBytes, int count, int[] min, int[] max) throws SerializerException {
        if (count <= 0) {
            throw new SerializerException(count + " <= 0");
        }
        ObjectNode accessor = OBJECT_MAPPER.createObjectNode();
        accessor.put("bufferView", bufferViewIndex);
        accessor.put("byteOffset", offsetBytes);
        accessor.put("componentType", 5125);
        accessor.put("count", count);
        accessor.put("type", "SCALAR");
        this.accessors.add((JsonNode)accessor);
        return this.accessors.size() - 1;
    }

    private int addMesh(IfcProduct ifcProduct, ArrayNode primitivesNode) {
        ObjectNode meshNode = OBJECT_MAPPER.createObjectNode();
        meshNode.set("primitives", (JsonNode)primitivesNode);
        this.meshes.add((JsonNode)meshNode);
        return this.meshes.size() - 1;
    }

    private void addBuffer(int byteLength) {
        ObjectNode bufferNode = OBJECT_MAPPER.createObjectNode();
        bufferNode.put("byteLength", byteLength);
        this.buffers.add((JsonNode)bufferNode);
    }

    private int createOrGetMaterial(String name, float[] colors) {
        if (this.createdMaterials.containsKey(name)) {
            return this.createdMaterials.get(name);
        }
        ObjectNode material = OBJECT_MAPPER.createObjectNode();
        material.put("name", name + "Material");
        ObjectNode values = OBJECT_MAPPER.createObjectNode();
        ArrayNode diffuse = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < 4; ++i) {
            diffuse.add(colors[i]);
        }
        ArrayNode specular = OBJECT_MAPPER.createArrayNode();
        specular.add(0.20000000298023218);
        specular.add(0.20000000298023218);
        specular.add(0.20000000298023218);
        values.set("diffuse", (JsonNode)diffuse);
        values.set("specular", (JsonNode)specular);
        values.put("shininess", 256);
        this.materials.add((JsonNode)material);
        this.createdMaterials.put(name, this.materials.size() - 1);
        return this.materials.size() - 1;
    }

    private void createVertexColorMaterial() {
        ObjectNode defaultMaterial = OBJECT_MAPPER.createObjectNode();
        this.materials.add((JsonNode)defaultMaterial);
        this.vertexColorIndex = this.materials.size() - 1;
    }

    private JsonNode createAsset() {
        ObjectNode asset = OBJECT_MAPPER.createObjectNode();
        asset.put("version", GLTF_VERSION);
        return asset;
    }

    private void writeHeader(LittleEndianDataOutputStream dataOutputStream, int headerLength, int sceneLength, int bodyLength) throws IOException {
        dataOutputStream.writeInt(1179937895);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(headerLength + sceneLength + bodyLength);
    }

    private void writeBody(LittleEndianDataOutputStream dataOutputStream, byte[] body) throws IOException {
        int rest = body.length % 4 == 0 ? 0 : 4 - body.length % 4;
        dataOutputStream.writeInt(body.length + rest);
        dataOutputStream.writeInt(5130562);
        dataOutputStream.write(body);
        if (rest > 0) {
            dataOutputStream.write(this.pad(rest, '\u0000'));
        }
    }

    private byte[] pad(int length, char c) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)c;
        }
        return result;
    }

    private void writeScene(LittleEndianDataOutputStream dataOutputStream, byte[] scene) throws IOException {
        int rest = scene.length % 4 == 0 ? 0 : 4 - scene.length % 4;
        dataOutputStream.writeInt(scene.length + rest);
        dataOutputStream.writeInt(1313821514);
        dataOutputStream.write(scene);
        if (rest > 0) {
            dataOutputStream.write(this.pad(rest, ' '));
        }
    }
}

