/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.gltf;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.emf.Schema;
import org.bimserver.gltf.BinaryGltfSerializer;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.SchemaName;
import org.bimserver.plugins.serializers.AbstractSerializerPlugin;
import org.bimserver.plugins.serializers.Serializer;
import org.bimserver.shared.exceptions.PluginException;

public class BinaryGltfSerializerPlugin
extends AbstractSerializerPlugin {
    private byte[] vertexColorFragmentShaderBytes;
    private byte[] vertexColorVertexShaderBytes;
    private byte[] materialColorFragmentShaderBytes;
    private byte[] materialColorVertexShaderBytes;

    public void init(PluginContext pluginContext, PluginConfiguration systemSettings) throws PluginException {
        Path vertexColorFragmentShaderPath = pluginContext.getRootPath().resolve("shaders/fragmentcolor.shader");
        Path vertexColorVertexShaderPath = pluginContext.getRootPath().resolve("shaders/vertexcolor.shader");
        Path materialColorFragmentShaderPath = pluginContext.getRootPath().resolve("shaders/fragmentmaterial.shader");
        Path materialColorVertexShaderPath = pluginContext.getRootPath().resolve("shaders/vertexmaterial.shader");
        try {
            this.vertexColorFragmentShaderBytes = Files.readAllBytes(vertexColorFragmentShaderPath);
            this.vertexColorVertexShaderBytes = Files.readAllBytes(vertexColorVertexShaderPath);
            this.materialColorFragmentShaderBytes = Files.readAllBytes(materialColorFragmentShaderPath);
            this.materialColorVertexShaderBytes = Files.readAllBytes(materialColorVertexShaderPath);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public Serializer createSerializer(PluginConfiguration plugin) {
        return new BinaryGltfSerializer(this.vertexColorFragmentShaderBytes, this.vertexColorVertexShaderBytes, this.materialColorFragmentShaderBytes, this.materialColorVertexShaderBytes);
    }

    public Set<Schema> getSupportedSchemas() {
        return Collections.singleton(Schema.IFC2X3TC1);
    }

    public Set<String> getRequiredGeometryFields() {
        HashSet<String> set = new HashSet<String>();
        set.add("indices");
        set.add("vertices");
        set.add("normals");
        set.add("colorsQuantized");
        return set;
    }

    public String getDefaultExtension() {
        return "glb";
    }

    public String getDefaultContentType() {
        return "model/gltf+binary";
    }

    public String getOutputFormat(Schema schema) {
        return SchemaName.GLTF_BIN_1_0.name();
    }
}

