/*
 * Decompiled with CFR 0.152.
 */
package org.mangosdk.spi.processor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mangosdk.spi.processor.Initializer;
import org.mangosdk.spi.processor.LogLocation;
import org.mangosdk.spi.processor.Logger;

final class ServiceFileInitializer
implements Initializer {
    private final Filer filer;
    private final String path;
    private final Logger logger;

    ServiceFileInitializer(Filer filer, String path, Logger logger) {
        this.filer = filer;
        this.path = path;
        this.logger = logger;
    }

    @Override
    public CharSequence initialData(String serviceName) {
        try {
            CharSequence result;
            FileObject resource = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.path + serviceName);
            try {
                result = this.tryWithReader(resource);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                this.logger.note(LogLocation.MESSAGER, "Eclipse gave an IOException: " + e.getMessage());
                return null;
            }
            catch (Exception other) {
                try {
                    result = resource.getCharContent(true);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
                catch (IOException e) {
                    this.logger.note(LogLocation.MESSAGER, "Javac gave an IOException: " + e.getMessage());
                    return null;
                }
            }
            return result;
        }
        catch (IOException e) {
            this.logger.note(LogLocation.MESSAGER, "getResource gave an IOException: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence tryWithReader(FileObject resource) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(resource.openReader(true));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            reader.close();
        }
        return sb;
    }
}

