/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.validation;

import au.com.bytecode.opencsv.CSVWriter;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.exceptions.DeveloperMadeABooBooException;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.RandomInstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.SetInstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.smac.ValidationOptions;
import ca.ubc.cs.beta.aeatk.smac.ValidationRoundingMode;
import ca.ubc.cs.beta.aeatk.state.StateSerializer;
import ca.ubc.cs.beta.aeatk.state.legacy.LegacyStateFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.WaitableTAECallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aeatk.trajectoryfile.TrajectoryFile;
import ca.ubc.cs.beta.aeatk.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.smac.validation.ValidationResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static Logger log = LoggerFactory.getLogger(Validator.class);

    public SortedMap<TrajectoryFileEntry, ValidationResult> simpleValidate(List<ProblemInstance> testInstances, ValidationOptions options, double cutoffTime, InstanceSeedGenerator testInstGen, TargetAlgorithmEvaluator validatingTae, String outputDir, RunObjective runObj, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, TrajectoryFile trajFile, boolean waitForRuns, int cores, AlgorithmExecutionConfiguration execConfig) {
        options.outputFileSuffix = options.useWallClockTime ? "walltime" + (options.outputFileSuffix.trim().length() > 0 ? "-" + options.outputFileSuffix : "") : "tunertime" + (options.outputFileSuffix.trim().length() > 0 ? "-" + options.outputFileSuffix : "");
        List<ProblemInstanceSeedPair> pisps = this.getProblemInstanceSeedPairsToRun(testInstances, options, testInstGen);
        ValidationRuns runs = this.validateStage(pisps, options, cutoffTime, runObj, intraInstanceObjective, interInstanceObjective, trajFile, execConfig, outputDir);
        if (runs.done) {
            return runs.result;
        }
        HashSet<ParameterConfiguration> configs = new HashSet<ParameterConfiguration>();
        for (AlgorithmRunConfiguration rc : runs.runConfigs) {
            configs.add(rc.getParameterConfiguration());
        }
        log.info("Validation needs {} algorithm runs to validate {} configurations found, each on {} problem instance seed pairs", new Object[]{runs.runConfigs.size(), configs.size(), pisps.size()});
        Date d = new Date(System.currentTimeMillis());
        DateFormat df = DateFormat.getDateTimeInstance();
        if (cutoffTime > Math.pow(10.0, 10.0)) {
            log.info("Validation start time: {}. Approximate worst-case end time is unknown.", (Object)df.format(d));
        } else {
            Date endTime = new Date(System.currentTimeMillis() + (long)(1.1 * (cutoffTime * (double)runs.runConfigs.size() * 1000.0 / (double)cores)));
            log.info("Validation start time: {}. Approximate worst-case end time: {}", (Object)df.format(d), (Object)df.format(endTime));
        }
        validatingTae.evaluateRunsAsync(runs.runConfigs, (TargetAlgorithmEvaluatorCallback)runs.callback);
        if (!validatingTae.areRunsPersisted() || waitForRuns) {
            log.debug("Waiting until validation completion");
            runs.callback.waitForCompletion();
        }
        if (runs.exception.get() != null) {
            throw (RuntimeException)runs.exception.get();
        }
        return runs.result;
    }

    public void multiValidate(List<ProblemInstance> testInstances, ValidationOptions options, double cutoffTime, InstanceSeedGenerator testInstGen, TargetAlgorithmEvaluator validatingTae, RunObjective runObj, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, Set<TrajectoryFile> tfes, boolean waitForRuns, int cores, AlgorithmExecutionConfiguration execConfig, String outputDir) {
        options.outputFileSuffix = options.useWallClockTime ? "walltime" + options.outputFileSuffix : "tunertime" + options.outputFileSuffix;
        List<ProblemInstanceSeedPair> pisps = this.getProblemInstanceSeedPairsToRun(testInstances, options, testInstGen);
        ArrayList<ValidationRuns> runs = new ArrayList<ValidationRuns>();
        if (tfes.size() > 1) {
            log.debug("Beginning multi-validation on {} files ", (Object)tfes.size());
        }
        for (TrajectoryFile tfe : tfes) {
            runs.add(this.validateStage(pisps, options, cutoffTime, runObj, intraInstanceObjective, interInstanceObjective, tfe, execConfig, outputDir));
        }
        LinkedHashSet<AlgorithmRunConfiguration> runConfigs = new LinkedHashSet<AlgorithmRunConfiguration>();
        HashSet<ParameterConfiguration> configs = new HashSet<ParameterConfiguration>();
        final LinkedHashMap<WaitableTAECallback, List<AlgorithmRunConfiguration>> callbacksToSchedule = new LinkedHashMap<WaitableTAECallback, List<AlgorithmRunConfiguration>>();
        for (ValidationRuns run : runs) {
            if (run.done) continue;
            for (AlgorithmRunConfiguration rc : run.runConfigs) {
                runConfigs.add(rc);
                configs.add(rc.getParameterConfiguration());
            }
            callbacksToSchedule.put(run.callback, run.runConfigs);
        }
        ArrayList runConfigsToRun = new ArrayList(runConfigs);
        log.info("Validation needs {} algorithm runs to validate {} configurations found, each on {} problem instance seed pairs", new Object[]{runConfigsToRun.size(), configs.size(), pisps.size()});
        Date d = new Date(System.currentTimeMillis());
        DateFormat df = DateFormat.getDateTimeInstance();
        if (cutoffTime > Math.pow(10.0, 10.0)) {
            log.info("Validation start time: {}. Approximate worst-case end time is unknown.", (Object)df.format(d));
        } else {
            Date endTime = new Date(System.currentTimeMillis() + (long)(1.1 * (cutoffTime * (double)runConfigsToRun.size() * 1000.0 / (double)cores)));
            log.info("Validation start time: {}. Approximate worst-case end time: {}", (Object)df.format(d), (Object)df.format(endTime));
        }
        final AtomicReference exception = new AtomicReference();
        WaitableTAECallback taeCallback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

            public void onSuccess(List<AlgorithmRunResult> runs) {
                HashMap<AlgorithmRunConfiguration, AlgorithmRunResult> runsToRunConfig = new HashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    runsToRunConfig.put(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult);
                }
                for (Map.Entry entry : callbacksToSchedule.entrySet()) {
                    ArrayList runsToNotify = new ArrayList();
                    for (AlgorithmRunConfiguration rc : (List)entry.getValue()) {
                        runsToNotify.add(runsToRunConfig.get(rc));
                    }
                    try {
                        ((WaitableTAECallback)entry.getKey()).onSuccess(runsToNotify);
                    }
                    catch (RuntimeException e) {
                        log.error("Error occurred while saving runs:", (Throwable)e);
                    }
                }
            }

            public void onFailure(RuntimeException e) {
                exception.set(e);
            }
        });
        validatingTae.evaluateRunsAsync(runConfigsToRun, (TargetAlgorithmEvaluatorCallback)taeCallback);
        if (!validatingTae.areRunsPersisted() || waitForRuns) {
            log.debug("Waiting until validation completion");
            taeCallback.waitForCompletion();
        }
        if (exception.get() != null) {
            throw (RuntimeException)exception.get();
        }
    }

    private ValidationRuns validateStage(final List<ProblemInstanceSeedPair> pisps, final ValidationOptions options, final double cutoffTime, final RunObjective runObj, final OverallObjective intraInstanceObjective, final OverallObjective interInstanceObjective, final TrajectoryFile trajFile, AlgorithmExecutionConfiguration execConfig, final String outputDir) {
        double maxWallTimeStamp = 0.0;
        double maxTunerTimeStamp = 0.0;
        final List tfes = trajFile.getTrajectoryFileEntries();
        for (TrajectoryFileEntry tfe : tfes) {
            maxWallTimeStamp = Math.max(tfe.getWallTime(), maxWallTimeStamp);
            maxTunerTimeStamp = Math.max(tfe.getTunerTime(), maxTunerTimeStamp);
        }
        if (options.validateOnlyIfWallTimeReached > maxWallTimeStamp) {
            log.info("Maximum walltime was {} but we required {} seconds to have passed validating ", (Object)maxWallTimeStamp, (Object)options.validateOnlyIfWallTimeReached);
            return new ValidationRuns(new TreeMap<TrajectoryFileEntry, ValidationResult>());
        }
        if (options.validateOnlyIfTunerTimeReached > maxTunerTimeStamp) {
            log.info("Maximum Tuner Time was {} but we required {} seconds to have passed before validating ", (Object)maxTunerTimeStamp, (Object)options.validateOnlyIfTunerTimeReached);
            return new ValidationRuns(new TreeMap<TrajectoryFileEntry, ValidationResult>());
        }
        TreeSet<TrajectoryFileEntry> tfesToUse = new TreeSet<TrajectoryFileEntry>();
        if (options.validateAll) {
            tfesToUse.addAll(tfes);
        } else if (options.validateOnlyLastIncumbent) {
            TrajectoryFileEntry newTfe;
            TrajectoryFileEntry tfe;
            log.trace("Validating only the last incumbent");
            if (options.useWallClockTime) {
                tfe = (TrajectoryFileEntry)tfes.get(tfes.size() - 1);
                double wallTime = tfe.getWallTime() > options.maxTimestamp ? options.maxTimestamp : tfe.getWallTime();
                newTfe = new TrajectoryFileEntry(tfe.getConfiguration(), tfe.getTunerTime(), wallTime, tfe.getEmpericalPerformance(), tfe.getACOverhead());
                tfesToUse.add(newTfe);
            } else {
                tfe = (TrajectoryFileEntry)tfes.get(tfes.size() - 1);
                double tunerTime = tfe.getTunerTime() > options.maxTimestamp ? options.maxTimestamp : tfe.getTunerTime();
                newTfe = new TrajectoryFileEntry(tfe.getConfiguration(), tunerTime, tfe.getWallTime(), tfe.getEmpericalPerformance(), tfe.getACOverhead());
                tfesToUse.add(newTfe);
            }
        } else {
            ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList = new ConcurrentSkipListMap<Double, TrajectoryFileEntry>();
            for (TrajectoryFileEntry tfe : tfes) {
                if (options.useWallClockTime) {
                    skipList.put(tfe.getWallTime(), tfe);
                    continue;
                }
                skipList.put(tfe.getTunerTime(), tfe);
            }
            double maxTimestamp = options.maxTimestamp;
            if (maxTimestamp == -1.0) {
                maxTimestamp = skipList.floorKey((Double)Double.MAX_VALUE);
            }
            ParameterConfiguration lastConfig = null;
            Object lastPerformance = Double.MAX_VALUE;
            for (double x = maxTimestamp; x > options.minTimestamp; x /= options.multFactor) {
                Map.Entry tfeEntry = skipList.floorEntry(x);
                TrajectoryFileEntry tfe = tfeEntry != null ? (TrajectoryFileEntry)tfeEntry.getValue() : new TrajectoryFileEntry(lastConfig, 0.0, 0.0, ((Double)lastPerformance).doubleValue(), 0.0);
                if (options.useWallClockTime) {
                    tfesToUse.add(new TrajectoryFileEntry(tfe.getConfiguration(), x, x, tfe.getEmpericalPerformance(), tfe.getACOverhead()));
                } else {
                    tfesToUse.add(new TrajectoryFileEntry(tfe.getConfiguration(), x, tfe.getWallTime(), tfe.getEmpericalPerformance(), tfe.getACOverhead()));
                }
                lastConfig = tfe.getConfiguration();
                lastPerformance = tfe.getEmpericalPerformance();
                if (x < 0.01) break;
            }
        }
        final ArrayList<TrajectoryFileEntry> tfesToRun = new ArrayList<TrajectoryFileEntry>(tfesToUse.size());
        tfesToRun.addAll(tfesToUse);
        LinkedHashSet<ParameterConfiguration> configs = new LinkedHashSet<ParameterConfiguration>();
        final LinkedHashMap<ParameterConfiguration, Integer> configToID = new LinkedHashMap<ParameterConfiguration, Integer>();
        int id = 1;
        for (TrajectoryFileEntry tfe : tfesToRun) {
            if (!configs.add(tfe.getConfiguration())) continue;
            configToID.put(tfe.getConfiguration(), id++);
        }
        List<AlgorithmRunConfiguration> runConfigs = this.getRunConfigs(configs, pisps, cutoffTime, execConfig);
        final AtomicReference<RuntimeException> exception = new AtomicReference<RuntimeException>();
        final ConcurrentSkipListMap<TrajectoryFileEntry, ValidationResult> finalPerformance = new ConcurrentSkipListMap<TrajectoryFileEntry, ValidationResult>();
        WaitableTAECallback callback = new WaitableTAECallback(new TargetAlgorithmEvaluatorCallback(){

            public void onSuccess(List<AlgorithmRunResult> runs) {
                try {
                    Validator.writeConfigurationMapFile(trajFile, options, configToID, runs, outputDir);
                }
                catch (IOException e) {
                    log.error("Could not write results file", (Throwable)e);
                }
                try {
                    Map testSetPerformance = Validator.writeInstanceResultFile(runs, options, cutoffTime, runObj, intraInstanceObjective, interInstanceObjective, trajFile, configToID, outputDir);
                    for (TrajectoryFileEntry tfe : tfesToRun) {
                        finalPerformance.put(tfe, new ValidationResult((Double)testSetPerformance.get(tfe.getConfiguration()), pisps));
                    }
                    if (runs.size() > 0) {
                        Validator.this.appendInstanceResultFile(finalPerformance, trajFile, options, options.useWallClockTime, configToID, outputDir);
                    }
                }
                catch (IOException e) {
                    log.error("Could not write results file:", (Throwable)e);
                }
                try {
                    ConcurrentHashMap matrixRuns = new ConcurrentHashMap();
                    for (AlgorithmRunResult run : runs) {
                        matrixRuns.putIfAbsent(run.getAlgorithmRunConfiguration().getParameterConfiguration(), new TreeMap());
                        Map configRuns = (Map)matrixRuns.get(run.getAlgorithmRunConfiguration().getParameterConfiguration());
                        configRuns.put(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair(), run);
                    }
                    ArrayList<ParameterConfiguration> configs = new ArrayList<ParameterConfiguration>();
                    for (AlgorithmRunResult run : runs) {
                        if (configs.contains(run.getAlgorithmRunConfiguration().getParameterConfiguration())) continue;
                        configs.add(run.getAlgorithmRunConfiguration().getParameterConfiguration());
                    }
                    Validator.writeConfigurationResultsMatrix(configs, matrixRuns, tfes, options, trajFile, runObj, configToID, outputDir);
                }
                catch (IOException e) {
                    log.error("Could not write matrix file:", (Throwable)e);
                }
                if (options.saveStateFile) {
                    try {
                        Validator.writeLegacyStateFile(options.outputFileSuffix, runs, trajFile, interInstanceObjective, interInstanceObjective, runObj, outputDir);
                    }
                    catch (RuntimeException e) {
                        log.error("Couldn't write state file:", (Throwable)e);
                    }
                }
            }

            public void onFailure(RuntimeException t) {
                exception.set(t);
            }
        });
        return new ValidationRuns(runConfigs, callback, exception, finalPerformance);
    }

    private List<ProblemInstanceSeedPair> getProblemInstanceSeedPairsToRun(List<ProblemInstance> testInstances, ValidationOptions options, InstanceSeedGenerator testInstGen) {
        int testInstancesCount = Math.min(options.numberOfTestInstances, testInstances.size());
        int testSeedsPerInstance = options.numberOfTestSeedsPerInstance;
        int validationRunsCount = options.numberOfValidationRuns;
        ValidationRoundingMode mode = options.validationRoundingMode;
        List<Object> pisps = new ArrayList();
        if (testInstGen instanceof SetInstanceSeedGenerator) {
            if (validationRunsCount > testInstGen.getInitialInstanceSeedCount()) {
                log.debug("Clamping number of validation runs from {} to {} due to seed limit", (Object)validationRunsCount, (Object)testInstGen.getInitialInstanceSeedCount());
                validationRunsCount = testInstGen.getInitialInstanceSeedCount();
            }
            pisps = Validator.getValidationRuns(testInstances, (SetInstanceSeedGenerator)testInstGen, mode, validationRunsCount);
        } else if (testInstGen instanceof RandomInstanceSeedGenerator) {
            pisps = Validator.getValidationRuns(testInstances, (RandomInstanceSeedGenerator)testInstGen, mode, validationRunsCount, testSeedsPerInstance, testInstancesCount);
        } else {
            throw new IllegalStateException("Unknown Instance Seed Generator specified");
        }
        return Collections.unmodifiableList(pisps);
    }

    private List<AlgorithmRunConfiguration> getRunConfigs(Set<ParameterConfiguration> configs, List<ProblemInstanceSeedPair> pisps, double cutoffTime, AlgorithmExecutionConfiguration execConfig) {
        ArrayList<AlgorithmRunConfiguration> runConfigs = new ArrayList<AlgorithmRunConfiguration>(pisps.size() * configs.size());
        for (ParameterConfiguration config : configs) {
            for (ProblemInstanceSeedPair pisp : pisps) {
                runConfigs.add(new AlgorithmRunConfiguration(pisp, cutoffTime, config, execConfig));
            }
        }
        return runConfigs;
    }

    private static List<ProblemInstanceSeedPair> getValidationRuns(List<ProblemInstance> pis, RandomInstanceSeedGenerator testInstGen, ValidationRoundingMode mode, int validationRunsCount, int testSeedsPerInstance, int testInstancesCount) {
        int numRuns = 0;
        switch (mode) {
            case UP: {
                numRuns = Math.round((float)(Math.ceil((float)validationRunsCount / (float)testInstancesCount) * (double)testInstancesCount));
                break;
            }
            case NONE: {
                numRuns = Math.min(validationRunsCount, testSeedsPerInstance * testInstancesCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Rounding Mode");
            }
        }
        List pisToUse = testInstGen.getProblemInstanceOrder(pis);
        int runsScheduled = 0;
        ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>(numRuns);
        block4: while (true) {
            int i = 0;
            while (true) {
                if (i >= testInstancesCount) continue block4;
                ProblemInstance pi = (ProblemInstance)pisToUse.get(i);
                pisps.add(new ProblemInstanceSeedPair(pi, (long)testInstGen.getNextSeed(pi)));
                if (++runsScheduled >= numRuns) break block4;
                ++i;
            }
            break;
        }
        return pisps;
    }

    private static List<ProblemInstanceSeedPair> getValidationRuns(List<ProblemInstance> pis, SetInstanceSeedGenerator testInstGen, ValidationRoundingMode mode, int validationRunsCount) {
        List instances = testInstGen.getProblemInstanceOrder(pis);
        int numRuns = 0;
        switch (mode) {
            case UP: {
                numRuns = Math.round((float)(Math.ceil((float)validationRunsCount / (float)instances.size()) * (double)instances.size()));
                break;
            }
            case NONE: {
                numRuns = Math.min(instances.size(), validationRunsCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode: " + mode);
            }
        }
        ArrayList<ProblemInstanceSeedPair> runs = new ArrayList<ProblemInstanceSeedPair>(numRuns);
        for (int i = 0; i < numRuns; ++i) {
            ProblemInstance pi = (ProblemInstance)instances.get(i);
            runs.add(new ProblemInstanceSeedPair(pi, (long)testInstGen.getNextSeed(pi)));
        }
        return runs;
    }

    private static void writeConfigurationMapFile(TrajectoryFile trajFile, ValidationOptions validationOptions, Map<ParameterConfiguration, Integer> configToID, List<AlgorithmRunResult> runs, String outputDir) throws IOException {
        File f = Validator.getFile(trajFile, "validationCallStrings", validationOptions.outputFileSuffix, "csv", outputDir);
        log.info("Validation Call Strings written to: {}", (Object)f.getAbsolutePath());
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(f));
        if (validationOptions.validationHeaders) {
            String[] args = new String[]{"Validation Configuration ID", "Configuration ", "Sample Call String"};
            writer.writeNext(args);
        }
        for (Map.Entry<ParameterConfiguration, Integer> ent : configToID.entrySet()) {
            AlgorithmRunConfiguration rc = null;
            for (AlgorithmRunResult run : runs) {
                if (!run.getAlgorithmRunConfiguration().getParameterConfiguration().equals((Object)ent.getKey())) continue;
                rc = run.getAlgorithmRunConfiguration();
                break;
            }
            String[] args = new String[]{String.valueOf(ent.getValue()), ent.getKey().getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString((AlgorithmRunConfiguration)rc)};
            writer.writeNext(args);
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfigurationResultsMatrix(List<ParameterConfiguration> inOrderConfigs, ConcurrentHashMap<ParameterConfiguration, Map<ProblemInstanceSeedPair, AlgorithmRunResult>> matrixRuns, List<TrajectoryFileEntry> tfes, ValidationOptions validationOptions, TrajectoryFile trajFile, RunObjective runObj, Map<ParameterConfiguration, Integer> idMap, String outputDir) throws IOException {
        File configurationObjective = Validator.getFile(trajFile, "validationObjectiveMatrix", validationOptions.outputFileSuffix, "csv", outputDir);
        File configurationRun = Validator.getFile(trajFile, "validationRunResultLineMatrix", validationOptions.outputFileSuffix, "csv", outputDir);
        log.info("Validation matrix of objectives for cross-product of configurations and (instance,seed) pairs written to: {}", (Object)configurationObjective.getAbsolutePath());
        log.info("Validation matrix of complete run result line for cross-product of configurations and (instance,seed) pairs written to: {}", (Object)configurationRun.getAbsolutePath());
        CSVWriter objectiveMatrixCSV = new CSVWriter((Writer)new FileWriter(configurationObjective));
        CSVWriter runMatrixCSV = new CSVWriter((Writer)new FileWriter(configurationRun));
        try {
            TreeMap transposedMap = new TreeMap();
            for (Map<ProblemInstanceSeedPair, AlgorithmRunResult> ent : matrixRuns.values()) {
                for (AlgorithmRunResult run : ent.values()) {
                    if (transposedMap.get(run.getProblemInstanceSeedPair()) == null) {
                        transposedMap.put(run.getProblemInstanceSeedPair(), new ConcurrentHashMap());
                    }
                    ((Map)transposedMap.get(run.getProblemInstanceSeedPair())).put(run.getParameterConfiguration(), run);
                }
            }
            ArrayList<String> runMatrixHeaderRow = new ArrayList<String>();
            ArrayList<String> objectiveMatrixHeaderRow = new ArrayList<String>();
            runMatrixHeaderRow.add("Problem Instance");
            runMatrixHeaderRow.add("Seed");
            objectiveMatrixHeaderRow.add("Problem Instance");
            objectiveMatrixHeaderRow.add("Seed");
            for (ParameterConfiguration config : inOrderConfigs) {
                runMatrixHeaderRow.add("Run result line of validation config #" + String.valueOf(idMap.get(config)));
                objectiveMatrixHeaderRow.add("Objective of validation config #" + String.valueOf(idMap.get(config)));
            }
            String[] header = objectiveMatrixHeaderRow.toArray(new String[0]);
            objectiveMatrixCSV.writeNext(header);
            header = runMatrixHeaderRow.toArray(new String[0]);
            runMatrixCSV.writeNext(header);
            for (Map.Entry ent : transposedMap.entrySet()) {
                ArrayList<String> objectiveRow = new ArrayList<String>();
                ArrayList<String> resultLineRow = new ArrayList<String>();
                objectiveRow.add(((ProblemInstanceSeedPair)ent.getKey()).getProblemInstance().getInstanceName());
                resultLineRow.add(((ProblemInstanceSeedPair)ent.getKey()).getProblemInstance().getInstanceName());
                objectiveRow.add(String.valueOf(((ProblemInstanceSeedPair)ent.getKey()).getSeed()));
                resultLineRow.add(String.valueOf(((ProblemInstanceSeedPair)ent.getKey()).getSeed()));
                for (ParameterConfiguration config : inOrderConfigs) {
                    AlgorithmRunResult run = (AlgorithmRunResult)((Map)ent.getValue()).get(config);
                    if (run == null) {
                        throw new IllegalStateException("Expected all configurations to have the exact same pisps");
                    }
                    if (!run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().equals(ent.getKey())) {
                        throw new IllegalStateException("DataStructure corruption detected ");
                    }
                    objectiveRow.add(String.valueOf(runObj.getObjective(run)));
                    resultLineRow.add(run.getResultLine());
                }
                String[] nextRow = objectiveRow.toArray(new String[0]);
                String[] nextRunRow = resultLineRow.toArray(new String[0]);
                objectiveMatrixCSV.writeNext(nextRow);
                runMatrixCSV.writeNext(nextRunRow);
            }
        }
        finally {
            objectiveMatrixCSV.close();
            runMatrixCSV.close();
        }
    }

    private static Map<ParameterConfiguration, Double> writeInstanceResultFile(List<AlgorithmRunResult> runs, ValidationOptions validationOptions, double cutoffTime, RunObjective runObj, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, TrajectoryFile trajFile, Map<ParameterConfiguration, Integer> configIDToMap, String outputDir) throws IOException {
        File f = Validator.getFile(trajFile, "validationPerformanceDebug", validationOptions.outputFileSuffix, "csv", outputDir);
        log.info("Instance performance (for debug) written to: {}", (Object)f.getAbsolutePath());
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(f));
        LinkedHashMap<ParameterConfiguration, Double> calculatedOverallObjectives = new LinkedHashMap<ParameterConfiguration, Double>();
        LinkedHashMap configToRunMap = new LinkedHashMap();
        for (AlgorithmRunResult algorithmRunResult : runs) {
            ParameterConfiguration config = algorithmRunResult.getAlgorithmRunConfiguration().getParameterConfiguration();
            if (configToRunMap.get(config) == null) {
                configToRunMap.put(config, new ArrayList(1000));
            }
            ((List)configToRunMap.get(config)).add(algorithmRunResult);
        }
        for (Map.Entry entry : configToRunMap.entrySet()) {
            LinkedHashMap map = new LinkedHashMap();
            runs = (List)entry.getValue();
            int maxRunLength = 0;
            for (AlgorithmRunResult run : runs) {
                ProblemInstance pi = run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance();
                if (map.get(pi) == null) {
                    map.put(pi, new ArrayList());
                }
                List list = (List)map.get(pi);
                list.add(run);
                maxRunLength = Math.max(list.size(), maxRunLength);
            }
            ArrayList<String> headerRow = new ArrayList<String>();
            headerRow.add("Validation Configuration ID:" + configIDToMap.get(entry.getKey()));
            headerRow.add("Instance");
            headerRow.add("OverallObjective");
            for (int i = 1; i <= maxRunLength; ++i) {
                headerRow.add("Run #" + i);
            }
            writer.writeNext(headerRow.toArray(new String[0]));
            ArrayList<Double> overallObjectives = new ArrayList<Double>();
            for (Map.Entry entry2 : map.entrySet()) {
                ArrayList<String> outputLine = new ArrayList<String>();
                outputLine.add("");
                outputLine.add(((ProblemInstance)entry2.getKey()).getInstanceName());
                List myRuns = (List)entry2.getValue();
                ArrayList<Double> results = new ArrayList<Double>(myRuns.size());
                for (int i = 0; i < myRuns.size(); ++i) {
                    results.add(runObj.getObjective((AlgorithmRunResult)myRuns.get(i)));
                }
                double overallResult = intraInstanceObjective.aggregate(results, cutoffTime);
                outputLine.add(String.valueOf(overallResult));
                overallObjectives.add(overallResult);
                for (AlgorithmRunResult run : (List)entry2.getValue()) {
                    outputLine.add(String.valueOf(runObj.getObjective(run)));
                }
                writer.writeNext(outputLine.toArray(new String[0]));
            }
            double overallObjective = interInstanceObjective.aggregate(overallObjectives, cutoffTime);
            String[] args = new String[]{"", "Overall Objective On Test Set", String.valueOf(overallObjective)};
            writer.writeNext(args);
            calculatedOverallObjectives.put((ParameterConfiguration)entry.getKey(), overallObjective);
        }
        writer.close();
        return calculatedOverallObjectives;
    }

    private static File getFile(TrajectoryFile trajFile, String filename, String suffix, String extension, String outputDir) {
        suffix = suffix.trim().equals("") ? "" : "-" + suffix.trim();
        String trajectoryFileName = trajFile.getLocation().getName();
        String baseName = trajectoryFileName.lastIndexOf(".") >= 0 ? trajectoryFileName.substring(0, trajectoryFileName.lastIndexOf(".")) : trajectoryFileName;
        if (outputDir != null) {
            return new File(outputDir + File.separator + filename + "-" + baseName + suffix + "." + extension.replaceAll(Matcher.quoteReplacement("\\."), ""));
        }
        if (trajFile.getLocation().getParent() != null) {
            return new File(trajFile.getLocation().getParent() + File.separator + filename + "-" + baseName + suffix + "." + extension.replaceAll(Matcher.quoteReplacement("\\."), ""));
        }
        return new File(filename + "-" + baseName + suffix + "." + extension.replaceAll(Matcher.quoteReplacement("\\."), ""));
    }

    private void appendInstanceResultFile(Map<TrajectoryFileEntry, ValidationResult> finalPerformance, TrajectoryFile trajFile, ValidationOptions validationOptions, boolean useWallTime, Map<ParameterConfiguration, Integer> idMap, String outputDir) throws IOException {
        File validationFile = Validator.getFile(trajFile, "validationResults", validationOptions.outputFileSuffix, "csv", outputDir);
        log.info("Main validation results file written to: {}", (Object)validationFile.getAbsolutePath());
        if (!validationFile.exists()) {
            validationFile.createNewFile();
        } else {
            validationFile.delete();
            validationFile.createNewFile();
        }
        StringBuilder sbValidation = new StringBuilder("\"Time\",\"Training (Empirical) Performance\",\"Test Set Performance\",\"AC Overhead Time\",\"Validation Configuration ID\",\n");
        for (Map.Entry<TrajectoryFileEntry, ValidationResult> ent : finalPerformance.entrySet()) {
            double time = useWallTime ? ent.getKey().getWallTime() : ent.getKey().getTunerTime();
            double empiricalPerformance = ent.getKey().getEmpericalPerformance();
            double testSetPerformance = ent.getValue().getPerformance();
            double acOverhead = ent.getKey().getACOverhead();
            sbValidation.append(time).append(",").append(empiricalPerformance).append(",").append(testSetPerformance).append(",").append(acOverhead).append(",\"").append(idMap.get(ent.getKey().getConfiguration())).append("\",\n");
        }
        if (!validationFile.canWrite()) {
            log.error("Could not write trajectory file would have written: {}", (Object)sbValidation.toString());
        } else {
            PrintWriter output = new PrintWriter(new FileOutputStream(validationFile, true));
            output.append(sbValidation);
            output.close();
        }
    }

    private static void writeLegacyStateFile(String suffix, List<AlgorithmRunResult> runs, TrajectoryFile trajFile, OverallObjective interRunObjective, OverallObjective intraRunObjective, RunObjective runObj, String outputDir) {
        NewRunHistory rh = new NewRunHistory(interRunObjective, intraRunObjective, runObj);
        for (AlgorithmRunResult run : runs) {
            try {
                rh.append(run);
            }
            catch (DuplicateRunException e) {
                throw new DeveloperMadeABooBooException("Duplicate run was detected by runHistory, this shouldn't be possible in validation");
            }
        }
        LegacyStateFactory sf = outputDir != null ? new LegacyStateFactory(outputDir + File.separator + "state" + suffix + "-run-" + trajFile.getLocation().getName(), null) : new LegacyStateFactory(trajFile.getLocation().getParent() + File.separator + "state" + suffix + "-run-" + trajFile.getLocation().getName(), null);
        StateSerializer ss = sf.getStateSerializer("it", 1);
        ss.setRunHistory((RunHistory)rh);
        ss.save();
    }

    public static class ValidationRuns {
        List<AlgorithmRunConfiguration> runConfigs;
        WaitableTAECallback callback;
        private SortedMap<TrajectoryFileEntry, ValidationResult> result;
        private AtomicReference<RuntimeException> exception;
        public boolean done;

        public ValidationRuns(SortedMap<TrajectoryFileEntry, ValidationResult> result) {
            this.result = result;
            this.runConfigs = Collections.emptyList();
            this.done = true;
        }

        public ValidationRuns(List<AlgorithmRunConfiguration> runConfigs, WaitableTAECallback callback, AtomicReference<RuntimeException> exception, SortedMap<TrajectoryFileEntry, ValidationResult> result) {
            this.runConfigs = runConfigs;
            this.callback = callback;
            this.exception = exception;
            this.result = result;
            this.done = false;
        }
    }
}

