/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.integration;

import net.sf.doodleproject.numerics4j.IterativeMethod;
import net.sf.doodleproject.numerics4j.exception.ConvergenceException;
import net.sf.doodleproject.numerics4j.exception.NumericException;
import net.sf.doodleproject.numerics4j.function.Function;

public class AdaptiveIntegrator
extends IterativeMethod {
    private Function function;

    public AdaptiveIntegrator(Function f) {
        this(f, 100, 1.0E-10);
    }

    public AdaptiveIntegrator(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public Function getFunction() {
        return this.function;
    }

    private double integrate(double a, double b, double fa, double fb, double fc, double h, double error, double s, int level) throws NumericException {
        double ret = s;
        if (level < this.getMaximumIterations()) {
            double fe;
            double s2;
            double fd = this.function.evaluate(a + h / 2.0);
            double s1 = h * (fa + 4.0 * fd + fc) / 6.0;
            double sn = s1 + (s2 = h * (fc + 4.0 * (fe = this.function.evaluate(a + 3.0 * h / 2.0)) + fb) / 6.0);
            if (Math.abs(sn / s - 1.0) <= error) {
                ret = sn;
            } else {
                double hn = h / 2.0;
                double e = error / 2.0;
                double pivot = a + h;
                int n = level + 1;
                ret = this.integrate(a, pivot, fa, fc, fd, hn, e, s1, n) + this.integrate(pivot, b, fc, fb, fe, hn, e, s2, n);
            }
        } else {
            throw new ConvergenceException("Adaptive quadrature failed to converge.");
        }
        return ret;
    }

    public double integrate(double a, double b) throws NumericException {
        double ret;
        if (Double.isNaN(a) || Double.isNaN(b)) {
            ret = Double.NaN;
        } else {
            double h = (b - a) / 2.0;
            double fa = this.function.evaluate(a);
            double fm = this.function.evaluate(a + h);
            double fb = this.function.evaluate(b);
            double s = h * (fa + 4.0 * fm + fb) / 3.0;
            ret = this.integrate(a, b, fa, fb, fm, h, this.getMaximumRelativeError(), s, 1);
        }
        return ret;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }
}

