/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.sf.doodleproject.numerics4j.random.RNG;
import net.sf.doodleproject.numerics4j.random.RandomRNG;

public class UniformRandomVariable
extends AbstractContinuousRandomVariable {
    private double lower = -1.7976931348623157E308;
    private double range;
    private double upper = Double.MAX_VALUE;

    public UniformRandomVariable() {
        this(0.0, 1.0);
    }

    public UniformRandomVariable(double a, double b) {
        this(a, b, new RandomRNG());
    }

    public UniformRandomVariable(double a, double b, RNG rng) {
        super(rng);
        if (!(a <= b)) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        this.setLower(a);
        this.setUpper(b);
    }

    public static double nextRandomVariable(double a, double b, RNG source) {
        return source.nextRandomNumber() * (b - a) + a;
    }

    private double getLower() {
        return this.lower;
    }

    private double getRange() {
        return this.range;
    }

    private double getUpper() {
        return this.upper;
    }

    public double nextRandomVariable() {
        return this.nextRandomNumber() * this.getRange() + this.getLower();
    }

    private void setLower(double low) {
        this.lower = low;
        this.setRange(this.getUpper() - low);
    }

    private void setRange(double value) {
        this.range = value;
    }

    private void setUpper(double up) {
        this.upper = up;
        this.setRange(up - this.getLower());
    }
}

