/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.statistics.distribution;

import net.sf.doodleproject.numerics4j.exception.NumericException;
import net.sf.doodleproject.numerics4j.special.Beta;
import net.sf.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class FDistribution
extends ContinuousDistribution {
    private double denominatorDegreesOfFreedom;
    private double numeratorDegreesOfFreedom;

    public FDistribution() {
        this(1.0, 1.0);
    }

    public FDistribution(double dfn, double dfd) {
        this.setNumeratorDegreesOfFreedom(dfn);
        this.setDenominatorDegreesOfFreedom(dfd);
    }

    public double cumulativeProbability(double x) throws NumericException {
        double ret;
        if (Double.isNaN(x)) {
            ret = Double.NaN;
        } else if (x <= 0.0) {
            ret = 0.0;
        } else if (Double.isInfinite(x)) {
            ret = 1.0;
        } else {
            double n = this.getNumeratorDegreesOfFreedom();
            double m = this.getDenominatorDegreesOfFreedom();
            ret = Beta.regularizedBeta(n * x / (m + n * x), 0.5 * n, 0.5 * m);
        }
        return ret;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double inverseCumulativeProbability(double p) throws NumericException {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? 0.0 : (p == 1.0 ? Double.POSITIVE_INFINITY : this.findInverseCumulativeProbability(p, 0.0, 10.0, Double.POSITIVE_INFINITY)));
        return ret;
    }

    public void setDenominatorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0 || Double.isNaN(degreesOfFreedom)) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.denominatorDegreesOfFreedom = degreesOfFreedom;
    }

    public void setNumeratorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0 || Double.isNaN(degreesOfFreedom)) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.numeratorDegreesOfFreedom = degreesOfFreedom;
    }
}

