/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Conditional;
import autoweka.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassParams {
    private static final Pattern targetClassPattern = Pattern.compile("(.*)\\.params");
    private String mTargetClass;
    private HashMap<String, Parameter> mParameterMap = new HashMap();
    private ArrayList<Parameter> mParameters = new ArrayList();
    private ArrayList<Conditional> mConditionals = new ArrayList();

    public ClassParams(String fileName) {
        File f = new File(fileName);
        Matcher m = targetClassPattern.matcher(f.getName());
        if (!m.matches()) {
            throw new RuntimeException("Failed to get target class name from '" + fileName + "' (Sould be (name).params");
        }
        this.mTargetClass = m.group(1);
        if (this.mTargetClass.isEmpty()) {
            throw new RuntimeException("Failed to extract targetclass from " + fileName);
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            boolean parsingParams = true;
            while ((line = in.readLine()) != null) {
                int hashIndex = line.indexOf(35);
                if (hashIndex != -1) {
                    line = line.substring(0, hashIndex);
                }
                if ((line = line.trim()).isEmpty()) continue;
                if (line.contains("Conditionals")) {
                    parsingParams = false;
                    continue;
                }
                if (parsingParams) {
                    Parameter param = new Parameter(line);
                    this.mParameters.add(param);
                    this.mParameterMap.put(param.name, param);
                    continue;
                }
                this.mConditionals.add(new Conditional(line, this.mParameterMap));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> filterParams(Map<String, String> inputMap) {
        HashMap<String, String> argMap = new HashMap<String, String>(inputMap);
        boolean updateMade = true;
        while (updateMade) {
            updateMade = false;
            for (Conditional cond : this.mConditionals) {
                if (argMap.get(cond.parameter.name) == null) continue;
                String parentVal = (String)argMap.get(cond.parent.name);
                if (parentVal == null) {
                    argMap.remove(cond.parameter.name);
                    updateMade = true;
                    continue;
                }
                if (cond.domain.contains(parentVal)) continue;
                argMap.remove(cond.parameter.name);
                updateMade = true;
            }
        }
        return argMap;
    }

    public String getTargetClass() {
        return this.mTargetClass;
    }

    public ArrayList<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.mParameters);
    }

    public ArrayList<Conditional> getConditionals() {
        return new ArrayList<Conditional>(this.mConditionals);
    }

    public HashMap<String, Parameter> getParameterMap() {
        return new HashMap<String, Parameter>(this.mParameterMap);
    }
}

