/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Experiment;
import autoweka.ExperimentBatch;
import autoweka.ListExperiment;
import autoweka.XmlSerializable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="listExperimentBatch")
@XmlAccessorType(value=XmlAccessType.NONE)
class ListExperimentBatch
extends XmlSerializable {
    static final Logger log = LoggerFactory.getLogger(ListExperimentBatch.class);
    @XmlElement(name="datasetComponent")
    List<ExperimentBatch.DatasetComponent> mInstances;
    @XmlElement(name="listExperimentComponent")
    List<ListExperimentComponent> mExperiments;

    ListExperimentBatch() {
    }

    public static ListExperimentBatch fromXML(String filename) {
        return XmlSerializable.fromXML(filename, ListExperimentBatch.class);
    }

    public static ListExperimentBatch fromXML(InputStream xml) {
        return XmlSerializable.fromXML(xml, ListExperimentBatch.class);
    }

    public static ListExperiment createListExperiment(ListExperimentComponent expComp, ExperimentBatch.DatasetComponent datasetComp) {
        ListExperiment exp = new ListExperiment();
        exp.name = expComp.name + "-" + datasetComp.name;
        exp.resultMetric = expComp.resultMetric;
        exp.instanceGenerator = expComp.instanceGenerator;
        exp.instanceGeneratorArgs = expComp.instanceGeneratorArgs;
        exp.datasetString = datasetComp.getDatasetString();
        exp.trainTimeout = expComp.trainTimeout;
        exp.memory = expComp.memory;
        exp.extraPropsString = expComp.extraProps;
        exp.trajectoryPointExtras = expComp.trajectoryPointExtras;
        return exp;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            log.error("Useage: {} <xmlfilename>", (Object)ExperimentBatch.class.getCanonicalName());
            log.error("Makes a template experiment batch file");
            System.exit(1);
        }
        ListExperimentBatch batch = new ListExperimentBatch();
        ExperimentBatch.DatasetComponent instance = new ExperimentBatch.DatasetComponent();
        instance.name = "";
        batch.mInstances = Collections.singletonList(instance);
        ListExperimentComponent experiment = new ListExperimentComponent();
        experiment.name = "";
        experiment.instanceGenerator = "";
        experiment.instanceGeneratorArgs = "(Optional)";
        experiment.trainTimeout = -1.0f;
        experiment.memory = "";
        experiment.extraProps = "(Optional)";
        experiment.constructorArgs = Collections.singletonList("(Optional List)");
        batch.mExperiments = Collections.singletonList(experiment);
        batch.toXML(args[0]);
    }

    @XmlRootElement(name="experiment")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ListExperimentComponent {
        @XmlElement(name="name")
        public String name;
        @XmlElement(name="resultMetric")
        public String resultMetric;
        @XmlElement(name="experimentConstructor")
        public String constructor;
        @XmlElement(name="experimentConstructorArgs")
        public List<String> constructorArgs = new ArrayList<String>();
        @XmlElement(name="instanceGenerator")
        public String instanceGenerator;
        @XmlElement(name="instanceGeneratorArgs")
        public String instanceGeneratorArgs;
        @XmlElement(name="trainTimeout")
        public float trainTimeout = -1.0f;
        @XmlElement(name="memory")
        public String memory;
        @XmlElement(name="extraProps")
        public String extraProps;
        @XmlElement(name="trajectoryPointExtras")
        public List<Experiment.TrajectoryPointExtra> trajectoryPointExtras = new ArrayList<Experiment.TrajectoryPointExtra>();
        @XmlElement(name="seed")
        public String seed = "0";
    }
}

