/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.ClassifierResult;
import autoweka.Experiment;
import autoweka.ListExperiment;
import autoweka.Util;
import autoweka.Wrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.SerializationHelper;

public class SubProcessWrapper
extends Wrapper {
    static final Logger log = LoggerFactory.getLogger(SubProcessWrapper.class);
    private static Pattern mResultPattern = Pattern.compile("SubProcessWrapper: Time\\(([\\.\\d]+)\\) Score\\(([\\.\\deE+-]+)\\)");

    public static void main(String[] args) {
        SubProcessWrapper wrapper = new SubProcessWrapper();
        try {
            wrapper.run(args);
        }
        catch (Exception e) {
            System.exit(1);
        }
        System.exit(0);
    }

    @Override
    protected void _processParameter(String arg, Queue<String> args) {
        if (arg.equals("-seed")) {
            args.poll();
        } else if (arg.equals("-timeout")) {
            this.mTimeout = Float.parseFloat(args.poll());
        }
    }

    @Override
    protected void _processWrapperParameterStart(Queue<String> args) {
        this.mInstance = args.poll();
    }

    @Override
    protected void _processResults(ClassifierResult res) {
        System.out.print("SubProcessWrapper: Time(" + res.getTime() + ") Score(" + res.getScore() + ")");
        String outputFilePrefix = this.mProperties.getProperty("modelOutputFilePrefix", null);
        if (outputFilePrefix != null) {
            try {
                if (res.getAttributeSelection() != null) {
                    SerializationHelper.write((String)(outputFilePrefix + ".attributeselection"), (Object)res.getAttributeSelection());
                } else {
                    File oldFile = new File(outputFilePrefix + ".attributeselection");
                    if (oldFile.exists()) {
                        oldFile.delete();
                    }
                }
                SerializationHelper.write((String)(outputFilePrefix + ".model"), (Object)res.getClassifier());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ErrorAndTime getErrorAndTime(File runDir, ListExperiment exp, String instance, String args, String autowekaSeed) {
        return SubProcessWrapper.getErrorAndTime(runDir, exp, instance, args, autowekaSeed, new Properties());
    }

    public static ErrorAndTime getErrorAndTime(File runDir, ListExperiment exp, String instance, String args, String autowekaSeed, Properties props) {
        props = new Properties(props);
        props.put("datasetString", exp.datasetString);
        props.put("instanceGenerator", exp.instanceGenerator);
        props.put("instanceGeneratorArgs", exp.instanceGeneratorArgs);
        props.put("resultMetric", exp.resultMetric);
        return SubProcessWrapper.getErrorAndTime(runDir, exp.memory, props, exp.trainTimeout, instance, args, autowekaSeed);
    }

    public static ErrorAndTime getErrorAndTime(File runDir, Experiment exp, String instance, String args, String autowekaSeed) {
        return SubProcessWrapper.getErrorAndTime(runDir, exp, instance, args, autowekaSeed, new Properties());
    }

    public static ErrorAndTime getErrorAndTime(File runDir, Experiment exp, String instance, String args, String autowekaSeed, Properties props) {
        props = new Properties(props);
        props.put("datasetString", exp.datasetString);
        props.put("instanceGenerator", exp.instanceGenerator);
        props.put("instanceGeneratorArgs", exp.instanceGeneratorArgs);
        props.put("resultMetric", exp.resultMetric);
        return SubProcessWrapper.getErrorAndTime(runDir, exp.memory, props, exp.trainTimeout, instance, args, autowekaSeed);
    }

    public static ErrorAndTime getErrorAndTime(File runDir, String memory, Properties props, float trainTimeout, String instance, String args, String autowekaSeed) {
        try {
            String line;
            ArrayList<String> wrapperCmd = new ArrayList<String>();
            wrapperCmd.add(Util.getJavaExecutable());
            wrapperCmd.add("-Xmx" + memory);
            wrapperCmd.add("-cp");
            wrapperCmd.add(Util.getAbsoluteClasspath());
            wrapperCmd.add("autoweka.SubProcessWrapper");
            wrapperCmd.add("-prop");
            wrapperCmd.add(Util.propertiesToString(props));
            wrapperCmd.add("-timeout");
            wrapperCmd.add(Float.toString(trainTimeout));
            wrapperCmd.add("-wrapper");
            wrapperCmd.add(instance);
            wrapperCmd.addAll(Arrays.asList(args.split(" ")));
            for (String c : wrapperCmd) {
                log.debug("{}", (Object)c);
            }
            ProcessBuilder pb = new ProcessBuilder(wrapperCmd);
            pb.environment().put("AUTOWEKA_EXPERIMENT_SEED", autowekaSeed);
            if (runDir != null) {
                pb.directory(runDir);
            }
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            Util.ProcessKillerShutdownHook killerHook = new Util.ProcessKillerShutdownHook(proc);
            Runtime.getRuntime().addShutdownHook(killerHook);
            Object prevLine = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            float error = 0.0f;
            float time = 0.0f;
            boolean foundMatch = false;
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                if (line.matches(".*DEBUG.*")) {
                    log.debug(line);
                } else if (line.matches(".*WARN.*")) {
                    log.warn(line);
                } else if (line.matches(".*ERROR.*")) {
                    log.error(line);
                } else {
                    log.info(line);
                }
                if (!(matcher = mResultPattern.matcher(line)).matches()) continue;
                time = Float.parseFloat(matcher.group(1));
                error = Float.parseFloat(matcher.group(2));
                foundMatch = true;
            }
            proc.waitFor();
            if (!foundMatch) {
                throw new RuntimeException("Failed to find output line from subprocess wrapper");
            }
            Runtime.getRuntime().removeShutdownHook(killerHook);
            return new ErrorAndTime(error, time);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke child process", e);
        }
    }

    public static class ErrorAndTime {
        public float error;
        public float time;

        public ErrorAndTime(float _error, float _time) {
            this.error = _error;
            this.time = _time;
        }
    }
}

