/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="trajectory")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Trajectory {
    @XmlElement(name="point")
    private List<Point> mPoints = new ArrayList<Point>();
    @XmlElement(name="seed")
    private String mSeed = "0";
    @XmlElement(name="numEvaluatedEvaluations")
    private int mNumEvaluations = -1;
    @XmlElement(name="numMemOutEvaluations")
    private int mNumMemOutEvaluations = -1;
    @XmlElement(name="numTimeOutEvaluations")
    private int mNumTimeOutEvaluations = -1;

    private Trajectory() {
    }

    public Trajectory(String seed) {
        this.mPoints = new ArrayList<Point>();
        this.mSeed = seed;
    }

    public String getSeed() {
        return this.mSeed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Point p : this.mPoints) {
            sb.append(p);
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<Point> getPoints() {
        return new ArrayList<Point>(this.mPoints);
    }

    public void addPoint(Point newPoint) {
        for (Point p : this.mPoints) {
            if (!(p.getTime() > newPoint.getTime())) continue;
            throw new RuntimeException("Tried to add a point that occured earlier in time");
        }
        this.mPoints.add(newPoint);
    }

    public Point getPointAtTime(double time) {
        for (int i = 0; i < this.mPoints.size() - 1; ++i) {
            if (!(this.mPoints.get(i + 1).getTime() > time)) continue;
            return this.mPoints.get(i);
        }
        return this.mPoints.get(this.mPoints.size() - 1);
    }

    public Point getNextPoint(double time) {
        for (int i = 0; i < this.mPoints.size() - 1; ++i) {
            if (!(this.mPoints.get(i + 1).getTime() > time)) continue;
            return this.mPoints.get(i + 1);
        }
        return null;
    }

    public Point getLastPoint() {
        if (this.mPoints.isEmpty()) {
            return null;
        }
        return this.mPoints.get(this.mPoints.size() - 1);
    }

    public void truncateToTime(float maxTime) {
        int i = 0;
        while (i < this.mPoints.size()) {
            if (this.mPoints.get(i).getTime() > (double)maxTime) {
                this.mPoints.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void setEvaluationCounts(int numTotalEvaluations, int numMemOutEvaluations, int numTimeOutEvaluations) {
        this.mNumEvaluations = numTotalEvaluations;
        this.mNumMemOutEvaluations = numMemOutEvaluations;
        this.mNumTimeOutEvaluations = numTimeOutEvaluations;
    }

    public int getNumEvaluations() {
        return this.mNumEvaluations;
    }

    public int getNumMemOutEvaluations() {
        return this.mNumMemOutEvaluations;
    }

    public int getNumTimedOutEvaluations() {
        return this.mNumTimeOutEvaluations;
    }

    @XmlRootElement(name="point")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Point {
        @XmlElement(name="time")
        public double mTime;
        @XmlElement(name="errorEstimate")
        public double mErrorEstimate;
        @XmlElement(name="args")
        public String mArgs;
        @XmlElement(name="specificInstanceInfo")
        public ArrayList<SpecificInstanceInfo> specificInstanceInfo = new ArrayList();

        private Point() {
        }

        public Point(double time, double errorEstimate, String args) {
            this.mTime = time;
            this.mErrorEstimate = errorEstimate;
            this.mArgs = args;
        }

        public double getTime() {
            return this.mTime;
        }

        public double getErrorEstimate() {
            return this.mErrorEstimate;
        }

        public String getArgs() {
            return this.mArgs;
        }

        public String toString() {
            return "time: " + this.mTime + ", error estimate: " + this.mErrorEstimate + ", args: " + this.mArgs;
        }

        @XmlRootElement(name="specific")
        @XmlAccessorType(value=XmlAccessType.NONE)
        public static class SpecificInstanceInfo {
            @XmlElement(name="name")
            public String name;
            @XmlElement(name="instance")
            public String instance;
            @XmlElement(name="error")
            public double error;
            @XmlElement(name="time")
            public double time;

            public SpecificInstanceInfo() {
            }

            public SpecificInstanceInfo(String _name, String _instance, double _error, double _time) {
                this.name = _name;
                this.instance = _instance;
                this.error = _error;
                this.time = _time;
            }
        }
    }
}

