/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Experiment;
import autoweka.Trajectory;
import autoweka.TrajectoryGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrajectoryParser {
    static final Logger log = LoggerFactory.getLogger(TrajectoryParser.class);

    public abstract Trajectory parseTrajectory(Experiment var1, File var2, String var3);

    public static void main(String[] args) {
        String targetSeed = null;
        ArrayList<String> experimentFolders = new ArrayList<String>();
        if (args[0].equals("-batch")) {
            for (String arg : args) {
                experimentFolders.add(arg);
            }
        } else {
            if (args[0].equals("-single")) {
                ArrayList<String> a = new ArrayList<String>(Arrays.asList(args));
                a.remove(0);
                args = a.toArray(new String[0]);
            }
            if (args.length != 2) {
                throw new IllegalArgumentException("Single mode requires an experiment folder and a seed");
            }
            experimentFolders.add(args[0]);
            targetSeed = args[1];
        }
        for (String experimentPath : experimentFolders) {
            File folder = new File(experimentPath);
            Experiment experiment = Experiment.fromXML(experimentPath + File.separator + folder.getName() + ".experiment");
            TrajectoryGroup group = new TrajectoryGroup(experiment);
            log.debug("Experiment {}", (Object)experimentPath);
            if (targetSeed == null) {
                File[] logs;
                for (File f : logs = new File(experimentPath + File.separator + "out" + File.separator + "logs" + File.separator).listFiles()) {
                    String logName = f.getName();
                    String seed = logName.substring(0, logName.lastIndexOf(46));
                    log.debug("Seed {}", (Object)seed);
                    try {
                        group.addTrajectory(TrajectoryParser.getTrajectory(experiment, folder, seed));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
                group.toXML(experimentPath + File.separator + folder.getName() + ".trajectories");
                continue;
            }
            log.debug("Seed {}", (Object)targetSeed);
            group.addTrajectory(TrajectoryParser.getTrajectory(experiment, folder, targetSeed));
            group.toXML(experimentPath + File.separator + folder.getName() + ".trajectories." + targetSeed);
        }
    }

    public static Trajectory getTrajectory(Experiment experiment, File folder, String seed) {
        TrajectoryParser parser;
        try {
            Class<?> cls = Class.forName(experiment.trajectoryParserClassName);
            parser = (TrajectoryParser)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class '" + experiment.trajectoryParserClassName + "': " + e, e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException("Failed to instantiate '" + experiment.trajectoryParserClassName + "': " + e, e);
        }
        return parser.parseTrajectory(experiment, folder, seed);
    }
}

