/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSerializable {
    static final Logger log = LoggerFactory.getLogger(XmlSerializable.class);
    private static Map<Class<?>, Class<?>> msParserMap = new HashMap();

    public void toXML(String filename) {
        try {
            this.toXML(new PrintStream(new File(filename)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void toXML(OutputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)this, stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Error marshalling XML response", e);
        }
    }

    protected static <T extends XmlSerializable> T fromXML(String filename, Class<T> c) {
        try {
            return XmlSerializable.fromXML(new FileInputStream(new File(filename)), c);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException("Failed to load from XML file");
        }
    }

    public static <T extends XmlSerializable> T fromXML(InputStream xml, Class<T> c) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller um = context.createUnmarshaller();
            return (T)((XmlSerializable)um.unmarshal(xml));
        }
        catch (Exception e) {
            throw new RuntimeException("Error unmarshalling XML response", e);
        }
    }

    public static int populateObjectFromCMDParams(Object obj, String[] args) {
        LinkedList<String> list = new LinkedList<String>(Arrays.asList(args));
        XmlSerializable.populateObjectFromCMDParams(obj, list);
        return list.size();
    }

    public static void populateObjectFromCMDParams(Object obj, Deque<String> args) {
        try {
            XmlRootElement rootAnnotation = obj.getClass().getAnnotation(XmlRootElement.class);
            if (rootAnnotation == null) {
                throw new IllegalStateException("Class " + obj.getClass().getName() + "does not have an XmlRootElement annotation");
            }
            HashMap<String, ParamParser> parserMap = new HashMap<String, ParamParser>();
            for (Field f : Arrays.asList(obj.getClass().getFields())) {
                XmlElement element = f.getAnnotation(XmlElement.class);
                if (element == null) continue;
                Class<?> parserClass = msParserMap.get(f.getType());
                if (parserClass == null) {
                    log.debug("{}", (Object)f.getType());
                    continue;
                }
                ParamParser parser = (ParamParser)parserClass.getDeclaredConstructor(Field.class).newInstance(f);
                parserMap.put(element.name(), parser);
            }
            while (!args.isEmpty()) {
                String arg = args.poll();
                if (!arg.startsWith("-") && !arg.startsWith("--")) continue;
                ParamParser parserForField = (ParamParser)parserMap.get(arg = arg.replaceFirst("-", "").replaceFirst("-", ""));
                if (parserForField == null) {
                    args.addFirst("--" + arg);
                    return;
                }
                parserForField.setParameter(obj, args);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        msParserMap.put(Short.TYPE, IntParser.class);
        msParserMap.put(Integer.TYPE, IntParser.class);
        msParserMap.put(Long.TYPE, IntParser.class);
        msParserMap.put(Boolean.TYPE, BooleanParser.class);
        msParserMap.put(Float.TYPE, FloatParser.class);
        msParserMap.put(Double.TYPE, FloatParser.class);
        msParserMap.put(String.class, StringParser.class);
        msParserMap.put(ArrayList.class, ListParser.class);
        msParserMap.put(List.class, ListParser.class);
    }

    private static class ListParser
    extends ParamParser {
        public ListParser(Field field) {
            super(field);
        }

        @Override
        void setParameter(Object obj, Deque<String> args) throws IllegalAccessException {
            block5: {
                try {
                    Class parserClass;
                    Class innerType = (Class)((ParameterizedType)this.mField.getGenericType()).getActualTypeArguments()[0];
                    ArrayList<Object> list = (ArrayList<Object>)this.mField.get(obj);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        this.mField.set(obj, list);
                    }
                    if ((parserClass = (Class)msParserMap.get(innerType)) != null) {
                        class TempClass {
                            public Object var;

                            TempClass() {
                            }
                        }
                        TempClass t = new TempClass();
                        ParamParser parser = (ParamParser)parserClass.getDeclaredConstructor(Field.class).newInstance(t.getClass().getField("var"));
                        parser.setParameter(t, args);
                        list.add(t.var);
                        break block5;
                    }
                    if (innerType.getAnnotation(XmlRootElement.class) != null) {
                        Object o = innerType.newInstance();
                        XmlSerializable.populateObjectFromCMDParams(o, args);
                        list.add(o);
                        break block5;
                    }
                    throw new RuntimeException("Can't parse an inner class of type " + innerType.getName());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class StringParser
    extends ParamParser {
        public StringParser(Field field) {
            super(field);
        }

        @Override
        void setParameter(Object obj, Deque<String> args) throws IllegalAccessException {
            this.mField.set(obj, args.poll());
        }
    }

    private static class FloatParser
    extends ParamParser {
        public FloatParser(Field field) {
            super(field);
        }

        @Override
        void setParameter(Object obj, Deque<String> args) throws IllegalAccessException {
            this.mField.set(obj, Float.valueOf(Float.parseFloat(args.poll())));
        }
    }

    private static class BooleanParser
    extends ParamParser {
        public BooleanParser(Field field) {
            super(field);
        }

        @Override
        void setParameter(Object obj, Deque<String> args) throws IllegalAccessException {
            this.mField.set(obj, Boolean.parseBoolean(args.poll()));
        }
    }

    private static class IntParser
    extends ParamParser {
        public IntParser(Field field) {
            super(field);
        }

        @Override
        void setParameter(Object obj, Deque<String> args) throws IllegalAccessException {
            this.mField.set(obj, Integer.parseInt(args.poll()));
        }
    }

    private static abstract class ParamParser {
        protected Field mField;

        public ParamParser(Field field) {
            this.mField = field;
        }

        abstract void setParameter(Object var1, Deque<String> var2) throws IllegalAccessException;
    }
}

