/*
 * Decompiled with CFR 0.152.
 */
package autoweka.instancegenerators;

import autoweka.InstanceGenerator;
import autoweka.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import weka.core.Instances;

public class CrossValidation
extends InstanceGenerator {
    public CrossValidation(InstanceGenerator generator) {
        super(generator);
    }

    public CrossValidation(String instanceFileName) {
        super(instanceFileName);
    }

    public CrossValidation(Instances training, Instances testing) {
        super(training, testing);
    }

    @Override
    public Instances _getTrainingFromParams(String paramString) {
        return this.getInstances(true, Util.parsePropertyString(paramString));
    }

    @Override
    public Instances _getTestingFromParams(String paramString) {
        return this.getInstances(false, Util.parsePropertyString(paramString));
    }

    protected Instances getInstances(boolean trainingFold, Properties params) {
        int seed = Integer.parseInt(params.getProperty("seed", "0"));
        int numFolds = Integer.parseInt(params.getProperty("numFolds", "-1"));
        int currentFold = Integer.parseInt(params.getProperty("fold", "-1"));
        if (numFolds <= 1) {
            throw new RuntimeException("numFolds must be set to something > 1");
        }
        if (currentFold < 0 || numFolds <= currentFold) {
            throw new RuntimeException("fold must be set to something in [0," + (numFolds - 1) + "]");
        }
        Random rand = new Random(seed);
        Instances randData = this.getTraining();
        randData.randomize(rand);
        if (trainingFold) {
            return randData.trainCV(numFolds, currentFold);
        }
        return randData.testCV(numFolds, currentFold);
    }

    @Override
    public List<String> getAllInstanceStrings(String paramStr) {
        int numFolds;
        int seed;
        Properties params = Util.parsePropertyString(paramStr);
        try {
            seed = Integer.parseInt(params.getProperty("seed", "0"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse seed", e);
        }
        try {
            numFolds = Integer.parseInt(params.getProperty("numFolds", "-1"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse numFolds", e);
        }
        if (numFolds <= 1) {
            throw new RuntimeException("numFolds must be set to something > 1");
        }
        ArrayList<String> instanceStrings = new ArrayList<String>(numFolds);
        for (int i = 0; i < numFolds; ++i) {
            instanceStrings.add("seed=" + seed + ":numFolds=" + numFolds + ":fold=" + i);
        }
        return instanceStrings;
    }
}

