/*
 * Decompiled with CFR 0.152.
 */
package autoweka.instancegenerators;

import autoweka.InstanceGenerator;
import autoweka.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.supervised.instance.Resample;

public class RandomSubSampling
extends InstanceGenerator {
    static final Logger log = LoggerFactory.getLogger(RandomSubSampling.class);

    public RandomSubSampling(InstanceGenerator generator) {
        super(generator);
    }

    public RandomSubSampling(Instances training, Instances testing) {
        super(training, testing);
    }

    public RandomSubSampling(String instanceFileName) {
        super(instanceFileName);
    }

    @Override
    public Instances _getTrainingFromParams(String params) {
        Resample filter = this.newFilter();
        filter.setInvertSelection(false);
        this.setFilterParams(filter, params);
        return this.getInstances(this.getTraining(), filter);
    }

    @Override
    public Instances _getTestingFromParams(String params) {
        Resample filter = this.newFilter();
        filter.setInvertSelection(true);
        this.setFilterParams(filter, params);
        return this.getInstances(this.getTraining(), filter);
    }

    protected final Resample newFilter() {
        Resample filter = new Resample();
        try {
            filter.setInputFormat(this.getTraining());
        }
        catch (Exception e) {
            filter = new RegressionResample();
        }
        return filter;
    }

    protected Instances getInstances(Instances data, Resample filter) {
        try {
            filter.setInputFormat(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set input format", e);
        }
        Instances newData = filter.getOutputFormat();
        try {
            newData = Filter.useFilter((Instances)data, (Filter)filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newData;
    }

    private void setFilterParams(Resample filter, String paramStr) {
        Properties params = Util.parsePropertyString(paramStr);
        filter.setNoReplacement(true);
        filter.setRandomSeed(Integer.parseInt(params.getProperty("seed", "0")));
        filter.setSampleSizePercent(Double.parseDouble(params.getProperty("percent", "70")));
        filter.setBiasToUniformClass(Double.parseDouble(params.getProperty("base", "0")));
    }

    @Override
    public List<String> getAllInstanceStrings(String paramStr) {
        double bias;
        double percent;
        int numSamples;
        int seed;
        Properties params = Util.parsePropertyString(paramStr);
        try {
            seed = Integer.parseInt(params.getProperty("startingSeed", "0"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse startingSeed", e);
        }
        try {
            numSamples = Integer.parseInt(params.getProperty("numSamples", "-1"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse numSamples", e);
        }
        try {
            percent = Integer.parseInt(params.getProperty("percent", "-1"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse percent", e);
        }
        try {
            bias = Double.parseDouble(params.getProperty("bias", "0"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse bias", e);
        }
        if (numSamples <= 0) {
            throw new RuntimeException("numSamples must be set to something > 0");
        }
        if (percent <= 0.0 || percent >= 100.0) {
            throw new RuntimeException("percent must be set to something > 0 && < 100");
        }
        if (bias < 0.0 || bias > 1.0) {
            throw new RuntimeException("bias must be set to something > 0 && < 1");
        }
        ArrayList<String> instanceStrings = new ArrayList<String>(numSamples);
        for (int i = 0; i < numSamples; ++i) {
            instanceStrings.add("seed=" + (seed + i) + ":percent=" + percent + ":bias=" + bias);
        }
        return instanceStrings;
    }

    private static class RegressionResample
    extends Resample {
        private RegressionResample() {
        }

        public Capabilities getCapabilities() {
            Capabilities result = super.getCapabilities();
            result.disableAll();
            result.enableAllAttributes();
            result.enable(Capabilities.Capability.MISSING_VALUES);
            result.enable(Capabilities.Capability.NUMERIC_CLASS);
            return result;
        }

        public void createSubsampleWithReplacement(Random random, int origSize, int sampleSize, int ignored, int[] classIndices) {
            throw new RuntimeException("This should not happen....");
        }

        public void createSubsampleWithoutReplacement(Random random, int origSize, int sampleSize, int ignored, int[] classIndices) {
            int i;
            if (sampleSize > origSize) {
                sampleSize = origSize;
                log.warn("Resampling without replacement can only use percentage <=100% - Using full dataset!");
            }
            int[] indices = new int[origSize];
            for (i = 0; i < origSize; ++i) {
                indices[i] = i;
            }
            for (i = 0; i < origSize; ++i) {
                int targetIndex = random.nextInt(origSize - i) + i;
                int temp = indices[i];
                indices[i] = indices[targetIndex];
                indices[targetIndex] = temp;
            }
            if (this.getInvertSelection()) {
                for (i = sampleSize; i < origSize; ++i) {
                    this.push((Instance)this.getInputFormat().instance(indices[i]).copy());
                }
            } else {
                for (i = 0; i < sampleSize; ++i) {
                    this.push((Instance)this.getInputFormat().instance(indices[i]).copy());
                }
            }
            indices = null;
        }

        protected void createSubsample() {
            int origSize = this.getInputFormat().numInstances();
            int sampleSize = (int)((double)origSize * this.m_SampleSizePercent / 100.0);
            Random random = new Random(this.m_RandomSeed);
            if (this.getNoReplacement()) {
                this.createSubsampleWithoutReplacement(random, origSize, sampleSize, 0, null);
            } else {
                this.createSubsampleWithReplacement(random, origSize, sampleSize, 0, null);
            }
        }
    }
}

