/*
 * Decompiled with CFR 0.152.
 */
package autoweka.tools;

import autoweka.ClassifierRunner;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.AttributeSelection;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;
import weka.core.SerializationHelper;
import weka.core.converters.ConverterUtils;

public class TrainedModelPredictionMaker {
    static final Logger log = LoggerFactory.getLogger(TrainedModelPredictionMaker.class);
    public Evaluation eval;

    public static void main(String[] argsArray) {
        String attributeSelectionObjPath = null;
        String modelObjPath = null;
        String instancesPath = null;
        String classIndex = "last";
        String predictionPath = "null";
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argsArray));
        while (!args.isEmpty()) {
            String arg = args.poll();
            if (arg.equals("-attributeselection")) {
                attributeSelectionObjPath = args.poll();
                continue;
            }
            if (arg.equals("-model")) {
                modelObjPath = args.poll();
                continue;
            }
            if (arg.equals("-dataset")) {
                instancesPath = args.poll();
                continue;
            }
            if (args.equals("-classindex")) {
                classIndex = args.poll();
                continue;
            }
            if (arg.equals("-predictionpath")) {
                predictionPath = args.poll();
                continue;
            }
            throw new RuntimeException("Unknown argument '" + arg + "'");
        }
        if (modelObjPath == null) {
            throw new RuntimeException("No trained model file provided");
        }
        if (instancesPath == null) {
            throw new RuntimeException("No dataset arff provided");
        }
        TrainedModelPredictionMaker tmpm = new TrainedModelPredictionMaker(attributeSelectionObjPath, modelObjPath, instancesPath, classIndex, predictionPath);
        log.info(tmpm.eval.toSummaryString("\nResults\n======\n", false));
    }

    public TrainedModelPredictionMaker(String attributeSelectionObjPath, String modelObjPath, String instancesPath, String classIndex, String predictionPath) {
        try {
            ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource((InputStream)new FileInputStream(instancesPath));
            Instances instances = dataSource.getDataSet();
            if (instances.classIndex() == -1) {
                if (classIndex.equals("last")) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                } else {
                    instances.setClassIndex(Integer.parseInt(classIndex));
                }
            }
            if (attributeSelectionObjPath != null) {
                AttributeSelection as = (AttributeSelection)SerializationHelper.read((String)attributeSelectionObjPath);
                instances = as.reduceDimensionality(instances);
            }
            AbstractClassifier classifier = (AbstractClassifier)SerializationHelper.read((String)modelObjPath);
            this.eval = new Evaluation(instances);
            ClassifierRunner.EvaluatorThread thrd = new ClassifierRunner.EvaluatorThread(this.eval, classifier, instances, predictionPath);
            thrd.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

