/*
 * Decompiled with CFR 0.152.
 */
package socket;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import socket.io.WrappedInputStream;
import socket.io.WrappedOutputStream;

public class KeepSocketOpen {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("usage: java socket.KeepSocketOpen file(s)");
            System.exit(1);
        }
        Server server = new Server(6789, stringArray);
        Client client = new Client("localhost", 6789);
        new Thread(server).start();
        new Thread(client).start();
    }

    public static final class Client
    extends HandlerBase
    implements Runnable {
        private Socket fServerSocket;
        private WrappedInputStream fWrappedInputStream;
        private boolean fVerbose;
        private byte[] fBuffer;
        private SAXParser fParser;
        private int fElementCount;
        private int fAttributeCount;
        private int fIgnorableWhitespaceCount;
        private int fCharactersCount;
        private long fTimeBefore;

        public Client(String string, int n) throws IOException {
            this(string, n, false);
            this.fParser = new SAXParser();
            this.fParser.setDocumentHandler(this);
            this.fParser.setErrorHandler(this);
        }

        public Client(String string, int n, boolean bl) throws IOException {
            System.out.println("Client: Created.");
            this.fServerSocket = new Socket(string, n);
            this.fVerbose = bl;
            this.fBuffer = new byte[1024];
        }

        public void run() {
            System.out.println("Client: Running.");
            try {
                InputStream inputStream = this.fServerSocket.getInputStream();
                while (!Thread.interrupted()) {
                    if (this.fVerbose) {
                        System.out.println("Client: Wrapping input stream.");
                    }
                    this.fWrappedInputStream = new WrappedInputStream(inputStream);
                    InputStreamReporter inputStreamReporter = new InputStreamReporter(this.fWrappedInputStream);
                    if (this.fVerbose) {
                        System.out.println("Client: Parsing XML document.");
                    }
                    InputSource inputSource = new InputSource(inputStreamReporter);
                    this.fParser.parse(inputSource);
                    this.fWrappedInputStream = null;
                    if (this.fVerbose) {
                        System.out.println("Client: Closing input stream.");
                    }
                    ((InputStream)inputStreamReporter).close();
                }
                if (this.fVerbose) {
                    System.out.println("Client: Closing socket.");
                }
                this.fServerSocket.close();
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                System.out.println("Client ERROR: " + exception.getMessage());
            }
            System.out.println("Client: Exiting.");
        }

        public void startDocument() {
            this.fElementCount = 0;
            this.fAttributeCount = 0;
            this.fIgnorableWhitespaceCount = 0;
            this.fCharactersCount = 0;
            this.fTimeBefore = System.currentTimeMillis();
        }

        public void startElement(String string, AttributeList attributeList) {
            ++this.fElementCount;
            this.fAttributeCount += attributeList != null ? attributeList.getLength() : 0;
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            this.fIgnorableWhitespaceCount += n2;
        }

        public void characters(char[] cArray, int n, int n2) {
            this.fCharactersCount += n2;
        }

        public void endDocument() {
            long l = System.currentTimeMillis();
            System.out.print("Client: ");
            System.out.print(l - this.fTimeBefore);
            System.out.print(" ms (");
            System.out.print(this.fElementCount);
            System.out.print(" elems, ");
            System.out.print(this.fAttributeCount);
            System.out.print(" attrs, ");
            System.out.print(this.fIgnorableWhitespaceCount);
            System.out.print(" spaces, ");
            System.out.print(this.fCharactersCount);
            System.out.print(" chars)");
            System.out.println();
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.out.println("Client: [warning] " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            System.out.println("Client: [error] " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.out.println("Client: [fatal error] " + sAXParseException.getMessage());
            try {
                this.fWrappedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw sAXParseException;
        }

        class InputStreamReporter
        extends FilterInputStream {
            private long fTotal;

            public InputStreamReporter(InputStream inputStream) {
                super(inputStream);
            }

            public int read() throws IOException {
                int n = this.in.read();
                if (n == -1) {
                    System.out.println("Client: Read " + this.fTotal + " byte(s) total.");
                    return -1;
                }
                ++this.fTotal;
                return n;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.in.read(byArray, n, n2);
                if (n3 == -1) {
                    System.out.println("Client: Read " + this.fTotal + " byte(s) total.");
                    return -1;
                }
                this.fTotal += (long)n3;
                if (Client.this.fVerbose) {
                    System.out.println("Client: Actually read " + n3 + " byte(s).");
                }
                return n3;
            }
        }
    }

    public static final class Server
    extends ServerSocket
    implements Runnable {
        private String[] fFilenames;
        private boolean fVerbose;
        private byte[] fBuffer;

        public Server(int n, String[] stringArray) throws IOException {
            this(n, stringArray, false);
        }

        public Server(int n, String[] stringArray, boolean bl) throws IOException {
            super(n);
            System.out.println("Server: Created.");
            this.fFilenames = stringArray;
            this.fVerbose = bl;
            this.fBuffer = new byte[16384];
        }

        public void run() {
            System.out.println("Server: Running.");
            Random random = new Random(System.currentTimeMillis());
            try {
                if (this.fVerbose) {
                    System.out.println("Server: Waiting for Client connection...");
                }
                Socket socket = this.accept();
                OutputStream outputStream = socket.getOutputStream();
                System.out.println("Server: Client connected.");
                int n = 0;
                while (n < this.fFilenames.length) {
                    String string = this.fFilenames[n];
                    System.out.println("Server: Opening file \"" + string + '\"');
                    FileInputStream fileInputStream = new FileInputStream(string);
                    if (this.fVerbose) {
                        System.out.println("Server: Wrapping output stream.");
                    }
                    WrappedOutputStream wrappedOutputStream = new WrappedOutputStream(outputStream);
                    int n2 = 0;
                    while (true) {
                        int n3;
                        int n4 = this.fBuffer.length;
                        if (this.fVerbose) {
                            System.out.println("Server: Attempting to read " + n4 + " byte(s).");
                        }
                        if ((n3 = fileInputStream.read(this.fBuffer, 0, n4)) == -1) {
                            if (!this.fVerbose) break;
                            System.out.println("Server: EOF.");
                            break;
                        }
                        if (this.fVerbose) {
                            System.out.println("Server: Writing " + n3 + " byte(s) to wrapped output stream.");
                        }
                        wrappedOutputStream.write(this.fBuffer, 0, n3);
                        n2 += n3;
                    }
                    System.out.println("Server: Wrote " + n2 + " byte(s) total.");
                    if (this.fVerbose) {
                        System.out.println("Server: Closing output stream.");
                    }
                    wrappedOutputStream.close();
                    if (this.fVerbose) {
                        System.out.println("Server: Closing file.");
                    }
                    fileInputStream.close();
                    ++n;
                }
                if (this.fVerbose) {
                    System.out.println("Server: Closing socket.");
                }
                socket.close();
            }
            catch (IOException iOException) {
                System.out.println("Server ERROR: " + iOException.getMessage());
            }
            System.out.println("Server: Exiting.");
        }
    }
}

