/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import autoweka.ClassifierResult;
import autoweka.Configuration;
import autoweka.ConfigurationCollection;
import autoweka.ConfigurationRanker;
import autoweka.Experiment;
import autoweka.ExperimentConstructor;
import autoweka.Trajectory;
import autoweka.TrajectoryGroup;
import autoweka.TrajectoryMerger;
import autoweka.Util;
import autoweka.tools.GetBestFromTrajectoryGroup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.Utils;
import weka.core.converters.ArffSaver;

public class AutoWEKAClassifier
extends AbstractClassifier
implements AdditionalMeasureProducer {
    static final long serialVersionUID = 2907034203562786373L;
    final Logger log = LoggerFactory.getLogger(AutoWEKAClassifier.class);
    static final int DEFAULT_TIME_LIMIT = 15;
    static final int DEFAULT_MEM_LIMIT = 1024;
    static final int DEFAULT_N_BEST = 1;
    static final Resampling DEFAULT_RESAMPLING = Resampling.CrossValidation;
    static final Metric[] metricsToMax = new Metric[]{Metric.areaUnderROC, Metric.correct, Metric.correlationCoefficient, Metric.fMeasure, Metric.kappa, Metric.kBInformation, Metric.kBMeanInformation, Metric.kBRelativeInformation, Metric.pctCorrect, Metric.precision, Metric.weightedAreaUnderROC, Metric.weightedFMeasure, Metric.weightedPrecision, Metric.weightedRecall, Metric.weightedTrueNegativeRate, Metric.weightedTruePositiveRate};
    static final Metric DEFAULT_METRIC = Metric.errorRate;
    static final Map<Resampling, String> resamplingArgsMap = new HashMap<Resampling, String>();
    static final String DEFAULT_RESAMPLING_ARGS;
    static final String DEFAULT_EXTRA_ARGS = "initialIncumbent=DEFAULT:acq-func=EI";
    public static final String configurationRankingPath;
    public static final String configurationHashSetPath;
    public static final String configurationInfoDirPath;
    protected Classifier classifier = null;
    protected AttributeSelection as;
    protected String classifierClass = null;
    protected String[] classifierArgs = null;
    protected String attributeSearchClass = null;
    protected String[] attributeSearchArgs;
    protected String attributeEvalClass = null;
    protected String[] attributeEvalArgs;
    protected String[] msExperimentPaths;
    protected static String expName;
    protected int seed = 123;
    protected int timeLimit = 15;
    protected int memLimit = 1024;
    protected int nBestConfigs = 1;
    protected ConfigurationCollection bestConfigsCollection;
    protected Resampling resampling = DEFAULT_RESAMPLING;
    protected String resamplingArgs = DEFAULT_RESAMPLING_ARGS;
    protected String extraArgs = "initialIncumbent=DEFAULT:acq-func=EI";
    protected Metric metric = DEFAULT_METRIC;
    protected double[] estimatedMetricValues;
    protected double estimatedMetricValue = -1.0;
    protected Evaluation eval;
    protected final int DEFAULT_PARALLEL_RUNS = 1;
    protected int parallelRuns = 1;
    protected double finalTrainTime = -1.0;
    private transient weka.gui.Logger wLog = null;
    public int totalTried = 0;

    public static void main(String[] argv) {
        AutoWEKAClassifier.runClassifier((Classifier)new AutoWEKAClassifier(), (String[])argv);
    }

    public AutoWEKAClassifier() {
        this.attributeSearchArgs = new String[0];
        this.attributeEvalArgs = new String[0];
        Properties props = System.getProperties();
        props.setProperty("org.xml.sax.parser", "com.sun.org.apache.xerces.internal.parsers.SAXParser");
        props.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        props.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }

    public void buildClassifier(Instances is) throws Exception {
        GetBestFromTrajectoryGroup mBest;
        block22: {
            int i;
            int i2;
            this.getCapabilities().testWithFail(is);
            this.estimatedMetricValues = new double[this.parallelRuns];
            this.msExperimentPaths = new String[this.parallelRuns];
            for (int i3 = 0; i3 < this.parallelRuns; ++i3) {
                this.estimatedMetricValues[i3] = -1.0;
                this.msExperimentPaths[i3] = Files.createTempDirectory("autoweka", new FileAttribute[0]).toString() + File.separator;
                Experiment exp = new Experiment();
                exp.name = expName;
                exp.resultMetric = this.metric.toString();
                Properties props = Util.parsePropertyString("type=trainTestArff:testArff=__dummy__");
                ArffSaver saver = new ArffSaver();
                saver.setInstances(is);
                File fp = new File(this.msExperimentPaths[i3] + expName + File.separator + expName + ".arff");
                saver.setFile(fp);
                saver.writeBatch();
                props.setProperty("trainArff", URLDecoder.decode(fp.getAbsolutePath()));
                props.setProperty("classIndex", String.valueOf(is.classIndex()));
                exp.datasetString = Util.propertiesToString(props);
                exp.instanceGenerator = "autoweka.instancegenerators." + String.valueOf((Object)this.resampling);
                exp.instanceGeneratorArgs = "seed=" + (this.seed + 1) + ":" + this.resamplingArgs + ":seed=" + (this.seed + i3);
                exp.attributeSelection = true;
                exp.attributeSelectionTimeout = this.timeLimit * 1;
                exp.tunerTimeout = this.timeLimit * 50;
                exp.trainTimeout = this.timeLimit * 5;
                exp.memory = this.memLimit + "m";
                exp.extraPropsString = this.extraArgs;
                LinkedList args = new LinkedList();
                args.add("-experimentpath");
                args.add(this.msExperimentPaths[i3]);
                ExperimentConstructor.buildSingle("autoweka.smac.SMACExperimentConstructor", exp, args);
                if (this.nBestConfigs <= 1) continue;
                String temporaryDirPath = this.msExperimentPaths[i3] + expName + File.separator;
                Util.makePath(temporaryDirPath + configurationInfoDirPath);
                Util.initializeFile(temporaryDirPath + configurationRankingPath);
                Util.initializeFile(temporaryDirPath + configurationHashSetPath);
            }
            final String javaExecutable = Util.getJavaExecutable();
            if (!new File(javaExecutable).isFile() && !new File(javaExecutable + ".exe").isFile()) {
                throw new Exception("Java executable could not be found. Please refer to \"Known Issues\" in the Auto-WEKA manual.");
            }
            Thread[] workers = new Thread[this.parallelRuns];
            for (i2 = 0; i2 < this.parallelRuns; ++i2) {
                final int index = i2;
                workers[i2] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Process mProc = null;
                        try {
                            String line;
                            ProcessBuilder pb = new ProcessBuilder(javaExecutable, "-Xmx128m", "-cp", Util.getAbsoluteClasspath(), "autoweka.tools.ExperimentRunner", AutoWEKAClassifier.this.msExperimentPaths[index] + expName, "" + (AutoWEKAClassifier.this.seed + index));
                            pb.redirectErrorStream(true);
                            mProc = pb.start();
                            Util.ProcessKillerShutdownHook killerHook = new Util.ProcessKillerShutdownHook(mProc);
                            Runtime.getRuntime().addShutdownHook(killerHook);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(mProc.getInputStream()));
                            Pattern p = Pattern.compile(".*Estimated mean quality of final incumbent config .* on test set: (-?[0-9.]+).*");
                            Pattern pint = Pattern.compile(".*mean quality of.*: (-?[0-9E.]+);.*");
                            int tried = 0;
                            double bestMetricValue = -1.0;
                            while ((line = reader.readLine()) != null) {
                                Matcher m = p.matcher(line);
                                if (m.matches()) {
                                    AutoWEKAClassifier.this.estimatedMetricValues[index] = Double.parseDouble(m.group(1));
                                    if (Arrays.asList(metricsToMax).contains((Object)AutoWEKAClassifier.this.metric)) {
                                        int n = index;
                                        AutoWEKAClassifier.this.estimatedMetricValues[n] = AutoWEKAClassifier.this.estimatedMetricValues[n] * -1.0;
                                    }
                                }
                                if ((m = pint.matcher(line)).matches()) {
                                    bestMetricValue = Double.parseDouble(m.group(1));
                                    if (Arrays.asList(metricsToMax).contains((Object)AutoWEKAClassifier.this.metric)) {
                                        bestMetricValue *= -1.0;
                                    }
                                }
                                if (!line.matches(".*DEBUG.*") && !line.matches(".*Variance is less than.*")) {
                                    if (line.matches(".*INFO.*")) {
                                        if (line.matches(".*ClassifierRunner - weka.classifiers.*")) {
                                            ++tried;
                                            ++AutoWEKAClassifier.this.totalTried;
                                            if (AutoWEKAClassifier.this.wLog != null) {
                                                String msg = "Thread " + index + ": performed " + tried + " evaluations, estimated " + (Object)((Object)AutoWEKAClassifier.this.metric) + " " + bestMetricValue + "...";
                                                AutoWEKAClassifier.this.wLog.statusMessage(msg);
                                                if (tried % 10 == 0) {
                                                    AutoWEKAClassifier.this.wLog.logMessage(msg);
                                                }
                                            }
                                        }
                                    } else if (line.matches(".*WARN.*")) {
                                        AutoWEKAClassifier.this.log.warn(line);
                                    } else if (line.matches(".*ERROR.*")) {
                                        AutoWEKAClassifier.this.log.error(line);
                                    } else {
                                        AutoWEKAClassifier.this.log.info(line);
                                    }
                                }
                                if (!Thread.currentThread().isInterrupted()) continue;
                                mProc.destroy();
                                break;
                            }
                            Runtime.getRuntime().removeShutdownHook(killerHook);
                        }
                        catch (Exception e) {
                            if (mProc != null) {
                                mProc.destroy();
                            }
                            AutoWEKAClassifier.this.log.error(e.getMessage(), e);
                        }
                    }
                });
                workers[i2].start();
            }
            try {
                for (i2 = 0; i2 < this.parallelRuns; ++i2) {
                    workers[i2].join();
                }
            }
            catch (InterruptedException e) {
                for (int i4 = 0; i4 < this.parallelRuns; ++i4) {
                    workers[i4].interrupt();
                }
                throw new InterruptedException("Auto-WEKA run interrupted!");
            }
            TrajectoryGroup[] groups = new TrajectoryGroup[this.parallelRuns];
            GetBestFromTrajectoryGroup[] bests = new GetBestFromTrajectoryGroup[this.parallelRuns];
            for (int i5 = 0; i5 < this.parallelRuns; ++i5) {
                groups[i5] = TrajectoryMerger.mergeExperimentFolder(this.msExperimentPaths[i5] + expName);
                this.log.debug("Optimization trajectory {}:", (Object)i5);
                for (Trajectory t : groups[i5].getTrajectories()) {
                    this.log.debug("{}", (Object)t);
                }
                bests[i5] = new GetBestFromTrajectoryGroup(groups[i5]);
                this.log.info("Thread {}, best configuration estimate {}", (Object)i5, (Object)this.estimatedMetricValues[i5]);
            }
            boolean allFailed = true;
            for (int i6 = 0; i6 < this.parallelRuns; ++i6) {
                allFailed &= (double)bests[i6].errorEstimate == ClassifierResult.getInfinity();
            }
            if (allFailed) {
                throw new Exception("All runs timed out, unable to find good configuration. Please allow more time and rerun.");
            }
            int bestIndex = 0;
            mBest = bests[bestIndex];
            if (Arrays.asList(metricsToMax).contains((Object)this.metric)) {
                for (i = 1; i < this.parallelRuns; ++i) {
                    if (!(this.estimatedMetricValues[i] > this.estimatedMetricValues[bestIndex])) continue;
                    mBest = bests[i];
                    bestIndex = i;
                }
            } else {
                for (i = 1; i < this.parallelRuns; ++i) {
                    if (!(this.estimatedMetricValues[i] < this.estimatedMetricValues[bestIndex])) continue;
                    mBest = bests[i];
                    bestIndex = i;
                }
            }
            this.estimatedMetricValue = this.estimatedMetricValues[bestIndex];
            if (this.nBestConfigs > 1) {
                try {
                    ConfigurationRanker.rank(this.nBestConfigs, this.msExperimentPaths[bestIndex] + expName + File.separator, mBest.rawArgs);
                    this.bestConfigsCollection = ConfigurationCollection.fromXML(this.msExperimentPaths[bestIndex] + expName + File.separator + configurationRankingPath, ConfigurationCollection.class);
                }
                catch (Exception e) {
                    if (!(e instanceof FileNotFoundException) && !(e instanceof NoSuchElementException)) break block22;
                    System.out.println("Could not find any configuration fully evaluated on all 10 folds. Please provide Auto-WEKA with more run time");
                    this.bestConfigsCollection = null;
                }
            }
        }
        this.classifierClass = mBest.classifierClass;
        this.classifierArgs = Util.splitQuotedString(mBest.classifierArgs).toArray(new String[0]);
        this.attributeSearchClass = mBest.attributeSearchClass;
        if (mBest.attributeSearchArgs != null) {
            this.attributeSearchArgs = Util.splitQuotedString(mBest.attributeSearchArgs).toArray(new String[0]);
        }
        this.attributeEvalClass = mBest.attributeEvalClass;
        if (mBest.attributeEvalArgs != null) {
            this.attributeEvalArgs = Util.splitQuotedString(mBest.attributeEvalArgs).toArray(new String[0]);
        }
        this.log.info("classifier: {}, arguments: {}, attribute search: {}, attribute search arguments: {}, attribute evaluation: {}, attribute evaluation arguments: {}", this.classifierClass, this.classifierArgs, this.attributeSearchClass, this.attributeSearchArgs, this.attributeEvalClass, this.attributeEvalArgs);
        this.as = new AttributeSelection();
        if (this.attributeSearchClass != null) {
            ASSearch asSearch = ASSearch.forName((String)this.attributeSearchClass, (String[])((String[])this.attributeSearchArgs.clone()));
            this.as.setSearch(asSearch);
        }
        if (this.attributeEvalClass != null) {
            ASEvaluation asEval = ASEvaluation.forName((String)this.attributeEvalClass, (String[])((String[])this.attributeEvalArgs.clone()));
            this.as.setEvaluator(asEval);
        }
        this.as.SelectAttributes(is);
        this.classifier = AbstractClassifier.forName((String)this.classifierClass, (String[])((String[])this.classifierArgs.clone()));
        long startTime = System.currentTimeMillis();
        is = this.as.reduceDimensionality(is);
        this.classifier.buildClassifier(is);
        long stopTime = System.currentTimeMillis();
        this.finalTrainTime = (double)(stopTime - startTime) / 1000.0;
        this.eval = new Evaluation(is);
        this.eval.evaluateModel(this.classifier, is, new Object[0]);
    }

    public double classifyInstance(Instance i) throws Exception {
        if (this.classifier == null) {
            throw new Exception("Auto-WEKA has not been run yet to get a model!");
        }
        i = this.as.reduceDimensionality(i);
        return this.classifier.classifyInstance(i);
    }

    public double[] distributionForInstance(Instance i) throws Exception {
        if (this.classifier == null) {
            throw new Exception("Auto-WEKA has not been run yet to get a model!");
        }
        i = this.as.reduceDimensionality(i);
        return this.classifier.distributionForInstance(i);
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe seed for the random number generator.\n\t(default: " + this.seed + ")", "seed", 1, "-seed <seed>"));
        result.addElement(new Option("\tThe time limit for tuning in minutes (approximately).\n\t(default: 15)", "timeLimit", 1, "-timeLimit <limit>"));
        result.addElement(new Option("\tThe memory limit for runs in MiB.\n\t(default: 1024)", "memLimit", 1, "-memLimit <limit>"));
        result.addElement(new Option("\tThe amount of best configurations to output.\n\t(default: 1)", "nBestConfigs", 1, "-nBestConfigs <limit>"));
        result.addElement(new Option("\tThe metric to optimise.\n\t(default: " + (Object)((Object)DEFAULT_METRIC) + ")", "metric", 1, "-metric <metric>"));
        result.addElement(new Option("\tThe number of parallel runs. EXPERIMENTAL.\n\t(default: 1)", "parallelRuns", 1, "-parallelRuns <runs>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement(enu.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-seed");
        result.add("" + this.seed);
        result.add("-timeLimit");
        result.add("" + this.timeLimit);
        result.add("-memLimit");
        result.add("" + this.memLimit);
        result.add("-nBestConfigs");
        result.add("" + this.nBestConfigs);
        result.add("-metric");
        result.add("" + (Object)((Object)this.metric));
        result.add("-parallelRuns");
        result.add("" + this.parallelRuns);
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"seed", (String[])options);
        if (tmpStr.length() != 0) {
            this.seed = Integer.parseInt(tmpStr);
        }
        this.timeLimit = (tmpStr = Utils.getOption((String)"timeLimit", (String[])options)).length() != 0 ? Integer.parseInt(tmpStr) : 15;
        tmpStr = Utils.getOption((String)"memLimit", (String[])options);
        this.memLimit = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1024;
        tmpStr = Utils.getOption((String)"nBestConfigs", (String[])options);
        this.nBestConfigs = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1;
        tmpStr = Utils.getOption((String)"metric", (String[])options);
        this.metric = tmpStr.length() != 0 ? Metric.valueOf(tmpStr) : DEFAULT_METRIC;
        tmpStr = Utils.getOption((String)"parallelRuns", (String[])options);
        this.parallelRuns = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 1;
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public void setSeed(int s) {
        this.seed = s;
    }

    public int getSeed() {
        return this.seed;
    }

    public String seedTipText() {
        return "the seed for the random number generator (you do not usually need to change this)";
    }

    public void setParallelRuns(int n) {
        this.parallelRuns = n;
    }

    public int getParallelRuns() {
        return this.parallelRuns;
    }

    public String parallelRunsTipText() {
        return "the number of runs to perform in parallel EXPERIMENTAL";
    }

    public void setMetric(Metric m) {
        this.metric = m;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public String metricTipText() {
        return "the metric to optimise";
    }

    public void setTimeLimit(int tl) {
        this.timeLimit = tl;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public String timeLimitTipText() {
        return "the time limit for tuning (in minutes)";
    }

    public void setMemLimit(int ml) {
        this.memLimit = ml;
    }

    public int getMemLimit() {
        return this.memLimit;
    }

    public String memLimitTipText() {
        return "the memory limit for runs (in MiB)";
    }

    public void setnBestConfigs(int nbc) {
        this.nBestConfigs = nbc;
    }

    public int getnBestConfigs() {
        return this.nBestConfigs;
    }

    public String nBestConfigsTipText() {
        return "How many of the best configurations should be returned as output";
    }

    public void setLog(weka.gui.Logger log) {
        this.wLog = log;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Chris Thornton, Frank Hutter, Holger Hoos, and Kevin Leyton-Brown");
        result.setValue(TechnicalInformation.Field.YEAR, "2013");
        result.setValue(TechnicalInformation.Field.TITLE, "Auto-WEKA: Combined Selection and Hyperparameter Optimization of Classifiaction Algorithms");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc. of KDD 2013");
        return result;
    }

    public String globalInfo() {
        return "Automatically finds the best model with its best parameter settings for a given dataset.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public String toString() {
        int i;
        String[] args2;
        String res = "best classifier: " + this.classifierClass + "\narguments: " + (this.classifierArgs != null ? Arrays.toString(this.classifierArgs) : "[]") + "\nattribute search: " + this.attributeSearchClass + "\nattribute search arguments: " + (this.attributeSearchArgs != null ? Arrays.toString(this.attributeSearchArgs) : "[]") + "\nattribute evaluation: " + this.attributeEvalClass + "\nattribute evaluation arguments: " + (this.attributeEvalArgs != null ? Arrays.toString(this.attributeEvalArgs) : "[]") + "\nmetric: " + (Object)((Object)this.metric) + "\nestimated " + (Object)((Object)this.metric) + ": " + this.estimatedMetricValue + "\ntraining time on evaluation dataset: " + this.finalTrainTime + " seconds\n\n";
        res = res + "You can use the chosen classifier in your own code as follows:\n\n";
        if (this.attributeSearchClass != null || this.attributeEvalClass != null) {
            res = res + "AttributeSelection as = new AttributeSelection();\n";
            if (this.attributeSearchClass != null) {
                res = res + "ASSearch asSearch = ASSearch.forName(\"" + this.attributeSearchClass + "\", new String[]{";
                if (this.attributeSearchArgs != null) {
                    args2 = (String[])this.attributeSearchArgs.clone();
                    for (i = 0; i < args2.length; ++i) {
                        res = res + "\"" + args2[i] + "\"";
                        if (i >= args2.length - 1) continue;
                        res = res + ", ";
                    }
                }
                res = res + "});\n";
                res = res + "as.setSearch(asSearch);\n";
            }
            if (this.attributeEvalClass != null) {
                res = res + "ASEvaluation asEval = ASEvaluation.forName(\"" + this.attributeEvalClass + "\", new String[]{";
                if (this.attributeEvalArgs != null) {
                    args2 = (String[])this.attributeEvalArgs.clone();
                    for (i = 0; i < args2.length; ++i) {
                        res = res + "\"" + args2[i] + "\"";
                        if (i >= args2.length - 1) continue;
                        res = res + ", ";
                    }
                }
                res = res + "});\n";
                res = res + "as.setEvaluator(asEval);\n";
            }
            res = res + "as.SelectAttributes(instances);\n";
            res = res + "instances = as.reduceDimensionality(instances);\n";
        }
        res = res + "Classifier classifier = AbstractClassifier.forName(\"" + this.classifierClass + "\", new String[]{";
        if (this.classifierArgs != null) {
            args2 = (String[])this.classifierArgs.clone();
            for (i = 0; i < args2.length; ++i) {
                res = res + "\"" + args2[i] + "\"";
                if (i >= args2.length - 1) continue;
                res = res + ", ";
            }
        }
        res = res + "});\n";
        res = res + "classifier.buildClassifier(instances);\n\n";
        try {
            res = res + this.eval.toSummaryString();
            res = res + "\n";
            res = res + this.eval.toMatrixString();
            res = res + "\n";
            res = res + this.eval.toClassDetailsString();
        }
        catch (Exception args2) {
            // empty catch block
        }
        if (this.nBestConfigs > 1) {
            if (this.bestConfigsCollection == null) {
                res = res + "\n\n------- BEST CONFIGURATIONS -------";
                res = res + "\nEither your dataset is so large or the runtime is so short that we couldn't evaluate even a single fold";
                res = res + "\nof your dataset within the given time constraints. Please, consider running Auto-WEKA for a longer time.";
            } else {
                ArrayList<Configuration> bccAL = this.bestConfigsCollection.asArrayList();
                int fullyEvaluatedAmt = this.bestConfigsCollection.getFullyEvaluatedAmt();
                int maxFoldEvaluationAmt = ((Configuration)bccAL.get(0)).getEvaluationAmount();
                res = res + "\n\n------- " + fullyEvaluatedAmt + " BEST CONFIGURATIONS -------";
                res = res + "\n\nThese are the " + fullyEvaluatedAmt + " best configurations, as ranked by SMAC";
                res = res + "\nPlease note that this list only contains configurations evaluated on at least " + maxFoldEvaluationAmt + " folds,";
                if (maxFoldEvaluationAmt < 10) {
                    res = res + "\nWhich is less than 10 because that was the largest amount of folds we could evaluate for a single configuration";
                    res = res + "\nunder the given time constraints. If you want us to evaluate more folds (recommended), or if you need more configurations,";
                    res = res + "\nplease consider running Auto-WEKA for a longer time.";
                } else {
                    res = res + "\nIf you need more configurations, please consider running Auto-WEKA for a longer time.";
                }
                for (int i2 = 0; i2 < fullyEvaluatedAmt; ++i2) {
                    res = res + "\n\nConfiguration #" + (i2 + 1) + ":\nSMAC Score: " + ((Configuration)bccAL.get(i2)).getAverageScore() + "\nArgument String:\n" + ((Configuration)bccAL.get(i2)).getArgStrings();
                }
            }
            res = res + "\n\n----END OF CONFIGURATION RANKING----\n";
        }
        if (this.msExperimentPaths != null) {
            res = res + "\nTemporary run directories:\n";
            for (int i3 = 0; i3 < this.msExperimentPaths.length; ++i3) {
                res = res + this.msExperimentPaths[i3] + "\n";
            }
        }
        res = res + "\n\nFor better performance, try giving Auto-WEKA more time.\n";
        if (this.totalTried < 1000) {
            res = res + "Tried " + this.totalTried + " configurations; to get good results reliably you may need to allow for trying thousands of configurations.\n";
        }
        return res;
    }

    public double measureEstimatedMetricValue() {
        return this.estimatedMetricValue;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureEstimatedMetricValue");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureEstimatedMetricValue") == 0) {
            return this.measureEstimatedMetricValue();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (Auto-WEKA)");
    }

    static {
        resamplingArgsMap.put(Resampling.CrossValidation, "numFolds=10");
        resamplingArgsMap.put(Resampling.MultiLevel, "numLevels=2[$]autoweka.instancegenerators.CrossValidation[$]numFolds=10");
        resamplingArgsMap.put(Resampling.RandomSubSampling, "numSamples=10:percent=66");
        DEFAULT_RESAMPLING_ARGS = resamplingArgsMap.get((Object)DEFAULT_RESAMPLING);
        configurationRankingPath = "ConfigurationLogging" + File.separator + "configuration_ranking.xml";
        configurationHashSetPath = "ConfigurationLogging" + File.separator + "configuration_hashes.txt";
        configurationInfoDirPath = "ConfigurationLogging" + File.separator + "configurations/";
        expName = "Auto-WEKA";
    }

    static enum Metric {
        areaAboveROC,
        areaUnderROC,
        avgCost,
        correct,
        correlationCoefficient,
        errorRate,
        falseNegativeRate,
        falsePositiveRate,
        fMeasure,
        incorrect,
        kappa,
        kBInformation,
        kBMeanInformation,
        kBRelativeInformation,
        meanAbsoluteError,
        pctCorrect,
        pctIncorrect,
        precision,
        relativeAbsoluteError,
        rootMeanSquaredError,
        rootRelativeSquaredError,
        weightedAreaUnderROC,
        weightedFalseNegativeRate,
        weightedFalsePositiveRate,
        weightedFMeasure,
        weightedPrecision,
        weightedRecall,
        weightedTrueNegativeRate,
        weightedTruePositiveRate;

    }

    static enum Resampling {
        CrossValidation,
        MultiLevel,
        RandomSubSampling,
        TerminationHoldout;

    }
}

