/*
 * Decompiled with CFR 0.152.
 */
package org.mangosdk.spi.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mangosdk.spi.ProviderFor;
import org.mangosdk.spi.processor.CheckResult;
import org.mangosdk.spi.processor.Collector;
import org.mangosdk.spi.processor.LogLocation;
import org.mangosdk.spi.processor.Logger;
import org.mangosdk.spi.processor.Options;
import org.mangosdk.spi.processor.Persistence;
import org.mangosdk.spi.processor.ProcessorLogger;
import org.mangosdk.spi.processor.Service;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"spi_dir", "spi_log", "spi_verbose", "spi_disabled"})
public class SpiProcessor
extends AbstractProcessor {
    public static final String NAME = SpiProcessor.class.getName() + " (" + "0.2.4" + ")";
    private Options options;
    private Logger logger;
    private Persistence persistence;
    private Collector data;

    @Override
    public synchronized void init(ProcessingEnvironment environment) {
        super.init(environment);
        try {
            this.initialize();
        }
        catch (Exception e) {
            environment.getMessager().printMessage(Diagnostic.Kind.ERROR, ProcessorLogger.exceptionToString(e));
        }
    }

    private void initialize() {
        this.options = new Options(this.processingEnv.getOptions());
        if (this.options.disabled()) {
            return;
        }
        this.logger = new ProcessorLogger(this.processingEnv.getMessager(), this.options);
        this.checkCompatibility();
        this.persistence = new Persistence(NAME, this.options.dir(), this.processingEnv.getFiler(), this.logger);
        this.data = new Collector(this.persistence.getInitializer(), this.logger);
        for (String serviceName : this.persistence.tryFind()) {
            this.data.getService(serviceName);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.options.disabled()) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.logger.note(LogLocation.LOG_FILE, "Starting round with " + roundEnv.getRootElements().size() + " elements");
        this.removeStaleData(roundEnv);
        this.handleAnnotations(roundEnv);
        long end = System.currentTimeMillis();
        this.logger.note(LogLocation.LOG_FILE, "Ending round in " + (end - start) + " milliseconds");
        if (roundEnv.processingOver()) {
            this.writeData();
        }
        return false;
    }

    private void writeData() {
        this.logger.note(LogLocation.LOG_FILE, "Writing output");
        for (Service service : this.data.services()) {
            try {
                this.persistence.write(service.getName(), service.toProviderNamesList());
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        this.persistence.writeLog();
    }

    private void removeStaleData(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement currentClass = (TypeElement)element;
            this.data.removeProvider(this.createProperQualifiedName(currentClass));
        }
    }

    private void handleAnnotations(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ProviderFor.class);
        for (Element element : elements) {
            this.handleElement(element);
        }
    }

    private void handleElement(Element e) {
        TypeElement currentClass = (TypeElement)e;
        CheckResult checkResult = this.checkCurrentClass(currentClass);
        if (checkResult.isError()) {
            this.reportError(currentClass, checkResult);
            return;
        }
        for (TypeElement service : this.findServices(currentClass)) {
            CheckResult implementationResult = this.isImplementation(currentClass, service);
            if (implementationResult.isError()) {
                this.reportError(currentClass, implementationResult);
                continue;
            }
            this.register(this.createProperQualifiedName(service), currentClass);
        }
    }

    private void reportError(TypeElement element, CheckResult result) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, element.getSimpleName() + " " + result.getMessage(), element);
    }

    private CheckResult checkCurrentClass(TypeElement currentClass) {
        if (currentClass.getKind() != ElementKind.CLASS) {
            return CheckResult.valueOf("is not a class");
        }
        if (!currentClass.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return CheckResult.valueOf("is not a public class");
        }
        if (!this.isStaticClass(currentClass)) {
            return CheckResult.valueOf("is not a static class");
        }
        if (!this.hasCorrectConstructor(currentClass)) {
            return CheckResult.valueOf("has no public no-args constructor");
        }
        return CheckResult.OK;
    }

    private boolean hasCorrectConstructor(TypeElement currentClass) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(currentClass.getEnclosedElements());
        for (ExecutableElement constructor : constructors) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isStaticClass(TypeElement element) {
        if (element.getEnclosingElement().getKind() != ElementKind.CLASS) {
            return true;
        }
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private CheckResult isImplementation(TypeElement currentClass, TypeElement provider) {
        if (this.isAssignable(currentClass.asType(), provider.asType())) {
            return CheckResult.OK;
        }
        String message = provider.getKind() == ElementKind.INTERFACE ? "does not implement" : "does not extend";
        return CheckResult.valueOf(message + " " + provider.getQualifiedName());
    }

    private boolean isAssignable(TypeMirror currentClass, TypeMirror provider) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        if (typeUtils.isAssignable(typeUtils.erasure(currentClass), typeUtils.erasure(provider))) {
            return true;
        }
        for (TypeMirror typeMirror : typeUtils.directSupertypes(currentClass)) {
            if (!this.isAssignable(typeMirror, provider)) continue;
            return true;
        }
        return false;
    }

    private List<TypeElement> findServices(TypeElement classElement) {
        ArrayList<TypeElement> services = new ArrayList<TypeElement>();
        for (AnnotationMirror annotation : SpiProcessor.findAnnotationMirrors(classElement, ProviderFor.class.getName())) {
            for (AnnotationValue value : this.findValue(annotation)) {
                services.add(this.toElement(value));
            }
        }
        return services;
    }

    private static List<AnnotationMirror> findAnnotationMirrors(TypeElement element, String lookingFor) {
        ArrayList<AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!SpiProcessor.annotationMirrorMatches(annotationMirror, lookingFor)) continue;
            annotationMirrors.add(annotationMirror);
        }
        return annotationMirrors;
    }

    private static boolean annotationMirrorMatches(AnnotationMirror annotation, String lookingFor) {
        Name qualifiedName = ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName();
        return qualifiedName.contentEquals(lookingFor);
    }

    private TypeElement toElement(AnnotationValue value) {
        return (TypeElement)((DeclaredType)((TypeMirror)value.getValue())).asElement();
    }

    private Collection<AnnotationValue> findValue(AnnotationMirror mirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
            Collection result = (Collection)entry.getValue().getValue();
            return result;
        }
        throw new IllegalStateException("No value found in element");
    }

    private void register(String serviceName, TypeElement provider) {
        this.data.getService(serviceName).addProvider(this.createProperQualifiedName(provider));
    }

    private String createProperQualifiedName(TypeElement provider) {
        return this.processingEnv.getElementUtils().getBinaryName(provider).toString();
    }

    private void checkCompatibility() {
        this.logger.note(LogLocation.MESSAGER, "Testing for compatability options");
        try {
            this.checkJavacOnLinux();
        }
        catch (Exception e) {
            this.warning(ProcessorLogger.exceptionToString(e));
        }
        this.logger.note(LogLocation.MESSAGER, "Testing complete");
    }

    private void checkJavacOnLinux() {
        try {
            FileObject resource = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.options.dir() + "a/b");
            if (resource.toUri().toString().equals("b")) {
                this.warning("Output files will be placed in the root of the output folder.\n  This is a known bug in the java compiler on Linux.\n  Please use the -d compiler option to circumvent this problem.\n  See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6647996 for more information.");
            }
        }
        catch (IOException e) {
            this.warning("IOException during testing Javac on Linux");
        }
    }

    private void warning(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }
}

