/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.special;

import net.sf.doodleproject.numerics4j.Constants;
import net.sf.doodleproject.numerics4j.continuedfraction.ContinuedFraction;
import net.sf.doodleproject.numerics4j.exception.NumericException;
import net.sf.doodleproject.numerics4j.series.Series;

public final class Gamma {
    private static double[] lanczos = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};

    private Gamma() {
    }

    public static double logGamma(double x) {
        double ret;
        if (Double.isNaN(x) || x <= 0.0) {
            ret = Double.NaN;
        } else {
            double g = 4.7421875;
            double sum = 0.0;
            for (int i = 1; i < lanczos.length; ++i) {
                sum += lanczos[i] / (x + (double)i);
            }
            double tmp = x + g + 0.5;
            ret = (x + 0.5) * Math.log(tmp) - tmp + 0.5 * Constants.LOG_2_PI + Math.log(sum += lanczos[0]) - Math.log(x);
        }
        return ret;
    }

    public static double regularizedGammaP(final double a, final double x) throws NumericException {
        double ret;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 0.0;
        } else if (x >= a + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaQ(a, x);
        } else {
            Series s = new Series(){
                private double term;
                {
                    this.term = 1.0 / x;
                }

                protected double getTerm(int n, double x2) {
                    this.term = x2 / (a + (double)n) * this.term;
                    return this.term;
                }
            };
            ret = s.evaluate(x) * Math.exp(-x + a * Math.log(x) - Gamma.logGamma(a));
        }
        return ret;
    }

    public static double regularizedGammaQ(final double a, double x) throws NumericException {
        double ret;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 1.0;
        } else if (x < a + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaP(a, x);
        } else {
            ContinuedFraction cf = new ContinuedFraction(){

                protected double getA(int n, double x) {
                    return 2.0 * (double)n + 1.0 - a + x;
                }

                protected double getB(int n, double x) {
                    return (double)n * (a - (double)n);
                }
            };
            ret = 1.0 / cf.evaluate(x);
            ret = Math.exp(-x + a * Math.log(x) - Gamma.logGamma(a)) * ret;
        }
        return ret;
    }
}

