/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.statistics.distribution;

import net.sf.doodleproject.numerics4j.exception.NumericException;
import net.sf.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;
import net.sf.doodleproject.numerics4j.statistics.distribution.GammaDistribution;

public class ChiSquaredDistribution
extends ContinuousDistribution {
    private GammaDistribution gamma;

    public ChiSquaredDistribution() {
        this(1.0);
    }

    public ChiSquaredDistribution(double df) {
        this.setGamma(new GammaDistribution(df / 2.0, 2.0));
    }

    public double cumulativeProbability(double x) throws NumericException {
        return this.getGamma().cumulativeProbability(x);
    }

    public double getDegreesOfFreedom() {
        return this.getGamma().getAlpha() * 2.0;
    }

    private GammaDistribution getGamma() {
        return this.gamma;
    }

    public double inverseCumulativeProbability(double p) throws NumericException {
        return this.getGamma().inverseCumulativeProbability(p);
    }

    public void setDegreesOfFreedom(double df) {
        this.getGamma().setAlpha(df / 2.0);
    }

    private void setGamma(GammaDistribution g) {
        this.gamma = g;
    }
}

