/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.acquisitionfunctions;

import ca.ubc.cs.beta.aeatk.misc.math.ArrayMathOps;

class AcquisitionFunctionHelper {
    static final double PI = Math.PI;
    static final double LOG2PI = 1.83787706640935;

    AcquisitionFunctionHelper() {
    }

    static double[] normcdf(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = AcquisitionFunctionHelper.normcdf(x[i]);
        }
        return result;
    }

    static double[] normpdf(double[] x) {
        double[] result = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            result[i] = AcquisitionFunctionHelper.normpdf(x[i]);
        }
        return result;
    }

    static double normcdf(double x) {
        double b1 = 0.31938153;
        double b2 = -0.356563782;
        double b3 = 1.781477937;
        double b4 = -1.821255978;
        double b5 = 1.330274429;
        double p = 0.2316419;
        double c = 0.39894228;
        if (x >= 0.0) {
            double t = 1.0 / (1.0 + p * x);
            return 1.0 - c * ArrayMathOps.exp(-x * x / 2.0) * t * (t * (t * (t * (t * b5 + b4) + b3) + b2) + b1);
        }
        double t = 1.0 / (1.0 - p * x);
        return c * ArrayMathOps.exp(-x * x / 2.0) * t * (t * (t * (t * (t * b5 + b4) + b3) + b2) + b1);
    }

    static double normpdfln(double x) {
        return -0.5 * (1.83787706640935 + x * x);
    }

    static double normcdfln(double x) {
        if (x > -6.5) {
            return ArrayMathOps.log(AcquisitionFunctionHelper.normcdf(x));
        }
        double z = ArrayMathOps.pow(x, -2.0);
        double y = z * (-1.0 + z * (2.5 + z * (-12.333333333333334 + z * (88.25 + z * (-816.2 + z * (9200.833333333334 + z * -854197.0 / 7.0))))));
        return y - 0.5 * ArrayMathOps.log(Math.PI * 2) - 0.5 * x * x - ArrayMathOps.log(-x);
    }

    static double normpdf(double x) {
        return ArrayMathOps.exp(AcquisitionFunctionHelper.normpdfln(x));
    }

    static double[] Z(double[] predmean, double fmin, double[] predvar) {
        return ArrayMathOps.divide(ArrayMathOps.subtract(fmin, predmean), predvar);
    }
}

