/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.json.serializers;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.json.serializers.JsonDeserializerHelper;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public class AlgorithmRunResultJson {
    public static final String R_WALLCLOCK_TIME = "r-wallclock-time";
    public static final String R_ADDL_RUN_DATA = "r-addl-run-data";
    public static final String R_RESULT_SEED = "r-result-seed";
    public static final String R_QUALITY = "r-quality";
    public static final String R_RUN_LENGTH = "r-run-length";
    public static final String R_RUNTIME = "r-runtime";
    public static final String R_RUN_RESULT = "r-run-result";
    public static final String R_RC = "r-rc";

    public static class AlgorithmRunSerializer
    extends StdSerializer<AlgorithmRunResult> {
        protected AlgorithmRunSerializer() {
            super(AlgorithmRunResult.class);
        }

        public void serialize(AlgorithmRunResult value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeObjectField(AlgorithmRunResultJson.R_RC, (Object)value.getAlgorithmRunConfiguration());
            jgen.writeObjectField(AlgorithmRunResultJson.R_RUN_RESULT, (Object)value.getRunStatus());
            jgen.writeObjectField(AlgorithmRunResultJson.R_RUNTIME, (Object)value.getRuntime());
            jgen.writeObjectField(AlgorithmRunResultJson.R_RUN_LENGTH, (Object)value.getRunLength());
            jgen.writeObjectField(AlgorithmRunResultJson.R_QUALITY, (Object)value.getQuality());
            jgen.writeObjectField(AlgorithmRunResultJson.R_RESULT_SEED, (Object)value.getResultSeed());
            jgen.writeObjectField(AlgorithmRunResultJson.R_ADDL_RUN_DATA, (Object)value.getAdditionalRunData());
            jgen.writeObjectField(AlgorithmRunResultJson.R_WALLCLOCK_TIME, (Object)value.getWallclockExecutionTime());
            jgen.writeEndObject();
        }
    }

    public static class AlgorithmRunDeserializer
    extends StdDeserializer<AlgorithmRunResult> {
        protected AlgorithmRunDeserializer() {
            super(AlgorithmRunResult.class);
        }

        public AlgorithmRunResult deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
            }
            RunStatus runResult = null;
            double runtime = -1.0;
            double quality = -1.0;
            double runlength = -1.0;
            String addlRunData = null;
            double wallclock = -1.0;
            long seed = Long.MIN_VALUE;
            AlgorithmRunConfiguration rc = null;
            while (jp.nextValue() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                if (jp.getCurrentName() == null) continue;
                switch (jp.getCurrentName()) {
                    case "r-runtime": {
                        runtime = jp.getValueAsDouble();
                        break;
                    }
                    case "r-run-length": {
                        runlength = jp.getValueAsDouble();
                        break;
                    }
                    case "r-result-seed": {
                        seed = jp.getValueAsLong();
                        break;
                    }
                    case "r-run-result": {
                        runResult = RunStatus.getAutomaticConfiguratorResultForKey(jp.getValueAsString());
                        break;
                    }
                    case "r-quality": {
                        quality = jp.getValueAsDouble();
                        break;
                    }
                    case "r-wallclock-time": {
                        wallclock = jp.getValueAsDouble();
                        break;
                    }
                    case "r-addl-run-data": {
                        addlRunData = jp.getValueAsString();
                        break;
                    }
                    case "r-rc": {
                        rc = (AlgorithmRunConfiguration)JsonDeserializerHelper.getDeserializedVersion(jp, ctxt, AlgorithmRunConfiguration.class);
                    }
                }
            }
            return new ExistingAlgorithmRunResult(rc, runResult, runtime, runlength, quality, seed, addlRunData, wallclock);
        }
    }
}

