/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.logging;

import ca.ubc.cs.beta.aeatk.logging.LogLevel;
import ca.ubc.cs.beta.aeatk.logging.LoggingOptions;
import ca.ubc.cs.beta.aeatk.misc.options.CommandLineOnly;
import ca.ubc.cs.beta.aeatk.misc.options.OptionLevel;
import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import com.beust.jcommander.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsageTextField(hiddenSection=true)
public class ConsoleOnlyLoggingOptions
extends AbstractOptions
implements LoggingOptions {
    static final String LOGBACK_CONFIGURATION_FILE_PROPERTY = "logback.configurationFile";
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.INTERMEDIATE)
    @Parameter(names={"--log-level", "--logLevel", "--console-log-level", "--consoleLogLevel"}, description="messages will only be logged if they are of this severity or higher.")
    public LogLevel logLevel = LogLevel.INFO;

    @Override
    public void initializeLogging(String completeOutputDir, int numRun) {
        this.initializeLogging();
    }

    @Override
    public void initializeLogging() {
        System.setProperty("LOGLEVEL", this.logLevel.name());
        if (System.getProperty(LOGBACK_CONFIGURATION_FILE_PROPERTY) != null) {
            Logger log = LoggerFactory.getLogger(this.getClass());
            log.trace("System property for logback.configurationFile has been found already set as {} , logging will follow this file", (Object)System.getProperty(LOGBACK_CONFIGURATION_FILE_PROPERTY));
        } else {
            String newXML = this.getClass().getPackage().getName().replace(".", "/") + "/" + "consoleonly-logback.xml";
            System.setProperty(LOGBACK_CONFIGURATION_FILE_PROPERTY, newXML);
            Logger log = LoggerFactory.getLogger(this.getClass());
            if (log.isTraceEnabled()) {
                log.trace("Logging initialized to use file:" + newXML);
            } else {
                log.debug("Logging initialized");
            }
        }
    }
}

