/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.objectives;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.math.stat.StatUtils;

public enum OverallObjective {
    MEAN,
    MEAN1000,
    MEAN10;


    public double aggregate(Collection<Double> c, double cutoffTime) {
        double[] values = new double[c.size()];
        int i = 0;
        Iterator<Double> iterator = c.iterator();
        while (iterator.hasNext()) {
            double d;
            values[i] = d = iterator.next().doubleValue();
            switch (this) {
                case MEAN10: {
                    values[i] = values[i] >= cutoffTime ? values[i] * 10.0 : values[i];
                    break;
                }
                case MEAN1000: {
                    values[i] = values[i] >= cutoffTime ? values[i] * 1000.0 : values[i];
                    break;
                }
            }
            ++i;
        }
        switch (this) {
            case MEAN10: 
            case MEAN1000: 
            case MEAN: {
                return StatUtils.mean((double[])values);
            }
        }
        throw new UnsupportedOperationException(this.toString() + " is not a supported aggregation method");
    }

    public double getPenaltyFactor() {
        switch (this) {
            case MEAN: {
                return 1.0;
            }
            case MEAN10: {
                return 10.0;
            }
            case MEAN1000: {
                return 1000.0;
            }
        }
        throw new UnsupportedOperationException(this.toString() + " is not a supported aggregation method");
    }
}

