/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace;

import java.io.Serializable;

public class NormalizedRange
implements Serializable {
    private static final long serialVersionUID = -2338679156299268217L;
    private final double minNormalizedValue;
    private final double maxNormalizedValue;
    private final double minUnnormalizedValue;
    private final double maxUnnormalizedValue;
    private final boolean normalizeToLog;
    private final boolean intValuesOnly;

    public NormalizedRange(double minValue, double maxValue, boolean normalizeToLog, boolean intValuesOnly) {
        this.normalizeToLog = normalizeToLog;
        this.intValuesOnly = intValuesOnly;
        this.minUnnormalizedValue = minValue;
        this.maxUnnormalizedValue = maxValue;
        if (intValuesOnly) {
            minValue -= 0.5;
            maxValue += 0.5;
        }
        if (normalizeToLog) {
            if (minValue <= 0.0 || maxValue <= 0.0) {
                throw new IllegalArgumentException("Log Scales cannot have negative or zero values in Param File: min:" + minValue + " max: " + maxValue);
            }
            minValue = Math.log10(minValue);
            maxValue = Math.log10(maxValue);
        }
        this.minNormalizedValue = minValue;
        this.maxNormalizedValue = maxValue;
        if (this.minNormalizedValue >= this.maxNormalizedValue) {
            throw new IllegalArgumentException("Min must be strictly less than max: " + minValue + " >= " + maxValue);
        }
        if (Double.isNaN(minValue) || Double.isInfinite(minValue)) {
            throw new IllegalArgumentException("Min must be a real value");
        }
        if (Double.isNaN(maxValue) || Double.isInfinite(maxValue)) {
            throw new IllegalArgumentException("Max must be a real value");
        }
    }

    public double normalizeValue(double x) {
        if (this.normalizeToLog) {
            x = Math.log10(x);
        }
        if (x < this.minNormalizedValue || x > this.maxNormalizedValue) {
            double a = this.minNormalizedValue;
            double b = this.maxNormalizedValue;
            if (this.intValuesOnly) {
                a = Math.round(a + 0.5);
                b = Math.round(b - 0.5);
            }
            if (this.normalizeToLog) {
                throw new IllegalArgumentException("Value " + Math.pow(10.0, x) + " is outside of domain [" + Math.pow(10.0, a) + "," + Math.pow(10.0, b) + "]");
            }
            throw new IllegalArgumentException("Value " + x + " is outside of domain [" + a + "," + b + "]");
        }
        return (x - this.minNormalizedValue) / (this.maxNormalizedValue - this.minNormalizedValue);
    }

    public double unnormalizeValue(double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("Value is outside of [0,1]");
        }
        double value = this.normalizeToLog ? Math.pow(10.0, x * (this.maxNormalizedValue - this.minNormalizedValue) + this.minNormalizedValue) : x * (this.maxNormalizedValue - this.minNormalizedValue) + this.minNormalizedValue;
        if (this.intValuesOnly) {
            value = Math.round(value);
        }
        value = Math.max(value, this.minUnnormalizedValue);
        value = Math.min(value, this.maxUnnormalizedValue);
        return value;
    }

    public String toString() {
        return "(NormalizeRange: {Min: " + this.minNormalizedValue + " Max: " + this.maxNormalizedValue + (this.normalizeToLog ? " LOG " : "") + (this.intValuesOnly ? " INT " : "") + "})";
    }

    public boolean isIntegerOnly() {
        return this.intValuesOnly;
    }
}

