/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace;

import ca.ubc.cs.beta.aeatk.exceptions.ParameterConfigurationLockedException;
import ca.ubc.cs.beta.aeatk.json.serializers.ParameterConfigurationSpaceJson;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ForbiddenOperators;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.NormalizedRange;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.ValidationResult;
import net.objecthunter.exp4j.operator.Operator;

@NotThreadSafe
@JsonDeserialize(using=ParameterConfigurationSpaceJson.ParamConfigurationDeserializer.class)
@JsonSerialize(using=ParameterConfigurationSpaceJson.ParamConfigurationSerializer.class)
public class ParameterConfiguration
implements Map<String, String>,
Serializable {
    private static final long serialVersionUID = 879997991870028528L;
    private final Map<String, Integer> paramKeyToValueArrayIndexMap;
    private final boolean[] parameterDomainContinuous;
    private final int[] categoricalSize;
    private final ParameterConfigurationSpace configSpace;
    private final double[] valueArray;
    private volatile boolean isDirty = true;
    private final boolean[] activeParams;
    private final double[] valueArrayForComparsion;
    private volatile boolean locked = false;
    volatile boolean hashSet = false;
    int lastHash = 0;
    private static final AtomicInteger idPool = new AtomicInteger(0);
    private int myID;
    private static final double EPSILON = Math.pow(10.0, -14.0);

    ParameterConfiguration(ParameterConfigurationSpace configSpace, double[] valueArray, int[] categoricalSize, boolean[] parameterDomainContinuous, Map<String, Integer> paramKeyToValueArrayIndexMap) {
        this.configSpace = configSpace;
        this.valueArray = valueArray;
        this.categoricalSize = categoricalSize;
        this.parameterDomainContinuous = parameterDomainContinuous;
        this.paramKeyToValueArrayIndexMap = paramKeyToValueArrayIndexMap;
        this.myID = idPool.incrementAndGet();
        this.activeParams = new boolean[valueArray.length];
        this.isDirty = true;
        this.valueArrayForComparsion = new double[valueArray.length];
    }

    public ParameterConfiguration(ParameterConfiguration oConfig) {
        if (oConfig.isDirty) {
            oConfig.cleanUp();
        }
        this.isDirty = oConfig.isDirty;
        this.myID = oConfig.myID;
        this.configSpace = oConfig.configSpace;
        this.valueArray = (double[])oConfig.valueArray.clone();
        this.categoricalSize = oConfig.categoricalSize;
        this.parameterDomainContinuous = oConfig.parameterDomainContinuous;
        this.paramKeyToValueArrayIndexMap = oConfig.paramKeyToValueArrayIndexMap;
        this.activeParams = (boolean[])oConfig.activeParams.clone();
        this.valueArrayForComparsion = (double[])oConfig.valueArrayForComparsion.clone();
        this.lastHash = oConfig.lastHash;
        this.locked = false;
    }

    @Override
    public int size() {
        return this.valueArray.length;
    }

    @Override
    public boolean isEmpty() {
        return this.valueArray.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.paramKeyToValueArrayIndexMap.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (String s : this.values()) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(Object key) {
        Integer index = this.paramKeyToValueArrayIndexMap.get(key);
        if (index == null) {
            return null;
        }
        double value = this.valueArray[index];
        if (Double.isNaN(value)) {
            return null;
        }
        if (this.parameterDomainContinuous[index]) {
            NormalizedRange range = this.configSpace.getNormalizedRangeMap().get(key);
            if (range.isIntegerOnly()) {
                long intValue = Math.round(range.unnormalizeValue(value));
                if (this.configSpace.getParameterTypes().get(key) == ParameterConfigurationSpace.ParameterType.ORDINAL) {
                    return this.configSpace.getValuesMap().get(key).get((int)intValue);
                }
                return String.valueOf(intValue);
            }
            return String.valueOf(range.unnormalizeValue(value));
        }
        if (value == 0.0) {
            return null;
        }
        return this.configSpace.getValuesMap().get(key).get((int)value - 1);
    }

    public ParameterConfiguration copy() {
        return new ParameterConfiguration(this);
    }

    @Override
    public String put(String key, String newValue) {
        if (this.locked) {
            if (this.get(key).equals(newValue)) {
                return newValue;
            }
            throw new ParameterConfigurationLockedException("This parameter setting has been locked (via the lock() method), this prevents any further changes to this instance. You should use the copy() method to obtain a new instance that is still modifiable. Unfortunately defensive copying was leaking too much memory.");
        }
        this.isDirty = true;
        Integer index = this.paramKeyToValueArrayIndexMap.get(key);
        if (index == null) {
            throw new IllegalArgumentException("This key does not exist in the Parameter Space: " + key);
        }
        String oldValue = this.get(key);
        if (newValue == null) {
            this.valueArray[index.intValue()] = Double.NaN;
        } else if (this.parameterDomainContinuous[index]) {
            if (this.configSpace.getParameterTypes().get(key) == ParameterConfigurationSpace.ParameterType.ORDINAL && (newValue = String.valueOf(this.configSpace.getCategoricalValueMap().get(key).get(newValue))) == null) {
                throw new IllegalArgumentException("Value is not legal for this parameter: " + key + " Value:" + newValue);
            }
            this.valueArray[index.intValue()] = this.configSpace.getNormalizedRangeMap().get(key).normalizeValue(Double.valueOf(newValue));
        } else {
            List<String> inOrderValues = this.configSpace.getValuesMap().get(key);
            int i = 1;
            boolean valueFound = false;
            for (String possibleValue : inOrderValues) {
                if (possibleValue.equals(newValue)) {
                    this.valueArray[index.intValue()] = i;
                    valueFound = true;
                    break;
                }
                ++i;
            }
            if (!valueFound) {
                throw new IllegalArgumentException("Value is not legal for this parameter: " + key + " Value:" + newValue);
            }
        }
        return oldValue;
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> ent : m.entrySet()) {
            this.put(ent.getKey(), ent.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (String s : this.paramKeyToValueArrayIndexMap.keySet()) {
            keys.add(s);
        }
        return keys;
    }

    @Override
    public Collection<String> values() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return new ValueSetCollection();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return new ParameterConfigurationEntrySet();
    }

    public double[] toValueArray() {
        return (double[])this.valueArray.clone();
    }

    public double[] toComparisonValueArray() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return (double[])this.valueArrayForComparsion.clone();
    }

    public String toString() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return this.getFriendlyIDHex();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParameterConfiguration) {
            ParameterConfiguration opc = (ParameterConfiguration)o;
            if (this.isDirty) {
                this.cleanUp();
            }
            if (opc.isDirty) {
                opc.cleanUp();
            }
            if (!this.configSpace.equals(opc.configSpace)) {
                return false;
            }
            for (int i = 0; i < this.valueArrayForComparsion.length; ++i) {
                if (!(Math.abs(this.valueArrayForComparsion[i] - opc.valueArrayForComparsion[i]) > EPSILON)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isDirty || !this.hashSet) {
            if (this.isDirty) {
                this.cleanUp();
            }
            float[] values = new float[this.valueArrayForComparsion.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (float)this.valueArrayForComparsion[i];
            }
            this.lastHash = Arrays.hashCode(values);
            this.hashSet = true;
        }
        return this.lastHash;
    }

    @Deprecated
    public String getFormattedParameterString(String preKey, String keyValSeperator, String valueDelimiter, String glue) {
        return this._getFormattedParameterString(preKey, keyValSeperator, valueDelimiter, glue, true);
    }

    protected String _getFormattedParameterString(String preKey, String keyValSeperator, String valueDelimiter, String glue, boolean hideInactiveParameters) {
        Set<String> activeParams = this.getActiveParameters();
        StringBuilder sb = new StringBuilder();
        boolean isFirstParameterInString = true;
        for (String key : this.keySet()) {
            if (this.get(key) == null || !activeParams.contains(key) && hideInactiveParameters) continue;
            if (!isFirstParameterInString) {
                sb.append(glue);
            }
            isFirstParameterInString = false;
            sb.append(preKey).append(key).append(keyValSeperator).append(valueDelimiter).append(this.get(key)).append(valueDelimiter);
        }
        return sb.toString();
    }

    @Deprecated
    public String getFormattedParameterString() {
        return this._getFormattedParameterString("-", " ", "'", " ", true);
    }

    public String getFormattedParameterString(ParameterStringFormat stringFormat) {
        double[] valueArray = this.valueArray;
        switch (stringFormat) {
            case FIXED_WIDTH_ARRAY_STRING_MASK_INACTIVE_SYNTAX: {
                if (this.isDirty) {
                    this.cleanUp();
                }
                valueArray = this.valueArrayForComparsion;
            }
            case FIXED_WIDTH_ARRAY_STRING_SYNTAX: {
                StringWriter sWriter = new StringWriter();
                PrintWriter pWriter = new PrintWriter(sWriter);
                for (int i = 0; i < valueArray.length; ++i) {
                    pWriter.format("%20s", valueArray[i]);
                    if (i + 1 == valueArray.length) continue;
                    pWriter.append(",");
                }
                return sWriter.toString();
            }
            case ARRAY_STRING_MASK_INACTIVE_SYNTAX: {
                if (this.isDirty) {
                    this.cleanUp();
                }
                valueArray = this.valueArrayForComparsion;
            }
            case ARRAY_STRING_SYNTAX: {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < valueArray.length; ++i) {
                    sb.append(valueArray[i]);
                    if (i + 1 == valueArray.length) continue;
                    sb.append(",");
                }
                return sb.toString();
            }
            case NODB_OR_STATEFILE_SYNTAX: {
                return this.getFormattedParameterString(ParameterStringFormat.NODB_SYNTAX);
            }
        }
        return this._getFormattedParameterString(stringFormat.getPreKey(), stringFormat.getKeyValueSeperator(), stringFormat.getValueDelimeter(), stringFormat.getGlue(), stringFormat.hideInactiveParameters());
    }

    public List<ParameterConfiguration> getNeighbourhood(Random rand, int numNumericalNeighbours) {
        Set<String> activeParams = this.getActiveParameters();
        ArrayList<ParameterConfiguration> neighbours = new ArrayList<ParameterConfiguration>(this.numberOfNeighboursExcludingForbidden(numNumericalNeighbours, activeParams));
        for (int i = 0; i < this.configSpace.getParameterNamesInAuthorativeOrder().size(); ++i) {
            double[] newValueArray = (double[])this.valueArray.clone();
            int failuresForParameter = 0;
            for (int j = 1; j <= this.numberOfNeighboursForParameter(i, activeParams.contains(this.configSpace.getParameterNamesInAuthorativeOrder().get(i)), numNumericalNeighbours); ++j) {
                newValueArray[i] = this.getNeighbourForParameter(i, j, rand);
                ParameterConfiguration config = new ParameterConfiguration(this.configSpace, (double[])newValueArray.clone(), this.categoricalSize, this.parameterDomainContinuous, this.paramKeyToValueArrayIndexMap);
                if (config.isForbiddenParameterConfiguration()) {
                    if (++failuresForParameter >= 100 || !this.parameterDomainContinuous[i]) continue;
                    --j;
                    continue;
                }
                neighbours.add(config);
            }
        }
        if (neighbours.size() > this.numberOfNeighboursExcludingForbidden(numNumericalNeighbours, activeParams)) {
            throw new IllegalStateException("Expected " + this.numberOfNeighboursExcludingForbidden(numNumericalNeighbours, activeParams) + " neighbours (should be greater than or equal to) but got " + neighbours.size());
        }
        return neighbours;
    }

    public boolean isNeighbour(ParameterConfiguration oConfig) {
        if (!oConfig.getParameterConfigurationSpace().equals(this.getParameterConfigurationSpace())) {
            return false;
        }
        if (this.isDirty) {
            this.cleanUp();
        }
        if (oConfig.isDirty) {
            oConfig.cleanUp();
        }
        int differences = 0;
        for (int i = 0; i < this.activeParams.length; ++i) {
            if (!this.activeParams[i] || !oConfig.activeParams[i] || this.valueArrayForComparsion[i] == oConfig.valueArrayForComparsion[i]) continue;
            ++differences;
        }
        return differences == 1;
    }

    private int numberOfNeighboursExcludingForbidden(int numNumericalNeighbours, Set<String> activeParams) {
        int neighbours = 0;
        for (int i = 0; i < this.configSpace.getParameterNamesInAuthorativeOrder().size(); ++i) {
            neighbours += this.numberOfNeighboursForParameter(i, activeParams.contains(this.configSpace.getParameterNamesInAuthorativeOrder().get(i)), numNumericalNeighbours);
        }
        return neighbours;
    }

    private int numberOfNeighboursForParameter(int valueArrayIndex, boolean isParameterActive, int neighboursForNumericalParameters) {
        if (!isParameterActive) {
            return 0;
        }
        if (this.configSpace.searchSubspaceActive[valueArrayIndex]) {
            return 0;
        }
        if (this.parameterDomainContinuous[valueArrayIndex]) {
            return neighboursForNumericalParameters;
        }
        return this.categoricalSize[valueArrayIndex] - 1;
    }

    private double getNeighbourForParameter(int valueArrayIndex, int neighbourNumber, Random rand) {
        if (this.parameterDomainContinuous[valueArrayIndex]) {
            double randValue;
            double mean = this.valueArray[valueArrayIndex];
            while (!((randValue = 0.2 * rand.nextGaussian() + mean) >= 0.0) || !(randValue <= 1.0)) {
            }
            NormalizedRange nr = this.configSpace.normalizedRangesByIndex[valueArrayIndex];
            randValue = nr.normalizeValue(nr.unnormalizeValue(randValue));
            return randValue;
        }
        if ((double)neighbourNumber < this.valueArray[valueArrayIndex]) {
            return neighbourNumber;
        }
        return neighbourNumber + 1;
    }

    private void cleanUp() {
        Set<String> activeParams = this._getActiveParameters();
        for (Map.Entry<String, Integer> keyVal : this.paramKeyToValueArrayIndexMap.entrySet()) {
            this.activeParams[keyVal.getValue().intValue()] = activeParams.contains(keyVal.getKey());
            if (this.activeParams[keyVal.getValue()]) {
                if (this.parameterDomainContinuous[keyVal.getValue()]) {
                    this.valueArrayForComparsion[keyVal.getValue().intValue()] = this.valueArray[keyVal.getValue()];
                    continue;
                }
                this.valueArrayForComparsion[keyVal.getValue().intValue()] = this.valueArray[keyVal.getValue()];
                continue;
            }
            this.valueArrayForComparsion[keyVal.getValue().intValue()] = Double.NaN;
        }
        this.myID = idPool.incrementAndGet();
        this.isDirty = false;
        if (!activeParams.equals(this.getActiveParameters())) {
            throw new IllegalStateException("Expected our internal set representation to match the array set implementation" + activeParams + " vs " + this.getActiveParameters());
        }
    }

    public Set<String> getActiveParameters() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return new ActiveParametersSet();
    }

    private Set<String> _getActiveParameters() {
        TreeSet<String> activeParams = new TreeSet<String>();
        Map<Integer, ArrayList<ArrayList<ParameterConfigurationSpace.Conditional>>> conds = this.configSpace.getNameConditionsMap();
        List<String> param_names = this.configSpace.getParameterNamesInAuthorativeOrder();
        block5: for (String param : this.configSpace.getActiveCheckOrderString()) {
            Integer param_id = this.configSpace.getParamKeyIndexMap().get(param);
            if (!conds.containsKey(param_id)) {
                activeParams.add(param);
                continue;
            }
            ArrayList<ArrayList<ParameterConfigurationSpace.Conditional>> clauses = conds.get(param_id);
            for (ArrayList<ParameterConfigurationSpace.Conditional> clause : clauses) {
                boolean all_satisfied = true;
                for (ParameterConfigurationSpace.Conditional cond : clause) {
                    boolean satisfied;
                    double encodedParentPresentValue;
                    Integer parent_id = cond.parent_ID;
                    String parent_name = param_names.get(parent_id);
                    String parent_value_string = this.get(parent_name);
                    if (!activeParams.contains(parent_name)) {
                        all_satisfied = false;
                        break;
                    }
                    String tmpParentValueString = parent_value_string;
                    switch (this.configSpace.getParameterTypes().get(parent_name)) {
                        case ORDINAL: {
                            tmpParentValueString = String.valueOf(this.configSpace.getCategoricalValueMap().get(parent_name).get(parent_value_string));
                        }
                        case INTEGER: 
                        case REAL: {
                            encodedParentPresentValue = Double.parseDouble(tmpParentValueString);
                            break;
                        }
                        case CATEGORICAL: {
                            encodedParentPresentValue = this.configSpace.getCategoricalValueMap().get(parent_name).get(parent_value_string).intValue();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown Type");
                        }
                    }
                    if (all_satisfied &= (satisfied = cond.op.conditionalClauseMatch(encodedParentPresentValue, cond.values))) continue;
                    break;
                }
                if (!all_satisfied) continue;
                activeParams.add(param);
                continue block5;
            }
        }
        return activeParams;
    }

    public int getFriendlyID() {
        if (this.isDirty) {
            this.cleanUp();
        }
        return this.myID;
    }

    public String getFriendlyIDHex() {
        String hex = Integer.toHexString(this.getFriendlyID());
        StringBuilder sb = new StringBuilder("0x");
        while (hex.length() + sb.length() < 6) {
            sb.append("0");
        }
        sb.append(hex.toUpperCase());
        return sb.toString();
    }

    public boolean isForbiddenParameterConfiguration() {
        if (this.configSpace.isForbiddenParameterConfigurationByClassicClauses(this.valueArray)) {
            return true;
        }
        if (!this.configSpace.hasNewForbidden()) {
            return false;
        }
        List<Expression> expressions = this.configSpace.tlExpressions.get();
        if (expressions == null) {
            expressions = new ArrayList<Expression>();
            for (ExpressionBuilder builder : this.configSpace.bl) {
                Expression exp = null;
                StringBuilder errorMessage = new StringBuilder(" Besides the operator and functions listed on http://www.objecthunter.net/exp4j/, the following are supported: ");
                ArrayList<String> operators = new ArrayList<String>();
                for (Operator o : ForbiddenOperators.operators) {
                    operators.add(o.getSymbol());
                }
                errorMessage.append(operators);
                try {
                    exp = builder.build();
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("The following forbidden line seems to be invalid: " + this.configSpace.expressions.get(builder) + "." + errorMessage, e);
                }
                for (Map.Entry<String, Double> ent : this.configSpace.forbiddenOrdinalAndCategoricalVariableValues.entrySet()) {
                    exp.setVariable(ent.getKey(), Double.valueOf(ent.getValue()).doubleValue());
                }
                ValidationResult res = exp.validate(false);
                if (!res.isValid()) {
                    throw new IllegalArgumentException("The following forbidden line seems to be invalid: " + this.configSpace.expressions.get(builder) + " exp4j says:" + res.getErrors() + "." + (this.configSpace.expressions.get(builder).indexOf(44) >= 0 ? " Guess: Is the , suppose to be an &&?" : "") + errorMessage);
                }
                expressions.add(exp);
            }
            this.configSpace.tlExpressions.set(expressions);
        }
        for (Expression calc : expressions) {
            int i = 0;
            for (String name : this.configSpace.getParameterNamesInAuthorativeOrder()) {
                if (this.configSpace.getNormalizedRangeMap().get(name) != null) {
                    double d = this.configSpace.getNormalizedRangeMap().get(name).unnormalizeValue(this.valueArray[i]);
                    if (this.configSpace.getParameterTypes().get(name) == ParameterConfigurationSpace.ParameterType.ORDINAL || this.configSpace.getParameterTypes().get(name) == ParameterConfigurationSpace.ParameterType.CATEGORICAL) {
                        String value = this.configSpace.getValuesMap().get(name).get((int)d);
                        calc.setVariable(name, Double.valueOf(this.configSpace.forbiddenParameterConstants.get(value)).doubleValue());
                    } else {
                        calc.setVariable(name, d);
                    }
                } else {
                    calc.setVariable(name, Double.valueOf(this.configSpace.forbiddenParameterConstants.get(this.get(name))).doubleValue());
                }
                ++i;
            }
            try {
                if (calc.evaluate() == 0.0) continue;
                return true;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Error occured evaluating configuration for forbiddenness", e);
            }
        }
        return false;
    }

    public ParameterConfigurationSpace getParameterConfigurationSpace() {
        return this.configSpace;
    }

    public boolean isInSearchSubspace() {
        for (int i = 0; i < this.valueArray.length; ++i) {
            if (!this.configSpace.searchSubspaceActive[i] || !(Math.abs(this.valueArray[i] - this.configSpace.searchSubspaceValues[i]) > EPSILON)) continue;
            return false;
        }
        return true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    private final class ActiveParametersSet
    extends AbstractSet<String> {
        private volatile int size = -1;

        private ActiveParametersSet() {
        }

        @Override
        public Iterator<String> iterator() {
            int firstIndex = ParameterConfiguration.this.activeParams.length;
            for (int i = 0; i < ParameterConfiguration.this.activeParams.length; ++i) {
                if (!ParameterConfiguration.this.activeParams[i]) continue;
                firstIndex = i;
                break;
            }
            final int firstRealIndex = firstIndex;
            return new Iterator<String>(){
                int i;
                final int creationID;
                {
                    this.i = firstRealIndex;
                    this.creationID = ParameterConfiguration.this.myID;
                }

                @Override
                public boolean hasNext() {
                    if (ParameterConfiguration.this.isDirty || this.creationID != ParameterConfiguration.this.myID) {
                        throw new ConcurrentModificationException("Detected change to the parameter settings");
                    }
                    return this.i < ParameterConfiguration.this.valueArray.length;
                }

                @Override
                public String next() {
                    if (ParameterConfiguration.this.isDirty || this.creationID != ParameterConfiguration.this.myID) {
                        throw new ConcurrentModificationException("Detected change to the parameter settings");
                    }
                    String result = ParameterConfiguration.this.configSpace.getParameterNamesInAuthorativeOrder().get(this.i);
                    this.i = -this.i;
                    for (int j = -this.i + 1; j < ParameterConfiguration.this.activeParams.length; ++j) {
                        if (!ParameterConfiguration.this.activeParams[j]) continue;
                        this.i = j;
                        break;
                    }
                    if (this.i <= 0) {
                        this.i = ParameterConfiguration.this.valueArray.length;
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = 0;
                for (String ent : this) {
                    ++this.size;
                }
            }
            return this.size;
        }

        @Override
        public boolean contains(Object o) {
            Integer index = ParameterConfiguration.this.configSpace.getParamKeyIndexMap().get(o);
            if (index == null) {
                return false;
            }
            return ParameterConfiguration.this.activeParams[index];
        }
    }

    private class ParameterConfigurationEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private ParameterConfigurationEntrySet() {
        }

        @Override
        public int size() {
            return ParameterConfiguration.this.size();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                final int creationID;
                private int i;
                {
                    this.creationID = ParameterConfiguration.this.myID;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    if (ParameterConfiguration.this.isDirty || this.creationID != ParameterConfiguration.this.myID) {
                        throw new ConcurrentModificationException("Detected change to the parameter settings");
                    }
                    return this.i < ParameterConfigurationEntrySet.this.size();
                }

                @Override
                public Map.Entry<String, String> next() {
                    if (ParameterConfiguration.this.isDirty || this.creationID != ParameterConfiguration.this.myID) {
                        throw new ConcurrentModificationException("Detected change to the parameter settings");
                    }
                    String key = ParameterConfiguration.this.configSpace.getParameterNamesInAuthorativeOrder().get(this.i);
                    ++this.i;
                    return new AbstractMap.SimpleImmutableEntry<String, String>(key, ParameterConfiguration.this.get(key));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class ValueSetCollection
    extends AbstractCollection<String> {
        private ValueSetCollection() {
        }

        @Override
        public int size() {
            return ParameterConfiguration.this.size();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private int i = 0;
                final int creationID;
                {
                    this.creationID = ParameterConfiguration.this.myID;
                }

                @Override
                public boolean hasNext() {
                    if (ParameterConfiguration.this.isDirty || this.creationID != ParameterConfiguration.this.myID) {
                        throw new ConcurrentModificationException("Detected change to the parameter settings");
                    }
                    return this.i < ValueSetCollection.this.size();
                }

                @Override
                public String next() {
                    if (ParameterConfiguration.this.isDirty || this.creationID != ParameterConfiguration.this.myID) {
                        throw new ConcurrentModificationException("Detected change to the parameter settings");
                    }
                    if (this.i >= ValueSetCollection.this.size()) {
                        throw new NoSuchElementException();
                    }
                    return ParameterConfiguration.this.get(ParameterConfiguration.this.configSpace.getParameterNamesInAuthorativeOrder().get(this.i++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static enum ParameterStringFormat {
        NODB_SYNTAX("-", " ", "'", " ", true),
        NODB_SYNTAX_WITH_INDEX("-", " ", "'", " ", true),
        STATEFILE_SYNTAX(" ", "=", "'", ",", false),
        STATEFILE_SYNTAX_WITH_INDEX(" ", "=", "'", ",", false),
        STATEFILE_SYNTAX_NO_INACTIVE(" ", "=", "'", ",", true),
        SURROGATE_EXECUTOR("-P", "=", "", " ", true),
        ARRAY_STRING_SYNTAX("", "", "", "", false),
        ARRAY_STRING_MASK_INACTIVE_SYNTAX("", "", "", "", true),
        FIXED_WIDTH_ARRAY_STRING_SYNTAX("", "", "", "", false),
        FIXED_WIDTH_ARRAY_STRING_MASK_INACTIVE_SYNTAX("", "", "", "", true),
        NODB_OR_STATEFILE_SYNTAX("", "", "", "", true);

        private final String preKey;
        private final String keyValSeperator;
        private final String valDelimiter;
        private final String glue;
        private final boolean hideInactive;

        private ParameterStringFormat(String preKey, String keyValSeperator, String valDelimeter, String glue, boolean hideInactive) {
            this.preKey = preKey;
            this.keyValSeperator = keyValSeperator;
            this.valDelimiter = valDelimeter;
            this.glue = glue;
            this.hideInactive = hideInactive;
        }

        public boolean hideInactiveParameters() {
            return this.hideInactive;
        }

        public String getPreKey() {
            return this.preKey;
        }

        public String getGlue() {
            return this.glue;
        }

        public String getValueDelimeter() {
            return this.valDelimiter;
        }

        public String getKeyValueSeperator() {
            return this.keyValSeperator;
        }
    }
}

