/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.probleminstance;

import ca.ubc.cs.beta.aeatk.json.serializers.ProblemInstanceJson;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

@JsonSerialize(using=ProblemInstanceJson.ProblemInstanceSerializer.class)
@JsonDeserialize(using=ProblemInstanceJson.ProblemInstanceDeserializer.class)
public class ProblemInstance
implements Serializable {
    private static final long serialVersionUID = -2077458754749675377L;
    private final String instanceName;
    private final int instanceId;
    private final double[] featuresDouble;
    private final String instanceSpecificInformation;
    private final Map<String, Double> featuresMap;

    public ProblemInstance(String instanceName) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.instanceName = instanceName;
        this.instanceId = 0;
        this.featuresMap = Collections.emptyMap();
        this.featuresDouble = new double[0];
        this.instanceSpecificInformation = "0";
    }

    public ProblemInstance(String instanceName, String instanceSpecificInformation) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.instanceName = instanceName;
        this.instanceId = 0;
        this.featuresMap = Collections.emptyMap();
        this.featuresDouble = new double[0];
        if (instanceSpecificInformation == null || instanceSpecificInformation.trim().length() == 0) {
            instanceSpecificInformation = "0";
        }
        this.instanceSpecificInformation = instanceSpecificInformation;
    }

    public ProblemInstance(String instanceName, int id) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.instanceName = instanceName;
        this.instanceId = id;
        this.featuresMap = Collections.emptyMap();
        this.featuresDouble = new double[0];
        this.instanceSpecificInformation = "0";
    }

    public ProblemInstance(String instanceName, int id, Map<String, Double> features) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.instanceName = instanceName;
        this.instanceId = id;
        this.featuresMap = features;
        this.featuresDouble = new double[features.size()];
        int i = 0;
        for (Map.Entry<String, Double> ent : features.entrySet()) {
            this.featuresDouble[i++] = ent.getValue();
        }
        this.instanceSpecificInformation = "0";
    }

    public ProblemInstance(String instanceName, int id, Map<String, Double> features, String instanceSpecificInformation) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Instance name cannot be null");
        }
        this.instanceName = instanceName;
        this.instanceId = id;
        this.featuresMap = features;
        this.featuresDouble = new double[features.size()];
        int i = 0;
        for (Map.Entry<String, Double> ent : features.entrySet()) {
            this.featuresDouble[i++] = ent.getValue();
        }
        this.instanceSpecificInformation = instanceSpecificInformation == null ? "0" : instanceSpecificInformation;
    }

    public ProblemInstance(String instanceName, Map<String, Double> features, String instanceSpecificInformation) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.instanceName = instanceName;
        this.instanceId = 0;
        this.featuresMap = features;
        this.featuresDouble = new double[features.size()];
        int i = 0;
        for (Map.Entry<String, Double> ent : features.entrySet()) {
            this.featuresDouble[i++] = ent.getValue();
        }
        this.instanceSpecificInformation = instanceSpecificInformation == null ? "0" : instanceSpecificInformation;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProblemInstance) {
            ProblemInstance ai = (ProblemInstance)o;
            return this.instanceName.equals(ai.instanceName);
        }
        return false;
    }

    public int hashCode() {
        return this.instanceName.hashCode();
    }

    public String toString() {
        if (this.instanceId != 0) {
            return "Instance(" + this.instanceId + "):" + this.instanceName;
        }
        return "Instance:" + this.instanceName;
    }

    public int getInstanceID() {
        return this.instanceId;
    }

    public Map<String, Double> getFeatures() {
        return this.featuresMap;
    }

    public double[] getFeaturesDouble() {
        return (double[])this.featuresDouble.clone();
    }

    public String getInstanceSpecificInformation() {
        return this.instanceSpecificInformation;
    }
}

