/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.state.legacy;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.exceptions.StateSerializationException;
import ca.ubc.cs.beta.aeatk.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.runhistory.RunData;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.state.StateSerializer;
import ca.ubc.cs.beta.aeatk.state.legacy.LegacyStateFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyStateSerializer
implements StateSerializer {
    private RunHistory runHistory = null;
    private ParameterConfiguration incumbent;
    private final String id;
    private final int iteration;
    private final String path;
    private final LegacyStateFactory legacyStateFactory;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> savedFiles = new HashSet<String>();
    private Map<String, Serializable> objectState;

    LegacyStateSerializer(String path, String id, int iteration, LegacyStateFactory legacyStateFactory) {
        this.id = id;
        this.iteration = iteration;
        this.path = new File(path).getAbsolutePath();
        this.legacyStateFactory = legacyStateFactory;
    }

    @Override
    public void setRunHistory(RunHistory runHistory) {
        this.runHistory = runHistory;
    }

    @Override
    public void setIncumbent(ParameterConfiguration incumbent) {
        this.incumbent = incumbent;
    }

    @Override
    public void save() {
        File f;
        boolean fullSave = true;
        if (this.runHistory == null) {
            fullSave = false;
        }
        this.log.trace("State Serialization for iteration {} commencing", (Object)this.iteration);
        AutoStartStopWatch auto = new AutoStartStopWatch();
        if (this.runHistory != null) {
            try {
                f = new File(LegacyStateFactory.getUniqConfigurationsFilename(this.path, this.id, this.iteration));
                this.addFileToSet(f);
                this.log.trace("Unique Configurations Saved in {}", (Object)f.getAbsolutePath());
                FileWriter uniqConfigurations = new FileWriter(f);
                this.log.trace("Parameter Strings Saved in {}", (Object)f.getAbsolutePath());
                f = new File(LegacyStateFactory.getParamStringsFilename(this.path, this.id, this.iteration));
                this.addFileToSet(f);
                FileWriter paramStrings = new FileWriter(f);
                int i = 1;
                for (ParameterConfiguration config : this.runHistory.getAllParameterConfigurationsRan()) {
                    paramStrings.append(i + ":" + config.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.STATEFILE_SYNTAX) + "\n");
                    uniqConfigurations.append(i + ",").append(this.getStringFromConfiguration(config)).append("\n");
                    ++i;
                }
                paramStrings.close();
                uniqConfigurations.close();
                paramStrings = null;
                uniqConfigurations = null;
                f = new File(LegacyStateFactory.getRunAndResultsFilename(this.path, this.id, this.iteration));
                this.addFileToSet(f);
                this.log.trace("Run Results Saved in {}", (Object)f.getAbsolutePath());
                FileWriter runResults = new FileWriter(f);
                i = 0;
                double cumulativeSum = 0.0;
                runResults.append("Run Number").append(",");
                runResults.append("Run History Configuration ID").append(",");
                runResults.append("Instance ID").append(",");
                runResults.append("Response Value (y)").append(",");
                runResults.append("Censored?").append(",");
                runResults.append("Cutoff Time Used").append(",");
                runResults.append("Seed").append(",");
                runResults.append("Runtime").append(",");
                runResults.append("Run Length").append(",");
                runResults.append("Run Result Code").append(",");
                runResults.append("Run Quality").append(",");
                runResults.append("SMAC Iteration").append(",");
                runResults.append("SMAC Cumulative Runtime").append(",");
                runResults.append("Run Result").append(",");
                runResults.append("Additional Algorithm Run Data").append(",");
                runResults.append("Wall Clock Time").append(",");
                runResults.append("\n");
                for (RunData runData : this.runHistory.getAlgorithmRunDataIncludingRedundant()) {
                    Integer thetaIdx = runData.getThetaIdx();
                    Integer instanceIdx = runData.getInstanceidx();
                    Integer iteration = runData.getIteration();
                    AlgorithmRunResult run = runData.getRun();
                    runResults.append(++i + ",");
                    runResults.append(thetaIdx + ",");
                    runResults.append(instanceIdx + ",");
                    runResults.append(this.runHistory.getRunObjective().getObjective(run) + ",");
                    int isCensored = 0;
                    if (run.getRunStatus().equals((Object)RunStatus.TIMEOUT) && run.getAlgorithmRunConfiguration().hasCutoffLessThanMax() || run.getRunStatus().equals((Object)RunStatus.KILLED)) {
                        isCensored = 1;
                    }
                    runResults.append(isCensored + ",");
                    runResults.append(run.getAlgorithmRunConfiguration().getCutoffTime() + ",");
                    runResults.append(run.getResultSeed() + ",");
                    runResults.append(run.getRuntime() + ",");
                    runResults.append(run.getRunLength() + ",");
                    runResults.append(String.valueOf(run.getRunStatus().getResultCode()) + ",");
                    runResults.append(run.getQuality() + ",");
                    runResults.append(iteration + ",");
                    runResults.append((cumulativeSum += run.getRuntime()) + ",");
                    runResults.append(run.getRunStatus().name() + ",");
                    runResults.append(run.getAdditionalRunData() + ",");
                    runResults.append(run.getWallclockExecutionTime() + ",");
                    runResults.append("\n");
                    if (i % 100 != 0) continue;
                    runResults.flush();
                }
                runResults.close();
            }
            catch (IOException e) {
                throw new StateSerializationException(e);
            }
        }
        try {
            if (fullSave) {
                f = new File(LegacyStateFactory.getJavaObjectDumpFilename(this.path, this.id, this.iteration));
                if (!f.createNewFile()) {
                    throw new IllegalStateException("File: " + f.getAbsolutePath() + " already exists ");
                }
                this.saveToFile(f);
                this.addFileToSet(f);
            } else {
                File currentFile = new File(LegacyStateFactory.getJavaQuickObjectDumpFilename(this.path, this.id, this.iteration));
                File oldFile = new File(LegacyStateFactory.getJavaQuickBackObjectDumpFilename(this.path, this.id, this.iteration));
                if (currentFile.exists()) {
                    if (oldFile.exists()) {
                        oldFile.delete();
                    }
                    if (!currentFile.renameTo(oldFile)) {
                        throw new IllegalStateException("Could not rename file " + currentFile.getAbsolutePath() + " to " + oldFile.getAbsolutePath());
                    }
                    currentFile = new File(LegacyStateFactory.getJavaQuickObjectDumpFilename(this.path, this.id, this.iteration));
                }
                this.saveToFile(currentFile);
            }
        }
        catch (IOException e) {
            throw new StateSerializationException(e);
        }
        this.legacyStateFactory.addWrittenFilesForIteration(this.iteration, this.savedFiles);
        this.log.debug("State saved for iteration {} in {} ", (Object)this.iteration, (Object)this.path);
        this.log.debug("Saving state took {} ms", (Object)auto.stop());
    }

    private void saveToFile(File f) throws IOException {
        HashMap<String, Object> mapToWrite = new HashMap<String, Object>();
        mapToWrite.put("OBJECT_MAP_KEY", this.objectState);
        mapToWrite.put("ITERATION_KEY", this.iteration);
        ObjectOutputStream oWriter = new ObjectOutputStream(new FileOutputStream(f));
        if (this.incumbent != null) {
            mapToWrite.put("INCUMBENT_TEXT_KEY", this.incumbent.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.STATEFILE_SYNTAX));
        }
        oWriter.writeObject(mapToWrite);
        oWriter.close();
        this.log.trace("Java Object Dump Saved in {}", (Object)f.getAbsolutePath());
    }

    public String getStringFromConfiguration(ParameterConfiguration config) {
        return config.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.ARRAY_STRING_SYNTAX);
    }

    private void addFileToSet(File f) {
        this.savedFiles.add(f.getAbsolutePath());
    }

    @Override
    public void setObjectStateMap(Map<String, Serializable> objectState) {
        this.objectState = objectState;
    }
}

