/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ResultOrderCorrectCheckerTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    public ResultOrderCorrectCheckerTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        List<AlgorithmRunResult> runs = this.tae.evaluateRun(Collections.unmodifiableList(runConfigs), obs);
        this.runOrderIsConsistent(runConfigs, runs);
        return runs;
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback callback = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                try {
                    ResultOrderCorrectCheckerTargetAlgorithmEvaluatorDecorator.this.runOrderIsConsistent(runConfigs, runs);
                    handler.onSuccess(runs);
                }
                catch (RuntimeException e) {
                    handler.onFailure(e);
                }
            }

            @Override
            public void onFailure(RuntimeException t) {
                handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(Collections.unmodifiableList(runConfigs), callback, obs);
    }

    private void runOrderIsConsistent(List<AlgorithmRunConfiguration> runConfigs, List<AlgorithmRunResult> runs) {
        if (runConfigs.size() != runs.size()) {
            throw new IllegalStateException("TAE did not return the correct sized results, submitted: " + runConfigs.size() + " got back: " + runs.size());
        }
        for (int i = 0; i < runConfigs.size(); ++i) {
            if (runs.get(i).getAlgorithmRunConfiguration().equals(runConfigs.get(i))) continue;
            throw new IllegalStateException("TAE did not return results in the correct order entry (" + i + ") was RunConfig: " + runConfigs.get(i) + " but the resulting run was :" + runs.get(i).getAlgorithmRunConfiguration());
        }
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

