/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.watchdog;

import ca.ubc.cs.beta.aeatk.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aeatk.misc.jcommander.validator.FixedPositiveInteger;
import ca.ubc.cs.beta.aeatk.misc.jcommander.validator.NonNegativeInteger;
import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.watchdog.LiveThreadWatchDog;
import ca.ubc.cs.beta.aeatk.watchdog.NullThreadWatchDog;
import ca.ubc.cs.beta.aeatk.watchdog.ThreadWatchDog;
import com.beust.jcommander.Parameter;

@UsageTextField(title="Thread Watch Dog Options", description="Options that control a thread that monitors the liveness of the application ")
public class ThreadWatchDogOptions
extends AbstractOptions {
    @Parameter(names={"--watchdog-enable"}, description="Enable Watchdog")
    public boolean watchDog = false;
    @Parameter(names={"--watchdog-last-event-delay"}, description="How long in seconds since the last event before we detect a problem", validateWith=NonNegativeInteger.class, hidden=true)
    public int lastEventDelay = 3600;
    @Parameter(names={"--watchdog-delay-between-checks"}, description="How often in seconds we should check if there is a problem", validateWith=FixedPositiveInteger.class, hidden=true)
    public int delayBetweenChecks = 600;
    @Parameter(names={"--watchdog-delay-before-shutdown"}, description="If we detect a problem how long (in seconds) after before we shutdown", validateWith=NonNegativeInteger.class, hidden=true)
    public int delayBeforeShutdown = 600;
    @Parameter(names={"--watchdog-log-thread-activity"}, description="How often to log the thread activity")
    public int logThreadActivity = 300;

    public ThreadWatchDog<? extends AutomaticConfiguratorEvent> getWatchDog() {
        if (this.watchDog) {
            return new LiveThreadWatchDog(this.lastEventDelay, this.delayBetweenChecks, this.delayBeforeShutdown, this.logThreadActivity);
        }
        return new NullThreadWatchDog();
    }

    public <K extends AutomaticConfiguratorEvent> ThreadWatchDog<K> getWatchDog(Class<K> t) {
        if (this.watchDog) {
            return new LiveThreadWatchDog(this.lastEventDelay, this.delayBetweenChecks, this.delayBeforeShutdown, this.logThreadActivity);
        }
        return new NullThreadWatchDog();
    }
}

