/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import weka.attributeSelection.AttributeSelection;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class ClassifierResult {
    public static final double INFINITY = 1.0E100;
    private double mRawScore;
    private double mTrainingTime = 0.0;
    private double mEvaluationTime = 0.0;
    private double mAttributeSelectionTime = 0.0;
    private double mRegularizationPlenalty = 0.0;
    private boolean mCompleted = false;
    private AbstractClassifier mClassifier = null;
    private AttributeSelection mAttributeSelection = null;
    private Metric mMetric = null;
    private double mPercentEvaluated = 0.0;
    private boolean mMemOut;

    public static double getInfinity() {
        if (System.getProperty("autoweka.infinity") != null) {
            return Double.parseDouble(System.getProperty("autoweka.infinity"));
        }
        return 1.0E100;
    }

    private static Metric getMetricFromString(String className) {
        className = className.trim();
        String metricName = "autoweka.ClassifierResult$" + className.substring(0, 1).toUpperCase() + className.substring(1) + "Metric";
        try {
            Class<?> cls = Class.forName(metricName);
            return (Metric)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class '" + metricName + "'", e);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            throw new RuntimeException("Failed to instantiate '" + metricName + "'", e);
        }
    }

    public ClassifierResult(String str) {
        this(ClassifierResult.getMetricFromString(str));
    }

    public ClassifierResult(Metric type) {
        this.mMetric = type;
        this.mRawScore = this.mMetric.getDefault();
    }

    public boolean getCompleted() {
        return this.mCompleted;
    }

    public void setCompleted(boolean completed) {
        this.mCompleted = completed;
    }

    public double getRawScore() {
        return this.mRawScore;
    }

    public void setScoreFromEval(Evaluation eval, Instances testingData) {
        this.mRawScore = this.mMetric.getScore(eval, testingData);
        if (Double.isInfinite(this.mRawScore)) {
            this.mRawScore = ClassifierResult.getInfinity();
        }
        if (this.mRawScore > ClassifierResult.getInfinity()) {
            System.err.println("Score larger than our definition of infinity, adjusting.");
            this.mRawScore = ClassifierResult.getInfinity() - 1.0;
        }
        this.setPercentEvaluated(eval);
    }

    public void setPercentEvaluated(Evaluation eval) {
        this.mPercentEvaluated = 100.0 * (1.0 - eval.unclassified() / eval.numInstances());
    }

    public void setPercentEvaluated(double pct) {
        this.mPercentEvaluated = pct;
    }

    public double getPercentEvaluated() {
        return this.mPercentEvaluated;
    }

    public void _setRawScore(double score) {
        this.mRawScore = score;
    }

    public double getNormalizationPenalty() {
        return this.mRegularizationPlenalty;
    }

    public void setRegularizationPenalty(double penalty) {
        this.mRegularizationPlenalty = penalty;
    }

    public double getTrainingTime() {
        return this.mTrainingTime;
    }

    public void setTrainingTime(double time) {
        this.mTrainingTime = time;
    }

    public double getAttributeSelectionTime() {
        return this.mAttributeSelectionTime;
    }

    public void setAttributeSelectionTime(double time) {
        this.mAttributeSelectionTime = time;
    }

    public double getEvaluationTime() {
        return this.mTrainingTime;
    }

    public void setEvaluationTime(double time) {
        this.mEvaluationTime = time;
    }

    public double getTime() {
        return this.mAttributeSelectionTime + this.mTrainingTime + this.mEvaluationTime;
    }

    public double getScore() {
        double score = this.mRegularizationPlenalty + this.mRawScore;
        return Double.isNaN(score) ? this.mMetric.getDefault() : score;
    }

    public String getDescription() {
        return "Attribute Selection Time: " + this.mAttributeSelectionTime + " Training Time: " + this.mTrainingTime + " Evaluation Time: " + this.mEvaluationTime + " Score: " + this.getScore() + " Completed: " + this.mCompleted;
    }

    public void setClassifier(AbstractClassifier cls) {
        this.mClassifier = cls;
    }

    public AbstractClassifier getClassifier() {
        return this.mClassifier;
    }

    public void setAttributeSelection(AttributeSelection search) {
        this.mAttributeSelection = search;
    }

    public AttributeSelection getAttributeSelection() {
        return this.mAttributeSelection;
    }

    public void setMemOut(boolean memout) {
        this.mMemOut = memout;
    }

    public boolean getMemOut() {
        return this.mMemOut;
    }

    public static class WeightedTruePositiveRateMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.weightedTruePositiveRate();
        }
    }

    public static class WeightedTrueNegativeRateMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.weightedTrueNegativeRate();
        }
    }

    public static class WeightedRecallMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.weightedRecall();
        }
    }

    public static class WeightedPrecisionMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.weightedPrecision();
        }
    }

    public static class WeightedFMeasureMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.weightedFMeasure();
        }
    }

    public static class WeightedFalsePositiveRateMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.weightedFalsePositiveRate();
        }
    }

    public static class WeightedFalseNegativeRateMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.weightedFalseNegativeRate();
        }
    }

    public static class WeightedAreaUnderROCMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.weightedAreaUnderROC();
        }
    }

    public static class PrecisionMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.precision(1);
        }
    }

    public static class PctIncorrectMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.pctIncorrect();
        }
    }

    public static class PctCorrectMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.pctCorrect();
        }
    }

    public static class KBRelativeInformationMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            try {
                return -eval.KBRelativeInformation();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class KBMeanInformationMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            try {
                return -eval.KBMeanInformation();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class KBInformationMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            try {
                return -eval.KBInformation();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class KappaMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.kappa();
        }
    }

    public static class FMeasureMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.fMeasure(1);
        }
    }

    public static class FalsePositiveRateMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.falsePositiveRate(1);
        }
    }

    public static class FalseNegativeRateMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.falseNegativeRate(1);
        }
    }

    public static class CorrelationCoefficientMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            try {
                return -eval.correlationCoefficient();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class IncorrectMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.incorrect();
        }
    }

    public static class CorrectMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.correct();
        }
    }

    public static class AvgCostMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.avgCost();
        }
    }

    public static class AreaUnderROCMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return -eval.areaUnderROC(1);
        }
    }

    public static class AreaAboveROCMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return 1.0 - eval.areaUnderROC(1);
        }
    }

    public static class RootRelativeSquaredErrorMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.rootRelativeSquaredError();
        }
    }

    public static class RelativeAbsoluteErrorMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            try {
                return eval.relativeAbsoluteError();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class RootMeanSquaredErrorMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.rootMeanSquaredError();
        }
    }

    public static class MeanAbsoluteErrorMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.meanAbsoluteError();
        }
    }

    public static class ErrorRateMetric
    implements Metric {
        @Override
        public double getDefault() {
            return ClassifierResult.getInfinity();
        }

        @Override
        public double getScore(Evaluation eval, Instances testingData) {
            return eval.errorRate();
        }
    }

    public static interface Metric {
        public double getDefault();

        public double getScore(Evaluation var1, Instances var2);
    }
}

