/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.XmlSerializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="configuration")
public class Configuration
extends XmlSerializable
implements Comparable {
    @XmlElement(name="argStrings")
    private String mArgStrings;
    @XmlElement(name="evaluatedScore")
    private double mEvaluatedScore;
    @XmlElement(name="evaluatedFold")
    private int mEvaluatedFold;
    @XmlElement(name="folds")
    private ArrayList<String> mFolds = new ArrayList();
    @XmlElement(name="scores")
    private ArrayList<String> mScores = new ArrayList();
    @XmlElement(name="avgScore")
    private double mAverageScore;
    @XmlElement(name="amtScores")
    private int mAmtScores;
    @XmlElement(name="amtFolds")
    private int mAmtFolds;
    @XmlElement(name="avgFlag")
    private boolean averagedFlag = false;

    public Configuration() {
    }

    public Configuration(List<String> argsList) {
        this();
        this.mArgStrings = "";
        for (String s : argsList) {
            this.mArgStrings = this.mArgStrings + s + " ";
        }
    }

    public Configuration(String args) {
        this();
        this.mArgStrings = args;
    }

    public void mergeWith(Configuration c) {
        if (c.hashCode() != this.hashCode()) {
            throw new RuntimeException("Not equivalent configurations!");
        }
        if (c.mFolds != null) {
            for (String fold : c.mFolds) {
                this.mFolds.add(fold);
                ++this.mAmtFolds;
            }
        }
        if (c.mFolds != null) {
            for (String score : c.mScores) {
                this.mScores.add(score);
                this.averagedFlag = false;
                ++this.mAmtScores;
            }
        }
    }

    public void lazyUpdateAverage() {
        if (!this.averagedFlag) {
            this.mAverageScore = this.average(this.mScores);
            this.averagedFlag = true;
        }
    }

    public void forceUpdateAverage() {
        this.mAverageScore = this.average(this.mScores);
        this.averagedFlag = true;
    }

    private double average(List<String> l) {
        double sum = 0.0;
        for (String d : l) {
            sum += Double.parseDouble(d);
        }
        return sum / (double)l.size();
    }

    public int compareTo(Object aTarget) {
        if (!(aTarget instanceof Configuration)) {
            throw new RuntimeException("Comparing Configuration to another type!");
        }
        Configuration cTarget = (Configuration)aTarget;
        this.lazyUpdateAverage();
        cTarget.lazyUpdateAverage();
        if (this.mFolds.size() > cTarget.mFolds.size()) {
            return 1;
        }
        if (this.mFolds.size() < cTarget.mFolds.size()) {
            return -1;
        }
        if (this.mAverageScore < cTarget.mAverageScore) {
            return 1;
        }
        if (this.mAverageScore > cTarget.mAverageScore) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        String strFolds = "[";
        for (String fold : this.mFolds) {
            strFolds = strFolds + fold.toString() + "/";
        }
        strFolds = strFolds + "]";
        return Integer.toString(this.hashCode()) + "," + Double.toString(this.mEvaluatedScore) + "," + strFolds;
    }

    public int hashCode() {
        return this.mArgStrings.hashCode();
    }

    public void setEvaluationValues(double aScore, int aFoldId) {
        this.mEvaluatedScore = aScore;
        this.mEvaluatedFold = aFoldId;
        if (this.mFolds == null) {
            this.mFolds = new ArrayList();
        }
        if (this.mScores == null) {
            this.mScores = new ArrayList();
        }
        this.mFolds.add(Integer.toString(aFoldId));
        this.mScores.add(Double.toString(aScore));
        ++this.mAmtFolds;
        ++this.mAmtScores;
        this.mAverageScore = this.average(this.mScores);
    }

    public void setScore(double aScore) {
        this.mEvaluatedScore = aScore;
        if (this.mScores == null) {
            this.mScores = new ArrayList();
        }
        this.mScores.add(Double.toString(aScore));
        ++this.mAmtScores;
    }

    public void setFoldId(int aFoldId) {
        this.mEvaluatedFold = aFoldId;
        if (this.mFolds == null) {
            this.mFolds = new ArrayList();
        }
        this.mFolds.add(Integer.toString(aFoldId));
        ++this.mAmtFolds;
    }

    public double getAverageScore() {
        this.lazyUpdateAverage();
        return this.mAverageScore;
    }

    public int getEvaluationAmount() {
        return this.mScores.size();
    }

    public double getEvaluatedScore() {
        return this.mEvaluatedScore;
    }

    public int getEvaluatedFold() {
        return this.mEvaluatedFold;
    }

    public int getAmtFolds() {
        return this.mAmtFolds;
    }

    public String getArgStrings() {
        return this.mArgStrings;
    }

    public List<String> getFolds() {
        return this.mFolds;
    }

    public List<String> getScores() {
        return this.mScores;
    }
}

