/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.TrajectoryParser;
import autoweka.Util;
import autoweka.XmlSerializable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="experiment")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Experiment
extends XmlSerializable {
    static final transient Logger log = LoggerFactory.getLogger(Experiment.class);
    @XmlElement(name="name")
    public String name;
    @XmlElement(name="type")
    public String type;
    @XmlElement(name="resultMetric")
    public String resultMetric = "errorRate";
    @XmlElement(name="instanceGenerator")
    public String instanceGenerator;
    @XmlElement(name="instanceGeneratorArgs")
    public String instanceGeneratorArgs;
    @XmlElement(name="datasetString")
    public String datasetString;
    @XmlElement(name="attributeSelection")
    public boolean attributeSelection = false;
    @XmlElement(name="attributeSelectionTimeout")
    public float attributeSelectionTimeout = -1.0f;
    @XmlElement(name="trajectoryParserClass")
    public String trajectoryParserClassName;
    @XmlElement(name="callString")
    public List<String> callString = new ArrayList<String>();
    @XmlElement(name="envVariables")
    public List<String> envVariables = new ArrayList<String>();
    @XmlElement(name="tunerTimeout")
    public float tunerTimeout = -1.0f;
    @XmlElement(name="trainTimeout")
    public float trainTimeout = -1.0f;
    @XmlElement(name="memory")
    public String memory;
    @XmlElement(name="extraProps")
    public String extraPropsString;
    @XmlElement(name="allowedClassifiers")
    public List<String> allowedClassifiers = new ArrayList<String>();
    @XmlElement(name="trajectoryPointExtras")
    public List<TrajectoryPointExtra> trajectoryPointExtras = new ArrayList<TrajectoryPointExtra>();

    public void validate() {
        if (this.name == null) {
            throw new RuntimeException("No experiment -name was defined!");
        }
        if (this.trainTimeout < 0.0f) {
            throw new RuntimeException("Need a -trainTimeout > 0!");
        }
        if (this.tunerTimeout < 0.0f) {
            throw new RuntimeException("Need a -tunerTimeout > 0!");
        }
        if (this.datasetString == null) {
            throw new RuntimeException("Need a -datasetString for the zipfile!");
        }
        if (this.instanceGenerator == null) {
            throw new RuntimeException("Need an -instanceGenerator");
        }
        if (this.attributeSelection && this.attributeSelectionTimeout < 0.0f) {
            throw new RuntimeException("Need a -attributeSelectionTimeout > 0 since attribute selection is on!");
        }
    }

    public static Experiment fromXML(String filename) {
        return XmlSerializable.fromXML(filename, Experiment.class);
    }

    public static Experiment fromXML(InputStream xml) {
        return XmlSerializable.fromXML(xml, Experiment.class);
    }

    public static void main(String[] args) {
        File experiment = null;
        String seed = null;
        boolean noExit = false;
        File expFolder = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-noexit")) {
                noExit = true;
                continue;
            }
            if (experiment == null) {
                expFolder = new File(args[i]).getAbsoluteFile();
                experiment = new File(URLDecoder.decode(expFolder.getAbsolutePath()) + File.separator + expFolder.getName() + ".experiment");
                continue;
            }
            if (seed == null) {
                seed = args[i];
                continue;
            }
            throw new RuntimeException("Unknown arg: " + args[i]);
        }
        if (experiment == null || seed == null) {
            throw new RuntimeException("Need to be run with an experiment and a seed");
        }
        try {
            String line;
            Experiment exp = Experiment.fromXML(new FileInputStream(experiment));
            for (int i = 0; i < exp.callString.size(); ++i) {
                exp.callString.set(i, exp.callString.get(i).replace("{SEED}", seed));
                log.debug("{}", (Object)exp.callString.get(i));
            }
            File executable = Util.findExecutableOnPath(exp.callString.get(0));
            if (executable == null) {
                throw new RuntimeException("Failed to find the executable '" + exp.callString.get(0) + "'");
            }
            exp.callString.set(0, URLDecoder.decode(executable.getAbsolutePath()));
            ProcessBuilder pb = new ProcessBuilder(exp.callString);
            pb.directory(experiment.getParentFile());
            pb.redirectErrorStream(true);
            Map<String, String> env = pb.environment();
            if (exp.envVariables != null) {
                for (String s : exp.envVariables) {
                    log.debug(s);
                    String[] var = s.split("=", 2);
                    env.put(var[0], var[1]);
                }
            }
            env.put("AUTOWEKA_EXPERIMENT_SEED", seed);
            Util.makePath(experiment.getParentFile() + File.separator + "out" + File.separator + "logs");
            Util.makePath(experiment.getParentFile() + File.separator + "out" + File.separator + "runstamps");
            File stampFile = new File(experiment.getParentFile() + File.separator + "out" + File.separator + "runstamps" + File.separator + seed + ".stamp");
            stampFile.createNewFile();
            stampFile.deleteOnExit();
            Process proc = pb.start();
            Runtime.getRuntime().addShutdownHook(new Util.ProcessKillerShutdownHook(proc));
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedWriter logOutput = new BufferedWriter(new FileWriter(experiment.getParentFile() + File.separator + "out" + File.separator + "logs" + File.separator + seed + ".log"));
            while ((line = reader.readLine()) != null) {
                if (line.matches(".*Result for ParamILS:.*")) {
                    log.debug(line);
                } else if (line.matches(".*autoweka.smac.SMACWrapper.*")) {
                    log.debug(line);
                } else if (line.matches(".*Sample call for new incumbent.*")) {
                    log.debug(line);
                } else if (line.matches(".*DEBUG.*")) {
                    log.debug(line);
                } else if (line.matches(".*INFO.*")) {
                    log.info(line);
                } else if (line.matches(".*WARN.*")) {
                    log.warn(line);
                } else if (line.matches(".*ERROR.*")) {
                    log.error(line);
                } else if (line.matches(".*Estimated mean quality of final incumbent config.*")) {
                    System.out.println(line);
                } else {
                    log.info(line);
                }
                logOutput.write(line + "\n");
                logOutput.flush();
            }
            TrajectoryParser.main(new String[]{"-single", URLDecoder.decode(expFolder.getAbsolutePath()), seed});
            if (!noExit) {
                System.exit(proc.waitFor());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            System.exit(1);
        }
    }

    public static Experiment createFromFolder(File folder) {
        File experiment = new File(URLDecoder.decode(folder.getAbsolutePath()) + File.separator + folder.getName() + ".experiment");
        try {
            return Experiment.fromXML(new FileInputStream(experiment));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @XmlRootElement(name="trajpointextra")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class TrajectoryPointExtra {
        @XmlElement(name="name")
        public String name;
        @XmlElement(name="instance")
        public String instance;

        public TrajectoryPointExtra() {
        }

        public TrajectoryPointExtra(String _name, String _instance) {
            this.name = _name;
            this.instance = _instance;
        }
    }
}

