/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.ClassParams;
import autoweka.ListExperimentConstructor;
import autoweka.Parameter;
import autoweka.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;

public class GridSearchExperimentConstructor
extends ListExperimentConstructor {
    private int mNumGridPoints = 3;

    public GridSearchExperimentConstructor() {
        this.mExperimentPath = "./gridsearch";
        this.mIncludeMeta = false;
        this.mIncludeEnsemble = false;
    }

    @Override
    public void addArgStrings() {
        for (ClassParams params : this.mClassifierParams) {
            this.addGridSearchPoints(params);
        }
    }

    @Override
    protected void processArg(String arg, Queue<String> args) {
        if (arg.equals("-numPoints")) {
            this.mNumGridPoints = Integer.parseInt(args.poll());
        }
    }

    protected void addGridSearchPoints(ClassParams classParams) {
        ArrayList<List<String>> argPoints = new ArrayList<List<String>>();
        ArrayList<Parameter> params = classParams.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            argPoints.add(((Parameter)params.get(i)).getDiscretization(this.mNumGridPoints));
        }
        HashSet<String> argStrings = new HashSet<String>();
        for (List<String> args : Util.cartesianProduct(argPoints)) {
            HashMap<String, String> argMap = new HashMap<String, String>();
            argMap.put("targetclass", classParams.getTargetClass());
            for (int i = 0; i < params.size(); ++i) {
                argMap.put(((Parameter)params.get((int)i)).name, args.get(i));
            }
            argStrings.add(Util.argMapToString(Util.removeHidden(classParams.filterParams(argMap))));
        }
        for (String s : argStrings) {
            this.mExperiment.argStrings.add(s);
        }
    }
}

