/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public abstract class InstanceGenerator {
    static final Logger log = LoggerFactory.getLogger(InstanceGenerator.class);
    private Instances mTraining = null;
    private Instances mTesting = null;

    public InstanceGenerator(InstanceGenerator generator) {
        this.mTraining = new Instances(generator.mTraining);
        this.mTesting = new Instances(generator.mTesting);
    }

    public InstanceGenerator(Instances training, Instances testing) {
        this.mTraining = training;
        this.mTesting = testing;
    }

    public InstanceGenerator(String datasetString) {
        if (datasetString.equals("__dummy__")) {
            this.mTraining = Util.createDummyInstances(50, 2, 1, 0, 0, 0, 0, 0);
            this.mTesting = Util.createDummyInstances(50, 2, 1, 0, 0, 0, 0, 1);
        } else {
            Properties props;
            try {
                props = Util.parsePropertyString(datasetString);
            }
            catch (Exception e) {
                log.warn("It looks like you're using an old experiment that doesn't indicate the type of dataset that it is using");
                this.loadZipFile(datasetString, "last");
                return;
            }
            String type = props.getProperty("type");
            if (type == null) {
                throw new RuntimeException("Dataset string does not contain a type");
            }
            if (type.equals("zipFile")) {
                this.loadZipFile(props.getProperty("zipFile"), props.getProperty("classIndex", "last"));
            } else if (type.equals("trainTestArff")) {
                this.loadTrainTestArff(props.getProperty("trainArff"), props.getProperty("testArff"), props.getProperty("classIndex", "last"));
            } else {
                throw new RuntimeException("Unhandled type data set type '" + type + "'");
            }
        }
    }

    private void loadZipFile(String zipFileName, String classIndex) {
        InputStream trainSource = null;
        InputStream testSource = null;
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.equals("train.arff")) {
                    trainSource = zipFile.getInputStream(entry);
                    continue;
                }
                if (name.equals("test.arff")) {
                    testSource = zipFile.getInputStream(entry);
                    continue;
                }
                throw new RuntimeException("Unknown file in zip dataset '" + name + "'");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Operation failed", e);
        }
        try {
            this.mTraining = Util.loadDataSource(trainSource);
            if (this.mTraining.classIndex() == -1) {
                if (classIndex.equals("last")) {
                    this.mTraining.setClassIndex(this.mTraining.numAttributes() - 1);
                } else {
                    this.mTraining.setClassIndex(Integer.parseInt(classIndex));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load training data provided in zip", e);
        }
        try {
            this.mTesting = Util.loadDataSource(testSource);
            if (this.mTesting.classIndex() == -1) {
                if (classIndex.equals("last")) {
                    this.mTesting.setClassIndex(this.mTesting.numAttributes() - 1);
                } else {
                    this.mTesting.setClassIndex(Integer.parseInt(classIndex));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load testing data provided in zip", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadTrainTestArff(String trainArff, String testArff, String classIndex) {
        try {
            this.mTraining = Util.loadDataSource(new FileInputStream(trainArff));
            if (this.mTraining.classIndex() == -1) {
                if (classIndex.equals("last")) {
                    this.mTraining.setClassIndex(this.mTraining.numAttributes() - 1);
                } else {
                    this.mTraining.setClassIndex(Integer.parseInt(classIndex));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to open training arff", e);
        }
        if (!testArff.equals("__dummy__")) {
            try {
                this.mTesting = Util.loadDataSource(new FileInputStream(testArff));
                if (this.mTesting.classIndex() != -1) return;
                if (classIndex.equals("last")) {
                    this.mTesting.setClassIndex(this.mTesting.numAttributes() - 1);
                    return;
                }
                this.mTesting.setClassIndex(Integer.parseInt(classIndex));
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open testing arff", e);
            }
        } else {
            this.mTesting = this.mTraining;
        }
    }

    public final Instances getTrainingFromParams(String params) {
        if (params.equals("default")) {
            return this.getTraining();
        }
        return this._getTrainingFromParams(params);
    }

    public final Instances getTestingFromParams(String params) {
        if (params.equals("default")) {
            return this.getTesting();
        }
        return this._getTestingFromParams(params);
    }

    public abstract Instances _getTrainingFromParams(String var1);

    public abstract Instances _getTestingFromParams(String var1);

    public Instances getTraining() {
        return new Instances(this.mTraining);
    }

    public Instances getTesting() {
        return new Instances(this.mTesting);
    }

    public abstract List<String> getAllInstanceStrings(String var1);

    public Map<String, Map<String, String>> getAllInstanceFeatures(String params) {
        HashMap<String, Map<String, String>> feats = new HashMap<String, Map<String, String>>();
        List<String> instanceNames = this.getAllInstanceStrings(params);
        for (String name : instanceNames) {
            feats.put(name, new HashMap());
        }
        return feats;
    }

    public static InstanceGenerator create(String className, String datasetFileName) {
        if (className == null || className.isEmpty() || className.equals("null")) {
            log.warn("No instance generator set, using default");
            className = "autoweka.instancegenerators.Default";
        }
        try {
            className = className.trim();
            Class<?> cls = Class.forName(className);
            return (InstanceGenerator)cls.getDeclaredConstructor(String.class).newInstance(datasetFileName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class '" + className + "': " + e, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate '" + className + "': " + e, e);
        }
    }

    public static InstanceGenerator create(String className, Instances training, Instances testing) {
        if (className == null || className.isEmpty() || className.equals("null")) {
            log.warn("No instance generator set, using default");
            className = "autoweka.instancegenerators.Default";
        }
        try {
            className = className.trim();
            Class<?> cls = Class.forName(className);
            return (InstanceGenerator)cls.getDeclaredConstructor(Instances.class, Instances.class).newInstance(training, testing);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class '" + className + "': " + e, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate '" + className + "': " + e, e);
        }
    }

    public static class NestedArgs {
        public String current;
        public String child;
        public String instance;

        public NestedArgs(String params) {
            List<String> args = Util.splitNestedString(params, "[$]", 2, 0);
            this.current = args.get(0);
            this.child = args.get(1);
            this.instance = args.get(2);
        }

        public NestedArgs(String current, String child, String instance) {
            this.current = current;
            this.child = child;
            this.instance = instance;
        }

        public String toString() {
            return Util.joinStrings("[$]", this.current, this.child, this.instance);
        }
    }
}

