/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.ApplicabilityTester;
import autoweka.ClassParams;
import autoweka.Experiment;
import autoweka.ExperimentBatch;
import autoweka.InstanceGenerator;
import autoweka.ListExperiment;
import autoweka.ListExperimentBatch;
import autoweka.Util;
import autoweka.XmlSerializable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public abstract class ListExperimentConstructor {
    static final Logger log = LoggerFactory.getLogger(ListExperimentConstructor.class);
    protected String mParamBaseDir = "./params";
    protected ArrayList<ClassParams> mClassifierParams = new ArrayList();
    protected ArrayList<Experiment.TrajectoryPointExtra> mTrajectoryPointExtras = new ArrayList();
    protected boolean mIncludeBase = true;
    protected boolean mIncludeMeta = true;
    protected boolean mIncludeEnsemble = true;
    protected String mExperimentPath = null;
    protected ListExperiment mExperiment = null;
    protected Properties mProperties = null;
    protected InstanceGenerator mInstanceGenerator = null;

    public static void main(String[] args) {
        if (args[0].equals("-batch") || new File(args[0]).isFile()) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) continue;
                ListExperimentConstructor.generateBatches(args[i]);
            }
        } else {
            LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
            String constructorName = argList.poll();
            ListExperiment exp = new ListExperiment();
            XmlSerializable.populateObjectFromCMDParams((Object)exp, argList);
            ListExperimentConstructor.buildSingle(constructorName, exp, argList);
        }
    }

    public static void generateBatches(String xmlFileName) {
        try {
            ListExperimentBatch batch = ListExperimentBatch.fromXML(xmlFileName);
            for (ListExperimentBatch.ListExperimentComponent expComp : batch.mExperiments) {
                for (ExperimentBatch.DatasetComponent datasetComp : batch.mInstances) {
                    ListExperiment exp = ListExperimentBatch.createListExperiment(expComp, datasetComp);
                    ListExperimentConstructor.buildSingle(expComp.constructor, exp, expComp.constructorArgs);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException("Failed to create batch for " + xmlFileName);
        }
    }

    public static void buildSingle(String builderClassName, ListExperiment exp, List<String> args) {
        ListExperimentConstructor builder;
        exp.validate();
        log.info("Making Experiment {}", (Object)exp.name);
        try {
            Class<?> cls = Class.forName(builderClassName);
            builder = (ListExperimentConstructor)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class '" + builderClassName + "': " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate '" + builderClassName + "': " + e.getMessage(), e);
        }
        builder.run(exp, new LinkedList<String>(args));
    }

    private void run(ListExperiment exp, List<String> args) {
        this.mExperiment = exp;
        LinkedList<String> argQueue = new LinkedList<String>(args);
        while (!args.isEmpty()) {
            String arg = (String)argQueue.poll();
            if (arg.equals("-nometa")) {
                this.mIncludeMeta = false;
                continue;
            }
            if (arg.equals("-noensemble")) {
                this.mIncludeEnsemble = false;
                continue;
            }
            if (arg.equals("-experimentpath")) {
                this.mExperimentPath = (String)argQueue.poll();
                continue;
            }
            this.processArg(arg, argQueue);
        }
        if (this.mExperimentPath == null) {
            throw new RuntimeException("No experiment path set");
        }
        if (exp.resultMetric == null) {
            throw new RuntimeException("No Result Metric defined");
        }
        this.mInstanceGenerator = InstanceGenerator.create(this.mExperiment.instanceGenerator, this.mExperiment.datasetString);
        this.loadClassifiers();
        Util.makePath(this.mExperimentPath + File.separator + this.mExperiment.name);
        this.mExperiment.argStrings = new ArrayList();
        this.addArgStrings();
        this.mExperiment.trajectoryPointExtras = this.mTrajectoryPointExtras;
        this.mExperiment.toXML(this.mExperimentPath + File.separator + this.mExperiment.name + File.separator + this.mExperiment.name + ".listexperiment");
    }

    protected void processArg(String arg, Queue<String> args) {
    }

    protected abstract void addArgStrings();

    protected void loadClassifiers() {
        Instances instances = this.mInstanceGenerator.getTraining();
        ApplicabilityTester.ApplicableClassifiers app = ApplicabilityTester.getApplicableClassifiers(instances, this.mParamBaseDir, null);
        if (this.mIncludeBase) {
            this.mClassifierParams.addAll(app.base);
        }
        if (this.mIncludeMeta) {
            this.mClassifierParams.addAll(app.meta);
        }
        if (this.mIncludeEnsemble) {
            this.mClassifierParams.addAll(app.ensemble);
        }
    }
}

