/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parameter {
    private static final Pattern paramPattern = Pattern.compile("\\s*([a-zA-Z0-9_-]*)\\s*([\\[{])(.*)[\\]}]\\s*\\[(.*)\\]([il]*).*");
    public String name = null;
    public ParamType type = ParamType.CATEGORICAL;
    public String defaultCategorical = null;
    public int defaultCategoricalIndex = -1;
    public List<String> categoricalInnards = null;
    public float defaultNumeric = 0.0f;
    public float minNumeric = 0.0f;
    public float maxNumeric = 0.0f;

    public Parameter(String line) {
        Matcher m = paramPattern.matcher(line);
        if (!m.matches()) {
            throw new RuntimeException("Failed to match parameter line '" + line + "'");
        }
        this.name = m.group(1);
        if (m.group(2).equals("{")) {
            this.type = ParamType.CATEGORICAL;
            this.defaultCategorical = m.group(4).trim();
            String[] innards = m.group(3).split(",");
            this.categoricalInnards = new ArrayList<String>(innards.length);
            boolean foundDefault = false;
            int i = 0;
            while (i < innards.length) {
                String innard = innards[i].trim();
                this.categoricalInnards.add(innard);
                foundDefault |= innard.equals(this.defaultCategorical);
                this.defaultCategoricalIndex = i++;
            }
            if (!foundDefault) {
                throw new RuntimeException("Default not found in set in " + line);
            }
        } else {
            this.defaultNumeric = Float.parseFloat(m.group(4));
            this.type = ParamType.NUMERIC;
            String[] vals = m.group(3).split(",");
            if (vals.length != 2) {
                throw new RuntimeException("Expected two values in '" + m.group(3) + "'");
            }
            this.minNumeric = Float.parseFloat(vals[0]);
            this.maxNumeric = Float.parseFloat(vals[1]);
            if (m.group(5) != null) {
                this.type = m.group(5).contains("i") ? (m.group(5).contains("l") ? ParamType.LOG_INTEGER : ParamType.INTEGER) : (m.group(5).contains("l") ? ParamType.LOG_NUMERIC : ParamType.NUMERIC);
            }
            if ((this.type == ParamType.LOG_INTEGER || this.type == ParamType.LOG_NUMERIC) && (this.minNumeric <= 0.0f || this.maxNumeric <= 0.0f)) {
                throw new RuntimeException("For parameter '" + line + "', bounds must be positive for logarithmic priors");
            }
        }
    }

    public Parameter(String name, String categoricalOption) {
        this(name, Collections.singletonList(categoricalOption));
    }

    public Parameter(String name, List<String> categoricalOptions) {
        this(name, categoricalOptions, categoricalOptions.get(0));
    }

    public Parameter(String name, List<String> categoricalOptions, String defaultOption) {
        this.name = name;
        this.type = ParamType.CATEGORICAL;
        this.defaultCategorical = defaultOption;
        this.categoricalInnards = new ArrayList<String>();
        int i = 0;
        for (String opt : categoricalOptions) {
            this.categoricalInnards.add(opt);
            if (!opt.equals(defaultOption)) continue;
            this.defaultCategoricalIndex = i;
        }
        if (this.defaultCategoricalIndex == -1) {
            throw new RuntimeException("Could not find default option '" + defaultOption + "'");
        }
    }

    public Parameter(String newName, Parameter clone) {
        this.name = newName;
        this.type = clone.type;
        this.defaultCategorical = clone.defaultCategorical;
        this.defaultCategoricalIndex = clone.defaultCategoricalIndex;
        this.categoricalInnards = clone.categoricalInnards;
        if (this.categoricalInnards != null) {
            this.categoricalInnards = new ArrayList<String>(this.categoricalInnards);
        }
        this.defaultNumeric = clone.defaultNumeric;
        this.minNumeric = clone.minNumeric;
        this.maxNumeric = clone.maxNumeric;
    }

    public List<String> getDiscretization(int numPoints) {
        ArrayList<String> points = new ArrayList<String>();
        switch (this.type) {
            case CATEGORICAL: {
                for (String s : this.categoricalInnards) {
                    points.add(s);
                }
                break;
            }
            case NUMERIC: 
            case INTEGER: {
                for (int i = 0; i < numPoints; ++i) {
                    float val = (this.maxNumeric - this.minNumeric) / (float)(numPoints - 1) * (float)i + this.minNumeric;
                    if (this.type == ParamType.INTEGER) {
                        points.add(Integer.toString(Math.round(val)));
                        continue;
                    }
                    points.add(Float.toString(val));
                }
                break;
            }
            case LOG_NUMERIC: 
            case LOG_INTEGER: {
                for (int i = 0; i < numPoints; ++i) {
                    float val = (float)Math.exp((Math.log(this.maxNumeric) - Math.log(this.minNumeric)) / (double)(numPoints - 1) * (double)i + Math.log(this.minNumeric));
                    if (this.type == ParamType.INTEGER) {
                        points.add(Integer.toString(Math.round(val)));
                        continue;
                    }
                    points.add(Float.toString(val));
                }
                break;
            }
        }
        return points;
    }

    public String getRandomValue(Random rand) {
        switch (this.type) {
            case CATEGORICAL: {
                return this.categoricalInnards.get(rand.nextInt(this.categoricalInnards.size()));
            }
            case NUMERIC: 
            case INTEGER: {
                float val = rand.nextFloat() * (this.maxNumeric - this.minNumeric) + this.minNumeric;
                if (this.type == ParamType.INTEGER) {
                    return Integer.toString(Math.round(val));
                }
                return Float.toString(val);
            }
            case LOG_NUMERIC: 
            case LOG_INTEGER: {
                float val = (float)Math.exp((Math.log(this.maxNumeric) - Math.log(this.minNumeric)) * (double)rand.nextFloat() + Math.log(this.minNumeric));
                if (this.type == ParamType.LOG_INTEGER) {
                    return Integer.toString(Math.round(val));
                }
                return Float.toString(val);
            }
        }
        throw new RuntimeException("Unhandeld parameter type '" + (Object)((Object)this.type) + "'");
    }

    public String toString() {
        String repr = this.name + " ";
        if (this.type == ParamType.CATEGORICAL) {
            repr = repr + "{" + Util.joinStrings(", ", this.categoricalInnards) + "} [" + this.defaultCategorical + "]";
        } else {
            repr = this.type == ParamType.INTEGER || this.type == ParamType.LOG_INTEGER ? repr + "[" + Math.round(this.minNumeric) + ", " + Math.round(this.maxNumeric) + "] [" + Math.round(this.defaultNumeric) + "]i" : repr + "[" + this.minNumeric + ", " + this.maxNumeric + "] [" + this.defaultNumeric + "]";
            if (this.type == ParamType.LOG_NUMERIC || this.type == ParamType.LOG_INTEGER) {
                repr = repr + "l";
            }
        }
        return repr;
    }

    public static enum ParamType {
        CATEGORICAL,
        NUMERIC,
        LOG_NUMERIC,
        INTEGER,
        LOG_INTEGER;

    }
}

