/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Experiment;
import autoweka.Trajectory;
import autoweka.XmlSerializable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="trajectorygroup")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TrajectoryGroup
extends XmlSerializable {
    @XmlElement(name="experiment")
    private Experiment mExperiment;
    @XmlElement(name="trajectories")
    private ArrayList<Trajectory> mTrajectories = new ArrayList();

    public TrajectoryGroup() {
    }

    public TrajectoryGroup(Experiment exp) {
        this.mExperiment = exp;
    }

    public Experiment getExperiment() {
        return this.mExperiment;
    }

    public void addTrajectory(Trajectory traj) {
        this.mTrajectories.add(traj);
    }

    public Trajectory getTrajectory(String seed) {
        for (Trajectory traj : this.mTrajectories) {
            if (!traj.getSeed().equals(seed)) continue;
            return traj;
        }
        throw new RuntimeException("Seed not found");
    }

    public List<Trajectory> getTrajectories() {
        return new ArrayList<Trajectory>(this.mTrajectories);
    }

    public List<String> getSeeds() {
        ArrayList<String> seeds = new ArrayList<String>(this.mTrajectories.size());
        for (Trajectory traj : this.mTrajectories) {
            seeds.add(traj.getSeed());
        }
        return seeds;
    }

    public static TrajectoryGroup fromXML(String filename) {
        return XmlSerializable.fromXML(filename, TrajectoryGroup.class);
    }

    public static TrajectoryGroup fromXML(InputStream xml) {
        return XmlSerializable.fromXML(xml, TrajectoryGroup.class);
    }
}

